/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglpixelbuffer_wrapper.h"

// Extra includes
#include <QImage>
#include <qgl.h>
#include <qglpixelbuffer.h>
#include <qimage.h>
#include <qpaintengine.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGLPixelBufferWrapper::QGLPixelBufferWrapper(const QSize & size, const QGLFormat & format, QGLWidget * shareWidget) : QGLPixelBuffer(size, format, shareWidget) {
    // ... middle
}

QGLPixelBufferWrapper::QGLPixelBufferWrapper(int width, int height, const QGLFormat & format, QGLWidget * shareWidget) : QGLPixelBuffer(width, height, format, shareWidget) {
    // ... middle
}

int QGLPixelBufferWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QGLPixelBuffer::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGLPixelBuffer.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QGLPixelBufferWrapper::metric(QPaintDevice::PaintDeviceMetric metric) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QGLPixelBuffer::metric(metric);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(metric)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGLPixelBuffer.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QGLPixelBufferWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QGLPixelBuffer::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGLPixelBuffer.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QGLPixelBufferWrapper::~QGLPixelBufferWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGLPixelBuffer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLPixelBufferWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QGLPixelBuffer", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
            cptr = new QGLPixelBufferWrapper(cpp_arg0, cpp_arg1);
        } else if (Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QGLFormat > cpp_arg2_auto_ptr;
            QGLFormat* cpp_arg2 = Shiboken::Converter<QGLFormat* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg2);
            if (numArgs == 3) {
                // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
                cptr = new QGLPixelBufferWrapper(cpp_arg0, cpp_arg1, *cpp_arg2);
            } else if (Shiboken::Converter<QGLWidget* >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return -1;
                QGLWidget* cpp_arg3 = Shiboken::Converter<QGLWidget* >::toCpp(pyargs[3]);
                // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
                cptr = new QGLPixelBufferWrapper(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            } else goto SbkQGLPixelBuffer_Init_TypeError;
        } else goto SbkQGLPixelBuffer_Init_TypeError;
    } else if (Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
            cptr = new QGLPixelBufferWrapper(*cpp_arg0);
        } else if (Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QGLFormat > cpp_arg1_auto_ptr;
            QGLFormat* cpp_arg1 = Shiboken::Converter<QGLFormat* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg1);
            if (numArgs == 2) {
                // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
                cptr = new QGLPixelBufferWrapper(*cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QGLWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QGLWidget* cpp_arg2 = Shiboken::Converter<QGLWidget* >::toCpp(pyargs[2]);
                // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
                cptr = new QGLPixelBufferWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
            } else goto SbkQGLPixelBuffer_Init_TypeError;
        } else goto SbkQGLPixelBuffer_Init_TypeError;
    } else goto SbkQGLPixelBuffer_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLPixelBuffer_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGLPixelBuffer_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtOpenGL.QGLFormat = QGLFormat.defaultFormat(), PySide.QtOpenGL.QGLWidget = None", "int, int, PySide.QtOpenGL.QGLFormat = QGLFormat.defaultFormat(), PySide.QtOpenGL.QGLWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLPixelBuffer", overloads);
        return -1;
}

static PyObject*
SbkQGLPixelBufferFunc_bindTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "bindTexture", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // bindTexture(QString)
        QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
        unsigned int cpp_result = cppSelf->QGLPixelBuffer::bindTexture(*cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // bindTexture(QPixmap,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLPixelBuffer::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // bindTexture(QPixmap,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLPixelBuffer::bindTexture(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else goto SbkQGLPixelBufferFunc_bindTexture_TypeError;
    } else if (Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // bindTexture(QImage,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLPixelBuffer::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // bindTexture(QImage,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLPixelBuffer::bindTexture(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else goto SbkQGLPixelBufferFunc_bindTexture_TypeError;
    } else goto SbkQGLPixelBufferFunc_bindTexture_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLPixelBufferFunc_bindTexture_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, unsigned int = 0x0DE1", "PySide.QtGui.QPixmap, unsigned int = 0x0DE1", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLPixelBuffer.bindTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLPixelBufferFunc_bindToDynamicTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // bindToDynamicTexture(uint)
        QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLPixelBuffer::bindToDynamicTexture(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGLPixelBufferFunc_bindToDynamicTexture_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLPixelBufferFunc_bindToDynamicTexture_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLPixelBuffer.bindToDynamicTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLPixelBufferFunc_deleteTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // deleteTexture(uint)
        QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
        cppSelf->QGLPixelBuffer::deleteTexture(cpp_arg0);
    } else goto SbkQGLPixelBufferFunc_deleteTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLPixelBufferFunc_deleteTexture_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLPixelBuffer.deleteTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLPixelBufferFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLPixelBuffer::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_doneCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doneCurrent()
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLPixelBuffer::doneCurrent();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_drawTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawTexture", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QRectF,uint,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            cppSelf->QGLPixelBuffer::drawTexture(*cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QRectF,uint,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            cppSelf->QGLPixelBuffer::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGLPixelBufferFunc_drawTexture_TypeError;
    } else if (Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QPointF,uint,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            cppSelf->QGLPixelBuffer::drawTexture(*cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QPointF,uint,uint)
            QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
            cppSelf->QGLPixelBuffer::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGLPixelBufferFunc_drawTexture_TypeError;
    } else goto SbkQGLPixelBufferFunc_drawTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLPixelBufferFunc_drawTexture_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, unsigned int, unsigned int = 0x0DE1", "PySide.QtCore.QRectF, unsigned int, unsigned int = 0x0DE1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLPixelBuffer.drawTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLPixelBufferFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    QGLFormat cpp_result = cppSelf->QGLPixelBuffer::format();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_generateDynamicTexture(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // generateDynamicTexture()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLPixelBuffer::generateDynamicTexture();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QGLPixelBuffer::handle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_hasOpenGLPbuffers(PyObject* self)
{
    PyObject* py_result = 0;

    // hasOpenGLPbuffers()
    bool cpp_result = QGLPixelBuffer::hasOpenGLPbuffers();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLPixelBuffer::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_makeCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // makeCurrent()
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLPixelBuffer::makeCurrent();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLPixelBuffer::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGLPixelBufferFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLPixelBufferFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLPixelBuffer.metric", overloads);
        return 0;
}

static PyObject*
SbkQGLPixelBufferFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QGLPixelBuffer::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_releaseFromDynamicTexture(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // releaseFromDynamicTexture()
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    cppSelf->QGLPixelBuffer::releaseFromDynamicTexture();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGLPixelBufferFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGLPixelBuffer::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_toImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toImage()const
    QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QGLPixelBuffer::toImage();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLPixelBufferFunc_updateDynamicTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // updateDynamicTexture(uint)const
        QGLPixelBuffer* cppSelf = Shiboken::Converter<QGLPixelBuffer* >::toCpp((PyObject*)self);
        cppSelf->QGLPixelBuffer::updateDynamicTexture(cpp_arg0);
    } else goto SbkQGLPixelBufferFunc_updateDynamicTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLPixelBufferFunc_updateDynamicTexture_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLPixelBuffer.updateDynamicTexture", overloads);
        return 0;
}

static PyMethodDef SbkQGLPixelBuffer_methods[] = {
    {"bindTexture", (PyCFunction)SbkQGLPixelBufferFunc_bindTexture, METH_VARARGS},
    {"bindToDynamicTexture", (PyCFunction)SbkQGLPixelBufferFunc_bindToDynamicTexture, METH_O},
    {"deleteTexture", (PyCFunction)SbkQGLPixelBufferFunc_deleteTexture, METH_O},
    {"devType", (PyCFunction)SbkQGLPixelBufferFunc_devType, METH_NOARGS},
    {"doneCurrent", (PyCFunction)SbkQGLPixelBufferFunc_doneCurrent, METH_NOARGS},
    {"drawTexture", (PyCFunction)SbkQGLPixelBufferFunc_drawTexture, METH_VARARGS},
    {"format", (PyCFunction)SbkQGLPixelBufferFunc_format, METH_NOARGS},
    {"generateDynamicTexture", (PyCFunction)SbkQGLPixelBufferFunc_generateDynamicTexture, METH_NOARGS},
    {"handle", (PyCFunction)SbkQGLPixelBufferFunc_handle, METH_NOARGS},
    {"hasOpenGLPbuffers", (PyCFunction)SbkQGLPixelBufferFunc_hasOpenGLPbuffers, METH_NOARGS|METH_STATIC},
    {"isValid", (PyCFunction)SbkQGLPixelBufferFunc_isValid, METH_NOARGS},
    {"makeCurrent", (PyCFunction)SbkQGLPixelBufferFunc_makeCurrent, METH_NOARGS},
    {"metric", (PyCFunction)SbkQGLPixelBufferFunc_metric, METH_O},
    {"paintEngine", (PyCFunction)SbkQGLPixelBufferFunc_paintEngine, METH_NOARGS},
    {"releaseFromDynamicTexture", (PyCFunction)SbkQGLPixelBufferFunc_releaseFromDynamicTexture, METH_NOARGS},
    {"size", (PyCFunction)SbkQGLPixelBufferFunc_size, METH_NOARGS},
    {"toImage", (PyCFunction)SbkQGLPixelBufferFunc_toImage, METH_NOARGS},
    {"updateDynamicTexture", (PyCFunction)SbkQGLPixelBufferFunc_updateDynamicTexture, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLPixelBuffer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLPixelBuffer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGLPixelBufferWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLPixelBuffer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLPixelBuffer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGLPixelBuffer(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLPixelBuffer_Type);

    SbkQGLPixelBuffer_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQGLPixelBuffer_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGLPixelBuffer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLPixelBuffer_Type));
    PyModule_AddObject(module, "QGLPixelBuffer",
        ((PyObject*)&SbkQGLPixelBuffer_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGLPixelBuffer >("QGLPixelBuffer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGLPixelBuffer >(typeid(QGLPixelBuffer).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

