/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qsslsocket_wrapper.h"

// Extra includes
#include <QList>
#include <qauthenticator.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qhostaddress.h>
#include <qnetworkproxy.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsslcipher.h>
#include <qsslconfiguration.h>
#include <qsslerror.h>
#include <qsslkey.h>
#include <qsslsocket.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSslSocketWrapper::QSslSocketWrapper(QObject * parent) : QSslSocket(parent), m_metaObject(0) {
    // ... middle
}

bool QSslSocketWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QSslSocket::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.atEnd");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QSslSocket::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.bytesAvailable");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QSslSocket::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.bytesToWrite");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QSslSocketWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QSslSocket::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.canReadLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSslSocketWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSslSocketWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSslSocket::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSslSocketWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSslSocketWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSslSocketWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSslSocketWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSslSocketWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QSslSocketWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSslSocketWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        return this->QSslSocket::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.readData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.readLineData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QSslSocketWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSslSocketWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QSslSocketWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QSslSocketWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSslSocket::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.waitForBytesWritten");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSslSocketWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSslSocket::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.waitForReadyRead");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QSslSocketWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QSslSocket::writeData(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSslSocket.writeData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QSslSocketWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSslSocket::staticMetaObject);
}
    return m_metaObject;
}

int QSslSocketWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSslSocket::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSslSocketWrapper::~QSslSocketWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSslSocket_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSslSocketWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSslSocket", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSslSocket(QObject*)
        cptr = new QSslSocketWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSslSocket(QObject*)
        cptr = new QSslSocketWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSslSocket_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSslSocket_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSslSocket_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket", overloads);
        return -1;
}

static PyObject*
SbkQSslSocketFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    cppSelf->QSslSocket::abort();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslSocketFunc_addCaCertificates(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addCaCertificates", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSslSocket::addCaCertificates(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[1])) {
            QSsl::EncodingFormat cpp_arg1 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // addCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QSslSocket::addCaCertificates(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (Shiboken::Converter<QRegExp::PatternSyntax >::isConvertible(pyargs[2])) {
                QRegExp::PatternSyntax cpp_arg2 = Shiboken::Converter<QRegExp::PatternSyntax >::toCpp(pyargs[2]);
                // addCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QSslSocket::addCaCertificates(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQSslSocketFunc_addCaCertificates_TypeError;
        } else goto SbkQSslSocketFunc_addCaCertificates_TypeError;
    } else goto SbkQSslSocketFunc_addCaCertificates_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_addCaCertificates_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem, PySide.QtCore.QRegExp.PatternSyntax = QRegExp.FixedString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.addCaCertificates", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_addDefaultCaCertificates(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addDefaultCaCertificates", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addDefaultCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
            bool cpp_result = QSslSocket::addDefaultCaCertificates(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[1])) {
            QSsl::EncodingFormat cpp_arg1 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // addDefaultCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
                bool cpp_result = QSslSocket::addDefaultCaCertificates(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (Shiboken::Converter<QRegExp::PatternSyntax >::isConvertible(pyargs[2])) {
                QRegExp::PatternSyntax cpp_arg2 = Shiboken::Converter<QRegExp::PatternSyntax >::toCpp(pyargs[2]);
                // addDefaultCaCertificates(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
                bool cpp_result = QSslSocket::addDefaultCaCertificates(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQSslSocketFunc_addDefaultCaCertificates_TypeError;
        } else goto SbkQSslSocketFunc_addDefaultCaCertificates_TypeError;
    } else goto SbkQSslSocketFunc_addDefaultCaCertificates_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_addDefaultCaCertificates_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem, PySide.QtCore.QRegExp.PatternSyntax = QRegExp.FixedString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.addDefaultCaCertificates", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslSocket::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QSslSocket::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_bytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesToWrite()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QSslSocket::bytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_canReadLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canReadLine()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslSocket::canReadLine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_ciphers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ciphers()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QList<QSslCipher > cpp_result = cppSelf->QSslSocket::ciphers();
    py_result = Shiboken::Converter<QList<QSslCipher > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QSslSocket::close();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslSocketFunc_connectToHostEncrypted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "connectToHostEncrypted", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // connectToHostEncrypted(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QSslSocket::connectToHostEncrypted(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            if (numArgs == 3) {
                // connectToHostEncrypted(QString,quint16,QString,QFlags<QIODevice::OpenModeFlag>)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                cppSelf->QSslSocket::connectToHostEncrypted(*cpp_arg0, cpp_arg1, *cpp_arg2);
            } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[3])) {
                QFlags<QIODevice::OpenModeFlag> cpp_arg3 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[3]);
                // connectToHostEncrypted(QString,quint16,QString,QFlags<QIODevice::OpenModeFlag>)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                cppSelf->QSslSocket::connectToHostEncrypted(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            } else goto SbkQSslSocketFunc_connectToHostEncrypted_TypeError;
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
            // connectToHostEncrypted(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QSslSocket::connectToHostEncrypted(*cpp_arg0, cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
        } else goto SbkQSslSocketFunc_connectToHostEncrypted_TypeError;
    } else goto SbkQSslSocketFunc_connectToHostEncrypted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_connectToHostEncrypted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, unsigned short, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", "PySide.QtCore.QString, unsigned short, PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.connectToHostEncrypted", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_connectToHostImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "connectToHostImplementation", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
        // connectToHostImplementation(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::connectToHostImplementation(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQSslSocketFunc_connectToHostImplementation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_connectToHostImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, unsigned short, PySide.QtCore.QIODevice.OpenMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.connectToHostImplementation", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_defaultCiphers(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultCiphers()
    QList<QSslCipher > cpp_result = QSslSocket::defaultCiphers();
    py_result = Shiboken::Converter<QList<QSslCipher > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_disconnectFromHostImplementation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // disconnectFromHostImplementation()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    cppSelf->QSslSocket::disconnectFromHostImplementation();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslSocketFunc_encryptedBytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encryptedBytesAvailable()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QSslSocket::encryptedBytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_encryptedBytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encryptedBytesToWrite()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QSslSocket::encryptedBytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flush()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslSocket::flush();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_ignoreSslErrors(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // ignoreSslErrors()
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::ignoreSslErrors();
    } else if (Shiboken::Converter<QList<QSslError >  >::isConvertible(arg)) {
        QList<QSslError >  cpp_arg0 = Shiboken::Converter<QList<QSslError >  >::toCpp(arg);
        // ignoreSslErrors(QList<QSslError>)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::ignoreSslErrors(cpp_arg0);
    } else goto SbkQSslSocketFunc_ignoreSslErrors_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_ignoreSslErrors_TypeError:
        const char* overloads[] = {"", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.ignoreSslErrors", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_isEncrypted(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEncrypted()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslSocket::isEncrypted();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_mode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mode()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSslSocket::SslMode cpp_result = cppSelf->QSslSocket::mode();
    py_result = Shiboken::Converter<QSslSocket::SslMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_peerVerifyDepth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerVerifyDepth()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSslSocket::peerVerifyDepth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_peerVerifyMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerVerifyMode()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSslSocket::PeerVerifyMode cpp_result = cppSelf->QSslSocket::peerVerifyMode();
    py_result = Shiboken::Converter<QSslSocket::PeerVerifyMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_privateKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // privateKey()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSslKey cpp_result = cppSelf->QSslSocket::privateKey();
    py_result = Shiboken::Converter<QSslKey >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_protocol(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // protocol()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSsl::SslProtocol cpp_result = cppSelf->QSslSocket::protocol();
    py_result = Shiboken::Converter<QSsl::SslProtocol >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QSslSocket::readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.readData", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_sessionCipher(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionCipher()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSslCipher cpp_result = cppSelf->QSslSocket::sessionCipher();
    py_result = Shiboken::Converter<QSslCipher >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_setCiphers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCiphers(QString)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setCiphers(*cpp_arg0);
    } else if (Shiboken::Converter<QList<QSslCipher >  >::isConvertible(arg)) {
        QList<QSslCipher >  cpp_arg0 = Shiboken::Converter<QList<QSslCipher >  >::toCpp(arg);
        // setCiphers(QList<QSslCipher>)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setCiphers(cpp_arg0);
    } else goto SbkQSslSocketFunc_setCiphers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setCiphers_TypeError:
        const char* overloads[] = {"list", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setCiphers", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setDefaultCiphers(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QList<QSslCipher >  >::isConvertible(arg)) {
        QList<QSslCipher >  cpp_arg0 = Shiboken::Converter<QList<QSslCipher >  >::toCpp(arg);
        // setDefaultCiphers(QList<QSslCipher>)
        QSslSocket::setDefaultCiphers(cpp_arg0);
    } else goto SbkQSslSocketFunc_setDefaultCiphers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setDefaultCiphers_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setDefaultCiphers", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setLocalCertificate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setLocalCertificate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setLocalCertificate(QString,QSsl::EncodingFormat)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            cppSelf->QSslSocket::setLocalCertificate(*cpp_arg0);
        } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[1])) {
            QSsl::EncodingFormat cpp_arg1 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[1]);
            // setLocalCertificate(QString,QSsl::EncodingFormat)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            cppSelf->QSslSocket::setLocalCertificate(*cpp_arg0, cpp_arg1);
        } else goto SbkQSslSocketFunc_setLocalCertificate_TypeError;
    } else goto SbkQSslSocketFunc_setLocalCertificate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setLocalCertificate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.setLocalCertificate", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setPeerVerifyDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPeerVerifyDepth(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setPeerVerifyDepth(cpp_arg0);
    } else goto SbkQSslSocketFunc_setPeerVerifyDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setPeerVerifyDepth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setPeerVerifyDepth", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setPeerVerifyMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslSocket::PeerVerifyMode >::isConvertible(arg)) {
        QSslSocket::PeerVerifyMode cpp_arg0 = Shiboken::Converter<QSslSocket::PeerVerifyMode >::toCpp(arg);
        // setPeerVerifyMode(QSslSocket::PeerVerifyMode)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setPeerVerifyMode(cpp_arg0);
    } else goto SbkQSslSocketFunc_setPeerVerifyMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setPeerVerifyMode_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslSocket.PeerVerifyMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setPeerVerifyMode", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setPrivateKey(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setPrivateKey", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setPrivateKey(QString,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QByteArray)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            cppSelf->QSslSocket::setPrivateKey(*cpp_arg0);
        } else if (Shiboken::Converter<QSsl::KeyAlgorithm >::isConvertible(pyargs[1])) {
            QSsl::KeyAlgorithm cpp_arg1 = Shiboken::Converter<QSsl::KeyAlgorithm >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setPrivateKey(QString,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QByteArray)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                cppSelf->QSslSocket::setPrivateKey(*cpp_arg0, cpp_arg1);
            } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[2])) {
                QSsl::EncodingFormat cpp_arg2 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setPrivateKey(QString,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QByteArray)
                    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                    cppSelf->QSslSocket::setPrivateKey(*cpp_arg0, cpp_arg1, cpp_arg2);
                } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    std::auto_ptr<QByteArray > cpp_arg3_auto_ptr;
                    QByteArray* cpp_arg3 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg3);
                    // setPrivateKey(QString,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QByteArray)
                    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                    cppSelf->QSslSocket::setPrivateKey(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                } else goto SbkQSslSocketFunc_setPrivateKey_TypeError;
            } else goto SbkQSslSocketFunc_setPrivateKey_TypeError;
        } else goto SbkQSslSocketFunc_setPrivateKey_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSslKey& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSslKey* cpp_arg0 = Shiboken::Converter<QSslKey* >::toCpp(pyargs[0]);
        // setPrivateKey(QSslKey)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setPrivateKey(*cpp_arg0);
    } else goto SbkQSslSocketFunc_setPrivateKey_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setPrivateKey_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslKey", "PySide.QtCore.QString, PySide.QtNetwork.QSsl.KeyAlgorithm = QSsl.Rsa, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem, PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.setPrivateKey", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setProtocol(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSsl::SslProtocol >::isConvertible(arg)) {
        QSsl::SslProtocol cpp_arg0 = Shiboken::Converter<QSsl::SslProtocol >::toCpp(arg);
        // setProtocol(QSsl::SslProtocol)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setProtocol(cpp_arg0);
    } else goto SbkQSslSocketFunc_setProtocol_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setProtocol_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSsl.SslProtocol", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setProtocol", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setReadBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setReadBufferSize(qint64)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setReadBufferSize(cpp_arg0);
    } else goto SbkQSslSocketFunc_setReadBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setReadBufferSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setReadBufferSize", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setSocketDescriptor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setSocketDescriptor", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
            QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSslSocket::setSocketDescriptor(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QAbstractSocket::SocketState >::isConvertible(pyargs[1])) {
            QAbstractSocket::SocketState cpp_arg1 = Shiboken::Converter<QAbstractSocket::SocketState >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QSslSocket::setSocketDescriptor(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
                QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
                // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
                QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QSslSocket::setSocketDescriptor(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQSslSocketFunc_setSocketDescriptor_TypeError;
        } else goto SbkQSslSocketFunc_setSocketDescriptor_TypeError;
    } else goto SbkQSslSocketFunc_setSocketDescriptor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_setSocketDescriptor_TypeError:
        const char* overloads[] = {"int, PySide.QtNetwork.QAbstractSocket.SocketState = ConnectedState, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.setSocketDescriptor", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_setSslConfiguration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslConfiguration& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSslConfiguration* cpp_arg0 = Shiboken::Converter<QSslConfiguration* >::toCpp(arg);
        // setSslConfiguration(QSslConfiguration)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        cppSelf->QSslSocket::setSslConfiguration(*cpp_arg0);
    } else goto SbkQSslSocketFunc_setSslConfiguration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslSocketFunc_setSslConfiguration_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.setSslConfiguration", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_sslConfiguration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sslConfiguration()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QSslConfiguration cpp_result = cppSelf->QSslSocket::sslConfiguration();
    py_result = Shiboken::Converter<QSslConfiguration >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_sslErrors(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sslErrors()const
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    QList<QSslError > cpp_result = cppSelf->QSslSocket::sslErrors();
    py_result = Shiboken::Converter<QList<QSslError > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_startClientEncryption(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startClientEncryption()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    cppSelf->QSslSocket::startClientEncryption();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslSocketFunc_startServerEncryption(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startServerEncryption()
    QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
    cppSelf->QSslSocket::startServerEncryption();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslSocketFunc_supportedCiphers(PyObject* self)
{
    PyObject* py_result = 0;

    // supportedCiphers()
    QList<QSslCipher > cpp_result = QSslSocket::supportedCiphers();
    py_result = Shiboken::Converter<QList<QSslCipher > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_supportsSsl(PyObject* self)
{
    PyObject* py_result = 0;

    // supportsSsl()
    bool cpp_result = QSslSocket::supportsSsl();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslSocketFunc_waitForBytesWritten(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForBytesWritten(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForBytesWritten();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForBytesWritten(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForBytesWritten(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_waitForBytesWritten_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_waitForBytesWritten_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.waitForBytesWritten", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_waitForConnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForConnected(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForConnected();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForConnected(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForConnected(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_waitForConnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_waitForConnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.waitForConnected", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_waitForDisconnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForDisconnected(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForDisconnected();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForDisconnected(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForDisconnected(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_waitForDisconnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_waitForDisconnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.waitForDisconnected", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_waitForEncrypted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForEncrypted(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForEncrypted();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForEncrypted(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForEncrypted(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_waitForEncrypted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_waitForEncrypted_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.waitForEncrypted", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_waitForReadyRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForReadyRead(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForReadyRead();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForReadyRead(int)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSslSocket::waitForReadyRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_waitForReadyRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_waitForReadyRead_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslSocket.waitForReadyRead", overloads);
        return 0;
}

static PyObject*
SbkQSslSocketFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QSslSocket* cppSelf = Shiboken::Converter<QSslSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QSslSocket::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQSslSocketFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslSocketFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslSocket.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQSslSocket_methods[] = {
    {"abort", (PyCFunction)SbkQSslSocketFunc_abort, METH_NOARGS},
    {"addCaCertificates", (PyCFunction)SbkQSslSocketFunc_addCaCertificates, METH_VARARGS},
    {"addDefaultCaCertificates", (PyCFunction)SbkQSslSocketFunc_addDefaultCaCertificates, METH_VARARGS|METH_STATIC},
    {"atEnd", (PyCFunction)SbkQSslSocketFunc_atEnd, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQSslSocketFunc_bytesAvailable, METH_NOARGS},
    {"bytesToWrite", (PyCFunction)SbkQSslSocketFunc_bytesToWrite, METH_NOARGS},
    {"canReadLine", (PyCFunction)SbkQSslSocketFunc_canReadLine, METH_NOARGS},
    {"ciphers", (PyCFunction)SbkQSslSocketFunc_ciphers, METH_NOARGS},
    {"close", (PyCFunction)SbkQSslSocketFunc_close, METH_NOARGS},
    {"connectToHostEncrypted", (PyCFunction)SbkQSslSocketFunc_connectToHostEncrypted, METH_VARARGS},
    {"connectToHostImplementation", (PyCFunction)SbkQSslSocketFunc_connectToHostImplementation, METH_VARARGS},
    {"defaultCiphers", (PyCFunction)SbkQSslSocketFunc_defaultCiphers, METH_NOARGS|METH_STATIC},
    {"disconnectFromHostImplementation", (PyCFunction)SbkQSslSocketFunc_disconnectFromHostImplementation, METH_NOARGS},
    {"encryptedBytesAvailable", (PyCFunction)SbkQSslSocketFunc_encryptedBytesAvailable, METH_NOARGS},
    {"encryptedBytesToWrite", (PyCFunction)SbkQSslSocketFunc_encryptedBytesToWrite, METH_NOARGS},
    {"flush", (PyCFunction)SbkQSslSocketFunc_flush, METH_NOARGS},
    {"ignoreSslErrors", (PyCFunction)SbkQSslSocketFunc_ignoreSslErrors, METH_NOARGS|METH_O},
    {"isEncrypted", (PyCFunction)SbkQSslSocketFunc_isEncrypted, METH_NOARGS},
    {"mode", (PyCFunction)SbkQSslSocketFunc_mode, METH_NOARGS},
    {"peerVerifyDepth", (PyCFunction)SbkQSslSocketFunc_peerVerifyDepth, METH_NOARGS},
    {"peerVerifyMode", (PyCFunction)SbkQSslSocketFunc_peerVerifyMode, METH_NOARGS},
    {"privateKey", (PyCFunction)SbkQSslSocketFunc_privateKey, METH_NOARGS},
    {"protocol", (PyCFunction)SbkQSslSocketFunc_protocol, METH_NOARGS},
    {"readData", (PyCFunction)SbkQSslSocketFunc_readData, METH_VARARGS},
    {"sessionCipher", (PyCFunction)SbkQSslSocketFunc_sessionCipher, METH_NOARGS},
    {"setCiphers", (PyCFunction)SbkQSslSocketFunc_setCiphers, METH_O},
    {"setDefaultCiphers", (PyCFunction)SbkQSslSocketFunc_setDefaultCiphers, METH_O|METH_STATIC},
    {"setLocalCertificate", (PyCFunction)SbkQSslSocketFunc_setLocalCertificate, METH_VARARGS},
    {"setPeerVerifyDepth", (PyCFunction)SbkQSslSocketFunc_setPeerVerifyDepth, METH_O},
    {"setPeerVerifyMode", (PyCFunction)SbkQSslSocketFunc_setPeerVerifyMode, METH_O},
    {"setPrivateKey", (PyCFunction)SbkQSslSocketFunc_setPrivateKey, METH_VARARGS},
    {"setProtocol", (PyCFunction)SbkQSslSocketFunc_setProtocol, METH_O},
    {"setReadBufferSize", (PyCFunction)SbkQSslSocketFunc_setReadBufferSize, METH_O},
    {"setSocketDescriptor", (PyCFunction)SbkQSslSocketFunc_setSocketDescriptor, METH_VARARGS},
    {"setSslConfiguration", (PyCFunction)SbkQSslSocketFunc_setSslConfiguration, METH_O},
    {"sslConfiguration", (PyCFunction)SbkQSslSocketFunc_sslConfiguration, METH_NOARGS},
    {"sslErrors", (PyCFunction)SbkQSslSocketFunc_sslErrors, METH_NOARGS},
    {"startClientEncryption", (PyCFunction)SbkQSslSocketFunc_startClientEncryption, METH_NOARGS},
    {"startServerEncryption", (PyCFunction)SbkQSslSocketFunc_startServerEncryption, METH_NOARGS},
    {"supportedCiphers", (PyCFunction)SbkQSslSocketFunc_supportedCiphers, METH_NOARGS|METH_STATIC},
    {"supportsSsl", (PyCFunction)SbkQSslSocketFunc_supportsSsl, METH_NOARGS|METH_STATIC},
    {"waitForBytesWritten", (PyCFunction)SbkQSslSocketFunc_waitForBytesWritten, METH_NOARGS|METH_O},
    {"waitForConnected", (PyCFunction)SbkQSslSocketFunc_waitForConnected, METH_NOARGS|METH_O},
    {"waitForDisconnected", (PyCFunction)SbkQSslSocketFunc_waitForDisconnected, METH_NOARGS|METH_O},
    {"waitForEncrypted", (PyCFunction)SbkQSslSocketFunc_waitForEncrypted, METH_NOARGS|METH_O},
    {"waitForReadyRead", (PyCFunction)SbkQSslSocketFunc_waitForReadyRead, METH_NOARGS|METH_O},
    {"writeData", (PyCFunction)SbkQSslSocketFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSslSocket_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSslSocket",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSslSocketWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSslSocket_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSslSocket_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QSslSocket_SslMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSslSocket_SslMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSslSocket_SslMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SslMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSslSocket_SslMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSslSocket_SslMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSslSocket_SslMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PeerVerifyMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSslSocket(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSslSocket_Type);

    SbkQSslSocket_Type.super.ht_type.tp_base = SbkPySide_QtNetworkTypes[SBK_QTCPSOCKET_IDX];
    // Fill type discovery information
    SbkQSslSocket_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSslSocket_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSslSocket_Type));
    PyModule_AddObject(module, "QSslSocket",
        ((PyObject*)&SbkQSslSocket_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SslMode
    SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX] = &SbkPySide_QtNetwork_QSslSocket_SslMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSslSocket_SslMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSslSocket_SslMode_Type);
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
            "SslMode",((PyObject*)&SbkPySide_QtNetwork_QSslSocket_SslMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_SslMode_Type,
        (long) QSslSocket::UnencryptedMode, "UnencryptedMode");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "UnencryptedMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_SslMode_Type.tp_dict,
        "UnencryptedMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_SslMode_Type,
        (long) QSslSocket::SslClientMode, "SslClientMode");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "SslClientMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_SslMode_Type.tp_dict,
        "SslClientMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_SslMode_Type,
        (long) QSslSocket::SslServerMode, "SslServerMode");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "SslServerMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_SslMode_Type.tp_dict,
        "SslServerMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSslSocket::SslMode");

    // init enum class: PeerVerifyMode
    SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX] = &SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type);
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
            "PeerVerifyMode",((PyObject*)&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type,
        (long) QSslSocket::VerifyNone, "VerifyNone");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "VerifyNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type.tp_dict,
        "VerifyNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type,
        (long) QSslSocket::QueryPeer, "QueryPeer");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "QueryPeer", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type.tp_dict,
        "QueryPeer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type,
        (long) QSslSocket::VerifyPeer, "VerifyPeer");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "VerifyPeer", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type.tp_dict,
        "VerifyPeer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type,
        (long) QSslSocket::AutoVerifyPeer, "AutoVerifyPeer");
    PyDict_SetItemString(SbkQSslSocket_Type.super.ht_type.tp_dict,
        "AutoVerifyPeer", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Type.tp_dict,
        "AutoVerifyPeer", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSslSocket::PeerVerifyMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QSslSocket >("QSslSocket*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSslSocket >(typeid(QSslSocket).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

