/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qsslkey_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qiodevice.h>
#include <qsslkey.h>

using namespace Shiboken;

static int
SbkQSslKey_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSslKey* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSslKey", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QSslKey()
        cptr = new QSslKey();
    } else if (numArgs == 1 && Shiboken::Converter<QSslKey& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSslKey* cpp_arg0 = Shiboken::Converter<QSslKey* >::toCpp(pyargs[0]);
        // QSslKey(QSslKey)
        cptr = new QSslKey(*cpp_arg0);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSsl::KeyAlgorithm >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        QSsl::KeyAlgorithm cpp_arg1 = Shiboken::Converter<QSsl::KeyAlgorithm >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
            cptr = new QSslKey(*cpp_arg0, cpp_arg1);
        } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[2])) {
            QSsl::EncodingFormat cpp_arg2 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                cptr = new QSslKey(*cpp_arg0, cpp_arg1, cpp_arg2);
            } else if (Shiboken::Converter<QSsl::KeyType >::isConvertible(pyargs[3])) {
                QSsl::KeyType cpp_arg3 = Shiboken::Converter<QSsl::KeyType >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                    cptr = new QSslKey(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return -1;
                    std::auto_ptr<QByteArray > cpp_arg4_auto_ptr;
                    QByteArray* cpp_arg4 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[4]);
                    if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[4]))
                        cpp_arg4_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg4);
                    // QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                    cptr = new QSslKey(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                } else goto SbkQSslKey_Init_TypeError;
            } else goto SbkQSslKey_Init_TypeError;
        } else goto SbkQSslKey_Init_TypeError;
    } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0]) && Shiboken::Converter<QSsl::KeyAlgorithm >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        QSsl::KeyAlgorithm cpp_arg1 = Shiboken::Converter<QSsl::KeyAlgorithm >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
            cptr = new QSslKey(cpp_arg0, cpp_arg1);
        } else if (Shiboken::Converter<QSsl::EncodingFormat >::isConvertible(pyargs[2])) {
            QSsl::EncodingFormat cpp_arg2 = Shiboken::Converter<QSsl::EncodingFormat >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                cptr = new QSslKey(cpp_arg0, cpp_arg1, cpp_arg2);
            } else if (Shiboken::Converter<QSsl::KeyType >::isConvertible(pyargs[3])) {
                QSsl::KeyType cpp_arg3 = Shiboken::Converter<QSsl::KeyType >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                    cptr = new QSslKey(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return -1;
                    std::auto_ptr<QByteArray > cpp_arg4_auto_ptr;
                    QByteArray* cpp_arg4 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[4]);
                    if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[4]))
                        cpp_arg4_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg4);
                    // QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
                    cptr = new QSslKey(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                } else goto SbkQSslKey_Init_TypeError;
            } else goto SbkQSslKey_Init_TypeError;
        } else goto SbkQSslKey_Init_TypeError;
    } else goto SbkQSslKey_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSslKey_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSslKey_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice, PySide.QtNetwork.QSsl.KeyAlgorithm, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem, PySide.QtNetwork.QSsl.KeyType = QSsl.PrivateKey, PySide.QtCore.QByteArray = QByteArray()", "PySide.QtCore.QByteArray, PySide.QtNetwork.QSsl.KeyAlgorithm, PySide.QtNetwork.QSsl.EncodingFormat = QSsl.Pem, PySide.QtNetwork.QSsl.KeyType = QSsl.PrivateKey, PySide.QtCore.QByteArray = QByteArray()", "PySide.QtNetwork.QSslKey", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslKey", overloads);
        return -1;
}

static PyObject*
SbkQSslKeyFunc_algorithm(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // algorithm()const
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    QSsl::KeyAlgorithm cpp_result = cppSelf->QSslKey::algorithm();
    py_result = Shiboken::Converter<QSsl::KeyAlgorithm >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslKeyFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    cppSelf->QSslKey::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSslKeyFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QSslKey::handle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslKeyFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslKey::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslKeyFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSslKey::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslKeyFunc_toDer(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toDer(QByteArray)const
        QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QSslKey::toDer();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // toDer(QByteArray)const
        QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QSslKey::toDer(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQSslKeyFunc_toDer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslKeyFunc_toDer_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslKey.toDer", overloads);
        return 0;
}

static PyObject*
SbkQSslKeyFunc_toPem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toPem(QByteArray)const
        QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QSslKey::toPem();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // toPem(QByteArray)const
        QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QSslKey::toPem(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQSslKeyFunc_toPem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSslKeyFunc_toPem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslKey.toPem", overloads);
        return 0;
}

static PyObject*
SbkQSslKeyFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QSslKey* cppSelf = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);
    QSsl::KeyType cpp_result = cppSelf->QSslKey::type();
    py_result = Shiboken::Converter<QSsl::KeyType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSslKey_methods[] = {
    {"algorithm", (PyCFunction)SbkQSslKeyFunc_algorithm, METH_NOARGS},
    {"clear", (PyCFunction)SbkQSslKeyFunc_clear, METH_NOARGS},
    {"handle", (PyCFunction)SbkQSslKeyFunc_handle, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSslKeyFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQSslKeyFunc_length, METH_NOARGS},
    {"toDer", (PyCFunction)SbkQSslKeyFunc_toDer, METH_NOARGS|METH_O},
    {"toPem", (PyCFunction)SbkQSslKeyFunc_toPem, METH_NOARGS|METH_O},
    {"type", (PyCFunction)SbkQSslKeyFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQSslKey_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSslKey& cpp_self = *Shiboken::Converter<QSslKey* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSslKey& >::isConvertible(other)) {
                QSslKey* cpp_other = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSslKey_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSslKey& >::isConvertible(other)) {
                QSslKey* cpp_other = Shiboken::Converter<QSslKey* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSslKey_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSslKey_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSslKey_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSslKey",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSslKey >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSslKey_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSslKey_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSslKey_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSslKey(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QSSLKEY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSslKey_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSslKey_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSslKey_Type));
    PyModule_AddObject(module, "QSslKey",
        ((PyObject*)&SbkQSslKey_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSslKey >("QSslKey");
    Shiboken::TypeResolver::createValueTypeResolver<QSslKey >(typeid(QSslKey).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

