/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qsslerror_wrapper.h"

// Extra includes
#include <qsslerror.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQSslError_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSslError* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSslError", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSslError()
        cptr = new QSslError();
    } else if (numArgs == 1 && Shiboken::Converter<QSslError::SslError >::isConvertible(pyargs[0])) {
        QSslError::SslError cpp_arg0 = Shiboken::Converter<QSslError::SslError >::toCpp(pyargs[0]);
        // QSslError(QSslError::SslError)
        cptr = new QSslError(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QSslError& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QSslError > cpp_arg0_auto_ptr;
        QSslError* cpp_arg0 = Shiboken::Converter<QSslError* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QSslError& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSslError >(cpp_arg0);
        // QSslError(QSslError)
        cptr = new QSslError(*cpp_arg0);
    } else goto SbkQSslError_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSslError_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSslError_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QSslError.SslError", "PySide.QtNetwork.QSslError", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslError", overloads);
        return -1;
}

static PyObject*
SbkQSslErrorFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QSslError* cppSelf = Shiboken::Converter<QSslError* >::toCpp((PyObject*)self);
    QSslError::SslError cpp_result = cppSelf->QSslError::error();
    py_result = Shiboken::Converter<QSslError::SslError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslErrorFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QSslError* cppSelf = Shiboken::Converter<QSslError* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslError::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSslError_methods[] = {
    {"error", (PyCFunction)SbkQSslErrorFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQSslErrorFunc_errorString, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQSslError_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSslError& cpp_self = *Shiboken::Converter<QSslError* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSslError& >::isConvertible(other)) {
                QSslError* cpp_other = Shiboken::Converter<QSslError* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QSslError >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QSslError > cpp_other_auto_ptr;
                QSslError* cpp_other = Shiboken::Converter<QSslError* >::toCpp(other);
                if (!Shiboken::Converter<QSslError >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QSslError >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSslError_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSslError& >::isConvertible(other)) {
                QSslError* cpp_other = Shiboken::Converter<QSslError* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QSslError >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QSslError > cpp_other_auto_ptr;
                QSslError* cpp_other = Shiboken::Converter<QSslError* >::toCpp(other);
                if (!Shiboken::Converter<QSslError >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QSslError >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSslError_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSslError_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSslError_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSslError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSslError >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSslError_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSslError_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSslError_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QSslError_SslError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSslError_SslError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSslError_SslError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SslError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSslError_SslError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSslError_SslError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSslError_SslError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSslError(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QSSLERROR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSslError_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSslError_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSslError_Type));
    PyModule_AddObject(module, "QSslError",
        ((PyObject*)&SbkQSslError_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SslError
    SbkPySide_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX] = &SbkPySide_QtNetwork_QSslError_SslError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSslError_SslError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSslError_SslError_Type);
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
            "SslError",((PyObject*)&SbkPySide_QtNetwork_QSslError_SslError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::NoError, "NoError");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnableToGetIssuerCertificate, "UnableToGetIssuerCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnableToGetIssuerCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnableToGetIssuerCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnableToDecryptCertificateSignature, "UnableToDecryptCertificateSignature");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnableToDecryptCertificateSignature", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnableToDecryptCertificateSignature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnableToDecodeIssuerPublicKey, "UnableToDecodeIssuerPublicKey");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnableToDecodeIssuerPublicKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnableToDecodeIssuerPublicKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateSignatureFailed, "CertificateSignatureFailed");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateSignatureFailed", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateSignatureFailed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateNotYetValid, "CertificateNotYetValid");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateNotYetValid", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateNotYetValid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateExpired, "CertificateExpired");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateExpired", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateExpired", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::InvalidNotBeforeField, "InvalidNotBeforeField");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "InvalidNotBeforeField", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "InvalidNotBeforeField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::InvalidNotAfterField, "InvalidNotAfterField");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "InvalidNotAfterField", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "InvalidNotAfterField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::SelfSignedCertificate, "SelfSignedCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "SelfSignedCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "SelfSignedCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::SelfSignedCertificateInChain, "SelfSignedCertificateInChain");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "SelfSignedCertificateInChain", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "SelfSignedCertificateInChain", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnableToGetLocalIssuerCertificate, "UnableToGetLocalIssuerCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnableToGetLocalIssuerCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnableToGetLocalIssuerCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnableToVerifyFirstCertificate, "UnableToVerifyFirstCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnableToVerifyFirstCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnableToVerifyFirstCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateRevoked, "CertificateRevoked");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateRevoked", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateRevoked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::InvalidCaCertificate, "InvalidCaCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "InvalidCaCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "InvalidCaCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::PathLengthExceeded, "PathLengthExceeded");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "PathLengthExceeded", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "PathLengthExceeded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::InvalidPurpose, "InvalidPurpose");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "InvalidPurpose", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "InvalidPurpose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateUntrusted, "CertificateUntrusted");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateUntrusted", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateUntrusted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::CertificateRejected, "CertificateRejected");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "CertificateRejected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "CertificateRejected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::SubjectIssuerMismatch, "SubjectIssuerMismatch");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "SubjectIssuerMismatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "SubjectIssuerMismatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::AuthorityIssuerSerialNumberMismatch, "AuthorityIssuerSerialNumberMismatch");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "AuthorityIssuerSerialNumberMismatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "AuthorityIssuerSerialNumberMismatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::NoPeerCertificate, "NoPeerCertificate");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "NoPeerCertificate", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "NoPeerCertificate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::HostNameMismatch, "HostNameMismatch");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "HostNameMismatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "HostNameMismatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::NoSslSupport, "NoSslSupport");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "NoSslSupport", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "NoSslSupport", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSslError_SslError_Type,
        (long) QSslError::UnspecifiedError, "UnspecifiedError");
    PyDict_SetItemString(SbkQSslError_Type.super.ht_type.tp_dict,
        "UnspecifiedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSslError_SslError_Type.tp_dict,
        "UnspecifiedError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSslError::SslError");

    Shiboken::TypeResolver::createValueTypeResolver<QSslError >("QSslError");
    Shiboken::TypeResolver::createValueTypeResolver<QSslError >(typeid(QSslError).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

