/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qsslconfiguration_wrapper.h"

// Extra includes
#include <QList>
#include <qsslcipher.h>
#include <qsslconfiguration.h>
#include <qsslkey.h>

using namespace Shiboken;

static int
SbkQSslConfiguration_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSslConfiguration* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSslConfiguration", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSslConfiguration()
        cptr = new QSslConfiguration();
    } else if (numArgs == 1 && Shiboken::Converter<QSslConfiguration& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSslConfiguration* cpp_arg0 = Shiboken::Converter<QSslConfiguration* >::toCpp(pyargs[0]);
        // QSslConfiguration(QSslConfiguration)
        cptr = new QSslConfiguration(*cpp_arg0);
    } else goto SbkQSslConfiguration_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSslConfiguration_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSslConfiguration_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QSslConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslConfiguration", overloads);
        return -1;
}

static PyObject*
SbkQSslConfigurationFunc_ciphers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ciphers()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    QList<QSslCipher > cpp_result = cppSelf->QSslConfiguration::ciphers();
    py_result = Shiboken::Converter<QList<QSslCipher > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_defaultConfiguration(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultConfiguration()
    QSslConfiguration cpp_result = QSslConfiguration::defaultConfiguration();
    py_result = Shiboken::Converter<QSslConfiguration >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslConfiguration::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_peerVerifyDepth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerVerifyDepth()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSslConfiguration::peerVerifyDepth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_peerVerifyMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerVerifyMode()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    QSslSocket::PeerVerifyMode cpp_result = cppSelf->QSslConfiguration::peerVerifyMode();
    py_result = Shiboken::Converter<QSslSocket::PeerVerifyMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_privateKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // privateKey()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    QSslKey cpp_result = cppSelf->QSslConfiguration::privateKey();
    py_result = Shiboken::Converter<QSslKey >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_protocol(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // protocol()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    QSsl::SslProtocol cpp_result = cppSelf->QSslConfiguration::protocol();
    py_result = Shiboken::Converter<QSsl::SslProtocol >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_sessionCipher(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionCipher()const
    QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
    QSslCipher cpp_result = cppSelf->QSslConfiguration::sessionCipher();
    py_result = Shiboken::Converter<QSslCipher >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslConfigurationFunc_setCiphers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QSslCipher >  >::isConvertible(arg)) {
        QList<QSslCipher >  cpp_arg0 = Shiboken::Converter<QList<QSslCipher >  >::toCpp(arg);
        // setCiphers(QList<QSslCipher>)
        QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
        cppSelf->QSslConfiguration::setCiphers(cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setCiphers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setCiphers_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setCiphers", overloads);
        return 0;
}

static PyObject*
SbkQSslConfigurationFunc_setDefaultConfiguration(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QSslConfiguration& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSslConfiguration* cpp_arg0 = Shiboken::Converter<QSslConfiguration* >::toCpp(arg);
        // setDefaultConfiguration(QSslConfiguration)
        QSslConfiguration::setDefaultConfiguration(*cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setDefaultConfiguration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setDefaultConfiguration_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setDefaultConfiguration", overloads);
        return 0;
}

static PyObject*
SbkQSslConfigurationFunc_setPeerVerifyDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPeerVerifyDepth(int)
        QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
        cppSelf->QSslConfiguration::setPeerVerifyDepth(cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setPeerVerifyDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setPeerVerifyDepth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setPeerVerifyDepth", overloads);
        return 0;
}

static PyObject*
SbkQSslConfigurationFunc_setPeerVerifyMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslSocket::PeerVerifyMode >::isConvertible(arg)) {
        QSslSocket::PeerVerifyMode cpp_arg0 = Shiboken::Converter<QSslSocket::PeerVerifyMode >::toCpp(arg);
        // setPeerVerifyMode(QSslSocket::PeerVerifyMode)
        QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
        cppSelf->QSslConfiguration::setPeerVerifyMode(cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setPeerVerifyMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setPeerVerifyMode_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslSocket.PeerVerifyMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setPeerVerifyMode", overloads);
        return 0;
}

static PyObject*
SbkQSslConfigurationFunc_setPrivateKey(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslKey& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSslKey* cpp_arg0 = Shiboken::Converter<QSslKey* >::toCpp(arg);
        // setPrivateKey(QSslKey)
        QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
        cppSelf->QSslConfiguration::setPrivateKey(*cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setPrivateKey_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setPrivateKey_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslKey", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setPrivateKey", overloads);
        return 0;
}

static PyObject*
SbkQSslConfigurationFunc_setProtocol(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSsl::SslProtocol >::isConvertible(arg)) {
        QSsl::SslProtocol cpp_arg0 = Shiboken::Converter<QSsl::SslProtocol >::toCpp(arg);
        // setProtocol(QSsl::SslProtocol)
        QSslConfiguration* cppSelf = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);
        cppSelf->QSslConfiguration::setProtocol(cpp_arg0);
    } else goto SbkQSslConfigurationFunc_setProtocol_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSslConfigurationFunc_setProtocol_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSsl.SslProtocol", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QSslConfiguration.setProtocol", overloads);
        return 0;
}

static PyMethodDef SbkQSslConfiguration_methods[] = {
    {"ciphers", (PyCFunction)SbkQSslConfigurationFunc_ciphers, METH_NOARGS},
    {"defaultConfiguration", (PyCFunction)SbkQSslConfigurationFunc_defaultConfiguration, METH_NOARGS|METH_STATIC},
    {"isNull", (PyCFunction)SbkQSslConfigurationFunc_isNull, METH_NOARGS},
    {"peerVerifyDepth", (PyCFunction)SbkQSslConfigurationFunc_peerVerifyDepth, METH_NOARGS},
    {"peerVerifyMode", (PyCFunction)SbkQSslConfigurationFunc_peerVerifyMode, METH_NOARGS},
    {"privateKey", (PyCFunction)SbkQSslConfigurationFunc_privateKey, METH_NOARGS},
    {"protocol", (PyCFunction)SbkQSslConfigurationFunc_protocol, METH_NOARGS},
    {"sessionCipher", (PyCFunction)SbkQSslConfigurationFunc_sessionCipher, METH_NOARGS},
    {"setCiphers", (PyCFunction)SbkQSslConfigurationFunc_setCiphers, METH_O},
    {"setDefaultConfiguration", (PyCFunction)SbkQSslConfigurationFunc_setDefaultConfiguration, METH_O|METH_STATIC},
    {"setPeerVerifyDepth", (PyCFunction)SbkQSslConfigurationFunc_setPeerVerifyDepth, METH_O},
    {"setPeerVerifyMode", (PyCFunction)SbkQSslConfigurationFunc_setPeerVerifyMode, METH_O},
    {"setPrivateKey", (PyCFunction)SbkQSslConfigurationFunc_setPrivateKey, METH_O},
    {"setProtocol", (PyCFunction)SbkQSslConfigurationFunc_setProtocol, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQSslConfiguration_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSslConfiguration& cpp_self = *Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSslConfiguration& >::isConvertible(other)) {
                QSslConfiguration* cpp_other = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSslConfiguration_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSslConfiguration& >::isConvertible(other)) {
                QSslConfiguration* cpp_other = Shiboken::Converter<QSslConfiguration* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSslConfiguration_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSslConfiguration_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSslConfiguration_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSslConfiguration",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSslConfiguration >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSslConfiguration_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSslConfiguration_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSslConfiguration_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSslConfiguration(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSslConfiguration_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSslConfiguration_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSslConfiguration_Type));
    PyModule_AddObject(module, "QSslConfiguration",
        ((PyObject*)&SbkQSslConfiguration_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSslConfiguration >("QSslConfiguration");
    Shiboken::TypeResolver::createValueTypeResolver<QSslConfiguration >(typeid(QSslConfiguration).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

