/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qnetworkreply_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qnetworkaccessmanager.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsslconfiguration.h>
#include <qsslerror.h>
#include <qstring.h>
#include <qthread.h>
#include <qurl.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QNetworkReplyWrapper::QNetworkReplyWrapper(QObject * parent) : QNetworkReply(parent), m_metaObject(0) {
    // ... middle
}

void QNetworkReplyWrapper::abort()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "abort"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkReply.abort()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkReplyWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QIODevice::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.atEnd");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.bytesAvailable");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.bytesToWrite");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QNetworkReplyWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.canReadLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QNetworkReplyWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkReplyWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QNetworkReply::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QNetworkReplyWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QNetworkReplyWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkReplyWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkReplyWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QNetworkReplyWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QNetworkReplyWrapper::ignoreSslErrors()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ignoreSslErrors"));
    if (py_override.isNull()) {
        return this->QNetworkReply::ignoreSslErrors();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkReplyWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QNetworkReply::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QNetworkReplyWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkReply.readData()' not implemented.");
        return qint64(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.readData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.readLineData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QNetworkReplyWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QNetworkReplyWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QNetworkReplyWrapper::setReadBufferSize(qint64 size)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setReadBufferSize"));
    if (py_override.isNull()) {
        return this->QNetworkReply::setReadBufferSize(size);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(size)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

qint64 QNetworkReplyWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QNetworkReplyWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QNetworkReplyWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.waitForBytesWritten");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QNetworkReplyWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.waitForReadyRead");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QNetworkReplyWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QNetworkReply::writeData(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QNetworkReply.writeData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QNetworkReplyWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QNetworkReply::staticMetaObject);
}
    return m_metaObject;
}

int QNetworkReplyWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QNetworkReply::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QNetworkReplyWrapper::~QNetworkReplyWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQNetworkReply_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkReplyWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QNetworkReply' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QNetworkReply", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QNetworkReply(QObject*)
        cptr = new QNetworkReplyWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QNetworkReply(QObject*)
        cptr = new QNetworkReplyWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQNetworkReply_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkReply_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQNetworkReply_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply", overloads);
        return -1;
}

static PyObject*
SbkQNetworkReplyFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkReply.abort()' not implemented.");
        return 0;
    }
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    cppSelf->abort();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQNetworkReplyFunc_attribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest::Attribute >::isConvertible(arg)) {
        QNetworkRequest::Attribute cpp_arg0 = Shiboken::Converter<QNetworkRequest::Attribute >::toCpp(arg);
        // attribute(QNetworkRequest::Attribute)const
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QNetworkReply::attribute(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQNetworkReplyFunc_attribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQNetworkReplyFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.attribute", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QNetworkReply::close();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQNetworkReplyFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QNetworkReply::NetworkError cpp_result = cppSelf->QNetworkReply::error();
    py_result = Shiboken::Converter<QNetworkReply::NetworkError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_hasRawHeader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // hasRawHeader(QByteArray)const
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QNetworkReply::hasRawHeader(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQNetworkReplyFunc_hasRawHeader_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQNetworkReplyFunc_hasRawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.hasRawHeader", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_header(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest::KnownHeaders >::isConvertible(arg)) {
        QNetworkRequest::KnownHeaders cpp_arg0 = Shiboken::Converter<QNetworkRequest::KnownHeaders >::toCpp(arg);
        // header(QNetworkRequest::KnownHeaders)const
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QNetworkReply::header(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQNetworkReplyFunc_header_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQNetworkReplyFunc_header_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.KnownHeaders", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.header", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_ignoreSslErrors(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // ignoreSslErrors()
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::ignoreSslErrors();
    } else if (Shiboken::Converter<QList<QSslError >  >::isConvertible(arg)) {
        QList<QSslError >  cpp_arg0 = Shiboken::Converter<QList<QSslError >  >::toCpp(arg);
        // ignoreSslErrors(QList<QSslError>)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::ignoreSslErrors(cpp_arg0);
    } else goto SbkQNetworkReplyFunc_ignoreSslErrors_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_ignoreSslErrors_TypeError:
        const char* overloads[] = {"", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.ignoreSslErrors", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_isFinished(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFinished()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkReply::isFinished();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_isRunning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRunning()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkReply::isRunning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkReply::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_manager(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // manager()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QNetworkAccessManager * cpp_result = cppSelf->QNetworkReply::manager();
    py_result = Shiboken::Converter<QNetworkAccessManager* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_operation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // operation()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QNetworkAccessManager::Operation cpp_result = cppSelf->QNetworkReply::operation();
    py_result = Shiboken::Converter<QNetworkAccessManager::Operation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_rawHeader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // rawHeader(QByteArray)const
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QNetworkReply::rawHeader(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQNetworkReplyFunc_rawHeader_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQNetworkReplyFunc_rawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.rawHeader", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_rawHeaderList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rawHeaderList()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QList<QByteArray > cpp_result = cppSelf->QNetworkReply::rawHeaderList();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_readBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readBufferSize()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QNetworkReply::readBufferSize();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_request(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // request()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QNetworkRequest cpp_result = cppSelf->QNetworkReply::request();
    py_result = Shiboken::Converter<QNetworkRequest >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QNetworkRequest::Attribute >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        QNetworkRequest::Attribute cpp_arg0 = Shiboken::Converter<QNetworkRequest::Attribute >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setAttribute(QNetworkRequest::Attribute,QVariant)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setAttribute(cpp_arg0, *cpp_arg1);
    } else goto SbkQNetworkReplyFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.Attribute, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply.setAttribute", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setError(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setError", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QNetworkReply::NetworkError >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        QNetworkReply::NetworkError cpp_arg0 = Shiboken::Converter<QNetworkReply::NetworkError >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setError(QNetworkReply::NetworkError,QString)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setError(cpp_arg0, *cpp_arg1);
    } else goto SbkQNetworkReplyFunc_setError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setError_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkReply.NetworkError, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply.setError", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setHeader(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHeader", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QNetworkRequest::KnownHeaders >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        QNetworkRequest::KnownHeaders cpp_arg0 = Shiboken::Converter<QNetworkRequest::KnownHeaders >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setHeader(QNetworkRequest::KnownHeaders,QVariant)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setHeader(cpp_arg0, *cpp_arg1);
    } else goto SbkQNetworkReplyFunc_setHeader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setHeader_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.KnownHeaders, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply.setHeader", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setOperation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkAccessManager::Operation >::isConvertible(arg)) {
        QNetworkAccessManager::Operation cpp_arg0 = Shiboken::Converter<QNetworkAccessManager::Operation >::toCpp(arg);
        // setOperation(QNetworkAccessManager::Operation)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setOperation(cpp_arg0);
    } else goto SbkQNetworkReplyFunc_setOperation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setOperation_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkAccessManager.Operation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.setOperation", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setRawHeader(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRawHeader", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // setRawHeader(QByteArray,QByteArray)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setRawHeader(*cpp_arg0, *cpp_arg1);
    } else goto SbkQNetworkReplyFunc_setRawHeader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setRawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply.setRawHeader", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setReadBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setReadBufferSize(qint64)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setReadBufferSize(cpp_arg0);
    } else goto SbkQNetworkReplyFunc_setReadBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setReadBufferSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.setReadBufferSize", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setRequest(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkRequest& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(arg);
        // setRequest(QNetworkRequest)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setRequest(*cpp_arg0);
    } else goto SbkQNetworkReplyFunc_setRequest_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setRequest_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.setRequest", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setSslConfiguration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslConfiguration& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSslConfiguration* cpp_arg0 = Shiboken::Converter<QSslConfiguration* >::toCpp(arg);
        // setSslConfiguration(QSslConfiguration)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setSslConfiguration(*cpp_arg0);
    } else goto SbkQNetworkReplyFunc_setSslConfiguration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setSslConfiguration_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.setSslConfiguration", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_setUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUrl& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!Shiboken::Converter<QUrl& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setUrl(QUrl)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        cppSelf->QNetworkReply::setUrl(*cpp_arg0);
    } else goto SbkQNetworkReplyFunc_setUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkReplyFunc_setUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkReply.setUrl", overloads);
        return 0;
}

static PyObject*
SbkQNetworkReplyFunc_sslConfiguration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sslConfiguration()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QSslConfiguration cpp_result = cppSelf->QNetworkReply::sslConfiguration();
    py_result = Shiboken::Converter<QSslConfiguration >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QNetworkReply::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkReplyFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QNetworkReply* cppSelf = Shiboken::Converter<QNetworkReply* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QNetworkReply::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQNetworkReplyFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQNetworkReplyFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkReply.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQNetworkReply_methods[] = {
    {"abort", (PyCFunction)SbkQNetworkReplyFunc_abort, METH_NOARGS},
    {"attribute", (PyCFunction)SbkQNetworkReplyFunc_attribute, METH_O},
    {"close", (PyCFunction)SbkQNetworkReplyFunc_close, METH_NOARGS},
    {"error", (PyCFunction)SbkQNetworkReplyFunc_error, METH_NOARGS},
    {"hasRawHeader", (PyCFunction)SbkQNetworkReplyFunc_hasRawHeader, METH_O},
    {"header", (PyCFunction)SbkQNetworkReplyFunc_header, METH_O},
    {"ignoreSslErrors", (PyCFunction)SbkQNetworkReplyFunc_ignoreSslErrors, METH_NOARGS|METH_O},
    {"isFinished", (PyCFunction)SbkQNetworkReplyFunc_isFinished, METH_NOARGS},
    {"isRunning", (PyCFunction)SbkQNetworkReplyFunc_isRunning, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQNetworkReplyFunc_isSequential, METH_NOARGS},
    {"manager", (PyCFunction)SbkQNetworkReplyFunc_manager, METH_NOARGS},
    {"operation", (PyCFunction)SbkQNetworkReplyFunc_operation, METH_NOARGS},
    {"rawHeader", (PyCFunction)SbkQNetworkReplyFunc_rawHeader, METH_O},
    {"rawHeaderList", (PyCFunction)SbkQNetworkReplyFunc_rawHeaderList, METH_NOARGS},
    {"readBufferSize", (PyCFunction)SbkQNetworkReplyFunc_readBufferSize, METH_NOARGS},
    {"request", (PyCFunction)SbkQNetworkReplyFunc_request, METH_NOARGS},
    {"setAttribute", (PyCFunction)SbkQNetworkReplyFunc_setAttribute, METH_VARARGS},
    {"setError", (PyCFunction)SbkQNetworkReplyFunc_setError, METH_VARARGS},
    {"setHeader", (PyCFunction)SbkQNetworkReplyFunc_setHeader, METH_VARARGS},
    {"setOperation", (PyCFunction)SbkQNetworkReplyFunc_setOperation, METH_O},
    {"setRawHeader", (PyCFunction)SbkQNetworkReplyFunc_setRawHeader, METH_VARARGS},
    {"setReadBufferSize", (PyCFunction)SbkQNetworkReplyFunc_setReadBufferSize, METH_O},
    {"setRequest", (PyCFunction)SbkQNetworkReplyFunc_setRequest, METH_O},
    {"setSslConfiguration", (PyCFunction)SbkQNetworkReplyFunc_setSslConfiguration, METH_O},
    {"setUrl", (PyCFunction)SbkQNetworkReplyFunc_setUrl, METH_O},
    {"sslConfiguration", (PyCFunction)SbkQNetworkReplyFunc_sslConfiguration, METH_NOARGS},
    {"url", (PyCFunction)SbkQNetworkReplyFunc_url, METH_NOARGS},
    {"writeData", (PyCFunction)SbkQNetworkReplyFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkReply_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkReply",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QNetworkReplyWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkReply_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkReply_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QNetworkReply_NetworkError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkReply_NetworkError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NetworkError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkReply_NetworkError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkReply_NetworkError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QNetworkReply_NetworkError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QNetworkReply(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkReply_Type);

    SbkQNetworkReply_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX];
    // Fill type discovery information
    SbkQNetworkReply_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkReply_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkReply_Type));
    PyModule_AddObject(module, "QNetworkReply",
        ((PyObject*)&SbkQNetworkReply_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: NetworkError
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_NETWORKERROR_IDX] = &SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type);
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
            "NetworkError",((PyObject*)&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::NoError, "NoError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ConnectionRefusedError, "ConnectionRefusedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ConnectionRefusedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ConnectionRefusedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::RemoteHostClosedError, "RemoteHostClosedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "RemoteHostClosedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "RemoteHostClosedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::HostNotFoundError, "HostNotFoundError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "HostNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "HostNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::TimeoutError, "TimeoutError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "TimeoutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "TimeoutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::OperationCanceledError, "OperationCanceledError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "OperationCanceledError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "OperationCanceledError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::SslHandshakeFailedError, "SslHandshakeFailedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "SslHandshakeFailedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "SslHandshakeFailedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::UnknownNetworkError, "UnknownNetworkError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "UnknownNetworkError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "UnknownNetworkError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProxyConnectionRefusedError, "ProxyConnectionRefusedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProxyConnectionRefusedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProxyConnectionRefusedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProxyConnectionClosedError, "ProxyConnectionClosedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProxyConnectionClosedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProxyConnectionClosedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProxyNotFoundError, "ProxyNotFoundError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProxyNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProxyNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProxyTimeoutError, "ProxyTimeoutError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProxyTimeoutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProxyTimeoutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProxyAuthenticationRequiredError, "ProxyAuthenticationRequiredError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::UnknownProxyError, "UnknownProxyError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "UnknownProxyError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "UnknownProxyError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ContentAccessDenied, "ContentAccessDenied");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ContentAccessDenied", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ContentAccessDenied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ContentOperationNotPermittedError, "ContentOperationNotPermittedError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ContentOperationNotPermittedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ContentOperationNotPermittedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ContentNotFoundError, "ContentNotFoundError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ContentNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ContentNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::AuthenticationRequiredError, "AuthenticationRequiredError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "AuthenticationRequiredError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "AuthenticationRequiredError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ContentReSendError, "ContentReSendError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ContentReSendError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ContentReSendError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::UnknownContentError, "UnknownContentError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "UnknownContentError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "UnknownContentError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProtocolUnknownError, "ProtocolUnknownError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProtocolUnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProtocolUnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProtocolInvalidOperationError, "ProtocolInvalidOperationError");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProtocolInvalidOperationError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProtocolInvalidOperationError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type,
        (long) QNetworkReply::ProtocolFailure, "ProtocolFailure");
    PyDict_SetItemString(SbkQNetworkReply_Type.super.ht_type.tp_dict,
        "ProtocolFailure", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkReply_NetworkError_Type.tp_dict,
        "ProtocolFailure", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkReply::NetworkError");

    Shiboken::TypeResolver::createObjectTypeResolver<QNetworkReply >("QNetworkReply*");
    Shiboken::TypeResolver::createObjectTypeResolver<QNetworkReply >(typeid(QNetworkReply).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

