/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qnetworkproxy_wrapper.h"

// Extra includes
#include <qnetworkproxy.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQNetworkProxy_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkProxy* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QNetworkProxy", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QNetworkProxy()
        cptr = new QNetworkProxy();
    } else if (Shiboken::Converter<QNetworkProxy::ProxyType >::isConvertible(pyargs[0])) {
        QNetworkProxy::ProxyType cpp_arg0 = Shiboken::Converter<QNetworkProxy::ProxyType >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
            cptr = new QNetworkProxy(cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                cptr = new QNetworkProxy(cpp_arg0, *cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                quint16 cpp_arg2 = Shiboken::Converter<quint16 >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                    cptr = new QNetworkProxy(cpp_arg0, *cpp_arg1, cpp_arg2);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return -1;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    if (numArgs == 4) {
                        // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                        cptr = new QNetworkProxy(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
                    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[4])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                            return -1;
                        std::auto_ptr<QString > cpp_arg4_auto_ptr;
                        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
                        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[4]))
                            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
                        // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                        cptr = new QNetworkProxy(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4);
                    } else goto SbkQNetworkProxy_Init_TypeError;
                } else goto SbkQNetworkProxy_Init_TypeError;
            } else goto SbkQNetworkProxy_Init_TypeError;
        } else goto SbkQNetworkProxy_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkProxy& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QNetworkProxy& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // QNetworkProxy(QNetworkProxy)
        cptr = new QNetworkProxy(*cpp_arg0);
    } else goto SbkQNetworkProxy_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkProxy_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQNetworkProxy_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QNetworkProxy.ProxyType, PySide.QtCore.QString = QString(), unsigned short = 0, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", "PySide.QtNetwork.QNetworkProxy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkProxy", overloads);
        return -1;
}

static PyObject*
SbkQNetworkProxyFunc_applicationProxy(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationProxy()
    QNetworkProxy cpp_result = QNetworkProxy::applicationProxy();
    py_result = Shiboken::Converter<QNetworkProxy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_hostName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hostName()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkProxy::hostName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_isCachingProxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCachingProxy()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkProxy::isCachingProxy();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_isTransparentProxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTransparentProxy()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkProxy::isTransparentProxy();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_password(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // password()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkProxy::password();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_port(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // port()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    quint16 cpp_result = cppSelf->QNetworkProxy::port();
    py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_setApplicationProxy(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QNetworkProxy& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(arg);
        if (!Shiboken::Converter<QNetworkProxy& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // setApplicationProxy(QNetworkProxy)
        QNetworkProxy::setApplicationProxy(*cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setApplicationProxy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setApplicationProxy_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setApplicationProxy", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_setHostName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHostName(QString)
        QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
        cppSelf->QNetworkProxy::setHostName(*cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setHostName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setHostName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setHostName", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_setPassword(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPassword(QString)
        QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
        cppSelf->QNetworkProxy::setPassword(*cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setPassword_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setPassword_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setPassword", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_setPort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint16 cpp_arg0 = Shiboken::Converter<quint16 >::toCpp(arg);
        // setPort(quint16)
        QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
        cppSelf->QNetworkProxy::setPort(cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setPort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setPort_TypeError:
        const char* overloads[] = {"unsigned short", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setPort", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_setType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkProxy::ProxyType >::isConvertible(arg)) {
        QNetworkProxy::ProxyType cpp_arg0 = Shiboken::Converter<QNetworkProxy::ProxyType >::toCpp(arg);
        // setType(QNetworkProxy::ProxyType)
        QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
        cppSelf->QNetworkProxy::setType(cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setType_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy.ProxyType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setType", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_setUser(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setUser(QString)
        QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
        cppSelf->QNetworkProxy::setUser(*cpp_arg0);
    } else goto SbkQNetworkProxyFunc_setUser_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkProxyFunc_setUser_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkProxy.setUser", overloads);
        return 0;
}

static PyObject*
SbkQNetworkProxyFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    QNetworkProxy::ProxyType cpp_result = cppSelf->QNetworkProxy::type();
    py_result = Shiboken::Converter<QNetworkProxy::ProxyType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQNetworkProxyFunc_user(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // user()const
    QNetworkProxy* cppSelf = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkProxy::user();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQNetworkProxy_methods[] = {
    {"applicationProxy", (PyCFunction)SbkQNetworkProxyFunc_applicationProxy, METH_NOARGS|METH_STATIC},
    {"hostName", (PyCFunction)SbkQNetworkProxyFunc_hostName, METH_NOARGS},
    {"isCachingProxy", (PyCFunction)SbkQNetworkProxyFunc_isCachingProxy, METH_NOARGS},
    {"isTransparentProxy", (PyCFunction)SbkQNetworkProxyFunc_isTransparentProxy, METH_NOARGS},
    {"password", (PyCFunction)SbkQNetworkProxyFunc_password, METH_NOARGS},
    {"port", (PyCFunction)SbkQNetworkProxyFunc_port, METH_NOARGS},
    {"setApplicationProxy", (PyCFunction)SbkQNetworkProxyFunc_setApplicationProxy, METH_O|METH_STATIC},
    {"setHostName", (PyCFunction)SbkQNetworkProxyFunc_setHostName, METH_O},
    {"setPassword", (PyCFunction)SbkQNetworkProxyFunc_setPassword, METH_O},
    {"setPort", (PyCFunction)SbkQNetworkProxyFunc_setPort, METH_O},
    {"setType", (PyCFunction)SbkQNetworkProxyFunc_setType, METH_O},
    {"setUser", (PyCFunction)SbkQNetworkProxyFunc_setUser, METH_O},
    {"type", (PyCFunction)SbkQNetworkProxyFunc_type, METH_NOARGS},
    {"user", (PyCFunction)SbkQNetworkProxyFunc_user, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQNetworkProxy_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QNetworkProxy& cpp_self = *Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QNetworkProxy& >::isConvertible(other)) {
                QNetworkProxy* cpp_other = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QNetworkProxy >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QNetworkProxy > cpp_other_auto_ptr;
                QNetworkProxy* cpp_other = Shiboken::Converter<QNetworkProxy* >::toCpp(other);
                if (!Shiboken::Converter<QNetworkProxy >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQNetworkProxy_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QNetworkProxy& >::isConvertible(other)) {
                QNetworkProxy* cpp_other = Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QNetworkProxy >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QNetworkProxy > cpp_other_auto_ptr;
                QNetworkProxy* cpp_other = Shiboken::Converter<QNetworkProxy* >::toCpp(other);
                if (!Shiboken::Converter<QNetworkProxy >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQNetworkProxy_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQNetworkProxy_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkProxy_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkProxy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QNetworkProxy >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQNetworkProxy_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkProxy_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkProxy_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QNetworkProxy_ProxyType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkProxy_ProxyType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProxyType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkProxy_ProxyType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkProxy_ProxyType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QNetworkProxy_ProxyType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QNetworkProxy_Capability_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkProxy_Capability_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkProxy_Capability_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Capability",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkProxy_Capability_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkProxy_Capability_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QNetworkProxy_Capability_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QNetworkProxy(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkProxy_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkProxy_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkProxy_Type));
    PyModule_AddObject(module, "QNetworkProxy",
        ((PyObject*)&SbkQNetworkProxy_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ProxyType
    SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX] = &SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type);
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
            "ProxyType",((PyObject*)&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::DefaultProxy, "DefaultProxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "DefaultProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "DefaultProxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::Socks5Proxy, "Socks5Proxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "Socks5Proxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "Socks5Proxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::NoProxy, "NoProxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "NoProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "NoProxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::HttpProxy, "HttpProxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "HttpProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "HttpProxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::HttpCachingProxy, "HttpCachingProxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "HttpCachingProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "HttpCachingProxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type,
        (long) QNetworkProxy::FtpCachingProxy, "FtpCachingProxy");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "FtpCachingProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Type.tp_dict,
        "FtpCachingProxy", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkProxy::ProxyType");

    // init enum class: Capability
    SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX] = &SbkPySide_QtNetwork_QNetworkProxy_Capability_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type);
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
            "Capability",((PyObject*)&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type,
        (long) QNetworkProxy::TunnelingCapability, "TunnelingCapability");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "TunnelingCapability", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_Capability_Type.tp_dict,
        "TunnelingCapability", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type,
        (long) QNetworkProxy::ListeningCapability, "ListeningCapability");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "ListeningCapability", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_Capability_Type.tp_dict,
        "ListeningCapability", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type,
        (long) QNetworkProxy::UdpTunnelingCapability, "UdpTunnelingCapability");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "UdpTunnelingCapability", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_Capability_Type.tp_dict,
        "UdpTunnelingCapability", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type,
        (long) QNetworkProxy::CachingCapability, "CachingCapability");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "CachingCapability", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_Capability_Type.tp_dict,
        "CachingCapability", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkProxy_Capability_Type,
        (long) QNetworkProxy::HostNameLookupCapability, "HostNameLookupCapability");
    PyDict_SetItemString(SbkQNetworkProxy_Type.super.ht_type.tp_dict,
        "HostNameLookupCapability", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkProxy_Capability_Type.tp_dict,
        "HostNameLookupCapability", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkProxy::Capability");

    Shiboken::TypeResolver::createValueTypeResolver<QNetworkProxy >("QNetworkProxy");
    Shiboken::TypeResolver::createValueTypeResolver<QNetworkProxy >(typeid(QNetworkProxy).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

