/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qhostinfo_wrapper.h"

// Extra includes
#include <QList>
#include <qhostaddress.h>
#include <qhostinfo.h>
#include <qobject.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQHostInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHostInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QHostInfo", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QHostInfo(int)
        cptr = new QHostInfo();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QHostInfo(int)
        cptr = new QHostInfo(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QHostInfo& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QHostInfo > cpp_arg0_auto_ptr;
        QHostInfo* cpp_arg0 = Shiboken::Converter<QHostInfo* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHostInfo& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostInfo >(cpp_arg0);
        // QHostInfo(QHostInfo)
        cptr = new QHostInfo(*cpp_arg0);
    } else goto SbkQHostInfo_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHostInfo_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHostInfo_Init_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostInfo", "int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHostInfo", overloads);
        return -1;
}

static PyObject*
SbkQHostInfoFunc_abortHostLookup(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // abortHostLookup(int)
        QHostInfo::abortHostLookup(cpp_arg0);
    } else goto SbkQHostInfoFunc_abortHostLookup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_abortHostLookup_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.abortHostLookup", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_addresses(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // addresses()const
    QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
    QList<QHostAddress > cpp_result = cppSelf->QHostInfo::addresses();
    py_result = Shiboken::Converter<QList<QHostAddress > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
    QHostInfo::HostInfoError cpp_result = cppSelf->QHostInfo::error();
    py_result = Shiboken::Converter<QHostInfo::HostInfoError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHostInfo::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_fromName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromName(QString)
        QHostInfo cpp_result = QHostInfo::fromName(*cpp_arg0);
        py_result = Shiboken::Converter<QHostInfo >::toPython(cpp_result);
    } else goto SbkQHostInfoFunc_fromName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHostInfoFunc_fromName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.fromName", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_hostName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hostName()const
    QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHostInfo::hostName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_localDomainName(PyObject* self)
{
    PyObject* py_result = 0;

    // localDomainName()
    QString cpp_result = QHostInfo::localDomainName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_localHostName(PyObject* self)
{
    PyObject* py_result = 0;

    // localHostName()
    QString cpp_result = QHostInfo::localHostName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_lookupId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lookupId()const
    QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHostInfo::lookupId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHostInfoFunc_setAddresses(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QHostAddress >  >::isConvertible(arg)) {
        QList<QHostAddress >  cpp_arg0 = Shiboken::Converter<QList<QHostAddress >  >::toCpp(arg);
        // setAddresses(QList<QHostAddress>)
        QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
        cppSelf->QHostInfo::setAddresses(cpp_arg0);
    } else goto SbkQHostInfoFunc_setAddresses_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_setAddresses_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.setAddresses", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_setError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostInfo::HostInfoError >::isConvertible(arg)) {
        QHostInfo::HostInfoError cpp_arg0 = Shiboken::Converter<QHostInfo::HostInfoError >::toCpp(arg);
        // setError(QHostInfo::HostInfoError)
        QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
        cppSelf->QHostInfo::setError(cpp_arg0);
    } else goto SbkQHostInfoFunc_setError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_setError_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostInfo.HostInfoError", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.setError", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_setErrorString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setErrorString(QString)
        QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
        cppSelf->QHostInfo::setErrorString(*cpp_arg0);
    } else goto SbkQHostInfoFunc_setErrorString_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_setErrorString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.setErrorString", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_setHostName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHostName(QString)
        QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
        cppSelf->QHostInfo::setHostName(*cpp_arg0);
    } else goto SbkQHostInfoFunc_setHostName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_setHostName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.setHostName", overloads);
        return 0;
}

static PyObject*
SbkQHostInfoFunc_setLookupId(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLookupId(int)
        QHostInfo* cppSelf = Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)self);
        cppSelf->QHostInfo::setLookupId(cpp_arg0);
    } else goto SbkQHostInfoFunc_setLookupId_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostInfoFunc_setLookupId_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostInfo.setLookupId", overloads);
        return 0;
}

static PyMethodDef SbkQHostInfo_methods[] = {
    {"abortHostLookup", (PyCFunction)SbkQHostInfoFunc_abortHostLookup, METH_O|METH_STATIC},
    {"addresses", (PyCFunction)SbkQHostInfoFunc_addresses, METH_NOARGS},
    {"error", (PyCFunction)SbkQHostInfoFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQHostInfoFunc_errorString, METH_NOARGS},
    {"fromName", (PyCFunction)SbkQHostInfoFunc_fromName, METH_O|METH_STATIC},
    {"hostName", (PyCFunction)SbkQHostInfoFunc_hostName, METH_NOARGS},
    {"localDomainName", (PyCFunction)SbkQHostInfoFunc_localDomainName, METH_NOARGS|METH_STATIC},
    {"localHostName", (PyCFunction)SbkQHostInfoFunc_localHostName, METH_NOARGS|METH_STATIC},
    {"lookupId", (PyCFunction)SbkQHostInfoFunc_lookupId, METH_NOARGS},
    {"setAddresses", (PyCFunction)SbkQHostInfoFunc_setAddresses, METH_O},
    {"setError", (PyCFunction)SbkQHostInfoFunc_setError, METH_O},
    {"setErrorString", (PyCFunction)SbkQHostInfoFunc_setErrorString, METH_O},
    {"setHostName", (PyCFunction)SbkQHostInfoFunc_setHostName, METH_O},
    {"setLookupId", (PyCFunction)SbkQHostInfoFunc_setLookupId, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHostInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHostInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHostInfo >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHostInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHostInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QHostInfo_HostInfoError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QHostInfo_HostInfoError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "HostInfoError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QHostInfo_HostInfoError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QHostInfo_HostInfoError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QHostInfo_HostInfoError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QHostInfo(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHostInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQHostInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHostInfo_Type));
    PyModule_AddObject(module, "QHostInfo",
        ((PyObject*)&SbkQHostInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: HostInfoError
    SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX] = &SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type);
    PyDict_SetItemString(SbkQHostInfo_Type.super.ht_type.tp_dict,
            "HostInfoError",((PyObject*)&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type,
        (long) QHostInfo::NoError, "NoError");
    PyDict_SetItemString(SbkQHostInfo_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type,
        (long) QHostInfo::HostNotFound, "HostNotFound");
    PyDict_SetItemString(SbkQHostInfo_Type.super.ht_type.tp_dict,
        "HostNotFound", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type.tp_dict,
        "HostNotFound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type,
        (long) QHostInfo::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQHostInfo_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostInfo_HostInfoError_Type.tp_dict,
        "UnknownError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHostInfo::HostInfoError");

    Shiboken::TypeResolver::createValueTypeResolver<QHostInfo >("QHostInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QHostInfo >(typeid(QHostInfo).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

