/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qabstractsocket_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractsocket.h>
#include <qauthenticator.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qhostaddress.h>
#include <qnetworkproxy.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractSocketWrapper::QAbstractSocketWrapper(QAbstractSocket::SocketType socketType, QObject * parent) : QAbstractSocket(socketType, parent), m_metaObject(0) {
    // ... middle
}

bool QAbstractSocketWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.atEnd");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.bytesAvailable");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.bytesToWrite");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSocketWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.canReadLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSocketWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSocketWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QAbstractSocket::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSocketWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSocketWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSocketWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractSocketWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractSocketWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QAbstractSocketWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSocketWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.readData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.readLineData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSocketWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSocketWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSocketWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractSocketWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QAbstractSocket::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.waitForBytesWritten");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSocketWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QAbstractSocket::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.waitForReadyRead");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QAbstractSocketWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QAbstractSocket::writeData(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSocket.writeData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QAbstractSocketWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractSocket::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractSocketWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractSocket::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractSocketWrapper::~QAbstractSocketWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractSocket_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractSocketWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QAbstractSocket", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QAbstractSocket::SocketType >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
        QAbstractSocket::SocketType cpp_arg0 = Shiboken::Converter<QAbstractSocket::SocketType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // QAbstractSocket(QAbstractSocket::SocketType,QObject*)
        cptr = new QAbstractSocketWrapper(cpp_arg0, cpp_arg1);
        Shiboken::setParent(pyargs[1], self);
    } else goto SbkQAbstractSocket_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractSocket_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractSocket_Init_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QAbstractSocket.SocketType, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket", overloads);
        return -1;
}

static PyObject*
SbkQAbstractSocketFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSocket::abort();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSocketFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSocket::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAbstractSocket::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_bytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesToWrite()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAbstractSocket::bytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_canReadLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canReadLine()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSocket::canReadLine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QAbstractSocket::close();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSocketFunc_connectToHost(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "connectToHost", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QAbstractSocket::connectToHost(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
            // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QAbstractSocket::connectToHost(*cpp_arg0, cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
        } else goto SbkQAbstractSocketFunc_connectToHost_TypeError;
    } else if (Shiboken::Converter<QHostAddress& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHostAddress& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QAbstractSocket::connectToHost(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
            // connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QAbstractSocket::connectToHost(*cpp_arg0, cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
        } else goto SbkQAbstractSocketFunc_connectToHost_TypeError;
    } else goto SbkQAbstractSocketFunc_connectToHost_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_connectToHost_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress, unsigned short, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", "PySide.QtCore.QString, unsigned short, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.connectToHost", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_connectToHostImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "connectToHostImplementation", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // connectToHostImplementation(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            cppSelf->QAbstractSocket::connectToHostImplementation(*cpp_arg0, cpp_arg1);
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
            // connectToHostImplementation(QString,quint16,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            cppSelf->QAbstractSocket::connectToHostImplementation(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQAbstractSocketFunc_connectToHostImplementation_TypeError;
    } else goto SbkQAbstractSocketFunc_connectToHostImplementation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_connectToHostImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, unsigned short, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.connectToHostImplementation", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_disconnectFromHost(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // disconnectFromHost()
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QAbstractSocket::disconnectFromHost();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSocketFunc_disconnectFromHostImplementation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // disconnectFromHostImplementation()
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSocket::disconnectFromHostImplementation();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSocketFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QAbstractSocket::SocketError cpp_result = cppSelf->QAbstractSocket::error();
    py_result = Shiboken::Converter<QAbstractSocket::SocketError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flush()
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSocket::flush();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSocket::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSocket::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_localAddress(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // localAddress()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QAbstractSocket::localAddress();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_localPort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // localPort()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    quint16 cpp_result = cppSelf->QAbstractSocket::localPort();
    py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_peerAddress(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerAddress()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QAbstractSocket::peerAddress();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_peerName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerName()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAbstractSocket::peerName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_peerPort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // peerPort()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    quint16 cpp_result = cppSelf->QAbstractSocket::peerPort();
    py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_proxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proxy()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QNetworkProxy cpp_result = cppSelf->QAbstractSocket::proxy();
    py_result = Shiboken::Converter<QNetworkProxy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_readBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readBufferSize()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAbstractSocket::readBufferSize();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QAbstractSocket::readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.readData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_readLineData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readLineData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readLineData(char*,qint64)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QAbstractSocket::readLineData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_readLineData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_readLineData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.readLineData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setLocalAddress(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostAddress& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(arg);
        if (!Shiboken::Converter<QHostAddress& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // setLocalAddress(QHostAddress)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setLocalAddress(*cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setLocalAddress_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setLocalAddress_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setLocalAddress", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setLocalPort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint16 cpp_arg0 = Shiboken::Converter<quint16 >::toCpp(arg);
        // setLocalPort(quint16)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setLocalPort(cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setLocalPort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setLocalPort_TypeError:
        const char* overloads[] = {"unsigned short", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setLocalPort", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setPeerAddress(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostAddress& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(arg);
        if (!Shiboken::Converter<QHostAddress& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // setPeerAddress(QHostAddress)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setPeerAddress(*cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setPeerAddress_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setPeerAddress_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setPeerAddress", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setPeerName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPeerName(QString)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setPeerName(*cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setPeerName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setPeerName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setPeerName", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setPeerPort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint16 cpp_arg0 = Shiboken::Converter<quint16 >::toCpp(arg);
        // setPeerPort(quint16)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setPeerPort(cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setPeerPort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setPeerPort_TypeError:
        const char* overloads[] = {"unsigned short", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setPeerPort", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setProxy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkProxy& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(arg);
        if (!Shiboken::Converter<QNetworkProxy& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // setProxy(QNetworkProxy)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setProxy(*cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setProxy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setProxy_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setProxy", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setReadBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setReadBufferSize(qint64)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setReadBufferSize(cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setReadBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setReadBufferSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setReadBufferSize", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setSocketDescriptor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setSocketDescriptor", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
            QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractSocket::setSocketDescriptor(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QAbstractSocket::SocketState >::isConvertible(pyargs[1])) {
            QAbstractSocket::SocketState cpp_arg1 = Shiboken::Converter<QAbstractSocket::SocketState >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
                QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QAbstractSocket::setSocketDescriptor(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
                QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
                // setSocketDescriptor(int,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
                QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QAbstractSocket::setSocketDescriptor(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQAbstractSocketFunc_setSocketDescriptor_TypeError;
        } else goto SbkQAbstractSocketFunc_setSocketDescriptor_TypeError;
    } else goto SbkQAbstractSocketFunc_setSocketDescriptor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_setSocketDescriptor_TypeError:
        const char* overloads[] = {"int, PySide.QtNetwork.QAbstractSocket.SocketState = ConnectedState, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.setSocketDescriptor", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setSocketError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractSocket::SocketError >::isConvertible(arg)) {
        QAbstractSocket::SocketError cpp_arg0 = Shiboken::Converter<QAbstractSocket::SocketError >::toCpp(arg);
        // setSocketError(QAbstractSocket::SocketError)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setSocketError(cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setSocketError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setSocketError_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QAbstractSocket.SocketError", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setSocketError", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_setSocketState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractSocket::SocketState >::isConvertible(arg)) {
        QAbstractSocket::SocketState cpp_arg0 = Shiboken::Converter<QAbstractSocket::SocketState >::toCpp(arg);
        // setSocketState(QAbstractSocket::SocketState)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSocket::setSocketState(cpp_arg0);
    } else goto SbkQAbstractSocketFunc_setSocketState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSocketFunc_setSocketState_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QAbstractSocket.SocketState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.setSocketState", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_socketDescriptor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // socketDescriptor()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSocket::socketDescriptor();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_socketType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // socketType()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QAbstractSocket::SocketType cpp_result = cppSelf->QAbstractSocket::socketType();
    py_result = Shiboken::Converter<QAbstractSocket::SocketType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
    QAbstractSocket::SocketState cpp_result = cppSelf->QAbstractSocket::state();
    py_result = Shiboken::Converter<QAbstractSocket::SocketState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSocketFunc_waitForBytesWritten(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForBytesWritten(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForBytesWritten();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForBytesWritten(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForBytesWritten(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_waitForBytesWritten_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_waitForBytesWritten_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.waitForBytesWritten", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_waitForConnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForConnected(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForConnected();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForConnected(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForConnected(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_waitForConnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_waitForConnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.waitForConnected", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_waitForDisconnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForDisconnected(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForDisconnected();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForDisconnected(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForDisconnected(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_waitForDisconnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_waitForDisconnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.waitForDisconnected", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_waitForReadyRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForReadyRead(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForReadyRead();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForReadyRead(int)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QAbstractSocket::waitForReadyRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_waitForReadyRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_waitForReadyRead_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAbstractSocket.waitForReadyRead", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSocketFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QAbstractSocket* cppSelf = Shiboken::Converter<QAbstractSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QAbstractSocket::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQAbstractSocketFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSocketFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAbstractSocket.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractSocket_methods[] = {
    {"abort", (PyCFunction)SbkQAbstractSocketFunc_abort, METH_NOARGS},
    {"atEnd", (PyCFunction)SbkQAbstractSocketFunc_atEnd, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQAbstractSocketFunc_bytesAvailable, METH_NOARGS},
    {"bytesToWrite", (PyCFunction)SbkQAbstractSocketFunc_bytesToWrite, METH_NOARGS},
    {"canReadLine", (PyCFunction)SbkQAbstractSocketFunc_canReadLine, METH_NOARGS},
    {"close", (PyCFunction)SbkQAbstractSocketFunc_close, METH_NOARGS},
    {"connectToHost", (PyCFunction)SbkQAbstractSocketFunc_connectToHost, METH_VARARGS},
    {"connectToHostImplementation", (PyCFunction)SbkQAbstractSocketFunc_connectToHostImplementation, METH_VARARGS},
    {"disconnectFromHost", (PyCFunction)SbkQAbstractSocketFunc_disconnectFromHost, METH_NOARGS},
    {"disconnectFromHostImplementation", (PyCFunction)SbkQAbstractSocketFunc_disconnectFromHostImplementation, METH_NOARGS},
    {"error", (PyCFunction)SbkQAbstractSocketFunc_error, METH_NOARGS},
    {"flush", (PyCFunction)SbkQAbstractSocketFunc_flush, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQAbstractSocketFunc_isSequential, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQAbstractSocketFunc_isValid, METH_NOARGS},
    {"localAddress", (PyCFunction)SbkQAbstractSocketFunc_localAddress, METH_NOARGS},
    {"localPort", (PyCFunction)SbkQAbstractSocketFunc_localPort, METH_NOARGS},
    {"peerAddress", (PyCFunction)SbkQAbstractSocketFunc_peerAddress, METH_NOARGS},
    {"peerName", (PyCFunction)SbkQAbstractSocketFunc_peerName, METH_NOARGS},
    {"peerPort", (PyCFunction)SbkQAbstractSocketFunc_peerPort, METH_NOARGS},
    {"proxy", (PyCFunction)SbkQAbstractSocketFunc_proxy, METH_NOARGS},
    {"readBufferSize", (PyCFunction)SbkQAbstractSocketFunc_readBufferSize, METH_NOARGS},
    {"readData", (PyCFunction)SbkQAbstractSocketFunc_readData, METH_VARARGS},
    {"readLineData", (PyCFunction)SbkQAbstractSocketFunc_readLineData, METH_VARARGS},
    {"setLocalAddress", (PyCFunction)SbkQAbstractSocketFunc_setLocalAddress, METH_O},
    {"setLocalPort", (PyCFunction)SbkQAbstractSocketFunc_setLocalPort, METH_O},
    {"setPeerAddress", (PyCFunction)SbkQAbstractSocketFunc_setPeerAddress, METH_O},
    {"setPeerName", (PyCFunction)SbkQAbstractSocketFunc_setPeerName, METH_O},
    {"setPeerPort", (PyCFunction)SbkQAbstractSocketFunc_setPeerPort, METH_O},
    {"setProxy", (PyCFunction)SbkQAbstractSocketFunc_setProxy, METH_O},
    {"setReadBufferSize", (PyCFunction)SbkQAbstractSocketFunc_setReadBufferSize, METH_O},
    {"setSocketDescriptor", (PyCFunction)SbkQAbstractSocketFunc_setSocketDescriptor, METH_VARARGS},
    {"setSocketError", (PyCFunction)SbkQAbstractSocketFunc_setSocketError, METH_O},
    {"setSocketState", (PyCFunction)SbkQAbstractSocketFunc_setSocketState, METH_O},
    {"socketDescriptor", (PyCFunction)SbkQAbstractSocketFunc_socketDescriptor, METH_NOARGS},
    {"socketType", (PyCFunction)SbkQAbstractSocketFunc_socketType, METH_NOARGS},
    {"state", (PyCFunction)SbkQAbstractSocketFunc_state, METH_NOARGS},
    {"waitForBytesWritten", (PyCFunction)SbkQAbstractSocketFunc_waitForBytesWritten, METH_NOARGS|METH_O},
    {"waitForConnected", (PyCFunction)SbkQAbstractSocketFunc_waitForConnected, METH_NOARGS|METH_O},
    {"waitForDisconnected", (PyCFunction)SbkQAbstractSocketFunc_waitForDisconnected, METH_NOARGS|METH_O},
    {"waitForReadyRead", (PyCFunction)SbkQAbstractSocketFunc_waitForReadyRead, METH_NOARGS|METH_O},
    {"writeData", (PyCFunction)SbkQAbstractSocketFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractSocket_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QAbstractSocket",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractSocketWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractSocket_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractSocket_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QAbstractSocket_SocketType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QAbstractSocket_SocketType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SocketType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QAbstractSocket_SocketType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QAbstractSocket_SocketType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QAbstractSocket_SocketType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QAbstractSocket_SocketError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QAbstractSocket_SocketError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SocketError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QAbstractSocket_SocketError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QAbstractSocket_SocketError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QAbstractSocket_SocketError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NetworkLayerProtocol",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QAbstractSocket_SocketState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QAbstractSocket_SocketState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SocketState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QAbstractSocket_SocketState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QAbstractSocket_SocketState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QAbstractSocket_SocketState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractSocket(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractSocket_Type);

    SbkQAbstractSocket_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX];
    // Fill type discovery information
    SbkQAbstractSocket_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractSocket_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractSocket_Type));
    PyModule_AddObject(module, "QAbstractSocket",
        ((PyObject*)&SbkQAbstractSocket_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SocketType
    SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX] = &SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type);
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
            "SocketType",((PyObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type,
        (long) QAbstractSocket::TcpSocket, "TcpSocket");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "TcpSocket", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type.tp_dict,
        "TcpSocket", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type,
        (long) QAbstractSocket::UdpSocket, "UdpSocket");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UdpSocket", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type.tp_dict,
        "UdpSocket", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type,
        (long) QAbstractSocket::UnknownSocketType, "UnknownSocketType");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnknownSocketType", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketType_Type.tp_dict,
        "UnknownSocketType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSocket::SocketType");

    // init enum class: SocketError
    SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX] = &SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type);
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
            "SocketError",((PyObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ConnectionRefusedError, "ConnectionRefusedError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ConnectionRefusedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ConnectionRefusedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::RemoteHostClosedError, "RemoteHostClosedError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "RemoteHostClosedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "RemoteHostClosedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::HostNotFoundError, "HostNotFoundError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "HostNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "HostNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::SocketAccessError, "SocketAccessError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "SocketAccessError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "SocketAccessError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::SocketResourceError, "SocketResourceError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "SocketResourceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "SocketResourceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::SocketTimeoutError, "SocketTimeoutError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "SocketTimeoutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "SocketTimeoutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::DatagramTooLargeError, "DatagramTooLargeError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "DatagramTooLargeError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "DatagramTooLargeError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::NetworkError, "NetworkError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "NetworkError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "NetworkError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::AddressInUseError, "AddressInUseError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "AddressInUseError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "AddressInUseError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::SocketAddressNotAvailableError, "SocketAddressNotAvailableError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "SocketAddressNotAvailableError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "SocketAddressNotAvailableError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::UnsupportedSocketOperationError, "UnsupportedSocketOperationError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnsupportedSocketOperationError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "UnsupportedSocketOperationError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::UnfinishedSocketOperationError, "UnfinishedSocketOperationError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnfinishedSocketOperationError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "UnfinishedSocketOperationError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyAuthenticationRequiredError, "ProxyAuthenticationRequiredError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::SslHandshakeFailedError, "SslHandshakeFailedError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "SslHandshakeFailedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "SslHandshakeFailedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyConnectionRefusedError, "ProxyConnectionRefusedError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyConnectionRefusedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyConnectionRefusedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyConnectionClosedError, "ProxyConnectionClosedError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyConnectionClosedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyConnectionClosedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyConnectionTimeoutError, "ProxyConnectionTimeoutError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyConnectionTimeoutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyConnectionTimeoutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyNotFoundError, "ProxyNotFoundError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::ProxyProtocolError, "ProxyProtocolError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ProxyProtocolError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "ProxyProtocolError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type,
        (long) QAbstractSocket::UnknownSocketError, "UnknownSocketError");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnknownSocketError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketError_Type.tp_dict,
        "UnknownSocketError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSocket::SocketError");

    // init enum class: NetworkLayerProtocol
    SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX] = &SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type);
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
            "NetworkLayerProtocol",((PyObject*)&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type,
        (long) QAbstractSocket::IPv4Protocol, "IPv4Protocol");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "IPv4Protocol", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type.tp_dict,
        "IPv4Protocol", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type,
        (long) QAbstractSocket::IPv6Protocol, "IPv6Protocol");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "IPv6Protocol", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type.tp_dict,
        "IPv6Protocol", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type,
        (long) QAbstractSocket::UnknownNetworkLayerProtocol, "UnknownNetworkLayerProtocol");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnknownNetworkLayerProtocol", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Type.tp_dict,
        "UnknownNetworkLayerProtocol", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSocket::NetworkLayerProtocol");

    // init enum class: SocketState
    SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX] = &SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type);
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
            "SocketState",((PyObject*)&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::UnconnectedState, "UnconnectedState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "UnconnectedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "UnconnectedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::HostLookupState, "HostLookupState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "HostLookupState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "HostLookupState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::ConnectingState, "ConnectingState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ConnectingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "ConnectingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::ConnectedState, "ConnectedState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ConnectedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "ConnectedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::BoundState, "BoundState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "BoundState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "BoundState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::ListeningState, "ListeningState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ListeningState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "ListeningState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type,
        (long) QAbstractSocket::ClosingState, "ClosingState");
    PyDict_SetItemString(SbkQAbstractSocket_Type.super.ht_type.tp_dict,
        "ClosingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QAbstractSocket_SocketState_Type.tp_dict,
        "ClosingState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSocket::SocketState");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSocket >("QAbstractSocket*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSocket >(typeid(QAbstractSocket).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

