/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qvector4d_wrapper.h"

// Extra includes
#include <QMatrix4x4>
#include <qdatastream.h>
#include <qpoint.h>
#include <qvariant.h>
#include <qvector2d.h>
#include <qvector3d.h>
#include <qvector4d.h>

using namespace Shiboken;

static int
SbkQVector4D_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QVector4D* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QVector4D", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QVector4D()
        cptr = new QVector4D();
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // QVector4D(qreal,qreal,qreal,qreal)
        cptr = new QVector4D(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (Shiboken::Converter<QVector2D& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QVector4D(QVector2D)
            cptr = new QVector4D(*cpp_arg0);
        } else if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
            // QVector4D(QVector2D,qreal,qreal)
            cptr = new QVector4D(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQVector4D_Init_TypeError;
    } else if (Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        if (numArgs == 1) {
            // QVector4D(QVector3D)
            cptr = new QVector4D(*cpp_arg0);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            // QVector4D(QVector3D,qreal)
            cptr = new QVector4D(*cpp_arg0, cpp_arg1);
        } else goto SbkQVector4D_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // QVector4D(QPoint)
        cptr = new QVector4D(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // QVector4D(QPointF)
        cptr = new QVector4D(*cpp_arg0);
    } else goto SbkQVector4D_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQVector4D_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQVector4D_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtGui.QVector2D", "PySide.QtGui.QVector2D, float, float", "PySide.QtGui.QVector3D", "PySide.QtGui.QVector3D, float", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QVector4D", overloads);
        return -1;
}

static PyObject*
SbkQVector4DFunc_dotProduct(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dotProduct", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
        QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
        // dotProduct(QVector4D,QVector4D)
        qreal cpp_result = QVector4D::dotProduct(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQVector4DFunc_dotProduct_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc_dotProduct_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D, PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QVector4D.dotProduct", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVector4D::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::length();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_lengthSquared(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lengthSquared()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::lengthSquared();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_normalize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // normalize()
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    cppSelf->QVector4D::normalize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQVector4DFunc_normalized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalized()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QVector4D cpp_result = cppSelf->QVector4D::normalized();
    py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_setW(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setW(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        cppSelf->QVector4D::setW(cpp_arg0);
    } else goto SbkQVector4DFunc_setW_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector4DFunc_setW_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.setW", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setX(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        cppSelf->QVector4D::setX(cpp_arg0);
    } else goto SbkQVector4DFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector4DFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.setX", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setY(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        cppSelf->QVector4D::setY(cpp_arg0);
    } else goto SbkQVector4DFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector4DFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.setY", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc_setZ(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setZ(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        cppSelf->QVector4D::setZ(cpp_arg0);
    } else goto SbkQVector4DFunc_setZ_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector4DFunc_setZ_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.setZ", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc_toPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPoint()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QVector4D::toPoint();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_toPointF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPointF()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QVector4D::toPointF();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_toVector2D(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector2D()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QVector2D cpp_result = cppSelf->QVector4D::toVector2D();
    py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_toVector2DAffine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector2DAffine()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QVector2D cpp_result = cppSelf->QVector4D::toVector2DAffine();
    py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_toVector3D(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector3D()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QVector3D cpp_result = cppSelf->QVector4D::toVector3D();
    py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_toVector3DAffine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector3DAffine()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    QVector3D cpp_result = cppSelf->QVector4D::toVector3DAffine();
    py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_w(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // w()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::w();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc_z(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // z()const
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector4D::z();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQVector4D_methods[] = {
    {"dotProduct", (PyCFunction)SbkQVector4DFunc_dotProduct, METH_VARARGS|METH_STATIC},
    {"isNull", (PyCFunction)SbkQVector4DFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQVector4DFunc_length, METH_NOARGS},
    {"lengthSquared", (PyCFunction)SbkQVector4DFunc_lengthSquared, METH_NOARGS},
    {"normalize", (PyCFunction)SbkQVector4DFunc_normalize, METH_NOARGS},
    {"normalized", (PyCFunction)SbkQVector4DFunc_normalized, METH_NOARGS},
    {"setW", (PyCFunction)SbkQVector4DFunc_setW, METH_O},
    {"setX", (PyCFunction)SbkQVector4DFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQVector4DFunc_setY, METH_O},
    {"setZ", (PyCFunction)SbkQVector4DFunc_setZ, METH_O},
    {"toPoint", (PyCFunction)SbkQVector4DFunc_toPoint, METH_NOARGS},
    {"toPointF", (PyCFunction)SbkQVector4DFunc_toPointF, METH_NOARGS},
    {"toVector2D", (PyCFunction)SbkQVector4DFunc_toVector2D, METH_NOARGS},
    {"toVector2DAffine", (PyCFunction)SbkQVector4DFunc_toVector2DAffine, METH_NOARGS},
    {"toVector3D", (PyCFunction)SbkQVector4DFunc_toVector3D, METH_NOARGS},
    {"toVector3DAffine", (PyCFunction)SbkQVector4DFunc_toVector3DAffine, METH_NOARGS},
    {"w", (PyCFunction)SbkQVector4DFunc_w, METH_NOARGS},
    {"x", (PyCFunction)SbkQVector4DFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQVector4DFunc_y, METH_NOARGS},
    {"z", (PyCFunction)SbkQVector4DFunc_z, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQVector4DFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QVector4D) [reverse operator]
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QVector4D,qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator*(QVector4D,QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator*(QVector4D,QMatrix4x4)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        QVector4D cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQVector4DFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", "PySide.QtGui.QVector4D", "float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator*=(QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        (*cppSelf) *= (*cpp_arg0);
    } else goto SbkQVector4DFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQVector4DFunc___imul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator+(QVector4D,QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQVector4DFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__add__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator+=(QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQVector4DFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQVector4DFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // operator-(QVector4D)
    QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
    const QVector4D cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQVector4DFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator-(QVector4D,QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQVector4DFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator-=(QVector4D)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQVector4DFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQVector4DFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QVector4D,qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        const QVector4D cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQVector4DFunc___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__div__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQVector4DFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQVector4DFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__idiv__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QVector4D) [reverse operator]
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQVector4DFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQVector4DFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQVector4D_Check(arg) && !SbkQVector4D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QVector4D&) [reverse operator]
        QVector4D* cppSelf = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQVector4DFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQVector4DFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector4D.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQVector4D_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQVector4DFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQVector4DFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQVector4DFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQVector4DFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQVector4DFunc___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQVector4DFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQVector4DFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQVector4DFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQVector4DFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQVector4DFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQVector4DFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQVector4D_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QVector4D& cpp_self = *Shiboken::Converter<QVector4D* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVector4D& >::isConvertible(other)) {
                QVector4D* cpp_other = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QVector4D >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QVector4D > cpp_other_auto_ptr;
                QVector4D* cpp_other = Shiboken::Converter<QVector4D* >::toCpp(other);
                if (!Shiboken::Converter<QVector4D >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QVector4D >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQVector4D_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVector4D& >::isConvertible(other)) {
                QVector4D* cpp_other = Shiboken::Converter<QVector4D* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QVector4D >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QVector4D > cpp_other_auto_ptr;
                QVector4D* cpp_other = Shiboken::Converter<QVector4D* >::toCpp(other);
                if (!Shiboken::Converter<QVector4D >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QVector4D >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQVector4D_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQVector4D_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQVector4D_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QVector4D",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QVector4D >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQVector4D_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQVector4D_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQVector4D_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQVector4D_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QVector4D(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QVECTOR4D_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQVector4D_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQVector4D_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQVector4D_Type));
    PyModule_AddObject(module, "QVector4D",
        ((PyObject*)&SbkQVector4D_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QVector4D >("QVector4D");
    Shiboken::TypeResolver::createValueTypeResolver<QVector4D >(typeid(QVector4D).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

