/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qundogroup_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qundogroup.h>
#include <qundostack.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QUndoGroupWrapper::QUndoGroupWrapper(QObject * parent) : QUndoGroup(parent), m_metaObject(0) {
    // ... middle
}

void QUndoGroupWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUndoGroupWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUndoGroupWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUndoGroupWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QUndoGroupWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QUndoGroup.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QUndoGroupWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QUndoGroup.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QUndoGroupWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QUndoGroupWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QUndoGroup::staticMetaObject);
}
    return m_metaObject;
}

int QUndoGroupWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QUndoGroup::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QUndoGroupWrapper::~QUndoGroupWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQUndoGroup_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUndoGroupWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QUndoGroup", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QUndoGroup(QObject*)
        cptr = new QUndoGroupWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QUndoGroup(QObject*)
        cptr = new QUndoGroupWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQUndoGroup_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUndoGroup_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQUndoGroup_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoGroup", overloads);
        return -1;
}

static PyObject*
SbkQUndoGroupFunc_activeStack(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activeStack()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    QUndoStack * cpp_result = cppSelf->QUndoGroup::activeStack();
    py_result = Shiboken::Converter<QUndoStack* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_addStack(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUndoStack* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QUndoStack* cpp_arg0 = Shiboken::Converter<QUndoStack* >::toCpp(arg);
        // addStack(QUndoStack*)
        QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
        cppSelf->QUndoGroup::addStack(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQUndoGroupFunc_addStack_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoGroupFunc_addStack_TypeError:
        const char* overloads[] = {"PySide.QtGui.QUndoStack", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoGroup.addStack", overloads);
        return 0;
}

static PyObject*
SbkQUndoGroupFunc_canRedo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canRedo()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoGroup::canRedo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_canUndo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canUndo()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoGroup::canUndo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_createRedoAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createRedoAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createRedoAction(QObject*,QString)const
            QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoGroup::createRedoAction(cpp_arg0);
            py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createRedoAction(QObject*,QString)const
            QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoGroup::createRedoAction(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQUndoGroupFunc_createRedoAction_TypeError;
    } else goto SbkQUndoGroupFunc_createRedoAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQUndoGroupFunc_createRedoAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoGroup.createRedoAction", overloads);
        return 0;
}

static PyObject*
SbkQUndoGroupFunc_createUndoAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createUndoAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createUndoAction(QObject*,QString)const
            QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoGroup::createUndoAction(cpp_arg0);
            py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createUndoAction(QObject*,QString)const
            QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUndoGroup::createUndoAction(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQUndoGroupFunc_createUndoAction_TypeError;
    } else goto SbkQUndoGroupFunc_createUndoAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQUndoGroupFunc_createUndoAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QUndoGroup.createUndoAction", overloads);
        return 0;
}

static PyObject*
SbkQUndoGroupFunc_isClean(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isClean()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUndoGroup::isClean();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    cppSelf->QUndoGroup::redo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQUndoGroupFunc_redoText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // redoText()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUndoGroup::redoText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_removeStack(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUndoStack* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QUndoStack* cpp_arg0 = Shiboken::Converter<QUndoStack* >::toCpp(arg);
        // removeStack(QUndoStack*)
        QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
        cppSelf->QUndoGroup::removeStack(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQUndoGroupFunc_removeStack_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoGroupFunc_removeStack_TypeError:
        const char* overloads[] = {"PySide.QtGui.QUndoStack", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoGroup.removeStack", overloads);
        return 0;
}

static PyObject*
SbkQUndoGroupFunc_setActiveStack(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUndoStack* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QUndoStack* cpp_arg0 = Shiboken::Converter<QUndoStack* >::toCpp(arg);
        // setActiveStack(QUndoStack*)
        QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
        cppSelf->QUndoGroup::setActiveStack(cpp_arg0);
    } else goto SbkQUndoGroupFunc_setActiveStack_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUndoGroupFunc_setActiveStack_TypeError:
        const char* overloads[] = {"PySide.QtGui.QUndoStack", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QUndoGroup.setActiveStack", overloads);
        return 0;
}

static PyObject*
SbkQUndoGroupFunc_stacks(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stacks()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    QList<QUndoStack * > cpp_result = cppSelf->QUndoGroup::stacks();
    py_result = Shiboken::Converter<QList<QUndoStack * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUndoGroupFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    cppSelf->QUndoGroup::undo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQUndoGroupFunc_undoText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // undoText()const
    QUndoGroup* cppSelf = Shiboken::Converter<QUndoGroup* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUndoGroup::undoText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQUndoGroup_methods[] = {
    {"activeStack", (PyCFunction)SbkQUndoGroupFunc_activeStack, METH_NOARGS},
    {"addStack", (PyCFunction)SbkQUndoGroupFunc_addStack, METH_O},
    {"canRedo", (PyCFunction)SbkQUndoGroupFunc_canRedo, METH_NOARGS},
    {"canUndo", (PyCFunction)SbkQUndoGroupFunc_canUndo, METH_NOARGS},
    {"createRedoAction", (PyCFunction)SbkQUndoGroupFunc_createRedoAction, METH_VARARGS},
    {"createUndoAction", (PyCFunction)SbkQUndoGroupFunc_createUndoAction, METH_VARARGS},
    {"isClean", (PyCFunction)SbkQUndoGroupFunc_isClean, METH_NOARGS},
    {"redo", (PyCFunction)SbkQUndoGroupFunc_redo, METH_NOARGS},
    {"redoText", (PyCFunction)SbkQUndoGroupFunc_redoText, METH_NOARGS},
    {"removeStack", (PyCFunction)SbkQUndoGroupFunc_removeStack, METH_O},
    {"setActiveStack", (PyCFunction)SbkQUndoGroupFunc_setActiveStack, METH_O},
    {"stacks", (PyCFunction)SbkQUndoGroupFunc_stacks, METH_NOARGS},
    {"undo", (PyCFunction)SbkQUndoGroupFunc_undo, METH_NOARGS},
    {"undoText", (PyCFunction)SbkQUndoGroupFunc_undoText, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUndoGroup_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QUndoGroup",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QUndoGroupWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUndoGroup_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUndoGroup_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QUndoGroup(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QUNDOGROUP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUndoGroup_Type);

    SbkQUndoGroup_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQUndoGroup_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQUndoGroup_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUndoGroup_Type));
    PyModule_AddObject(module, "QUndoGroup",
        ((PyObject*)&SbkQUndoGroup_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QUndoGroup >("QUndoGroup*");
    Shiboken::TypeResolver::createObjectTypeResolver<QUndoGroup >(typeid(QUndoGroup).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

