/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtreewidget_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qheaderview.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qtreewidget.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTreeWidgetWrapper::QTreeWidgetWrapper(QWidget * parent) : QTreeWidget(parent), m_metaObject(0) {
    // ... middle
}

void QTreeWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(current),
        Shiboken::Converter<QModelIndex& >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(topLeft),
        Shiboken::Converter<QModelIndex& >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QTreeView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::drawBranches(QPainter * painter, const QRect & rect, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawBranches"));
    if (py_override.isNull()) {
        return this->QTreeView::drawBranches(painter, rect, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::drawRow(QPainter * painter, const QStyleOptionViewItem & options, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawRow"));
    if (py_override.isNull()) {
        return this->QTreeView::drawRow(painter, options, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(options),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QTreeWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTreeWidgetWrapper::dropMimeData(QTreeWidgetItem * parent, int index, const QMimeData * data, Qt::DropAction action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QTreeWidget::dropMimeData(parent, index, data, action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiOO)",
        Shiboken::Converter<QTreeWidgetItem* >::toPython(parent),
        index,
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTreeWidgetWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.edit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QTreeWidgetWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTreeWidgetWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QTreeWidget::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTreeWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTreeWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTreeWidgetWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QTreeView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.horizontalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QTreeView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QTreeWidgetWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QTreeView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPoint& >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.indexAt");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QTreeWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QTreeWidgetWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QTreeView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.isIndexHidden");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QTreeView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTreeWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QStringList QTreeWidgetWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QTreeWidget::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QSize QTreeWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTreeWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QTreeWidgetWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QTreeView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QTreeView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QTreeView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QTreeView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QTreeView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QTreeView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QTreeWidgetWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QTreeView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.selectedIndexes");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selected),
        Shiboken::Converter<QItemSelection& >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QTreeWidgetWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.selectionCommand");
        return QFlags<QItemSelectionModel::SelectionFlag>()        ;
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTreeWidgetWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QTreeView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QTreeView::setSelection(rect, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QTreeWidget::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelectionModel* >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QTreeWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QTreeWidgetWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QTreeView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.sizeHintForColumn");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QTreeWidgetWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.sizeHintForRow");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::DropAction> QTreeWidgetWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QTreeWidget::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeWidgetWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QTreeView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeWidgetWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QTreeView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.verticalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeWidgetWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QTreeWidgetWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.viewOptions");
        return QStyleOptionViewItem()        ;
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QTreeWidgetWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QTreeWidgetWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QTreeView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.visualRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QTreeWidgetWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QTreeView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTreeWidget.visualRegionForSelection");
        return QRegion()        ;
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTreeWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTreeWidget::staticMetaObject);
}
    return m_metaObject;
}

int QTreeWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTreeWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTreeWidgetWrapper::~QTreeWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTreeWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTreeWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTreeWidget", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTreeWidget(QWidget*)
        cptr = new QTreeWidgetWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTreeWidget(QWidget*)
        cptr = new QTreeWidgetWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTreeWidget_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTreeWidget_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTreeWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget", overloads);
        return -1;
}

static PyObject*
SbkQTreeWidgetFunc_addTopLevelItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // addTopLevelItem(QTreeWidgetItem*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::addTopLevelItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeWidgetFunc_addTopLevelItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_addTopLevelItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.addTopLevelItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_addTopLevelItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTreeWidgetItem * >  >::isConvertible(arg)) {
        QList<QTreeWidgetItem * >  cpp_arg0 = Shiboken::Converter<QList<QTreeWidgetItem * >  >::toCpp(arg);
        // addTopLevelItems(QList<QTreeWidgetItem*>)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::addTopLevelItems(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeWidgetFunc_addTopLevelItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_addTopLevelItems_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.addTopLevelItems", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    cppSelf->QTreeWidget::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTreeWidgetFunc_closePersistentEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "closePersistentEditor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // closePersistentEditor(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::closePersistentEditor(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // closePersistentEditor(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::closePersistentEditor(cpp_arg0, cpp_arg1);
        } else goto SbkQTreeWidgetFunc_closePersistentEditor_TypeError;
    } else goto SbkQTreeWidgetFunc_closePersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_closePersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.closePersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_collapseItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // collapseItem(const QTreeWidgetItem*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::collapseItem(cpp_arg0);
    } else goto SbkQTreeWidgetFunc_collapseItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_collapseItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.collapseItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidget::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_currentColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentColumn()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidget::currentColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_currentItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentItem()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::currentItem();
    py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::dropEvent(cpp_arg0);
    } else goto SbkQTreeWidgetFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QMimeData* >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QMimeData* cpp_arg2 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[2]);
        Qt::DropAction cpp_arg3 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[3]);
        // dropMimeData(QTreeWidgetItem*,int,const QMimeData*,Qt::DropAction)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_dropMimeData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int, PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.dropMimeData", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_editItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "editItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // editItem(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::editItem(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // editItem(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::editItem(cpp_arg0, cpp_arg1);
        } else goto SbkQTreeWidgetFunc_editItem_TypeError;
    } else goto SbkQTreeWidgetFunc_editItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_editItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.editItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.event", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_expandItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // expandItem(const QTreeWidgetItem*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::expandItem(cpp_arg0);
    } else goto SbkQTreeWidgetFunc_expandItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_expandItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.expandItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_findItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "findItems", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QFlags<Qt::MatchFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // findItems(QString,QFlags<Qt::MatchFlag>,int)const
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            QList<QTreeWidgetItem * > cpp_result = cppSelf->QTreeWidget::findItems(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QTreeWidgetItem * > >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // findItems(QString,QFlags<Qt::MatchFlag>,int)const
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            QList<QTreeWidgetItem * > cpp_result = cppSelf->QTreeWidget::findItems(*cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QList<QTreeWidgetItem * > >::toPython(cpp_result);
        } else goto SbkQTreeWidgetFunc_findItems_TypeError;
    } else goto SbkQTreeWidgetFunc_findItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_findItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.MatchFlags, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.findItems", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_headerItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // headerItem()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::headerItem();
    py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_indexFromItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexFromItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexFromItem(QTreeWidgetItem*,int)const
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QTreeWidget::indexFromItem(cpp_arg0);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexFromItem(QTreeWidgetItem*,int)const
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QTreeWidget::indexFromItem(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        } else goto SbkQTreeWidgetFunc_indexFromItem_TypeError;
    } else goto SbkQTreeWidgetFunc_indexFromItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_indexFromItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.indexFromItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_indexOfTopLevelItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // indexOfTopLevelItem(QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeWidget::indexOfTopLevelItem(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_indexOfTopLevelItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_indexOfTopLevelItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.indexOfTopLevelItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_insertTopLevelItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertTopLevelItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTreeWidgetItem* cpp_arg1 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[1]);
        // insertTopLevelItem(int,QTreeWidgetItem*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::insertTopLevelItem(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTreeWidgetFunc_insertTopLevelItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_insertTopLevelItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.insertTopLevelItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_insertTopLevelItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertTopLevelItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QList<QTreeWidgetItem * >  >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QList<QTreeWidgetItem * >  cpp_arg1 = Shiboken::Converter<QList<QTreeWidgetItem * >  >::toCpp(pyargs[1]);
        // insertTopLevelItems(int,QList<QTreeWidgetItem*>)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::insertTopLevelItems(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTreeWidgetFunc_insertTopLevelItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_insertTopLevelItems_TypeError:
        const char* overloads[] = {"int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.insertTopLevelItems", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_invisibleRootItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // invisibleRootItem()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::invisibleRootItem();
    py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_isFirstItemColumnSpanned(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // isFirstItemColumnSpanned(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::isFirstItemColumnSpanned(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_isFirstItemColumnSpanned_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_isFirstItemColumnSpanned_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.isFirstItemColumnSpanned", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_isItemExpanded(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // isItemExpanded(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::isItemExpanded(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_isItemExpanded_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_isItemExpanded_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.isItemExpanded", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_isItemHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // isItemHidden(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::isItemHidden(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_isItemHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_isItemHidden_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.isItemHidden", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_isItemSelected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // isItemSelected(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeWidget::isItemSelected(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_isItemSelected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_isItemSelected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.isItemSelected", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_itemAbove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // itemAbove(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::itemAbove(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_itemAbove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_itemAbove_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.itemAbove", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemAt(int,int)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::itemAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // itemAt(QPoint)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::itemAt(*cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_itemAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_itemBelow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // itemBelow(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::itemBelow(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_itemBelow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_itemBelow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.itemBelow", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_itemFromIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemFromIndex(QModelIndex)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::itemFromIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_itemFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_itemFromIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.itemFromIndex", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_itemWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemWidget(QTreeWidgetItem*,int)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTreeWidget::itemWidget(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_itemWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_itemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.itemWidget", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QTreeWidget::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_openPersistentEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "openPersistentEditor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // openPersistentEditor(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::openPersistentEditor(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // openPersistentEditor(QTreeWidgetItem*,int)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::openPersistentEditor(cpp_arg0, cpp_arg1);
        } else goto SbkQTreeWidgetFunc_openPersistentEditor_TypeError;
    } else goto SbkQTreeWidgetFunc_openPersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_openPersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.openPersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_removeItemWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeItemWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeItemWidget(QTreeWidgetItem*,int)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::removeItemWidget(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, 0);
    } else goto SbkQTreeWidgetFunc_removeItemWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_removeItemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.removeItemWidget", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_scrollToItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollToItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollToItem(const QTreeWidgetItem*,QAbstractItemView::ScrollHint)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::scrollToItem(cpp_arg0);
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollToItem(const QTreeWidgetItem*,QAbstractItemView::ScrollHint)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::scrollToItem(cpp_arg0, cpp_arg1);
        } else goto SbkQTreeWidgetFunc_scrollToItem_TypeError;
    } else goto SbkQTreeWidgetFunc_scrollToItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_scrollToItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.scrollToItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_selectedItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedItems()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QList<QTreeWidgetItem * > cpp_result = cppSelf->QTreeWidget::selectedItems();
    py_result = Shiboken::Converter<QList<QTreeWidgetItem * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_setColumnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColumnCount(int)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setColumnCount(cpp_arg0);
    } else goto SbkQTreeWidgetFunc_setColumnCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setColumnCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.setColumnCount", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setCurrentItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentItem", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setCurrentItem(QTreeWidgetItem*)
            QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
            cppSelf->QTreeWidget::setCurrentItem(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setCurrentItem(QTreeWidgetItem*,int)
                QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
                cppSelf->QTreeWidget::setCurrentItem(cpp_arg0, cpp_arg1);
            } else if (numArgs == 3 && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[2])) {
                QFlags<QItemSelectionModel::SelectionFlag> cpp_arg2 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[2]);
                // setCurrentItem(QTreeWidgetItem*,int,QFlags<QItemSelectionModel::SelectionFlag>)
                QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
                cppSelf->QTreeWidget::setCurrentItem(cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQTreeWidgetFunc_setCurrentItem_TypeError;
        } else goto SbkQTreeWidgetFunc_setCurrentItem_TypeError;
    } else goto SbkQTreeWidgetFunc_setCurrentItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setCurrentItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", "PySide.QtGui.QTreeWidgetItem, int", "PySide.QtGui.QTreeWidgetItem, int, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setCurrentItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setFirstItemColumnSpanned(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFirstItemColumnSpanned", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setFirstItemColumnSpanned(const QTreeWidgetItem*,bool)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setFirstItemColumnSpanned(cpp_arg0, cpp_arg1);
    } else goto SbkQTreeWidgetFunc_setFirstItemColumnSpanned_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setFirstItemColumnSpanned_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setFirstItemColumnSpanned", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // setHeaderItem(QTreeWidgetItem*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setHeaderItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeWidgetFunc_setHeaderItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setHeaderItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.setHeaderItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setHeaderLabel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHeaderLabel(QString)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setHeaderLabel(*cpp_arg0);
    } else goto SbkQTreeWidgetFunc_setHeaderLabel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setHeaderLabel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.setHeaderLabel", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setHeaderLabels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setHeaderLabels(QStringList)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setHeaderLabels(*cpp_arg0);
    } else goto SbkQTreeWidgetFunc_setHeaderLabels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setHeaderLabels_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.setHeaderLabels", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setItemExpanded(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemExpanded", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setItemExpanded(const QTreeWidgetItem*,bool)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setItemExpanded(cpp_arg0, cpp_arg1);
    } else goto SbkQTreeWidgetFunc_setItemExpanded_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setItemExpanded_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setItemExpanded", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setItemHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemHidden", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setItemHidden(const QTreeWidgetItem*,bool)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setItemHidden(cpp_arg0, cpp_arg1);
    } else goto SbkQTreeWidgetFunc_setItemHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setItemHidden_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setItemHidden", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setItemSelected(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemSelected", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setItemSelected(const QTreeWidgetItem*,bool)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setItemSelected(cpp_arg0, cpp_arg1);
    } else goto SbkQTreeWidgetFunc_setItemSelected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setItemSelected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setItemSelected", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setItemWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setItemWidget", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QTreeWidgetItem* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // setItemWidget(QTreeWidgetItem*,int,QWidget*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setItemWidget(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQTreeWidgetFunc_setItemWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setItemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem, int, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.setItemWidget", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_setSelectionModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionModel* cpp_arg0 = Shiboken::Converter<QItemSelectionModel* >::toCpp(arg);
        // setSelectionModel(QItemSelectionModel*)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::setSelectionModel(cpp_arg0);
    } else goto SbkQTreeWidgetFunc_setSelectionModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_setSelectionModel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.setSelectionModel", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_sortColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortColumn()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidget::sortColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_sortItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sortItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
        // sortItems(int,Qt::SortOrder)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidget::sortItems(cpp_arg0, cpp_arg1);
    } else goto SbkQTreeWidgetFunc_sortItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetFunc_sortItems_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidget.sortItems", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QTreeWidget::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_takeTopLevelItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeTopLevelItem(int)
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::takeTopLevelItem(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_takeTopLevelItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_takeTopLevelItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.takeTopLevelItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_topLevelItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // topLevelItem(int)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidget::topLevelItem(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetFunc_topLevelItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_topLevelItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.topLevelItem", overloads);
        return 0;
}

static PyObject*
SbkQTreeWidgetFunc_topLevelItemCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topLevelItemCount()const
    QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidget::topLevelItemCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTreeWidgetFunc_visualItemRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // visualItemRect(const QTreeWidgetItem*)const
        QTreeWidget* cppSelf = Shiboken::Converter<QTreeWidget* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTreeWidget::visualItemRect(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQTreeWidgetFunc_visualItemRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTreeWidgetFunc_visualItemRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidget.visualItemRect", overloads);
        return 0;
}

static PyMethodDef SbkQTreeWidget_methods[] = {
    {"addTopLevelItem", (PyCFunction)SbkQTreeWidgetFunc_addTopLevelItem, METH_O},
    {"addTopLevelItems", (PyCFunction)SbkQTreeWidgetFunc_addTopLevelItems, METH_O},
    {"clear", (PyCFunction)SbkQTreeWidgetFunc_clear, METH_NOARGS},
    {"closePersistentEditor", (PyCFunction)SbkQTreeWidgetFunc_closePersistentEditor, METH_VARARGS},
    {"collapseItem", (PyCFunction)SbkQTreeWidgetFunc_collapseItem, METH_O},
    {"columnCount", (PyCFunction)SbkQTreeWidgetFunc_columnCount, METH_NOARGS},
    {"currentColumn", (PyCFunction)SbkQTreeWidgetFunc_currentColumn, METH_NOARGS},
    {"currentItem", (PyCFunction)SbkQTreeWidgetFunc_currentItem, METH_NOARGS},
    {"dropEvent", (PyCFunction)SbkQTreeWidgetFunc_dropEvent, METH_O},
    {"dropMimeData", (PyCFunction)SbkQTreeWidgetFunc_dropMimeData, METH_VARARGS},
    {"editItem", (PyCFunction)SbkQTreeWidgetFunc_editItem, METH_VARARGS},
    {"event", (PyCFunction)SbkQTreeWidgetFunc_event, METH_O},
    {"expandItem", (PyCFunction)SbkQTreeWidgetFunc_expandItem, METH_O},
    {"findItems", (PyCFunction)SbkQTreeWidgetFunc_findItems, METH_VARARGS},
    {"headerItem", (PyCFunction)SbkQTreeWidgetFunc_headerItem, METH_NOARGS},
    {"indexFromItem", (PyCFunction)SbkQTreeWidgetFunc_indexFromItem, METH_VARARGS},
    {"indexOfTopLevelItem", (PyCFunction)SbkQTreeWidgetFunc_indexOfTopLevelItem, METH_O},
    {"insertTopLevelItem", (PyCFunction)SbkQTreeWidgetFunc_insertTopLevelItem, METH_VARARGS},
    {"insertTopLevelItems", (PyCFunction)SbkQTreeWidgetFunc_insertTopLevelItems, METH_VARARGS},
    {"invisibleRootItem", (PyCFunction)SbkQTreeWidgetFunc_invisibleRootItem, METH_NOARGS},
    {"isFirstItemColumnSpanned", (PyCFunction)SbkQTreeWidgetFunc_isFirstItemColumnSpanned, METH_O},
    {"isItemExpanded", (PyCFunction)SbkQTreeWidgetFunc_isItemExpanded, METH_O},
    {"isItemHidden", (PyCFunction)SbkQTreeWidgetFunc_isItemHidden, METH_O},
    {"isItemSelected", (PyCFunction)SbkQTreeWidgetFunc_isItemSelected, METH_O},
    {"itemAbove", (PyCFunction)SbkQTreeWidgetFunc_itemAbove, METH_O},
    {"itemAt", (PyCFunction)SbkQTreeWidgetFunc_itemAt, METH_VARARGS},
    {"itemBelow", (PyCFunction)SbkQTreeWidgetFunc_itemBelow, METH_O},
    {"itemFromIndex", (PyCFunction)SbkQTreeWidgetFunc_itemFromIndex, METH_O},
    {"itemWidget", (PyCFunction)SbkQTreeWidgetFunc_itemWidget, METH_VARARGS},
    {"mimeTypes", (PyCFunction)SbkQTreeWidgetFunc_mimeTypes, METH_NOARGS},
    {"openPersistentEditor", (PyCFunction)SbkQTreeWidgetFunc_openPersistentEditor, METH_VARARGS},
    {"removeItemWidget", (PyCFunction)SbkQTreeWidgetFunc_removeItemWidget, METH_VARARGS},
    {"scrollToItem", (PyCFunction)SbkQTreeWidgetFunc_scrollToItem, METH_VARARGS},
    {"selectedItems", (PyCFunction)SbkQTreeWidgetFunc_selectedItems, METH_NOARGS},
    {"setColumnCount", (PyCFunction)SbkQTreeWidgetFunc_setColumnCount, METH_O},
    {"setCurrentItem", (PyCFunction)SbkQTreeWidgetFunc_setCurrentItem, METH_VARARGS},
    {"setFirstItemColumnSpanned", (PyCFunction)SbkQTreeWidgetFunc_setFirstItemColumnSpanned, METH_VARARGS},
    {"setHeaderItem", (PyCFunction)SbkQTreeWidgetFunc_setHeaderItem, METH_O},
    {"setHeaderLabel", (PyCFunction)SbkQTreeWidgetFunc_setHeaderLabel, METH_O},
    {"setHeaderLabels", (PyCFunction)SbkQTreeWidgetFunc_setHeaderLabels, METH_O},
    {"setItemExpanded", (PyCFunction)SbkQTreeWidgetFunc_setItemExpanded, METH_VARARGS},
    {"setItemHidden", (PyCFunction)SbkQTreeWidgetFunc_setItemHidden, METH_VARARGS},
    {"setItemSelected", (PyCFunction)SbkQTreeWidgetFunc_setItemSelected, METH_VARARGS},
    {"setItemWidget", (PyCFunction)SbkQTreeWidgetFunc_setItemWidget, METH_VARARGS},
    {"setSelectionModel", (PyCFunction)SbkQTreeWidgetFunc_setSelectionModel, METH_O},
    {"sortColumn", (PyCFunction)SbkQTreeWidgetFunc_sortColumn, METH_NOARGS},
    {"sortItems", (PyCFunction)SbkQTreeWidgetFunc_sortItems, METH_VARARGS},
    {"supportedDropActions", (PyCFunction)SbkQTreeWidgetFunc_supportedDropActions, METH_NOARGS},
    {"takeTopLevelItem", (PyCFunction)SbkQTreeWidgetFunc_takeTopLevelItem, METH_O},
    {"topLevelItem", (PyCFunction)SbkQTreeWidgetFunc_topLevelItem, METH_O},
    {"topLevelItemCount", (PyCFunction)SbkQTreeWidgetFunc_topLevelItemCount, METH_NOARGS},
    {"visualItemRect", (PyCFunction)SbkQTreeWidgetFunc_visualItemRect, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTreeWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTreeWidget* me = reinterpret_cast<QTreeWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTREEVIEW_IDX]))
        return static_cast<QTreeView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTreeWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTreeWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTreeWidgetWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTreeWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTreeWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTreeWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTreeWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTreeWidget_Type);

    SbkQTreeWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTREEVIEW_IDX];
    SbkQTreeWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTreeWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTreeWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTreeWidget_Type));
    PyModule_AddObject(module, "QTreeWidget",
        ((PyObject*)&SbkQTreeWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTreeWidget >("QTreeWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTreeWidget >(typeid(QTreeWidget).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

