/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtransform_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qline.h>
#include <qmatrix.h>
#include <qpainterpath.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qtransform.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQTransform_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTransform* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 7)
        goto SbkQTransform_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QTransform", 0, 9, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8])))
        return -1;

    if (numArgs == 0) {
        // QTransform()
        cptr = new QTransform();
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        if (numArgs == 6) {
            // QTransform(qreal,qreal,qreal,qreal,qreal,qreal)
            cptr = new QTransform(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        } else if (PyNumber_Check(pyargs[6]) && PyNumber_Check(pyargs[7])) {
            qreal cpp_arg6 = Shiboken::Converter<qreal >::toCpp(pyargs[6]);
            qreal cpp_arg7 = Shiboken::Converter<qreal >::toCpp(pyargs[7]);
            if (numArgs == 8) {
                // QTransform(qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal)
                cptr = new QTransform(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7);
            } else if (PyNumber_Check(pyargs[8])) {
                qreal cpp_arg8 = Shiboken::Converter<qreal >::toCpp(pyargs[8]);
                // QTransform(qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal)
                cptr = new QTransform(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8);
            } else goto SbkQTransform_Init_TypeError;
        } else goto SbkQTransform_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        // QTransform(QMatrix)
        cptr = new QTransform(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<Qt::Initialization >::isConvertible(pyargs[0])) {
        Qt::Initialization cpp_arg0 = Shiboken::Converter<Qt::Initialization >::toCpp(pyargs[0]);
        // QTransform(Qt::Initialization)
        cptr = new QTransform(cpp_arg0);
    } else goto SbkQTransform_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTransform_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTransform_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.Initialization", "PySide.QtGui.QMatrix", "float, float, float, float, float, float, float, float, float = 1.0", "float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform", overloads);
        return -1;
}

static PyObject*
SbkQTransformFunc_adjoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // adjoint()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QTransform::adjoint();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_det(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // det()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::det();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_determinant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // determinant()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::determinant();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_dx(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dx()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::dx();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_dy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dy()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::dy();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_fromScale(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromScale", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // fromScale(qreal,qreal)
        QTransform cpp_result = QTransform::fromScale(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc_fromScale_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_fromScale_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.fromScale", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_fromTranslate(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromTranslate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // fromTranslate(qreal,qreal)
        QTransform cpp_result = QTransform::fromTranslate(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc_fromTranslate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_fromTranslate_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.fromTranslate", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_inverted(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inverted(bool*)const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_bool* - START
    bool ok_;
    QTransform retval_ = cppSelf->inverted(&ok_);
    py_result = Shiboken::makeTuple(retval_, ok_);
    // TEMPLATE - fix_bool* - END
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isAffine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAffine()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isAffine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isIdentity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isIdentity()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isIdentity();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isInvertible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isInvertible()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isInvertible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isRotating(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRotating()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isRotating();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isScaling(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isScaling()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isScaling();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_isTranslating(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTranslating()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTransform::isTranslating();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m11(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m11()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m11();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m12(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m12()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m12();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m13(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m13()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m13();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m21(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m21()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m21();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m22(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m22()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m22();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m23(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m23()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m23();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m31(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m31()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m31();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m32(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m32()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m32();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_m33(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // m33()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTransform::m33();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_map(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!Shiboken::Converter<QPolygon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // map(QPolygon)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // map(QRegion)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPolygonF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // map(QPolygonF)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // map(QPoint)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // map(QPointF)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // map(QPainterPath)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else if (Shiboken::Converter<QLine& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(arg);
        // map(QLine)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QLine cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QLine >::toPython(cpp_result);
    } else if (Shiboken::Converter<QLineF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!Shiboken::Converter<QLineF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // map(QLineF)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QLineF cpp_result = cppSelf->QTransform::map(*cpp_arg0);
        py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
    } else goto SbkQTransformFunc_map_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_map_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLine", "PySide.QtCore.QLineF", "PySide.QtGui.QPainterPath", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtGui.QPolygon", "PySide.QtGui.QPolygonF", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.map", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_mapRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // mapRect(QRect)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTransform::mapRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // mapRect(QRectF)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QTransform::mapRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQTransformFunc_mapRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_mapRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.mapRect", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_mapToPolygon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // mapToPolygon(QRect)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QTransform::mapToPolygon(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
    } else goto SbkQTransformFunc_mapToPolygon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_mapToPolygon_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.mapToPolygon", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_quadToQuad(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "quadToQuad", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[1]) && Shiboken::Converter<QTransform& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg1_auto_ptr;
        QPolygonF* cpp_arg1 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTransform* cpp_arg2 = Shiboken::Converter<QTransform* >::toCpp(pyargs[2]);
        // quadToQuad(QPolygonF,QPolygonF,QTransform&)
        bool cpp_result = QTransform::quadToQuad(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTransformFunc_quadToQuad_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_quadToQuad_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF, PySide.QtGui.QPolygonF, PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.quadToQuad", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_quadToSquare(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "quadToSquare", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QTransform& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
        // quadToSquare(QPolygonF,QTransform&)
        bool cpp_result = QTransform::quadToSquare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTransformFunc_quadToSquare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_quadToSquare_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF, PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.quadToSquare", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    cppSelf->QTransform::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTransformFunc_rotate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rotate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // rotate(qreal,Qt::Axis)
            QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
            QTransform & cpp_result = cppSelf->QTransform::rotate(cpp_arg0);
            py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::Axis >::isConvertible(pyargs[1])) {
            Qt::Axis cpp_arg1 = Shiboken::Converter<Qt::Axis >::toCpp(pyargs[1]);
            // rotate(qreal,Qt::Axis)
            QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
            QTransform & cpp_result = cppSelf->QTransform::rotate(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
        } else goto SbkQTransformFunc_rotate_TypeError;
    } else goto SbkQTransformFunc_rotate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_rotate_TypeError:
        const char* overloads[] = {"float, PySide.QtCore.Qt.Axis = Qt.ZAxis", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.rotate", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_rotateRadians(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rotateRadians", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // rotateRadians(qreal,Qt::Axis)
            QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
            QTransform & cpp_result = cppSelf->QTransform::rotateRadians(cpp_arg0);
            py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::Axis >::isConvertible(pyargs[1])) {
            Qt::Axis cpp_arg1 = Shiboken::Converter<Qt::Axis >::toCpp(pyargs[1]);
            // rotateRadians(qreal,Qt::Axis)
            QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
            QTransform & cpp_result = cppSelf->QTransform::rotateRadians(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
        } else goto SbkQTransformFunc_rotateRadians_TypeError;
    } else goto SbkQTransformFunc_rotateRadians_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_rotateRadians_TypeError:
        const char* overloads[] = {"float, PySide.QtCore.Qt.Axis = Qt.ZAxis", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.rotateRadians", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // scale(qreal,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform & cpp_result = cppSelf->QTransform::scale(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
    } else goto SbkQTransformFunc_scale_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_scale_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.scale", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_setMatrix(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setMatrix", 9, 9, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8])))
        return 0;

    if (numArgs == 9 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5]) && PyNumber_Check(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        qreal cpp_arg6 = Shiboken::Converter<qreal >::toCpp(pyargs[6]);
        qreal cpp_arg7 = Shiboken::Converter<qreal >::toCpp(pyargs[7]);
        qreal cpp_arg8 = Shiboken::Converter<qreal >::toCpp(pyargs[8]);
        // setMatrix(qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        cppSelf->QTransform::setMatrix(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8);
    } else goto SbkQTransformFunc_setMatrix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTransformFunc_setMatrix_TypeError:
        const char* overloads[] = {"float, float, float, float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.setMatrix", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_shear(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "shear", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // shear(qreal,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform & cpp_result = cppSelf->QTransform::shear(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
    } else goto SbkQTransformFunc_shear_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_shear_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.shear", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_squareToQuad(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "squareToQuad", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QTransform& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
        // squareToQuad(QPolygonF,QTransform&)
        bool cpp_result = QTransform::squareToQuad(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTransformFunc_squareToQuad_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_squareToQuad_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF, PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.squareToQuad", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_toAffine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAffine()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    const QMatrix & cpp_result = cppSelf->QTransform::toAffine();
    py_result = Shiboken::Converter<QMatrix& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform & cpp_result = cppSelf->QTransform::translate(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTransform& >::toPython(cpp_result);
    } else goto SbkQTransformFunc_translate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc_translate_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTransform.translate", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc_transposed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transposed()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QTransform::transposed();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTransformFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
    QTransform::TransformationType cpp_result = cppSelf->QTransform::type();
    py_result = Shiboken::Converter<QTransform::TransformationType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTransform_methods[] = {
    {"adjoint", (PyCFunction)SbkQTransformFunc_adjoint, METH_NOARGS},
    {"det", (PyCFunction)SbkQTransformFunc_det, METH_NOARGS},
    {"determinant", (PyCFunction)SbkQTransformFunc_determinant, METH_NOARGS},
    {"dx", (PyCFunction)SbkQTransformFunc_dx, METH_NOARGS},
    {"dy", (PyCFunction)SbkQTransformFunc_dy, METH_NOARGS},
    {"fromScale", (PyCFunction)SbkQTransformFunc_fromScale, METH_VARARGS|METH_STATIC},
    {"fromTranslate", (PyCFunction)SbkQTransformFunc_fromTranslate, METH_VARARGS|METH_STATIC},
    {"inverted", (PyCFunction)SbkQTransformFunc_inverted, METH_NOARGS},
    {"isAffine", (PyCFunction)SbkQTransformFunc_isAffine, METH_NOARGS},
    {"isIdentity", (PyCFunction)SbkQTransformFunc_isIdentity, METH_NOARGS},
    {"isInvertible", (PyCFunction)SbkQTransformFunc_isInvertible, METH_NOARGS},
    {"isRotating", (PyCFunction)SbkQTransformFunc_isRotating, METH_NOARGS},
    {"isScaling", (PyCFunction)SbkQTransformFunc_isScaling, METH_NOARGS},
    {"isTranslating", (PyCFunction)SbkQTransformFunc_isTranslating, METH_NOARGS},
    {"m11", (PyCFunction)SbkQTransformFunc_m11, METH_NOARGS},
    {"m12", (PyCFunction)SbkQTransformFunc_m12, METH_NOARGS},
    {"m13", (PyCFunction)SbkQTransformFunc_m13, METH_NOARGS},
    {"m21", (PyCFunction)SbkQTransformFunc_m21, METH_NOARGS},
    {"m22", (PyCFunction)SbkQTransformFunc_m22, METH_NOARGS},
    {"m23", (PyCFunction)SbkQTransformFunc_m23, METH_NOARGS},
    {"m31", (PyCFunction)SbkQTransformFunc_m31, METH_NOARGS},
    {"m32", (PyCFunction)SbkQTransformFunc_m32, METH_NOARGS},
    {"m33", (PyCFunction)SbkQTransformFunc_m33, METH_NOARGS},
    {"map", (PyCFunction)SbkQTransformFunc_map, METH_O},
    {"mapRect", (PyCFunction)SbkQTransformFunc_mapRect, METH_O},
    {"mapToPolygon", (PyCFunction)SbkQTransformFunc_mapToPolygon, METH_O},
    {"quadToQuad", (PyCFunction)SbkQTransformFunc_quadToQuad, METH_VARARGS|METH_STATIC},
    {"quadToSquare", (PyCFunction)SbkQTransformFunc_quadToSquare, METH_VARARGS|METH_STATIC},
    {"reset", (PyCFunction)SbkQTransformFunc_reset, METH_NOARGS},
    {"rotate", (PyCFunction)SbkQTransformFunc_rotate, METH_VARARGS},
    {"rotateRadians", (PyCFunction)SbkQTransformFunc_rotateRadians, METH_VARARGS},
    {"scale", (PyCFunction)SbkQTransformFunc_scale, METH_VARARGS},
    {"setMatrix", (PyCFunction)SbkQTransformFunc_setMatrix, METH_VARARGS},
    {"shear", (PyCFunction)SbkQTransformFunc_shear, METH_VARARGS},
    {"squareToQuad", (PyCFunction)SbkQTransformFunc_squareToQuad, METH_VARARGS|METH_STATIC},
    {"toAffine", (PyCFunction)SbkQTransformFunc_toAffine, METH_NOARGS},
    {"translate", (PyCFunction)SbkQTransformFunc_translate, METH_VARARGS},
    {"transposed", (PyCFunction)SbkQTransformFunc_transposed, METH_NOARGS},
    {"type", (PyCFunction)SbkQTransformFunc_type, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQTransformFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QTransform,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*(QTransform)const
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else if (!isReverse && Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*=(QTransform)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        (*cppSelf) *= (*cpp_arg0);
    } else goto SbkQTransformFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQTransformFunc___imul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator+(QTransform,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform cpp_result = (*cppSelf) + cpp_arg0;
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___add___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__add__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator+=(qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        (*cppSelf) += cpp_arg0;
    } else goto SbkQTransformFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQTransformFunc___iadd___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator-(QTransform,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform cpp_result = (*cppSelf) - cpp_arg0;
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___sub___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator-=(qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        (*cppSelf) -= cpp_arg0;
    } else goto SbkQTransformFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQTransformFunc___isub___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QTransform,qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QTransform cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQTransformFunc___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__div__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQTransformFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQTransformFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__idiv__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QTransform) [reverse operator]
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTransformFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQTransformFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTransform_Check(arg) && !SbkQTransform_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QTransform&) [reverse operator]
        QTransform* cppSelf = Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTransformFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTransformFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTransform.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQTransform_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQTransformFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQTransformFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQTransformFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQTransformFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQTransformFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQTransformFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQTransformFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQTransformFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQTransformFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQTransformFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQTransform_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTransform& cpp_self = *Shiboken::Converter<QTransform* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTransform& >::isConvertible(other)) {
                QTransform* cpp_other = Shiboken::Converter<QTransform* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQTransform_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTransform& >::isConvertible(other)) {
                QTransform* cpp_other = Shiboken::Converter<QTransform* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQTransform_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTransform_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTransform_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTransform",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTransform >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTransform_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTransform_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTransform_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTransform_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QTransform_TransformationType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTransform_TransformationType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTransform_TransformationType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TransformationType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTransform_TransformationType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTransform_TransformationType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTransform_TransformationType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTransform(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTRANSFORM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTransform_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTransform_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTransform_Type));
    PyModule_AddObject(module, "QTransform",
        ((PyObject*)&SbkQTransform_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: TransformationType
    SbkPySide_QtGuiTypes[SBK_QTRANSFORM_TRANSFORMATIONTYPE_IDX] = &SbkPySide_QtGui_QTransform_TransformationType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTransform_TransformationType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTransform_TransformationType_Type);
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
            "TransformationType",((PyObject*)&SbkPySide_QtGui_QTransform_TransformationType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxNone, "TxNone");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxTranslate, "TxTranslate");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxTranslate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxTranslate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxScale, "TxScale");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxScale", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxScale", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxRotate, "TxRotate");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxRotate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxRotate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxShear, "TxShear");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxShear", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxShear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTransform_TransformationType_Type,
        (long) QTransform::TxProject, "TxProject");
    PyDict_SetItemString(SbkQTransform_Type.super.ht_type.tp_dict,
        "TxProject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTransform_TransformationType_Type.tp_dict,
        "TxProject", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTransform::TransformationType");

    Shiboken::TypeResolver::createValueTypeResolver<QTransform >("QTransform");
    Shiboken::TypeResolver::createValueTypeResolver<QTransform >(typeid(QTransform).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

