/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtouchevent_touchpoint_wrapper.h"

// Extra includes
#include <qevent.h>
#include <qpoint.h>
#include <qrect.h>

using namespace Shiboken;

static int
SbkQTouchEvent_TouchPoint_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTouchEvent::TouchPoint* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "TouchPoint", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // TouchPoint(int)
        cptr = new QTouchEvent::TouchPoint();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // TouchPoint(int)
        cptr = new QTouchEvent::TouchPoint(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTouchEvent::TouchPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QTouchEvent::TouchPoint > cpp_arg0_auto_ptr;
        QTouchEvent::TouchPoint* cpp_arg0 = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QTouchEvent::TouchPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QTouchEvent::TouchPoint >(cpp_arg0);
        // TouchPoint(QTouchEvent::TouchPoint)
        cptr = new QTouchEvent::TouchPoint(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPoint_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTouchEvent_TouchPoint_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTouchEvent_TouchPoint_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTouchEvent::TouchPoint", "int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.TouchPoint", overloads);
        return -1;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_id(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // id()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->TouchPoint::id();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_isPrimary(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isPrimary()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->TouchPoint::isPrimary();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_lastNormalizedPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastNormalizedPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::lastNormalizedPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_lastPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::lastPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_lastScenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScenePos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::lastScenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_lastScreenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScreenPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::lastScreenPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_normalizedPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalizedPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::normalizedPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_pressure(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pressure()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->TouchPoint::pressure();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->TouchPoint::rect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_sceneRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sceneRect()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->TouchPoint::sceneRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::screenPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_screenRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenRect()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->TouchPoint::screenRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setId(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setId(int)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setId(cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setId_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setId_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setId", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setLastNormalizedPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastNormalizedPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setLastNormalizedPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setLastNormalizedPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setLastNormalizedPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setLastNormalizedPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setLastPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setLastPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setLastPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setLastPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setLastPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setLastScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastScenePos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setLastScenePos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setLastScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setLastScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setLastScenePos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setLastScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastScreenPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setLastScreenPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setLastScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setLastScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setLastScreenPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setNormalizedPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setNormalizedPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setNormalizedPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setNormalizedPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setNormalizedPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setNormalizedPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setPressure(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setPressure(qreal)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setPressure(cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setPressure_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setPressure_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setPressure", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setRect(QRectF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setRect(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setRect", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setScenePos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setScenePos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setSceneRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setSceneRect(QRectF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setSceneRect(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setSceneRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setSceneRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setSceneRect", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScreenPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setScreenPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setScreenPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setScreenRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setScreenRect(QRectF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setScreenRect(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setScreenRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setScreenRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setScreenRect", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setStartNormalizedPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStartNormalizedPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setStartNormalizedPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setStartNormalizedPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setStartNormalizedPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setStartNormalizedPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setStartPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStartPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setStartPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setStartPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setStartPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setStartPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setStartScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStartScenePos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setStartScenePos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setStartScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setStartScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setStartScenePos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_setStartScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setStartScreenPos(QPointF)
        QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
        cppSelf->TouchPoint::setStartScreenPos(*cpp_arg0);
    } else goto SbkQTouchEvent_TouchPointFunc_setStartScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTouchEvent_TouchPointFunc_setStartScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.TouchPoint.setStartScreenPos", overloads);
        return 0;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_startNormalizedPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startNormalizedPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::startNormalizedPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_startPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::startPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_startScenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startScenePos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::startScenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_startScreenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startScreenPos()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->TouchPoint::startScreenPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTouchEvent_TouchPointFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QTouchEvent::TouchPoint* cppSelf = Shiboken::Converter<QTouchEvent::TouchPoint* >::toCpp((PyObject*)self);
    Qt::TouchPointState cpp_result = cppSelf->TouchPoint::state();
    py_result = Shiboken::Converter<Qt::TouchPointState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTouchEvent_TouchPoint_methods[] = {
    {"id", (PyCFunction)SbkQTouchEvent_TouchPointFunc_id, METH_NOARGS},
    {"isPrimary", (PyCFunction)SbkQTouchEvent_TouchPointFunc_isPrimary, METH_NOARGS},
    {"lastNormalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_lastNormalizedPos, METH_NOARGS},
    {"lastPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_lastPos, METH_NOARGS},
    {"lastScenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_lastScenePos, METH_NOARGS},
    {"lastScreenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_lastScreenPos, METH_NOARGS},
    {"normalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_normalizedPos, METH_NOARGS},
    {"pos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_pos, METH_NOARGS},
    {"pressure", (PyCFunction)SbkQTouchEvent_TouchPointFunc_pressure, METH_NOARGS},
    {"rect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_rect, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_scenePos, METH_NOARGS},
    {"sceneRect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_sceneRect, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_screenPos, METH_NOARGS},
    {"screenRect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_screenRect, METH_NOARGS},
    {"setId", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setId, METH_O},
    {"setLastNormalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setLastNormalizedPos, METH_O},
    {"setLastPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setLastPos, METH_O},
    {"setLastScenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setLastScenePos, METH_O},
    {"setLastScreenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setLastScreenPos, METH_O},
    {"setNormalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setNormalizedPos, METH_O},
    {"setPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setPos, METH_O},
    {"setPressure", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setPressure, METH_O},
    {"setRect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setRect, METH_O},
    {"setScenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setScenePos, METH_O},
    {"setSceneRect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setSceneRect, METH_O},
    {"setScreenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setScreenPos, METH_O},
    {"setScreenRect", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setScreenRect, METH_O},
    {"setStartNormalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setStartNormalizedPos, METH_O},
    {"setStartPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setStartPos, METH_O},
    {"setStartScenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setStartScenePos, METH_O},
    {"setStartScreenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_setStartScreenPos, METH_O},
    {"startNormalizedPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_startNormalizedPos, METH_NOARGS},
    {"startPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_startPos, METH_NOARGS},
    {"startScenePos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_startScenePos, METH_NOARGS},
    {"startScreenPos", (PyCFunction)SbkQTouchEvent_TouchPointFunc_startScreenPos, METH_NOARGS},
    {"state", (PyCFunction)SbkQTouchEvent_TouchPointFunc_state, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTouchEvent_TouchPoint_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.TouchPoint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTouchEvent::TouchPoint >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTouchEvent_TouchPoint_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTouchEvent_TouchPoint_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTouchEvent_TouchPoint(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTouchEvent_TouchPoint_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTouchEvent_TouchPoint_Type) < 0)
        return;

    PyDict_SetItemString(module,"TouchPoint", (PyObject*)&SbkQTouchEvent_TouchPoint_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QTouchEvent::TouchPoint >("QTouchEvent::TouchPoint");
    Shiboken::TypeResolver::createValueTypeResolver<QTouchEvent::TouchPoint >(typeid(QTouchEvent::TouchPoint).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

