/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtooltip_wrapper.h"

// Extra includes
#include <qfont.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qwidget.h>

using namespace Shiboken;

static PyObject*
SbkQToolTipFunc_font(PyObject* self)
{
    PyObject* py_result = 0;

    // font()
    QFont cpp_result = QToolTip::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQToolTipFunc_hideText(PyObject* self)
{

    // hideText()
    QToolTip::hideText();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQToolTipFunc_isVisible(PyObject* self)
{
    PyObject* py_result = 0;

    // isVisible()
    bool cpp_result = QToolTip::isVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQToolTipFunc_palette(PyObject* self)
{
    PyObject* py_result = 0;

    // palette()
    QPalette cpp_result = QToolTip::palette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQToolTipFunc_setFont(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QToolTip::setFont(*cpp_arg0);
    } else goto SbkQToolTipFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQToolTipFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QToolTip.setFont", overloads);
        return 0;
}

static PyObject*
SbkQToolTipFunc_setPalette(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // setPalette(QPalette)
        QToolTip::setPalette(*cpp_arg0);
    } else goto SbkQToolTipFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQToolTipFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QToolTip.setPalette", overloads);
        return 0;
}

static PyObject*
SbkQToolTipFunc_showText(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "showText", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // showText(QPoint,QString,QWidget*)
            QToolTip::showText(*cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // showText(QPoint,QString,QWidget*)
                QToolTip::showText(*cpp_arg0, *cpp_arg1, cpp_arg2);
            } else if (numArgs == 4 && Shiboken::Converter<QRect& >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QRect* cpp_arg3 = Shiboken::Converter<QRect* >::toCpp(pyargs[3]);
                // showText(QPoint,QString,QWidget*,QRect)
                QToolTip::showText(*cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
            } else goto SbkQToolTipFunc_showText_TypeError;
        } else goto SbkQToolTipFunc_showText_TypeError;
    } else goto SbkQToolTipFunc_showText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQToolTipFunc_showText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QString, PySide.QtGui.QWidget = None", "PySide.QtCore.QPoint, PySide.QtCore.QString, PySide.QtGui.QWidget, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QToolTip.showText", overloads);
        return 0;
}

static PyObject*
SbkQToolTipFunc_text(PyObject* self)
{
    PyObject* py_result = 0;

    // text()
    QString cpp_result = QToolTip::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQToolTip_methods[] = {
    {"font", (PyCFunction)SbkQToolTipFunc_font, METH_NOARGS|METH_STATIC},
    {"hideText", (PyCFunction)SbkQToolTipFunc_hideText, METH_NOARGS|METH_STATIC},
    {"isVisible", (PyCFunction)SbkQToolTipFunc_isVisible, METH_NOARGS|METH_STATIC},
    {"palette", (PyCFunction)SbkQToolTipFunc_palette, METH_NOARGS|METH_STATIC},
    {"setFont", (PyCFunction)SbkQToolTipFunc_setFont, METH_O|METH_STATIC},
    {"setPalette", (PyCFunction)SbkQToolTipFunc_setPalette, METH_O|METH_STATIC},
    {"showText", (PyCFunction)SbkQToolTipFunc_showText, METH_VARARGS|METH_STATIC},
    {"text", (PyCFunction)SbkQToolTipFunc_text, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQToolTip_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QToolTip",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QToolTip >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQToolTip_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QToolTip(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTOOLTIP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQToolTip_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQToolTip_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQToolTip_Type));
    PyModule_AddObject(module, "QToolTip",
        ((PyObject*)&SbkQToolTip_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QToolTip >("QToolTip*");
    Shiboken::TypeResolver::createObjectTypeResolver<QToolTip >(typeid(QToolTip).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

