/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextoption_tab_wrapper.h"

// Extra includes
#include <qtextoption.h>

using namespace Shiboken;

static int
SbkQTextOption_Tab_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextOption::Tab* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // Tab()
    cptr = new QTextOption::Tab();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyMethodDef SbkQTextOption_Tab_methods[] = {
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQTextOption_Tab_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTextOption::Tab& cpp_self = *Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextOption::Tab& >::isConvertible(other)) {
                QTextOption::Tab* cpp_other = Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQTextOption_Tab_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextOption::Tab& >::isConvertible(other)) {
                QTextOption::Tab* cpp_other = Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQTextOption_Tab_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTextOption_Tab_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

static PyObject* SbkQTextOption_Tab_get_delimiter(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QChar >::toPython(Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->delimiter);
}
static int SbkQTextOption_Tab_set_delimiter(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'delimiter' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QChar >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'delimiter', 'QChar' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->delimiter = Shiboken::Converter<QChar >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextOption_Tab_get_position(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->position);
}
static int SbkQTextOption_Tab_set_position(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->position = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextOption_Tab_get_type(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextOption::TabType >::toPython(Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->type);
}
static int SbkQTextOption_Tab_set_type(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextOption::TabType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'TabType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextOption::Tab* >::toCpp((PyObject*)self)->type = Shiboken::Converter<QTextOption::TabType >::toCpp(value);

    return 0;
}

// Getters and Setters for Tab
static PyGetSetDef SbkQTextOption_Tab_getsetlist[] = {
    {const_cast<char*>("delimiter"), (getter)SbkQTextOption_Tab_get_delimiter, (setter)SbkQTextOption_Tab_set_delimiter},
    {const_cast<char*>("position"), (getter)SbkQTextOption_Tab_get_position, (setter)SbkQTextOption_Tab_set_position},
    {const_cast<char*>("type"), (getter)SbkQTextOption_Tab_get_type, (setter)SbkQTextOption_Tab_set_type},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextOption_Tab_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.Tab",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextOption::Tab >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextOption_Tab_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextOption_Tab_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTextOption_Tab_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextOption_Tab_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextOption_Tab(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextOption_Tab_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextOption_Tab_Type) < 0)
        return;

    PyDict_SetItemString(module,"Tab", (PyObject*)&SbkQTextOption_Tab_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QTextOption::Tab >("QTextOption::Tab");
    Shiboken::TypeResolver::createValueTypeResolver<QTextOption::Tab >(typeid(QTextOption::Tab).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

