/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextinlineobject_wrapper.h"

// Extra includes
#include <qrect.h>
#include <qtextformat.h>

using namespace Shiboken;

static int
SbkQTextInlineObject_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextInlineObject* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QTextInlineObject()
    cptr = new QTextInlineObject();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQTextInlineObjectFunc_ascent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ascent()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextInlineObject::ascent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_descent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // descent()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextInlineObject::descent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    QTextFormat cpp_result = cppSelf->QTextInlineObject::format();
    py_result = Shiboken::Converter<QTextFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_formatIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // formatIndex()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextInlineObject::formatIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextInlineObject::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextInlineObject::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QTextInlineObject::rect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_setAscent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAscent(qreal)
        QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
        cppSelf->QTextInlineObject::setAscent(cpp_arg0);
    } else goto SbkQTextInlineObjectFunc_setAscent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextInlineObjectFunc_setAscent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextInlineObject.setAscent", overloads);
        return 0;
}

static PyObject*
SbkQTextInlineObjectFunc_setDescent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDescent(qreal)
        QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
        cppSelf->QTextInlineObject::setDescent(cpp_arg0);
    } else goto SbkQTextInlineObjectFunc_setDescent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextInlineObjectFunc_setDescent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextInlineObject.setDescent", overloads);
        return 0;
}

static PyObject*
SbkQTextInlineObjectFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
        cppSelf->QTextInlineObject::setWidth(cpp_arg0);
    } else goto SbkQTextInlineObjectFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextInlineObjectFunc_setWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextInlineObject.setWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextInlineObjectFunc_textDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textDirection()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QTextInlineObject::textDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_textPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textPosition()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextInlineObject::textPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextInlineObjectFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QTextInlineObject* cppSelf = Shiboken::Converter<QTextInlineObject* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextInlineObject::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextInlineObject_methods[] = {
    {"ascent", (PyCFunction)SbkQTextInlineObjectFunc_ascent, METH_NOARGS},
    {"descent", (PyCFunction)SbkQTextInlineObjectFunc_descent, METH_NOARGS},
    {"format", (PyCFunction)SbkQTextInlineObjectFunc_format, METH_NOARGS},
    {"formatIndex", (PyCFunction)SbkQTextInlineObjectFunc_formatIndex, METH_NOARGS},
    {"height", (PyCFunction)SbkQTextInlineObjectFunc_height, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextInlineObjectFunc_isValid, METH_NOARGS},
    {"rect", (PyCFunction)SbkQTextInlineObjectFunc_rect, METH_NOARGS},
    {"setAscent", (PyCFunction)SbkQTextInlineObjectFunc_setAscent, METH_O},
    {"setDescent", (PyCFunction)SbkQTextInlineObjectFunc_setDescent, METH_O},
    {"setWidth", (PyCFunction)SbkQTextInlineObjectFunc_setWidth, METH_O},
    {"textDirection", (PyCFunction)SbkQTextInlineObjectFunc_textDirection, METH_NOARGS},
    {"textPosition", (PyCFunction)SbkQTextInlineObjectFunc_textPosition, METH_NOARGS},
    {"width", (PyCFunction)SbkQTextInlineObjectFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextInlineObject_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextInlineObject",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextInlineObject >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextInlineObject_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextInlineObject_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextInlineObject(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTINLINEOBJECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextInlineObject_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextInlineObject_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextInlineObject_Type));
    PyModule_AddObject(module, "QTextInlineObject",
        ((PyObject*)&SbkQTextInlineObject_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextInlineObject >("QTextInlineObject");
    Shiboken::TypeResolver::createValueTypeResolver<QTextInlineObject >(typeid(QTextInlineObject).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

