/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextfragment_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qtextformat.h>
#include <qtextobject.h>

using namespace Shiboken;

static int
SbkQTextFragment_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextFragment* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextFragment", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextFragment()
        cptr = new QTextFragment();
    } else if (numArgs == 1 && Shiboken::Converter<QTextFragment& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFragment* cpp_arg0 = Shiboken::Converter<QTextFragment* >::toCpp(pyargs[0]);
        // QTextFragment(QTextFragment)
        cptr = new QTextFragment(*cpp_arg0);
    } else goto SbkQTextFragment_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextFragment_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextFragment_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextFragment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextFragment", overloads);
        return -1;
}

static PyObject*
SbkQTextFragmentFunc_charFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // charFormat()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextFragment::charFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextFragmentFunc_charFormatIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // charFormatIndex()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFragment::charFormatIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextFragmentFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // contains(int)const
        QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextFragment::contains(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextFragmentFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextFragmentFunc_contains_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFragment.contains", overloads);
        return 0;
}

static PyObject*
SbkQTextFragmentFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFragment::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextFragmentFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFragment::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextFragmentFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFragment::position();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextFragmentFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QTextFragment* cppSelf = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextFragment::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextFragment_methods[] = {
    {"charFormat", (PyCFunction)SbkQTextFragmentFunc_charFormat, METH_NOARGS},
    {"charFormatIndex", (PyCFunction)SbkQTextFragmentFunc_charFormatIndex, METH_NOARGS},
    {"contains", (PyCFunction)SbkQTextFragmentFunc_contains, METH_O},
    {"isValid", (PyCFunction)SbkQTextFragmentFunc_isValid, METH_NOARGS},
    {"length", (PyCFunction)SbkQTextFragmentFunc_length, METH_NOARGS},
    {"position", (PyCFunction)SbkQTextFragmentFunc_position, METH_NOARGS},
    {"text", (PyCFunction)SbkQTextFragmentFunc_text, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQTextFragment_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTextFragment& cpp_self = *Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextFragment& >::isConvertible(other)) {
                QTextFragment* cpp_other = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQTextFragment_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QTextFragment& >::isConvertible(other)) {
                QTextFragment* cpp_other = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQTextFragment_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextFragment& >::isConvertible(other)) {
                QTextFragment* cpp_other = Shiboken::Converter<QTextFragment* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQTextFragment_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTextFragment_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextFragment_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextFragment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextFragment >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextFragment_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextFragment_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextFragment_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextFragment(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTFRAGMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextFragment_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextFragment_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextFragment_Type));
    PyModule_AddObject(module, "QTextFragment",
        ((PyObject*)&SbkQTextFragment_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextFragment >("QTextFragment");
    Shiboken::TypeResolver::createValueTypeResolver<QTextFragment >(typeid(QTextFragment).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

