/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextedit_extraselection_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

ExtraSelectionWrapper::ExtraSelectionWrapper() : QTextEdit::ExtraSelection() {
    // ... middle
}

ExtraSelectionWrapper::~ExtraSelectionWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextEdit_ExtraSelection_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    ExtraSelectionWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // ExtraSelection()
    cptr = new ExtraSelectionWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyMethodDef SbkQTextEdit_ExtraSelection_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQTextEdit_ExtraSelection_get_cursor(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextCursor >::toPython(Shiboken::Converter<QTextEdit::ExtraSelection* >::toCpp((PyObject*)self)->cursor);
}
static int SbkQTextEdit_ExtraSelection_set_cursor(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'cursor' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextCursor >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cursor', 'QTextCursor' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextEdit::ExtraSelection* >::toCpp((PyObject*)self)->cursor = Shiboken::Converter<QTextCursor >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextEdit_ExtraSelection_get_format(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextCharFormat >::toPython(Shiboken::Converter<QTextEdit::ExtraSelection* >::toCpp((PyObject*)self)->format);
}
static int SbkQTextEdit_ExtraSelection_set_format(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'format' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextCharFormat >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'format', 'QTextCharFormat' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextEdit::ExtraSelection* >::toCpp((PyObject*)self)->format = Shiboken::Converter<QTextCharFormat >::toCpp(value);

    return 0;
}

// Getters and Setters for ExtraSelection
static PyGetSetDef SbkQTextEdit_ExtraSelection_getsetlist[] = {
    {const_cast<char*>("cursor"), (getter)SbkQTextEdit_ExtraSelection_get_cursor, (setter)SbkQTextEdit_ExtraSelection_set_cursor},
    {const_cast<char*>("format"), (getter)SbkQTextEdit_ExtraSelection_get_format, (setter)SbkQTextEdit_ExtraSelection_set_format},
    {0}  // Sentinel
};

extern "C"
{

static void* SbkQTextEdit_ExtraSelection_ObjCopierFunc(const void* ptr){
    return new ExtraSelectionWrapper(*reinterpret_cast<const QTextEdit::ExtraSelection*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextEdit_ExtraSelection_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.ExtraSelection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< ExtraSelectionWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextEdit_ExtraSelection_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTextEdit_ExtraSelection_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextEdit_ExtraSelection_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextEdit_ExtraSelection_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQTextEdit_ExtraSelection_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTextEdit_ExtraSelection_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTextEdit::ExtraSelection*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QTextEdit_ExtraSelection(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextEdit_ExtraSelection_Type);

    // Fill type discovery information
    SbkQTextEdit_ExtraSelection_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTextEdit_ExtraSelection_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTextEdit_ExtraSelection_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTextEdit_ExtraSelection_Type) < 0)
        return;

    PyDict_SetItemString(module,"ExtraSelection", (PyObject*)&SbkQTextEdit_ExtraSelection_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QTextEdit::ExtraSelection >("QTextEdit::ExtraSelection");
    Shiboken::TypeResolver::createValueTypeResolver<QTextEdit::ExtraSelection >(typeid(QTextEdit::ExtraSelection).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

