/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextdocumentfragment_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qstring.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextdocumentfragment.h>

using namespace Shiboken;

static int
SbkQTextDocumentFragment_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextDocumentFragment* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextDocumentFragment", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextDocumentFragment()
        cptr = new QTextDocumentFragment();
    } else if (numArgs == 1 && Shiboken::Converter<QTextDocumentFragment& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocumentFragment* cpp_arg0 = Shiboken::Converter<QTextDocumentFragment* >::toCpp(pyargs[0]);
        // QTextDocumentFragment(QTextDocumentFragment)
        cptr = new QTextDocumentFragment(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QTextDocumentFragment(const QTextDocument*)
        cptr = new QTextDocumentFragment(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTextCursor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[0]);
        // QTextDocumentFragment(QTextCursor)
        cptr = new QTextDocumentFragment(*cpp_arg0);
    } else goto SbkQTextDocumentFragment_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextDocumentFragment_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextDocumentFragment_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextCursor", "PySide.QtGui.QTextDocument", "PySide.QtGui.QTextDocumentFragment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocumentFragment", overloads);
        return -1;
}

static PyObject*
SbkQTextDocumentFragmentFunc_fromHtml(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromHtml", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromHtml(QString)
            QTextDocumentFragment cpp_result = QTextDocumentFragment::fromHtml(*cpp_arg0);
            py_result = Shiboken::Converter<QTextDocumentFragment >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTextDocument* cpp_arg1 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[1]);
            // fromHtml(QString,const QTextDocument*)
            QTextDocumentFragment cpp_result = QTextDocumentFragment::fromHtml(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTextDocumentFragment >::toPython(cpp_result);
        } else goto SbkQTextDocumentFragmentFunc_fromHtml_TypeError;
    } else goto SbkQTextDocumentFragmentFunc_fromHtml_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFragmentFunc_fromHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocumentFragment.fromHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFragmentFunc_fromPlainText(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromPlainText(QString)
        QTextDocumentFragment cpp_result = QTextDocumentFragment::fromPlainText(*cpp_arg0);
        py_result = Shiboken::Converter<QTextDocumentFragment >::toPython(cpp_result);
    } else goto SbkQTextDocumentFragmentFunc_fromPlainText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFragmentFunc_fromPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocumentFragment.fromPlainText", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFragmentFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QTextDocumentFragment* cppSelf = Shiboken::Converter<QTextDocumentFragment* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocumentFragment::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFragmentFunc_toHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toHtml()const
        QTextDocumentFragment* cppSelf = Shiboken::Converter<QTextDocumentFragment* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextDocumentFragment::toHtml();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // toHtml(QByteArray)const
        QTextDocumentFragment* cppSelf = Shiboken::Converter<QTextDocumentFragment* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextDocumentFragment::toHtml(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextDocumentFragmentFunc_toHtml_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFragmentFunc_toHtml_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocumentFragment.toHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFragmentFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QTextDocumentFragment* cppSelf = Shiboken::Converter<QTextDocumentFragment* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextDocumentFragment::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextDocumentFragment_methods[] = {
    {"fromHtml", (PyCFunction)SbkQTextDocumentFragmentFunc_fromHtml, METH_VARARGS|METH_STATIC},
    {"fromPlainText", (PyCFunction)SbkQTextDocumentFragmentFunc_fromPlainText, METH_O|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQTextDocumentFragmentFunc_isEmpty, METH_NOARGS},
    {"toHtml", (PyCFunction)SbkQTextDocumentFragmentFunc_toHtml, METH_NOARGS|METH_O},
    {"toPlainText", (PyCFunction)SbkQTextDocumentFragmentFunc_toPlainText, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextDocumentFragment_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextDocumentFragment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextDocumentFragment >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextDocumentFragment_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextDocumentFragment_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextDocumentFragment(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextDocumentFragment_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextDocumentFragment_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextDocumentFragment_Type));
    PyModule_AddObject(module, "QTextDocumentFragment",
        ((PyObject*)&SbkQTextDocumentFragment_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextDocumentFragment >("QTextDocumentFragment");
    Shiboken::TypeResolver::createValueTypeResolver<QTextDocumentFragment >(typeid(QTextDocumentFragment).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

