/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextblockformat_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpen.h>
#include <qstring.h>
#include <qtextformat.h>
#include <qtextoption.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextBlockFormatWrapper::QTextBlockFormatWrapper() : QTextBlockFormat() {
    // ... middle
}

QTextBlockFormatWrapper::QTextBlockFormatWrapper(const QTextFormat & fmt) : QTextBlockFormat(fmt) {
    // ... middle
}

QTextBlockFormatWrapper::~QTextBlockFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextBlockFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextBlockFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextBlockFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextBlockFormat()
        cptr = new QTextBlockFormatWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextBlockFormat(QTextFormat)
        cptr = new QTextBlockFormatWrapper(*cpp_arg0);
    } else goto SbkQTextBlockFormat_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextBlockFormat_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextBlockFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextBlockFormat", overloads);
        return -1;
}

static PyObject*
SbkQTextBlockFormatFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QTextBlockFormat::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_bottomMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomMargin()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextBlockFormat::bottomMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_indent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indent()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlockFormat::indent();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBlockFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_leftMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leftMargin()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextBlockFormat::leftMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_nonBreakableLines(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nonBreakableLines()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBlockFormat::nonBreakableLines();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_pageBreakPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageBreakPolicy()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    QFlags<QTextFormat::PageBreakFlag> cpp_result = cppSelf->QTextBlockFormat::pageBreakPolicy();
    py_result = Shiboken::Converter<QFlags<QTextFormat::PageBreakFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_rightMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rightMargin()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextBlockFormat::rightMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setAlignment(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setAlignment", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setBottomMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBottomMargin(qreal)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setBottomMargin(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setBottomMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setBottomMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setBottomMargin", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setIndent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIndent(int)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setIndent(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setIndent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setIndent_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setIndent", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setLeftMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLeftMargin(qreal)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setLeftMargin(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setLeftMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setLeftMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setLeftMargin", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setNonBreakableLines(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setNonBreakableLines(bool)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setNonBreakableLines(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setNonBreakableLines_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setNonBreakableLines_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setNonBreakableLines", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setPageBreakPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QTextFormat_PageBreakFlag_Check(arg)) {
        QFlags<QTextFormat::PageBreakFlag> cpp_arg0 = Shiboken::Converter<QFlags<QTextFormat::PageBreakFlag> >::toCpp(arg);
        // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setPageBreakPolicy(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setPageBreakPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setPageBreakPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFormat.PageBreakFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setPageBreakPolicy", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setRightMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRightMargin(qreal)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setRightMargin(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setRightMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setRightMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setRightMargin", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setTabPositions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTextOption::Tab >  >::isConvertible(arg)) {
        QList<QTextOption::Tab >  cpp_arg0 = Shiboken::Converter<QList<QTextOption::Tab >  >::toCpp(arg);
        // setTabPositions(QList<QTextOption::Tab>)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setTabPositions(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setTabPositions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setTabPositions_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setTabPositions", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setTextIndent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTextIndent(qreal)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setTextIndent(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setTextIndent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setTextIndent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setTextIndent", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_setTopMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTopMargin(qreal)
        QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextBlockFormat::setTopMargin(cpp_arg0);
    } else goto SbkQTextBlockFormatFunc_setTopMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFormatFunc_setTopMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlockFormat.setTopMargin", overloads);
        return 0;
}

static PyObject*
SbkQTextBlockFormatFunc_tabPositions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabPositions()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    QList<QTextOption::Tab > cpp_result = cppSelf->QTextBlockFormat::tabPositions();
    py_result = Shiboken::Converter<QList<QTextOption::Tab > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_textIndent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textIndent()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextBlockFormat::textIndent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBlockFormatFunc_topMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topMargin()const
    QTextBlockFormat* cppSelf = Shiboken::Converter<QTextBlockFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextBlockFormat::topMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextBlockFormat_methods[] = {
    {"alignment", (PyCFunction)SbkQTextBlockFormatFunc_alignment, METH_NOARGS},
    {"bottomMargin", (PyCFunction)SbkQTextBlockFormatFunc_bottomMargin, METH_NOARGS},
    {"indent", (PyCFunction)SbkQTextBlockFormatFunc_indent, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextBlockFormatFunc_isValid, METH_NOARGS},
    {"leftMargin", (PyCFunction)SbkQTextBlockFormatFunc_leftMargin, METH_NOARGS},
    {"nonBreakableLines", (PyCFunction)SbkQTextBlockFormatFunc_nonBreakableLines, METH_NOARGS},
    {"pageBreakPolicy", (PyCFunction)SbkQTextBlockFormatFunc_pageBreakPolicy, METH_NOARGS},
    {"rightMargin", (PyCFunction)SbkQTextBlockFormatFunc_rightMargin, METH_NOARGS},
    {"setAlignment", (PyCFunction)SbkQTextBlockFormatFunc_setAlignment, METH_O},
    {"setBottomMargin", (PyCFunction)SbkQTextBlockFormatFunc_setBottomMargin, METH_O},
    {"setIndent", (PyCFunction)SbkQTextBlockFormatFunc_setIndent, METH_O},
    {"setLeftMargin", (PyCFunction)SbkQTextBlockFormatFunc_setLeftMargin, METH_O},
    {"setNonBreakableLines", (PyCFunction)SbkQTextBlockFormatFunc_setNonBreakableLines, METH_O},
    {"setPageBreakPolicy", (PyCFunction)SbkQTextBlockFormatFunc_setPageBreakPolicy, METH_O},
    {"setRightMargin", (PyCFunction)SbkQTextBlockFormatFunc_setRightMargin, METH_O},
    {"setTabPositions", (PyCFunction)SbkQTextBlockFormatFunc_setTabPositions, METH_O},
    {"setTextIndent", (PyCFunction)SbkQTextBlockFormatFunc_setTextIndent, METH_O},
    {"setTopMargin", (PyCFunction)SbkQTextBlockFormatFunc_setTopMargin, METH_O},
    {"tabPositions", (PyCFunction)SbkQTextBlockFormatFunc_tabPositions, METH_NOARGS},
    {"textIndent", (PyCFunction)SbkQTextBlockFormatFunc_textIndent, METH_NOARGS},
    {"topMargin", (PyCFunction)SbkQTextBlockFormatFunc_topMargin, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextBlockFormat_ObjCopierFunc(const void* ptr){
    return new QTextBlockFormatWrapper(*reinterpret_cast<const QTextBlockFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextBlockFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextBlockFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextBlockFormatWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextBlockFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextBlockFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextBlockFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextBlockFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextBlockFormat_Type);

    SbkQTextBlockFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX];
    // Fill type discovery information
    SbkQTextBlockFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextBlockFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextBlockFormat_Type));
    PyModule_AddObject(module, "QTextBlockFormat",
        ((PyObject*)&SbkQTextBlockFormat_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextBlockFormat >("QTextBlockFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextBlockFormat >(typeid(QTextBlockFormat).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

