/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtablewidgetitem_wrapper.h"

// Extra includes
#include <qbrush.h>
#include <qdatastream.h>
#include <qfont.h>
#include <qicon.h>
#include <qsize.h>
#include <qstring.h>
#include <qtablewidget.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTableWidgetItemWrapper::QTableWidgetItemWrapper(const QIcon & icon, const QString & text, int type) : QTableWidgetItem(icon, text, type) {
    // ... middle
}

QTableWidgetItemWrapper::QTableWidgetItemWrapper(const QString & text, int type) : QTableWidgetItem(text, type) {
    // ... middle
}

QTableWidgetItemWrapper::QTableWidgetItemWrapper(int type) : QTableWidgetItem(type) {
    // ... middle
}

QTableWidgetItem * QTableWidgetItemWrapper::clone() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clone"));
    if (py_override.isNull()) {
        return this->QTableWidgetItem::clone();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QTableWidgetItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTableWidgetItem.clone");
        return 0        ;
    }
    QTableWidgetItem* cpp_result(Shiboken::Converter<QTableWidgetItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QVariant QTableWidgetItemWrapper::data(int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QTableWidgetItem::data(role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTableWidgetItem.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetItemWrapper::setData(int role, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QTableWidgetItem::setData(role, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        role,
        Shiboken::Converter<QVariant& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QTableWidgetItemWrapper::~QTableWidgetItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTableWidgetItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTableWidgetItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QTableWidgetItem", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QTableWidgetItem(int)
        cptr = new QTableWidgetItemWrapper();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QTableWidgetItem(int)
        cptr = new QTableWidgetItemWrapper(cpp_arg0);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QTableWidgetItem(QString,int)
            cptr = new QTableWidgetItemWrapper(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QTableWidgetItem(QString,int)
            cptr = new QTableWidgetItemWrapper(*cpp_arg0, cpp_arg1);
        } else goto SbkQTableWidgetItem_Init_TypeError;
    } else if (Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // QTableWidgetItem(QIcon,QString,int)
            cptr = new QTableWidgetItemWrapper(*cpp_arg0, *cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // QTableWidgetItem(QIcon,QString,int)
            cptr = new QTableWidgetItemWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
        } else goto SbkQTableWidgetItem_Init_TypeError;
    } else goto SbkQTableWidgetItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTableWidgetItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTableWidgetItem_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon, PySide.QtCore.QString, int = Type", "PySide.QtCore.QString, int = Type", "int = Type", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidgetItem", overloads);
        return -1;
}

static PyObject*
SbkQTableWidgetItemFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QTableWidgetItem::background();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_checkState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // checkState()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    Qt::CheckState cpp_result = cppSelf->QTableWidgetItem::checkState();
    py_result = Shiboken::Converter<Qt::CheckState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QTableWidgetItem * cpp_result = cppSelf->QTableWidgetItem::clone();
    py_result = Shiboken::Converter<QTableWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_column(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // column()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetItem::column();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // data(int)const
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTableWidgetItem::data(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQTableWidgetItemFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTableWidgetItemFunc_data_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.data", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QFlags<Qt::ItemFlag> cpp_result = cppSelf->QTableWidgetItem::flags();
    py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTableWidgetItem::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_foreground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foreground()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QTableWidgetItem::foreground();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QTableWidgetItem::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_isSelected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelected()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTableWidgetItem::isSelected();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_row(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // row()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetItem::row();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setBackground(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setBackground", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setCheckState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CheckState >::isConvertible(arg)) {
        Qt::CheckState cpp_arg0 = Shiboken::Converter<Qt::CheckState >::toCpp(arg);
        // setCheckState(Qt::CheckState)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setCheckState(cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setCheckState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setCheckState_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CheckState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setCheckState", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setData(int,QVariant)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setData(cpp_arg0, *cpp_arg1);
    } else goto SbkQTableWidgetItemFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidgetItem.setData", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_ItemFlag_Check(arg)) {
        QFlags<Qt::ItemFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(arg);
        // setFlags(QFlags<Qt::ItemFlag>)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setFlags(cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ItemFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setFlags", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setFont(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setFont", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setForeground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForeground(QBrush)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setForeground(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setForeground", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setIcon(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setIcon", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setSelected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelected(bool)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setSelected(cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setSelected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setSelected_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setSelected", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setSizeHint(QSize)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setSizeHint(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setSizeHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setSizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setSizeHint", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setStatusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStatusTip(QString)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setStatusTip(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setStatusTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setStatusTip", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setText(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setText", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setTextAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTextAlignment(int)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setTextAlignment(cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setTextAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setTextAlignment_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setTextAlignment", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setToolTip(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setToolTip", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTableWidgetItem::setWhatsThis(*cpp_arg0);
    } else goto SbkQTableWidgetItemFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetItemFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.setWhatsThis", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTableWidgetItem::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_statusTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusTip()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTableWidgetItem::statusTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_tableWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tableWidget()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QTableWidget * cpp_result = cppSelf->QTableWidgetItem::tableWidget();
    py_result = Shiboken::Converter<QTableWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTableWidgetItem::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_textAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textAlignment()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetItem::textAlignment();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTableWidgetItem::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetItem::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetItemFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTableWidgetItem::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTableWidgetItem_methods[] = {
    {"background", (PyCFunction)SbkQTableWidgetItemFunc_background, METH_NOARGS},
    {"checkState", (PyCFunction)SbkQTableWidgetItemFunc_checkState, METH_NOARGS},
    {"clone", (PyCFunction)SbkQTableWidgetItemFunc_clone, METH_NOARGS},
    {"column", (PyCFunction)SbkQTableWidgetItemFunc_column, METH_NOARGS},
    {"data", (PyCFunction)SbkQTableWidgetItemFunc_data, METH_O},
    {"flags", (PyCFunction)SbkQTableWidgetItemFunc_flags, METH_NOARGS},
    {"font", (PyCFunction)SbkQTableWidgetItemFunc_font, METH_NOARGS},
    {"foreground", (PyCFunction)SbkQTableWidgetItemFunc_foreground, METH_NOARGS},
    {"icon", (PyCFunction)SbkQTableWidgetItemFunc_icon, METH_NOARGS},
    {"isSelected", (PyCFunction)SbkQTableWidgetItemFunc_isSelected, METH_NOARGS},
    {"row", (PyCFunction)SbkQTableWidgetItemFunc_row, METH_NOARGS},
    {"setBackground", (PyCFunction)SbkQTableWidgetItemFunc_setBackground, METH_O},
    {"setCheckState", (PyCFunction)SbkQTableWidgetItemFunc_setCheckState, METH_O},
    {"setData", (PyCFunction)SbkQTableWidgetItemFunc_setData, METH_VARARGS},
    {"setFlags", (PyCFunction)SbkQTableWidgetItemFunc_setFlags, METH_O},
    {"setFont", (PyCFunction)SbkQTableWidgetItemFunc_setFont, METH_O},
    {"setForeground", (PyCFunction)SbkQTableWidgetItemFunc_setForeground, METH_O},
    {"setIcon", (PyCFunction)SbkQTableWidgetItemFunc_setIcon, METH_O},
    {"setSelected", (PyCFunction)SbkQTableWidgetItemFunc_setSelected, METH_O},
    {"setSizeHint", (PyCFunction)SbkQTableWidgetItemFunc_setSizeHint, METH_O},
    {"setStatusTip", (PyCFunction)SbkQTableWidgetItemFunc_setStatusTip, METH_O},
    {"setText", (PyCFunction)SbkQTableWidgetItemFunc_setText, METH_O},
    {"setTextAlignment", (PyCFunction)SbkQTableWidgetItemFunc_setTextAlignment, METH_O},
    {"setToolTip", (PyCFunction)SbkQTableWidgetItemFunc_setToolTip, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQTableWidgetItemFunc_setWhatsThis, METH_O},
    {"sizeHint", (PyCFunction)SbkQTableWidgetItemFunc_sizeHint, METH_NOARGS},
    {"statusTip", (PyCFunction)SbkQTableWidgetItemFunc_statusTip, METH_NOARGS},
    {"tableWidget", (PyCFunction)SbkQTableWidgetItemFunc_tableWidget, METH_NOARGS},
    {"text", (PyCFunction)SbkQTableWidgetItemFunc_text, METH_NOARGS},
    {"textAlignment", (PyCFunction)SbkQTableWidgetItemFunc_textAlignment, METH_NOARGS},
    {"toolTip", (PyCFunction)SbkQTableWidgetItemFunc_toolTip, METH_NOARGS},
    {"type", (PyCFunction)SbkQTableWidgetItemFunc_type, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQTableWidgetItemFunc_whatsThis, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQTableWidgetItemFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTableWidgetItem_Check(arg) && !SbkQTableWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QTableWidgetItem) [reverse operator]
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetItemFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTableWidgetItemFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQTableWidgetItemFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTableWidgetItem_Check(arg) && !SbkQTableWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QTableWidgetItem&) [reverse operator]
        QTableWidgetItem* cppSelf = Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetItemFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTableWidgetItemFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidgetItem.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQTableWidgetItem_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQTableWidgetItemFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQTableWidgetItemFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQTableWidgetItem_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTableWidgetItem& cpp_self = *Shiboken::Converter<QTableWidgetItem* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTableWidgetItem_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTableWidgetItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTableWidgetItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTableWidgetItemWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTableWidgetItem_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTableWidgetItem_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTableWidgetItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTableWidgetItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQTableWidgetItem_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTableWidgetItem_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTableWidgetItem*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QTableWidgetItem_ItemType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTableWidgetItem_ItemType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTableWidgetItem_ItemType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTableWidgetItem_ItemType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTableWidgetItem_ItemType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTableWidgetItem_ItemType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTableWidgetItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTableWidgetItem_Type);

    // Fill type discovery information
    SbkQTableWidgetItem_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTableWidgetItem_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTableWidgetItem_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTableWidgetItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTableWidgetItem_Type));
    PyModule_AddObject(module, "QTableWidgetItem",
        ((PyObject*)&SbkQTableWidgetItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ItemType
    SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETITEM_ITEMTYPE_IDX] = &SbkPySide_QtGui_QTableWidgetItem_ItemType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTableWidgetItem_ItemType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTableWidgetItem_ItemType_Type);
    PyDict_SetItemString(SbkQTableWidgetItem_Type.super.ht_type.tp_dict,
            "ItemType",((PyObject*)&SbkPySide_QtGui_QTableWidgetItem_ItemType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTableWidgetItem_ItemType_Type,
        (long) QTableWidgetItem::Type, "Type");
    PyDict_SetItemString(SbkQTableWidgetItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTableWidgetItem_ItemType_Type.tp_dict,
        "Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTableWidgetItem_ItemType_Type,
        (long) QTableWidgetItem::UserType, "UserType");
    PyDict_SetItemString(SbkQTableWidgetItem_Type.super.ht_type.tp_dict,
        "UserType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTableWidgetItem_ItemType_Type.tp_dict,
        "UserType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTableWidgetItem::ItemType");

    Shiboken::TypeResolver::createObjectTypeResolver<QTableWidgetItem >("QTableWidgetItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTableWidgetItem >(typeid(QTableWidgetItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

