/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtabletevent_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTabletEventWrapper::QTabletEventWrapper(QEvent::Type t, const QPoint & pos, const QPoint & globalPos, const QPointF & hiResGlobalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID) : QTabletEvent(t, pos, globalPos, hiResGlobalPos, device, pointerType, pressure, xTilt, yTilt, tangentialPressure, rotation, z, keyState, uniqueID) {
    // ... middle
}

QTabletEventWrapper::~QTabletEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTabletEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTabletEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QTabletEvent", 14, 14, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9]), &(pyargs[10]), &(pyargs[11]), &(pyargs[12]), &(pyargs[13])))
        return -1;

    if (numArgs == 14 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5]) && PyNumber_Check(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8]) && PyNumber_Check(pyargs[9]) && PyNumber_Check(pyargs[10]) && PyNumber_Check(pyargs[11]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[12]) && PyNumber_Check(pyargs[13])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg3_auto_ptr;
        QPointF* cpp_arg3 = Shiboken::Converter<QPointF* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPointF >(cpp_arg3);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        qreal cpp_arg6 = Shiboken::Converter<qreal >::toCpp(pyargs[6]);
        int cpp_arg7 = Shiboken::Converter<int >::toCpp(pyargs[7]);
        int cpp_arg8 = Shiboken::Converter<int >::toCpp(pyargs[8]);
        qreal cpp_arg9 = Shiboken::Converter<qreal >::toCpp(pyargs[9]);
        qreal cpp_arg10 = Shiboken::Converter<qreal >::toCpp(pyargs[10]);
        int cpp_arg11 = Shiboken::Converter<int >::toCpp(pyargs[11]);
        QFlags<Qt::KeyboardModifier> cpp_arg12 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[12]);
        qint64 cpp_arg13 = Shiboken::Converter<qint64 >::toCpp(pyargs[13]);
        // QTabletEvent(QEvent::Type,QPoint,QPoint,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64)
        cptr = new QTabletEventWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8, cpp_arg9, cpp_arg10, cpp_arg11, cpp_arg12, cpp_arg13);
    } else goto SbkQTabletEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTabletEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTabletEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.QPoint, PySide.QtCore.QPoint, PySide.QtCore.QPointF, int, int, float, int, int, float, float, int, PySide.QtCore.Qt.KeyboardModifiers, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabletEvent", overloads);
        return -1;
}

static PyObject*
SbkQTabletEventFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    QTabletEvent::TabletDevice cpp_result = cppSelf->QTabletEvent::device();
    py_result = Shiboken::Converter<QTabletEvent::TabletDevice >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_globalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalPos()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QTabletEvent::globalPos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_globalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalX()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::globalX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_globalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalY()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::globalY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_hiResGlobalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hiResGlobalPos()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    const QPointF & cpp_result = cppSelf->QTabletEvent::hiResGlobalPos();
    py_result = Shiboken::Converter<QPointF& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_hiResGlobalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hiResGlobalX()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTabletEvent::hiResGlobalX();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_hiResGlobalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hiResGlobalY()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTabletEvent::hiResGlobalY();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_pointerType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pointerType()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    QTabletEvent::PointerType cpp_result = cppSelf->QTabletEvent::pointerType();
    py_result = Shiboken::Converter<QTabletEvent::PointerType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QTabletEvent::pos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_pressure(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pressure()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTabletEvent::pressure();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_rotation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rotation()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTabletEvent::rotation();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_tangentialPressure(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tangentialPressure()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTabletEvent::tangentialPressure();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_uniqueId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uniqueId()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QTabletEvent::uniqueId();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_xTilt(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // xTilt()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::xTilt();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_yTilt(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yTilt()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::yTilt();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTabletEventFunc_z(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // z()const
    QTabletEvent* cppSelf = Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabletEvent::z();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTabletEvent_methods[] = {
    {"device", (PyCFunction)SbkQTabletEventFunc_device, METH_NOARGS},
    {"globalPos", (PyCFunction)SbkQTabletEventFunc_globalPos, METH_NOARGS},
    {"globalX", (PyCFunction)SbkQTabletEventFunc_globalX, METH_NOARGS},
    {"globalY", (PyCFunction)SbkQTabletEventFunc_globalY, METH_NOARGS},
    {"hiResGlobalPos", (PyCFunction)SbkQTabletEventFunc_hiResGlobalPos, METH_NOARGS},
    {"hiResGlobalX", (PyCFunction)SbkQTabletEventFunc_hiResGlobalX, METH_NOARGS},
    {"hiResGlobalY", (PyCFunction)SbkQTabletEventFunc_hiResGlobalY, METH_NOARGS},
    {"pointerType", (PyCFunction)SbkQTabletEventFunc_pointerType, METH_NOARGS},
    {"pos", (PyCFunction)SbkQTabletEventFunc_pos, METH_NOARGS},
    {"pressure", (PyCFunction)SbkQTabletEventFunc_pressure, METH_NOARGS},
    {"rotation", (PyCFunction)SbkQTabletEventFunc_rotation, METH_NOARGS},
    {"tangentialPressure", (PyCFunction)SbkQTabletEventFunc_tangentialPressure, METH_NOARGS},
    {"uniqueId", (PyCFunction)SbkQTabletEventFunc_uniqueId, METH_NOARGS},
    {"x", (PyCFunction)SbkQTabletEventFunc_x, METH_NOARGS},
    {"xTilt", (PyCFunction)SbkQTabletEventFunc_xTilt, METH_NOARGS},
    {"y", (PyCFunction)SbkQTabletEventFunc_y, METH_NOARGS},
    {"yTilt", (PyCFunction)SbkQTabletEventFunc_yTilt, METH_NOARGS},
    {"z", (PyCFunction)SbkQTabletEventFunc_z, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQTabletEvent_get_mYT(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mYT);
}
static int SbkQTabletEvent_set_mYT(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mYT' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mYT', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mYT = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mGPos(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mGPos);
}
static int SbkQTabletEvent_set_mGPos(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mGPos' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mGPos', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mGPos = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mXT(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mXT);
}
static int SbkQTabletEvent_set_mXT(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mXT' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mXT', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mXT = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mUnique(SbkBaseWrapper* self)
{
    return Shiboken::Converter<long long >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mUnique);
}
static int SbkQTabletEvent_set_mUnique(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mUnique' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mUnique', 'qint64' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mUnique = Shiboken::Converter<long long >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mTangential(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mTangential);
}
static int SbkQTabletEvent_set_mTangential(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mTangential' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mTangential', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mTangential = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mPointerType(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPointerType);
}
static int SbkQTabletEvent_set_mPointerType(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mPointerType' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mPointerType', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPointerType = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mHiResGlobalPos(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPointF >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mHiResGlobalPos);
}
static int SbkQTabletEvent_set_mHiResGlobalPos(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mHiResGlobalPos' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPointF >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mHiResGlobalPos', 'QPointF' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mHiResGlobalPos = Shiboken::Converter<QPointF >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mPos(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPos);
}
static int SbkQTabletEvent_set_mPos(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mPos' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mPos', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPos = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mPress(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPress);
}
static int SbkQTabletEvent_set_mPress(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mPress' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mPress', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mPress = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mDev(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mDev);
}
static int SbkQTabletEvent_set_mDev(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mDev' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mDev', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mDev = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mRot(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mRot);
}
static int SbkQTabletEvent_set_mRot(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mRot' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mRot', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mRot = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQTabletEvent_get_mZ(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mZ);
}
static int SbkQTabletEvent_set_mZ(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mZ' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mZ', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTabletEvent* >::toCpp((PyObject*)self)->mZ = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

// Getters and Setters for QTabletEvent
static PyGetSetDef SbkQTabletEvent_getsetlist[] = {
    {const_cast<char*>("mYT"), (getter)SbkQTabletEvent_get_mYT, (setter)SbkQTabletEvent_set_mYT},
    {const_cast<char*>("mGPos"), (getter)SbkQTabletEvent_get_mGPos, (setter)SbkQTabletEvent_set_mGPos},
    {const_cast<char*>("mXT"), (getter)SbkQTabletEvent_get_mXT, (setter)SbkQTabletEvent_set_mXT},
    {const_cast<char*>("mUnique"), (getter)SbkQTabletEvent_get_mUnique, (setter)SbkQTabletEvent_set_mUnique},
    {const_cast<char*>("mTangential"), (getter)SbkQTabletEvent_get_mTangential, (setter)SbkQTabletEvent_set_mTangential},
    {const_cast<char*>("mPointerType"), (getter)SbkQTabletEvent_get_mPointerType, (setter)SbkQTabletEvent_set_mPointerType},
    {const_cast<char*>("mHiResGlobalPos"), (getter)SbkQTabletEvent_get_mHiResGlobalPos, (setter)SbkQTabletEvent_set_mHiResGlobalPos},
    {const_cast<char*>("mPos"), (getter)SbkQTabletEvent_get_mPos, (setter)SbkQTabletEvent_set_mPos},
    {const_cast<char*>("mPress"), (getter)SbkQTabletEvent_get_mPress, (setter)SbkQTabletEvent_set_mPress},
    {const_cast<char*>("mDev"), (getter)SbkQTabletEvent_get_mDev, (setter)SbkQTabletEvent_set_mDev},
    {const_cast<char*>("mRot"), (getter)SbkQTabletEvent_get_mRot, (setter)SbkQTabletEvent_set_mRot},
    {const_cast<char*>("mZ"), (getter)SbkQTabletEvent_get_mZ, (setter)SbkQTabletEvent_set_mZ},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTabletEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTabletEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTabletEventWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTabletEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTabletEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTabletEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQTabletEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTabletEvent_Type);
     if ( reinterpret_cast<QTabletEvent*>(cptr)->type() == QEvent::TabletMove ||  reinterpret_cast<QTabletEvent*>(cptr)->type() == QEvent::TabletPress ||  reinterpret_cast<QTabletEvent*>(cptr)->type() == QEvent::TabletRelease)
        return &SbkQTabletEvent_Type;
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QTabletEvent_TabletDevice_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabletEvent_TabletDevice_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabletEvent_TabletDevice_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabletDevice",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabletEvent_TabletDevice_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabletEvent_TabletDevice_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTabletEvent_TabletDevice_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTabletEvent_PointerType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabletEvent_PointerType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabletEvent_PointerType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PointerType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabletEvent_PointerType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabletEvent_PointerType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTabletEvent_PointerType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTabletEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTabletEvent_Type);

    SbkQTabletEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQTabletEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQTabletEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTabletEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTabletEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTabletEvent_Type));
    PyModule_AddObject(module, "QTabletEvent",
        ((PyObject*)&SbkQTabletEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: TabletDevice
    SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX] = &SbkPySide_QtGui_QTabletEvent_TabletDevice_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type);
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
            "TabletDevice",((PyObject*)&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::NoDevice, "NoDevice");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "NoDevice", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "NoDevice", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::Puck, "Puck");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Puck", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "Puck", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::Stylus, "Stylus");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Stylus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "Stylus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::Airbrush, "Airbrush");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Airbrush", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "Airbrush", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::FourDMouse, "FourDMouse");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "FourDMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "FourDMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::XFreeEraser, "XFreeEraser");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "XFreeEraser", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "XFreeEraser", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_TabletDevice_Type,
        (long) QTabletEvent::RotationStylus, "RotationStylus");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "RotationStylus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_TabletDevice_Type.tp_dict,
        "RotationStylus", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabletEvent::TabletDevice");

    // init enum class: PointerType
    SbkPySide_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX] = &SbkPySide_QtGui_QTabletEvent_PointerType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabletEvent_PointerType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabletEvent_PointerType_Type);
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
            "PointerType",((PyObject*)&SbkPySide_QtGui_QTabletEvent_PointerType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_PointerType_Type,
        (long) QTabletEvent::UnknownPointer, "UnknownPointer");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "UnknownPointer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_PointerType_Type.tp_dict,
        "UnknownPointer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_PointerType_Type,
        (long) QTabletEvent::Pen, "Pen");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Pen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_PointerType_Type.tp_dict,
        "Pen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_PointerType_Type,
        (long) QTabletEvent::Cursor, "Cursor");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Cursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_PointerType_Type.tp_dict,
        "Cursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabletEvent_PointerType_Type,
        (long) QTabletEvent::Eraser, "Eraser");
    PyDict_SetItemString(SbkQTabletEvent_Type.super.ht_type.tp_dict,
        "Eraser", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabletEvent_PointerType_Type.tp_dict,
        "Eraser", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabletEvent::PointerType");

    Shiboken::TypeResolver::createObjectTypeResolver<QTabletEvent >("QTabletEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTabletEvent >(typeid(QTabletEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

