/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qsystemtrayicon_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmenu.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qstring.h>
#include <qsystemtrayicon.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSystemTrayIconWrapper::QSystemTrayIconWrapper(QObject * parent) : QSystemTrayIcon(parent), m_metaObject(0) {
    // ... middle
}

QSystemTrayIconWrapper::QSystemTrayIconWrapper(const QIcon & icon, QObject * parent) : QSystemTrayIcon(icon, parent), m_metaObject(0) {
    // ... middle
}

void QSystemTrayIconWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemTrayIconWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSystemTrayIconWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemTrayIconWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSystemTrayIconWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QSystemTrayIcon::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSystemTrayIcon.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSystemTrayIconWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSystemTrayIcon.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSystemTrayIconWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSystemTrayIconWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSystemTrayIcon::staticMetaObject);
}
    return m_metaObject;
}

int QSystemTrayIconWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSystemTrayIcon::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSystemTrayIconWrapper::~QSystemTrayIconWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSystemTrayIcon_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSystemTrayIconWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSystemTrayIcon", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSystemTrayIcon(QObject*)
        cptr = new QSystemTrayIconWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QIcon& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (numArgs == 1) {
            // QSystemTrayIcon(QIcon,QObject*)
            cptr = new QSystemTrayIconWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QSystemTrayIcon(QIcon,QObject*)
            cptr = new QSystemTrayIconWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQSystemTrayIcon_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSystemTrayIcon(QObject*)
        cptr = new QSystemTrayIconWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSystemTrayIcon_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSystemTrayIcon_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSystemTrayIcon_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtGui.QIcon, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSystemTrayIcon", overloads);
        return -1;
}

static PyObject*
SbkQSystemTrayIconFunc_contextMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contextMenu()const
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QSystemTrayIcon::contextMenu();
    py_result = Shiboken::Converter<QMenu* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSystemTrayIcon::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSystemTrayIconFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSystemTrayIconFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSystemTrayIcon.event", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QSystemTrayIcon::geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_hide(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // hide()
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    cppSelf->QSystemTrayIcon::hide();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSystemTrayIconFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QSystemTrayIcon::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_isSystemTrayAvailable(PyObject* self)
{
    PyObject* py_result = 0;

    // isSystemTrayAvailable()
    bool cpp_result = QSystemTrayIcon::isSystemTrayAvailable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_isVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isVisible()const
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSystemTrayIcon::isVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_setContextMenu(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMenu* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMenu* cpp_arg0 = Shiboken::Converter<QMenu* >::toCpp(arg);
        // setContextMenu(QMenu*)
        QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
        cppSelf->QSystemTrayIcon::setContextMenu(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQSystemTrayIconFunc_setContextMenu_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemTrayIconFunc_setContextMenu_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMenu", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSystemTrayIcon.setContextMenu", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
        cppSelf->QSystemTrayIcon::setIcon(*cpp_arg0);
    } else goto SbkQSystemTrayIconFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemTrayIconFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSystemTrayIcon.setIcon", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
        cppSelf->QSystemTrayIcon::setToolTip(*cpp_arg0);
    } else goto SbkQSystemTrayIconFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemTrayIconFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSystemTrayIcon.setToolTip", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
        cppSelf->QSystemTrayIcon::setVisible(cpp_arg0);
    } else goto SbkQSystemTrayIconFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemTrayIconFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSystemTrayIcon.setVisible", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_show(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // show()
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    cppSelf->QSystemTrayIcon::show();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSystemTrayIconFunc_showMessage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "showMessage", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // showMessage(QString,QString,QSystemTrayIcon::MessageIcon,int)
            QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
            cppSelf->QSystemTrayIcon::showMessage(*cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QSystemTrayIcon::MessageIcon >::isConvertible(pyargs[2])) {
            QSystemTrayIcon::MessageIcon cpp_arg2 = Shiboken::Converter<QSystemTrayIcon::MessageIcon >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // showMessage(QString,QString,QSystemTrayIcon::MessageIcon,int)
                QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
                cppSelf->QSystemTrayIcon::showMessage(*cpp_arg0, *cpp_arg1, cpp_arg2);
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // showMessage(QString,QString,QSystemTrayIcon::MessageIcon,int)
                QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
                cppSelf->QSystemTrayIcon::showMessage(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
            } else goto SbkQSystemTrayIconFunc_showMessage_TypeError;
        } else goto SbkQSystemTrayIconFunc_showMessage_TypeError;
    } else goto SbkQSystemTrayIconFunc_showMessage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemTrayIconFunc_showMessage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QSystemTrayIcon.MessageIcon = Information, int = 10000", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSystemTrayIcon.showMessage", overloads);
        return 0;
}

static PyObject*
SbkQSystemTrayIconFunc_supportsMessages(PyObject* self)
{
    PyObject* py_result = 0;

    // supportsMessages()
    bool cpp_result = QSystemTrayIcon::supportsMessages();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemTrayIconFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QSystemTrayIcon* cppSelf = Shiboken::Converter<QSystemTrayIcon* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSystemTrayIcon::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSystemTrayIcon_methods[] = {
    {"contextMenu", (PyCFunction)SbkQSystemTrayIconFunc_contextMenu, METH_NOARGS},
    {"event", (PyCFunction)SbkQSystemTrayIconFunc_event, METH_O},
    {"geometry", (PyCFunction)SbkQSystemTrayIconFunc_geometry, METH_NOARGS},
    {"hide", (PyCFunction)SbkQSystemTrayIconFunc_hide, METH_NOARGS},
    {"icon", (PyCFunction)SbkQSystemTrayIconFunc_icon, METH_NOARGS},
    {"isSystemTrayAvailable", (PyCFunction)SbkQSystemTrayIconFunc_isSystemTrayAvailable, METH_NOARGS|METH_STATIC},
    {"isVisible", (PyCFunction)SbkQSystemTrayIconFunc_isVisible, METH_NOARGS},
    {"setContextMenu", (PyCFunction)SbkQSystemTrayIconFunc_setContextMenu, METH_O},
    {"setIcon", (PyCFunction)SbkQSystemTrayIconFunc_setIcon, METH_O},
    {"setToolTip", (PyCFunction)SbkQSystemTrayIconFunc_setToolTip, METH_O},
    {"setVisible", (PyCFunction)SbkQSystemTrayIconFunc_setVisible, METH_O},
    {"show", (PyCFunction)SbkQSystemTrayIconFunc_show, METH_NOARGS},
    {"showMessage", (PyCFunction)SbkQSystemTrayIconFunc_showMessage, METH_VARARGS},
    {"supportsMessages", (PyCFunction)SbkQSystemTrayIconFunc_supportsMessages, METH_NOARGS|METH_STATIC},
    {"toolTip", (PyCFunction)SbkQSystemTrayIconFunc_toolTip, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSystemTrayIcon_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSystemTrayIcon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSystemTrayIconWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSystemTrayIcon_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSystemTrayIcon_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MessageIcon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ActivationReason",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSystemTrayIcon(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSystemTrayIcon_Type);

    SbkQSystemTrayIcon_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSystemTrayIcon_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSystemTrayIcon_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSystemTrayIcon_Type));
    PyModule_AddObject(module, "QSystemTrayIcon",
        ((PyObject*)&SbkQSystemTrayIcon_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MessageIcon
    SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_MESSAGEICON_IDX] = &SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type);
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
            "MessageIcon",((PyObject*)&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type,
        (long) QSystemTrayIcon::NoIcon, "NoIcon");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "NoIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type.tp_dict,
        "NoIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type,
        (long) QSystemTrayIcon::Information, "Information");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Information", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type.tp_dict,
        "Information", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type,
        (long) QSystemTrayIcon::Warning, "Warning");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Warning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type.tp_dict,
        "Warning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type,
        (long) QSystemTrayIcon::Critical, "Critical");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Critical", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_MessageIcon_Type.tp_dict,
        "Critical", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSystemTrayIcon::MessageIcon");

    // init enum class: ActivationReason
    SbkPySide_QtGuiTypes[SBK_QSYSTEMTRAYICON_ACTIVATIONREASON_IDX] = &SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type);
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
            "ActivationReason",((PyObject*)&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type,
        (long) QSystemTrayIcon::Unknown, "Unknown");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Unknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type.tp_dict,
        "Unknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type,
        (long) QSystemTrayIcon::Context, "Context");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Context", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type.tp_dict,
        "Context", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type,
        (long) QSystemTrayIcon::DoubleClick, "DoubleClick");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "DoubleClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type.tp_dict,
        "DoubleClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type,
        (long) QSystemTrayIcon::Trigger, "Trigger");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "Trigger", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type.tp_dict,
        "Trigger", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type,
        (long) QSystemTrayIcon::MiddleClick, "MiddleClick");
    PyDict_SetItemString(SbkQSystemTrayIcon_Type.super.ht_type.tp_dict,
        "MiddleClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSystemTrayIcon_ActivationReason_Type.tp_dict,
        "MiddleClick", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSystemTrayIcon::ActivationReason");

    Shiboken::TypeResolver::createObjectTypeResolver<QSystemTrayIcon >("QSystemTrayIcon*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSystemTrayIcon >(typeid(QSystemTrayIcon).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

