/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qsortfilterproxymodel_wrapper.h"

// Extra includes
#include <QItemSelection>
#include <QList>
#include <QMap>
#include <QSize>
#include <QStringList>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qitemselectionmodel.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qregexp.h>
#include <qsize.h>
#include <qsortfilterproxymodel.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSortFilterProxyModelWrapper::QSortFilterProxyModelWrapper(QObject * parent) : QSortFilterProxyModel(parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QSortFilterProxyModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.buddy");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.canFetchMore");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QSortFilterProxyModelWrapper::columnCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "columnCount"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::columnCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.columnCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSortFilterProxyModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QSortFilterProxyModelWrapper::data(const QModelIndex & index, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::data(index, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSortFilterProxyModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiiO)",
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSortFilterProxyModelWrapper::filterAcceptsColumn(int source_column, const QModelIndex & source_parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "filterAcceptsColumn"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::filterAcceptsColumn(source_column, source_parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        source_column,
        Shiboken::Converter<QModelIndex& >::toPython(source_parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.filterAcceptsColumn");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::filterAcceptsRow(int source_row, const QModelIndex & source_parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "filterAcceptsRow"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::filterAcceptsRow(source_row, source_parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        source_row,
        Shiboken::Converter<QModelIndex& >::toPython(source_parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.filterAcceptsRow");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::ItemFlag> QSortFilterProxyModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.flags");
        return QFlags<Qt::ItemFlag>()        ;
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::hasChildren(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasChildren"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::hasChildren(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.hasChildren");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QSortFilterProxyModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.headerData");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QSortFilterProxyModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::index(row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.index");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.insertColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.insertRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QSortFilterProxyModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.itemData");
        return QMap<int, QVariant >()        ;
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::lessThan(const QModelIndex & left, const QModelIndex & right) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lessThan"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::lessThan(left, right);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(left),
        Shiboken::Converter<QModelIndex& >::toPython(right)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.lessThan");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QSortFilterProxyModelWrapper::mapFromSource(const QModelIndex & sourceIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapFromSource"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mapFromSource(sourceIndex);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(sourceIndex)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mapFromSource");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

QItemSelection QSortFilterProxyModelWrapper::mapSelectionFromSource(const QItemSelection & sourceSelection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapSelectionFromSource"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mapSelectionFromSource(sourceSelection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(sourceSelection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QItemSelection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QItemSelection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mapSelectionFromSource");
        return QItemSelection()        ;
    }
    QItemSelection cpp_result(Shiboken::Converter<QItemSelection >::toCpp(py_result));
    return cpp_result;
}

QItemSelection QSortFilterProxyModelWrapper::mapSelectionToSource(const QItemSelection & proxySelection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapSelectionToSource"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mapSelectionToSource(proxySelection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(proxySelection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QItemSelection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QItemSelection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mapSelectionToSource");
        return QItemSelection()        ;
    }
    QItemSelection cpp_result(Shiboken::Converter<QItemSelection >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QSortFilterProxyModelWrapper::mapToSource(const QModelIndex & proxyIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapToSource"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mapToSource(proxyIndex);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(proxyIndex)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mapToSource");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QSortFilterProxyModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiOiO)",
        Shiboken::Converter<QModelIndex& >::toPython(start),
        role,
        Shiboken::Converter<QVariant& >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.match");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QSortFilterProxyModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mimeData");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QStringList QSortFilterProxyModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QSortFilterProxyModelWrapper::parent(const QModelIndex & child) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parent"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::parent(child);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(child)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.parent");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.removeColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.removeRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QSortFilterProxyModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::rowCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.rowCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.setData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.setHeaderData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.setItemData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::setSourceModel(QAbstractItemModel * sourceModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSourceModel"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::setSourceModel(sourceModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractItemModel* >::toPython(sourceModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSortFilterProxyModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QSortFilterProxyModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.span");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QSortFilterProxyModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.submit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QSortFilterProxyModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QSortFilterProxyModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSortFilterProxyModel.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QSortFilterProxyModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSortFilterProxyModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSortFilterProxyModel::staticMetaObject);
}
    return m_metaObject;
}

int QSortFilterProxyModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSortFilterProxyModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSortFilterProxyModelWrapper::~QSortFilterProxyModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSortFilterProxyModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSortFilterProxyModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSortFilterProxyModel", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSortFilterProxyModel(QObject*)
        cptr = new QSortFilterProxyModelWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSortFilterProxyModel(QObject*)
        cptr = new QSortFilterProxyModelWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSortFilterProxyModel_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSortFilterProxyModel_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSortFilterProxyModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel", overloads);
        return -1;
}

static PyObject*
SbkQSortFilterProxyModelFunc_buddy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // buddy(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::buddy(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_buddy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_buddy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.buddy", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_canFetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // canFetchMore(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::canFetchMore(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_canFetchMore_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_canFetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.canFetchMore", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_columnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // columnCount(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSortFilterProxyModel::columnCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // columnCount(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSortFilterProxyModel::columnCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_columnCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_columnCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.columnCount", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // data(QModelIndex,int)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSortFilterProxyModel::data(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // data(QModelIndex,int)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSortFilterProxyModel::data(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_data_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.data", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QMimeData* >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[0]);
        Qt::DropAction cpp_arg1 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QModelIndex* cpp_arg4 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[4]);
        // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_dropMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction, int, int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.dropMimeData", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_dynamicSortFilter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dynamicSortFilter()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSortFilterProxyModel::dynamicSortFilter();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_fetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // fetchMore(QModelIndex)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::fetchMore(*cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_fetchMore_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_fetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.fetchMore", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterAcceptsColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "filterAcceptsColumn", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // filterAcceptsColumn(int,QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::filterAcceptsColumn(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_filterAcceptsColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_filterAcceptsColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.filterAcceptsColumn", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterAcceptsRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "filterAcceptsRow", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // filterAcceptsRow(int,QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::filterAcceptsRow(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_filterAcceptsRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_filterAcceptsRow_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.filterAcceptsRow", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterCaseSensitivity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filterCaseSensitivity()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    Qt::CaseSensitivity cpp_result = cppSelf->QSortFilterProxyModel::filterCaseSensitivity();
    py_result = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterKeyColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filterKeyColumn()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSortFilterProxyModel::filterKeyColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterRegExp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filterRegExp()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    QRegExp cpp_result = cppSelf->QSortFilterProxyModel::filterRegExp();
    py_result = Shiboken::Converter<QRegExp >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_filterRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filterRole()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSortFilterProxyModel::filterRole();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_flags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // flags(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QFlags<Qt::ItemFlag> cpp_result = cppSelf->QSortFilterProxyModel::flags(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_flags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_flags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.flags", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_hasChildren(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // hasChildren(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::hasChildren();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // hasChildren(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::hasChildren(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_hasChildren_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_hasChildren_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.hasChildren", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_headerData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // headerData(int,Qt::Orientation,int)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSortFilterProxyModel::headerData(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // headerData(int,Qt::Orientation,int)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSortFilterProxyModel::headerData(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_headerData_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_headerData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_headerData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.headerData", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_index(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "index", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // index(int,int,QModelIndex)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::index(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // index(int,int,QModelIndex)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::index(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_index_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_index_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_index_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.index", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertColumns(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::insertColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertColumns(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::insertColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_insertColumns_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_insertColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.insertColumns", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertRows(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::insertRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertRows(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::insertRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_insertRows_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_insertRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_insertRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.insertRows", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    cppSelf->QSortFilterProxyModel::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSortFilterProxyModelFunc_invalidateFilter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidateFilter()
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    cppSelf->QSortFilterProxyModel::invalidateFilter();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSortFilterProxyModelFunc_isSortLocaleAware(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSortLocaleAware()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSortFilterProxyModel::isSortLocaleAware();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_lessThan(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lessThan", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // lessThan(QModelIndex,QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSortFilterProxyModel::lessThan(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_lessThan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_lessThan_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.lessThan", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mapFromSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // mapFromSource(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::mapFromSource(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_mapFromSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_mapFromSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.mapFromSource", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mapSelectionFromSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // mapSelectionFromSource(QItemSelection)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QItemSelection cpp_result = cppSelf->QSortFilterProxyModel::mapSelectionFromSource(*cpp_arg0);
        py_result = Shiboken::Converter<QItemSelection >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_mapSelectionFromSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_mapSelectionFromSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.mapSelectionFromSource", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mapSelectionToSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // mapSelectionToSource(QItemSelection)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QItemSelection cpp_result = cppSelf->QSortFilterProxyModel::mapSelectionToSource(*cpp_arg0);
        py_result = Shiboken::Converter<QItemSelection >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_mapSelectionToSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_mapSelectionToSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.mapSelectionToSource", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mapToSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // mapToSource(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::mapToSource(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_mapToSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_mapToSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.mapToSource", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_match(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "match", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            QList<QModelIndex > cpp_result = cppSelf->QSortFilterProxyModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
                QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
                QList<QModelIndex > cpp_result = cppSelf->QSortFilterProxyModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[4])) {
                QFlags<Qt::MatchFlag> cpp_arg4 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[4]);
                // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
                QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
                QList<QModelIndex > cpp_result = cppSelf->QSortFilterProxyModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
            } else goto SbkQSortFilterProxyModelFunc_match_TypeError;
        } else goto SbkQSortFilterProxyModelFunc_match_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_match_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_match_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, PySide.QtCore.QVariant, int = 1, PySide.QtCore.Qt.MatchFlags = Qt.MatchFlags(Qt.MatchStartsWith|Qt.MatchWrap)", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.match", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QList<QModelIndex >  >::isConvertible(arg)) {
        QList<QModelIndex >  cpp_arg0 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(arg);
        // mimeData(QList<QModelIndex>)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QMimeData * cpp_result = cppSelf->QSortFilterProxyModel::mimeData(cpp_arg0);
        py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQSortFilterProxyModelFunc_mimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_mimeData_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.mimeData", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSortFilterProxyModel::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_parent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // parent(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QSortFilterProxyModel::parent(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_parent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_parent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.parent", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeColumns(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::removeColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeColumns(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::removeColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_removeColumns_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_removeColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.removeColumns", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeRows(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::removeRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeRows(int,int,QModelIndex)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::removeRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_removeRows_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_removeRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.removeRows", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_rowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // rowCount(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSortFilterProxyModel::rowCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowCount(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSortFilterProxyModel::rowCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_rowCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_rowCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.rowCount", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setData(QModelIndex,QVariant,int)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::setData(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setData(QModelIndex,QVariant,int)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::setData(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_setData_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_setData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.setData", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setDynamicSortFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDynamicSortFilter(bool)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setDynamicSortFilter(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setDynamicSortFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setDynamicSortFilter_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setDynamicSortFilter", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterCaseSensitivity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);
        // setFilterCaseSensitivity(Qt::CaseSensitivity)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterCaseSensitivity(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterCaseSensitivity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterCaseSensitivity", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterFixedString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFilterFixedString(QString)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterFixedString(*cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterFixedString_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterFixedString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterFixedString", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterKeyColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFilterKeyColumn(int)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterKeyColumn(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterKeyColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterKeyColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterKeyColumn", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterRegExp(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFilterRegExp(QString)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterRegExp(*cpp_arg0);
    } else if (Shiboken::Converter<QRegExp& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(arg);
        // setFilterRegExp(QRegExp)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterRegExp(*cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterRegExp_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterRegExp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterRegExp", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFilterRole(int)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterRole(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterRole_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterRole", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setFilterWildcard(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFilterWildcard(QString)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setFilterWildcard(*cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setFilterWildcard_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setFilterWildcard_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setFilterWildcard", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setHeaderData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHeaderData", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSortFilterProxyModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSortFilterProxyModelFunc_setHeaderData_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_setHeaderData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_setHeaderData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.setHeaderData", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setSortCaseSensitivity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);
        // setSortCaseSensitivity(Qt::CaseSensitivity)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setSortCaseSensitivity(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setSortCaseSensitivity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setSortCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setSortCaseSensitivity", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setSortLocaleAware(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSortLocaleAware(bool)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setSortLocaleAware(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setSortLocaleAware_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setSortLocaleAware_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setSortLocaleAware", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setSortRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSortRole(int)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setSortRole(cpp_arg0);
    } else goto SbkQSortFilterProxyModelFunc_setSortRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setSortRole_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setSortRole", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_setSourceModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setSourceModel(QAbstractItemModel*)
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QSortFilterProxyModel::setSourceModel(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQSortFilterProxyModelFunc_setSourceModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_setSourceModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.setSourceModel", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_sort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sort(int,Qt::SortOrder)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            cppSelf->QSortFilterProxyModel::sort(cpp_arg0);
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sort(int,Qt::SortOrder)
            QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
            cppSelf->QSortFilterProxyModel::sort(cpp_arg0, cpp_arg1);
        } else goto SbkQSortFilterProxyModelFunc_sort_TypeError;
    } else goto SbkQSortFilterProxyModelFunc_sort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSortFilterProxyModelFunc_sort_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSortFilterProxyModel.sort", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_sortCaseSensitivity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortCaseSensitivity()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    Qt::CaseSensitivity cpp_result = cppSelf->QSortFilterProxyModel::sortCaseSensitivity();
    py_result = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_sortColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortColumn()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSortFilterProxyModel::sortColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_sortOrder(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortOrder()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    Qt::SortOrder cpp_result = cppSelf->QSortFilterProxyModel::sortOrder();
    py_result = Shiboken::Converter<Qt::SortOrder >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_sortRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortRole()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSortFilterProxyModel::sortRole();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSortFilterProxyModelFunc_span(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // span(QModelIndex)const
        QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QSortFilterProxyModel::span(*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQSortFilterProxyModelFunc_span_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSortFilterProxyModelFunc_span_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSortFilterProxyModel.span", overloads);
        return 0;
}

static PyObject*
SbkQSortFilterProxyModelFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QSortFilterProxyModel* cppSelf = Shiboken::Converter<QSortFilterProxyModel* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QSortFilterProxyModel::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSortFilterProxyModel_methods[] = {
    {"buddy", (PyCFunction)SbkQSortFilterProxyModelFunc_buddy, METH_O},
    {"canFetchMore", (PyCFunction)SbkQSortFilterProxyModelFunc_canFetchMore, METH_O},
    {"columnCount", (PyCFunction)SbkQSortFilterProxyModelFunc_columnCount, METH_NOARGS|METH_O},
    {"data", (PyCFunction)SbkQSortFilterProxyModelFunc_data, METH_VARARGS},
    {"dropMimeData", (PyCFunction)SbkQSortFilterProxyModelFunc_dropMimeData, METH_VARARGS},
    {"dynamicSortFilter", (PyCFunction)SbkQSortFilterProxyModelFunc_dynamicSortFilter, METH_NOARGS},
    {"fetchMore", (PyCFunction)SbkQSortFilterProxyModelFunc_fetchMore, METH_O},
    {"filterAcceptsColumn", (PyCFunction)SbkQSortFilterProxyModelFunc_filterAcceptsColumn, METH_VARARGS},
    {"filterAcceptsRow", (PyCFunction)SbkQSortFilterProxyModelFunc_filterAcceptsRow, METH_VARARGS},
    {"filterCaseSensitivity", (PyCFunction)SbkQSortFilterProxyModelFunc_filterCaseSensitivity, METH_NOARGS},
    {"filterKeyColumn", (PyCFunction)SbkQSortFilterProxyModelFunc_filterKeyColumn, METH_NOARGS},
    {"filterRegExp", (PyCFunction)SbkQSortFilterProxyModelFunc_filterRegExp, METH_NOARGS},
    {"filterRole", (PyCFunction)SbkQSortFilterProxyModelFunc_filterRole, METH_NOARGS},
    {"flags", (PyCFunction)SbkQSortFilterProxyModelFunc_flags, METH_O},
    {"hasChildren", (PyCFunction)SbkQSortFilterProxyModelFunc_hasChildren, METH_NOARGS|METH_O},
    {"headerData", (PyCFunction)SbkQSortFilterProxyModelFunc_headerData, METH_VARARGS},
    {"index", (PyCFunction)SbkQSortFilterProxyModelFunc_index, METH_VARARGS},
    {"insertColumns", (PyCFunction)SbkQSortFilterProxyModelFunc_insertColumns, METH_VARARGS},
    {"insertRows", (PyCFunction)SbkQSortFilterProxyModelFunc_insertRows, METH_VARARGS},
    {"invalidate", (PyCFunction)SbkQSortFilterProxyModelFunc_invalidate, METH_NOARGS},
    {"invalidateFilter", (PyCFunction)SbkQSortFilterProxyModelFunc_invalidateFilter, METH_NOARGS},
    {"isSortLocaleAware", (PyCFunction)SbkQSortFilterProxyModelFunc_isSortLocaleAware, METH_NOARGS},
    {"lessThan", (PyCFunction)SbkQSortFilterProxyModelFunc_lessThan, METH_VARARGS},
    {"mapFromSource", (PyCFunction)SbkQSortFilterProxyModelFunc_mapFromSource, METH_O},
    {"mapSelectionFromSource", (PyCFunction)SbkQSortFilterProxyModelFunc_mapSelectionFromSource, METH_O},
    {"mapSelectionToSource", (PyCFunction)SbkQSortFilterProxyModelFunc_mapSelectionToSource, METH_O},
    {"mapToSource", (PyCFunction)SbkQSortFilterProxyModelFunc_mapToSource, METH_O},
    {"match", (PyCFunction)SbkQSortFilterProxyModelFunc_match, METH_VARARGS},
    {"mimeData", (PyCFunction)SbkQSortFilterProxyModelFunc_mimeData, METH_O},
    {"mimeTypes", (PyCFunction)SbkQSortFilterProxyModelFunc_mimeTypes, METH_NOARGS},
    {"parent", (PyCFunction)SbkQSortFilterProxyModelFunc_parent, METH_O},
    {"removeColumns", (PyCFunction)SbkQSortFilterProxyModelFunc_removeColumns, METH_VARARGS},
    {"removeRows", (PyCFunction)SbkQSortFilterProxyModelFunc_removeRows, METH_VARARGS},
    {"rowCount", (PyCFunction)SbkQSortFilterProxyModelFunc_rowCount, METH_NOARGS|METH_O},
    {"setData", (PyCFunction)SbkQSortFilterProxyModelFunc_setData, METH_VARARGS},
    {"setDynamicSortFilter", (PyCFunction)SbkQSortFilterProxyModelFunc_setDynamicSortFilter, METH_O},
    {"setFilterCaseSensitivity", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterCaseSensitivity, METH_O},
    {"setFilterFixedString", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterFixedString, METH_O},
    {"setFilterKeyColumn", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterKeyColumn, METH_O},
    {"setFilterRegExp", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterRegExp, METH_O},
    {"setFilterRole", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterRole, METH_O},
    {"setFilterWildcard", (PyCFunction)SbkQSortFilterProxyModelFunc_setFilterWildcard, METH_O},
    {"setHeaderData", (PyCFunction)SbkQSortFilterProxyModelFunc_setHeaderData, METH_VARARGS},
    {"setSortCaseSensitivity", (PyCFunction)SbkQSortFilterProxyModelFunc_setSortCaseSensitivity, METH_O},
    {"setSortLocaleAware", (PyCFunction)SbkQSortFilterProxyModelFunc_setSortLocaleAware, METH_O},
    {"setSortRole", (PyCFunction)SbkQSortFilterProxyModelFunc_setSortRole, METH_O},
    {"setSourceModel", (PyCFunction)SbkQSortFilterProxyModelFunc_setSourceModel, METH_O},
    {"sort", (PyCFunction)SbkQSortFilterProxyModelFunc_sort, METH_VARARGS},
    {"sortCaseSensitivity", (PyCFunction)SbkQSortFilterProxyModelFunc_sortCaseSensitivity, METH_NOARGS},
    {"sortColumn", (PyCFunction)SbkQSortFilterProxyModelFunc_sortColumn, METH_NOARGS},
    {"sortOrder", (PyCFunction)SbkQSortFilterProxyModelFunc_sortOrder, METH_NOARGS},
    {"sortRole", (PyCFunction)SbkQSortFilterProxyModelFunc_sortRole, METH_NOARGS},
    {"span", (PyCFunction)SbkQSortFilterProxyModelFunc_span, METH_O},
    {"supportedDropActions", (PyCFunction)SbkQSortFilterProxyModelFunc_supportedDropActions, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSortFilterProxyModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSortFilterProxyModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSortFilterProxyModelWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSortFilterProxyModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSortFilterProxyModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSortFilterProxyModel(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSORTFILTERPROXYMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSortFilterProxyModel_Type);

    SbkQSortFilterProxyModel_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTPROXYMODEL_IDX];
    // Fill type discovery information
    SbkQSortFilterProxyModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSortFilterProxyModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSortFilterProxyModel_Type));
    PyModule_AddObject(module, "QSortFilterProxyModel",
        ((PyObject*)&SbkQSortFilterProxyModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSortFilterProxyModel >("QSortFilterProxyModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSortFilterProxyModel >(typeid(QSortFilterProxyModel).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

