/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qshortcutevent_wrapper.h"

// Extra includes
#include <qkeysequence.h>

using namespace Shiboken;

static int
SbkQShortcutEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QShortcutEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QShortcutEvent", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (Shiboken::Converter<QKeySequence& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QKeySequence& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QShortcutEvent(QKeySequence,int,bool)
            cptr = new QShortcutEvent(*cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
            // QShortcutEvent(QKeySequence,int,bool)
            cptr = new QShortcutEvent(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQShortcutEvent_Init_TypeError;
    } else goto SbkQShortcutEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQShortcutEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQShortcutEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence, int, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QShortcutEvent", overloads);
        return -1;
}

static PyObject*
SbkQShortcutEventFunc_isAmbiguous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAmbiguous()const
    QShortcutEvent* cppSelf = Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QShortcutEvent::isAmbiguous();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQShortcutEventFunc_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QShortcutEvent* cppSelf = Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self);
    const QKeySequence & cpp_result = cppSelf->QShortcutEvent::key();
    py_result = Shiboken::Converter<QKeySequence& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQShortcutEventFunc_shortcutId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shortcutId()const
    QShortcutEvent* cppSelf = Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QShortcutEvent::shortcutId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQShortcutEvent_methods[] = {
    {"isAmbiguous", (PyCFunction)SbkQShortcutEventFunc_isAmbiguous, METH_NOARGS},
    {"key", (PyCFunction)SbkQShortcutEventFunc_key, METH_NOARGS},
    {"shortcutId", (PyCFunction)SbkQShortcutEventFunc_shortcutId, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQShortcutEvent_get_sequence(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QKeySequence >::toPython(Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->sequence);
}
static int SbkQShortcutEvent_set_sequence(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'sequence' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QKeySequence >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sequence', 'QKeySequence' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->sequence = Shiboken::Converter<QKeySequence >::toCpp(value);

    return 0;
}

static PyObject* SbkQShortcutEvent_get_sid(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->sid);
}
static int SbkQShortcutEvent_set_sid(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'sid' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sid', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->sid = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQShortcutEvent_get_ambig(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->ambig);
}
static int SbkQShortcutEvent_set_ambig(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'ambig' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'ambig', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QShortcutEvent* >::toCpp((PyObject*)self)->ambig = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

// Getters and Setters for QShortcutEvent
static PyGetSetDef SbkQShortcutEvent_getsetlist[] = {
    {const_cast<char*>("sequence"), (getter)SbkQShortcutEvent_get_sequence, (setter)SbkQShortcutEvent_set_sequence},
    {const_cast<char*>("sid"), (getter)SbkQShortcutEvent_get_sid, (setter)SbkQShortcutEvent_set_sid},
    {const_cast<char*>("ambig"), (getter)SbkQShortcutEvent_get_ambig, (setter)SbkQShortcutEvent_set_ambig},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQShortcutEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QShortcutEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QShortcutEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQShortcutEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQShortcutEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQShortcutEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QShortcutEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSHORTCUTEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQShortcutEvent_Type);

    SbkQShortcutEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQShortcutEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQShortcutEvent_Type));
    PyModule_AddObject(module, "QShortcutEvent",
        ((PyObject*)&SbkQShortcutEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QShortcutEvent >("QShortcutEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QShortcutEvent >(typeid(QShortcutEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

