/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qregion_wrapper.h"

// Extra includes
#include <QVector>
#include <qbitmap.h>
#include <qdatastream.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQRegion_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRegion* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQRegion_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QRegion", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QRegion()
        cptr = new QRegion();
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // QRegion(int,int,int,int,QRegion::RegionType)
            cptr = new QRegion(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else if (Shiboken::Converter<QRegion::RegionType >::isConvertible(pyargs[4])) {
            QRegion::RegionType cpp_arg4 = Shiboken::Converter<QRegion::RegionType >::toCpp(pyargs[4]);
            // QRegion(int,int,int,int,QRegion::RegionType)
            cptr = new QRegion(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else goto SbkQRegion_Init_TypeError;
    } else if (Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QRegion(QRect,QRegion::RegionType)
            cptr = new QRegion(*cpp_arg0);
        } else if (Shiboken::Converter<QRegion::RegionType >::isConvertible(pyargs[1])) {
            QRegion::RegionType cpp_arg1 = Shiboken::Converter<QRegion::RegionType >::toCpp(pyargs[1]);
            // QRegion(QRect,QRegion::RegionType)
            cptr = new QRegion(*cpp_arg0, cpp_arg1);
        } else goto SbkQRegion_Init_TypeError;
    } else if (Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        if (numArgs == 1) {
            // QRegion(QPolygon,Qt::FillRule)
            cptr = new QRegion(*cpp_arg0);
        } else if (Shiboken::Converter<Qt::FillRule >::isConvertible(pyargs[1])) {
            Qt::FillRule cpp_arg1 = Shiboken::Converter<Qt::FillRule >::toCpp(pyargs[1]);
            // QRegion(QPolygon,Qt::FillRule)
            cptr = new QRegion(*cpp_arg0, cpp_arg1);
        } else goto SbkQRegion_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QBitmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QBitmap > cpp_arg0_auto_ptr;
        QBitmap* cpp_arg0 = Shiboken::Converter<QBitmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QBitmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QBitmap >(cpp_arg0);
        // QRegion(QBitmap)
        cptr = new QRegion(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QRegion& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRegion& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // QRegion(QRegion)
        cptr = new QRegion(*cpp_arg0);
    } else goto SbkQRegion_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRegion_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQRegion_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QBitmap", "PySide.QtGui.QPolygon, PySide.QtCore.Qt.FillRule = Qt.OddEvenFill", "PySide.QtCore.QRect, PySide.QtGui.QRegion.RegionType = Rectangle", "PySide.QtGui.QRegion", "int, int, int, int, PySide.QtGui.QRegion.RegionType = Rectangle", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegion", overloads);
        return -1;
}

static PyObject*
SbkQRegionFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QRegion::boundingRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRegionFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // contains(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRegion::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // contains(QPoint)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRegion::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQRegionFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.contains", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_intersect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersect(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::intersect(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_intersect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_intersect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.intersect", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersected(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // intersected(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.intersected", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_intersects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersects(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRegion::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // intersects(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRegion::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQRegionFunc_intersects_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_intersects_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.intersects", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRegion::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRegionFunc_numRects(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numRects()const
    QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRegion::numRects();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRegionFunc_rectCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rectCount()const
    QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRegion::rectCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRegionFunc_rects(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rects()const
    QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
    QVector<QRect > cpp_result = cppSelf->QRegion::rects();
    py_result = Shiboken::Converter<QVector<QRect > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRegionFunc_setRects(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRects", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QRect* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setRects(const QRect*,int)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        cppSelf->QRegion::setRects(cpp_arg0, cpp_arg1);
    } else goto SbkQRegionFunc_setRects_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegionFunc_setRects_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegion.setRects", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_subtracted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // subtracted(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::subtracted(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_subtracted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_subtracted_TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.subtracted", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translate(int,int)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        cppSelf->QRegion::translate(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // translate(QPoint)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        cppSelf->QRegion::translate(*cpp_arg0);
    } else goto SbkQRegionFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegionFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegion.translate", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translated(int,int)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // translated(QPoint)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegion.translated", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_unite(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // unite(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::unite(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_unite_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_unite_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.unite", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // united(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::united(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // united(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::united(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.united", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc_xored(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // xored(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QRegion::xored(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc_xored_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc_xored_TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.xored", overloads);
        return 0;
}

static PyMethodDef SbkQRegion_methods[] = {
    {"boundingRect", (PyCFunction)SbkQRegionFunc_boundingRect, METH_NOARGS},
    {"contains", (PyCFunction)SbkQRegionFunc_contains, METH_O},
    {"intersect", (PyCFunction)SbkQRegionFunc_intersect, METH_O},
    {"intersected", (PyCFunction)SbkQRegionFunc_intersected, METH_O},
    {"intersects", (PyCFunction)SbkQRegionFunc_intersects, METH_O},
    {"isEmpty", (PyCFunction)SbkQRegionFunc_isEmpty, METH_NOARGS},
    {"numRects", (PyCFunction)SbkQRegionFunc_numRects, METH_NOARGS},
    {"rectCount", (PyCFunction)SbkQRegionFunc_rectCount, METH_NOARGS},
    {"rects", (PyCFunction)SbkQRegionFunc_rects, METH_NOARGS},
    {"setRects", (PyCFunction)SbkQRegionFunc_setRects, METH_VARARGS},
    {"subtracted", (PyCFunction)SbkQRegionFunc_subtracted, METH_O},
    {"translate", (PyCFunction)SbkQRegionFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQRegionFunc_translated, METH_VARARGS},
    {"unite", (PyCFunction)SbkQRegionFunc_unite, METH_O},
    {"united", (PyCFunction)SbkQRegionFunc_united, METH_O},
    {"xored", (PyCFunction)SbkQRegionFunc_xored, METH_O},
    {0} // Sentinel
};

static PyObject*
SbkQRegionFunc___and__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator&(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator&(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___and___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___and___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__and__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*(QRegion,QTransform)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // operator*(QRegion,QMatrix)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QRegion cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator+(QRect)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator+(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__add__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator+=(QRegion)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQRegionFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQRegionFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator-(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator-=(QRegion)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQRegionFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQRegionFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QRegion) [reverse operator]
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQRegionFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QRegion&) [reverse operator]
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQRegionFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__rshift__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___xor__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator^(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) ^ (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___xor___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___xor___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__xor__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___ixor__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator^=(QRegion)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        (*cppSelf) ^= (*cpp_arg0);
    } else goto SbkQRegionFunc___ixor___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQRegionFunc___ixor___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__ixor__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___or__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator|(QRegion)const
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        const QRegion cpp_result = (*cppSelf) | (*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQRegionFunc___or___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQRegionFunc___or___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__or__", overloads);
        return 0;
}

static PyObject*
SbkQRegionFunc___ior__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQRegion_Check(arg) && !SbkQRegion_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // operator|=(QRegion)
        QRegion* cppSelf = Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);
        (*cppSelf) |= (*cpp_arg0);
    } else goto SbkQRegionFunc___ior___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQRegionFunc___ior___TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegion.__ior__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQRegion_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQRegionFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQRegionFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQRegionFunc___mul__,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQRegionFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQRegionFunc___rshift__,
    /*nb_and*/                  (binaryfunc)SbkQRegionFunc___and__,
    /*nb_xor*/                  (binaryfunc)SbkQRegionFunc___xor__,
    /*nb_or*/                   (binaryfunc)SbkQRegionFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQRegionFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQRegionFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)SbkQRegionFunc___ixor__,
    /*nb_inplace_or*/           (binaryfunc)SbkQRegionFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQRegion_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QRegion& cpp_self = *Shiboken::Converter<QRegion* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QRegion& >::isConvertible(other)) {
                QRegion* cpp_other = Shiboken::Converter<QRegion* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QRegion >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QRegion > cpp_other_auto_ptr;
                QRegion* cpp_other = Shiboken::Converter<QRegion* >::toCpp(other);
                if (!Shiboken::Converter<QRegion >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QRegion >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQRegion_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QRegion& >::isConvertible(other)) {
                QRegion* cpp_other = Shiboken::Converter<QRegion* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QRegion >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QRegion > cpp_other_auto_ptr;
                QRegion* cpp_other = Shiboken::Converter<QRegion* >::toCpp(other);
                if (!Shiboken::Converter<QRegion >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QRegion >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQRegion_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQRegion_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRegion_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QRegion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QRegion >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQRegion_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQRegion_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRegion_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRegion_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QRegion_RegionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QRegion_RegionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QRegion_RegionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RegionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QRegion_RegionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QRegion_RegionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QRegion_RegionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QRegion(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QREGION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRegion_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQRegion_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRegion_Type));
    PyModule_AddObject(module, "QRegion",
        ((PyObject*)&SbkQRegion_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RegionType
    SbkPySide_QtGuiTypes[SBK_QREGION_REGIONTYPE_IDX] = &SbkPySide_QtGui_QRegion_RegionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QRegion_RegionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QRegion_RegionType_Type);
    PyDict_SetItemString(SbkQRegion_Type.super.ht_type.tp_dict,
            "RegionType",((PyObject*)&SbkPySide_QtGui_QRegion_RegionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QRegion_RegionType_Type,
        (long) QRegion::Rectangle, "Rectangle");
    PyDict_SetItemString(SbkQRegion_Type.super.ht_type.tp_dict,
        "Rectangle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QRegion_RegionType_Type.tp_dict,
        "Rectangle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QRegion_RegionType_Type,
        (long) QRegion::Ellipse, "Ellipse");
    PyDict_SetItemString(SbkQRegion_Type.super.ht_type.tp_dict,
        "Ellipse", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QRegion_RegionType_Type.tp_dict,
        "Ellipse", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QRegion::RegionType");

    Shiboken::TypeResolver::createValueTypeResolver<QRegion >("QRegion");
    Shiboken::TypeResolver::createValueTypeResolver<QRegion >(typeid(QRegion).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

