/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qplaintextdocumentlayout_wrapper.h"

// Extra includes
#include <QAbstractTextDocumentLayout>
#include <QList>
#include <qabstracttextdocumentlayout.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextlayout.h>
#include <qtextobject.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPlainTextDocumentLayoutWrapper::QPlainTextDocumentLayoutWrapper(QTextDocument * document) : QPlainTextDocumentLayout(document), m_metaObject(0) {
    // ... middle
}

QRectF QPlainTextDocumentLayoutWrapper::blockBoundingRect(const QTextBlock & block) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "blockBoundingRect"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::blockBoundingRect(block);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTextBlock& >::toPython(block)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.blockBoundingRect");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextDocumentLayoutWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPlainTextDocumentLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextDocumentLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPlainTextDocumentLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextDocumentLayoutWrapper::documentChanged(int from, int arg__2, int charsAdded)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "documentChanged"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::documentChanged(from, arg__2, charsAdded);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iii)",
        from,
        arg__2,
        charsAdded
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QPlainTextDocumentLayoutWrapper::documentSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "documentSize"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::documentSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.documentSize");
        return QSizeF()        ;
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextDocumentLayoutWrapper::draw(QPainter * arg__1, const QAbstractTextDocumentLayout::PaintContext & arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "draw"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::draw(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(arg__1),
        Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext& >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextDocumentLayoutWrapper::drawInlineObject(QPainter * painter, const QRectF & rect, QTextInlineObject object, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect),
        Shiboken::Converter<QTextInlineObject >::toPython(object),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QPlainTextDocumentLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QPlainTextDocumentLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QRectF QPlainTextDocumentLayoutWrapper::frameBoundingRect(QTextFrame * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "frameBoundingRect"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::frameBoundingRect(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTextFrame* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.frameBoundingRect");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

int QPlainTextDocumentLayoutWrapper::hitTest(const QPointF & arg__1, Qt::HitTestAccuracy arg__2) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTest"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::hitTest(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPointF& >::toPython(arg__1),
        Shiboken::Converter<Qt::HitTestAccuracy >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.hitTest");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QPlainTextDocumentLayoutWrapper::pageCount() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pageCount"));
    if (py_override.isNull()) {
        return this->QPlainTextDocumentLayout::pageCount();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextDocumentLayout.pageCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextDocumentLayoutWrapper::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "positionInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QTextInlineObject >::toPython(item),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextDocumentLayoutWrapper::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QTextInlineObject >::toPython(item),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextDocumentLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QPlainTextDocumentLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QPlainTextDocumentLayout::staticMetaObject);
}
    return m_metaObject;
}

int QPlainTextDocumentLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QPlainTextDocumentLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QPlainTextDocumentLayoutWrapper::~QPlainTextDocumentLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQPlainTextDocumentLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPlainTextDocumentLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPlainTextDocumentLayout", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QPlainTextDocumentLayout(QTextDocument*)
        cptr = new QPlainTextDocumentLayoutWrapper(cpp_arg0);
    } else goto SbkQPlainTextDocumentLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPlainTextDocumentLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPlainTextDocumentLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextDocumentLayout", overloads);
        return -1;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_blockBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextBlock& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // blockBoundingRect(QTextBlock)const
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPlainTextDocumentLayout::blockBoundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPlainTextDocumentLayoutFunc_blockBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextDocumentLayoutFunc_blockBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextDocumentLayout.blockBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_cursorWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorWidth()const
    QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextDocumentLayout::cursorWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_documentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "documentChanged", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // documentChanged(int,int,int)
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextDocumentLayout::documentChanged(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQPlainTextDocumentLayoutFunc_documentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextDocumentLayoutFunc_documentChanged_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextDocumentLayout.documentChanged", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_documentSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentSize()const
    QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QPlainTextDocumentLayout::documentSize();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_draw(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "draw", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractTextDocumentLayout::PaintContext* cpp_arg1 = Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp(pyargs[1]);
        // draw(QPainter*,QAbstractTextDocumentLayout::PaintContext)
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextDocumentLayout::draw(cpp_arg0, *cpp_arg1);
    } else goto SbkQPlainTextDocumentLayoutFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextDocumentLayoutFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QAbstractTextDocumentLayout::PaintContext", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextDocumentLayout.draw", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_ensureBlockLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlock& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // ensureBlockLayout(QTextBlock)const
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextDocumentLayout::ensureBlockLayout(*cpp_arg0);
    } else goto SbkQPlainTextDocumentLayoutFunc_ensureBlockLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextDocumentLayoutFunc_ensureBlockLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextDocumentLayout.ensureBlockLayout", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_frameBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextFrame* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFrame* cpp_arg0 = Shiboken::Converter<QTextFrame* >::toCpp(arg);
        // frameBoundingRect(QTextFrame*)const
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPlainTextDocumentLayout::frameBoundingRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPlainTextDocumentLayoutFunc_frameBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextDocumentLayoutFunc_frameBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrame", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextDocumentLayout.frameBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_hitTest(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hitTest", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::HitTestAccuracy >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        Qt::HitTestAccuracy cpp_arg1 = Shiboken::Converter<Qt::HitTestAccuracy >::toCpp(pyargs[1]);
        // hitTest(QPointF,Qt::HitTestAccuracy)const
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPlainTextDocumentLayout::hitTest(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQPlainTextDocumentLayoutFunc_hitTest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextDocumentLayoutFunc_hitTest_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.Qt.HitTestAccuracy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextDocumentLayout.hitTest", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_pageCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageCount()const
    QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextDocumentLayout::pageCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_requestUpdate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // requestUpdate()
    QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextDocumentLayout::requestUpdate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextDocumentLayoutFunc_setCursorWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCursorWidth(int)
        QPlainTextDocumentLayout* cppSelf = Shiboken::Converter<QPlainTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextDocumentLayout::setCursorWidth(cpp_arg0);
    } else goto SbkQPlainTextDocumentLayoutFunc_setCursorWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextDocumentLayoutFunc_setCursorWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextDocumentLayout.setCursorWidth", overloads);
        return 0;
}

static PyMethodDef SbkQPlainTextDocumentLayout_methods[] = {
    {"blockBoundingRect", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_blockBoundingRect, METH_O},
    {"cursorWidth", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_cursorWidth, METH_NOARGS},
    {"documentChanged", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_documentChanged, METH_VARARGS},
    {"documentSize", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_documentSize, METH_NOARGS},
    {"draw", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_draw, METH_VARARGS},
    {"ensureBlockLayout", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_ensureBlockLayout, METH_O},
    {"frameBoundingRect", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_frameBoundingRect, METH_O},
    {"hitTest", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_hitTest, METH_VARARGS},
    {"pageCount", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_pageCount, METH_NOARGS},
    {"requestUpdate", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_requestUpdate, METH_NOARGS},
    {"setCursorWidth", (PyCFunction)SbkQPlainTextDocumentLayoutFunc_setCursorWidth, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPlainTextDocumentLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPlainTextDocumentLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPlainTextDocumentLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPlainTextDocumentLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPlainTextDocumentLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPlainTextDocumentLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPLAINTEXTDOCUMENTLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPlainTextDocumentLayout_Type);

    SbkQPlainTextDocumentLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX];
    // Fill type discovery information
    SbkQPlainTextDocumentLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPlainTextDocumentLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPlainTextDocumentLayout_Type));
    PyModule_AddObject(module, "QPlainTextDocumentLayout",
        ((PyObject*)&SbkQPlainTextDocumentLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPlainTextDocumentLayout >("QPlainTextDocumentLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPlainTextDocumentLayout >(typeid(QPlainTextDocumentLayout).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

