/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpixmap_wrapper.h"

// Extra includes
#include <QVariant>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qdatastream.h>
#include <qimage.h>
#include <qimagewriter.h>
#include <qiodevice.h>
#include <qmatrix.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qstring.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPixmapWrapper::QPixmapWrapper() : QPixmap() {
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(const QSize & arg__1) : QPixmap(arg__1) {
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(const QString & fileName, const char * format, QFlags<Qt::ImageConversionFlag> flags) : QPixmap(fileName, format, flags) {
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(int w, int h) : QPixmap(w, h) {
    // ... middle
}

int QPixmapWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPixmap::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPixmap.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QPixmapWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QPixmap::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPixmap.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QPixmapWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QPixmap::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPixmap.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QPixmapWrapper::~QPixmapWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPixmap_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPixmapWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QPixmap", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QPixmap()
        cptr = new QPixmapWrapper();
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QPixmap(int,int)
        cptr = new QPixmapWrapper(cpp_arg0, cpp_arg1);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            cptr = new QPixmapWrapper(*cpp_arg0);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
                cptr = new QPixmapWrapper(*cpp_arg0, cpp_arg1);
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[2])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[2]);
                // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
                cptr = new QPixmapWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQPixmap_Init_TypeError;
        } else goto SbkQPixmap_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // QPixmap(QSize)
        cptr = new QPixmapWrapper(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QVariant >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVariant >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // QPixmap(QVariant)
        // Begin code injection
        
        if ((*cpp_arg0).type() == QVariant::Pixmap)
            cptr = new QPixmapWrapper((*cpp_arg0).value<QPixmap>());
        else if ((*cpp_arg0).type() == QVariant::Image)
            cptr = new QPixmapWrapper(QPixmap::fromImage((*cpp_arg0).value<QImage>()));
        else
            PyErr_SetString(PyExc_TypeError, "QVariant must be holding a QPixmap");
        
        // End of code injection

    } else if (numArgs == 1 && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // QPixmap(QPixmap)
        cptr = new QPixmapWrapper(*cpp_arg0);
    } else goto SbkQPixmap_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPixmap_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPixmap_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QVariant", "PySide.QtGui.QPixmap", "PySide.QtCore.QSize", "PySide.QtCore.QString, str = None, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap", overloads);
        return -1;
}

static PyObject*
SbkQPixmapFunc_alphaChannel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alphaChannel()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QPixmap::alphaChannel();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_cacheKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheKey()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QPixmap::cacheKey();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_copy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPixmapFunc_copy_TypeError;

    if (!PyArg_UnpackTuple(args, "copy", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // copy(QRect)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QPixmap::copy();
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // copy(int,int,int,int)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QPixmap::copy(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // copy(QRect)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QPixmap::copy(*cpp_arg0);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQPixmapFunc_copy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_copy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect = QRect()", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.copy", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_createHeuristicMask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // createHeuristicMask(bool)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QBitmap cpp_result = cppSelf->QPixmap::createHeuristicMask();
        py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // createHeuristicMask(bool)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QBitmap cpp_result = cppSelf->QPixmap::createHeuristicMask(cpp_arg0);
        py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
    } else goto SbkQPixmapFunc_createHeuristicMask_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_createHeuristicMask_TypeError:
        const char* overloads[] = {"bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.createHeuristicMask", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_createMaskFromColor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createMaskFromColor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QColor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        if (numArgs == 1) {
            // createMaskFromColor(QColor)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QBitmap cpp_result = cppSelf->QPixmap::createMaskFromColor(*cpp_arg0);
            py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<Qt::MaskMode >::isConvertible(pyargs[1])) {
            Qt::MaskMode cpp_arg1 = Shiboken::Converter<Qt::MaskMode >::toCpp(pyargs[1]);
            // createMaskFromColor(QColor,Qt::MaskMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QBitmap cpp_result = cppSelf->QPixmap::createMaskFromColor(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_createMaskFromColor_TypeError;
    } else goto SbkQPixmapFunc_createMaskFromColor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_createMaskFromColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", "PySide.QtGui.QColor, PySide.QtCore.Qt.MaskMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.createMaskFromColor", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_defaultDepth(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultDepth()
    int cpp_result = QPixmap::defaultDepth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_depth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // depth()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPixmap::depth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPixmap::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_fill(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fill", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // fill(QColor)
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        cppSelf->QPixmap::fill();
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // fill(const QWidget*,int,int)
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            cppSelf->QPixmap::fill(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (numArgs == 2 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
            // fill(const QWidget*,QPoint)
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            cppSelf->QPixmap::fill(cpp_arg0, *cpp_arg1);
        } else goto SbkQPixmapFunc_fill_TypeError;
    } else if (Shiboken::Converter<QColor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // fill(QColor)
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        cppSelf->QPixmap::fill(*cpp_arg0);
    } else goto SbkQPixmapFunc_fill_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPixmapFunc_fill_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor = Qt.white", "PySide.QtGui.QWidget, PySide.QtCore.QPoint", "PySide.QtGui.QWidget, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.fill", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_fromImage(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromImage", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            QPixmap cpp_result = QPixmap::fromImage(*cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[1])) {
            QFlags<Qt::ImageConversionFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[1]);
            // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            QPixmap cpp_result = QPixmap::fromImage(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_fromImage_TypeError;
    } else goto SbkQPixmapFunc_fromImage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_fromImage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.fromImage", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_fromX11Pixmap(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromX11Pixmap", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyLong_Check(pyargs[0])) {
        Qt::HANDLE cpp_arg0 = Shiboken::Converter<Qt::HANDLE >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fromX11Pixmap(Qt::HANDLE,QPixmap::ShareMode)
            QPixmap cpp_result = QPixmap::fromX11Pixmap(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<QPixmap::ShareMode >::isConvertible(pyargs[1])) {
            QPixmap::ShareMode cpp_arg1 = Shiboken::Converter<QPixmap::ShareMode >::toCpp(pyargs[1]);
            // fromX11Pixmap(Qt::HANDLE,QPixmap::ShareMode)
            QPixmap cpp_result = QPixmap::fromX11Pixmap(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_fromX11Pixmap_TypeError;
    } else goto SbkQPixmapFunc_fromX11Pixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_fromX11Pixmap_TypeError:
        const char* overloads[] = {"Qt::HANDLE, PySide.QtGui.QPixmap.ShareMode = ImplicitlyShared", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.fromX11Pixmap", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_grabWidget(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "grabWidget", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // grabWidget(QWidget*,int,int,int,int)
            QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // grabWidget(QWidget*,int,int,int,int)
                QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // grabWidget(QWidget*,int,int,int,int)
                    QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // grabWidget(QWidget*,int,int,int,int)
                        QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    } else if (PyNumber_Check(pyargs[4])) {
                        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                        // grabWidget(QWidget*,int,int,int,int)
                        QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    } else goto SbkQPixmapFunc_grabWidget_TypeError;
                } else goto SbkQPixmapFunc_grabWidget_TypeError;
            } else goto SbkQPixmapFunc_grabWidget_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QRect& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
            // grabWidget(QWidget*,QRect)
            QPixmap cpp_result = QPixmap::grabWidget(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_grabWidget_TypeError;
    } else goto SbkQPixmapFunc_grabWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_grabWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QRect", "PySide.QtGui.QWidget, int = 0, int = 0, int = -1, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.grabWidget", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_grabWindow(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "grabWindow", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        WId cpp_arg0 = Shiboken::Converter<WId >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // grabWindow(WId,int,int,int,int)
            QPixmap cpp_result = QPixmap::grabWindow(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // grabWindow(WId,int,int,int,int)
                QPixmap cpp_result = QPixmap::grabWindow(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // grabWindow(WId,int,int,int,int)
                    QPixmap cpp_result = QPixmap::grabWindow(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // grabWindow(WId,int,int,int,int)
                        QPixmap cpp_result = QPixmap::grabWindow(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    } else if (PyNumber_Check(pyargs[4])) {
                        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                        // grabWindow(WId,int,int,int,int)
                        QPixmap cpp_result = QPixmap::grabWindow(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    } else goto SbkQPixmapFunc_grabWindow_TypeError;
                } else goto SbkQPixmapFunc_grabWindow_TypeError;
            } else goto SbkQPixmapFunc_grabWindow_TypeError;
        } else goto SbkQPixmapFunc_grabWindow_TypeError;
    } else goto SbkQPixmapFunc_grabWindow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_grabWindow_TypeError:
        const char* overloads[] = {"unsigned long, int = 0, int = 0, int = -1, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.grabWindow", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QPixmap::handle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_hasAlpha(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAlpha()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPixmap::hasAlpha();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_hasAlphaChannel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAlphaChannel()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPixmap::hasAlphaChannel();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPixmap::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPixmap::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_isQBitmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isQBitmap()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPixmap::isQBitmap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPixmap::load(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::load(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[2])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[2]);
                // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::load(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_load_TypeError;
        } else goto SbkQPixmapFunc_load_TypeError;
    } else goto SbkQPixmapFunc_load_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, str = None, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.load", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_loadFromData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "loadFromData", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            // Begin code injection
            
            const uchar* buf_out = reinterpret_cast<const uchar*>(PyString_AS_STRING(pyargs[1-1]));
            
            // End of code injection
            // Begin code injection
            
            uint len_out = static_cast<uint>(PyString_GET_SIZE(pyargs[1-1]));
            
            // End of code injection
            bool cpp_result = cppSelf->QPixmap::loadFromData(buf_out, len_out);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                // Begin code injection
                
                const uchar* buf_out = reinterpret_cast<const uchar*>(PyString_AS_STRING(pyargs[1-1]));
                
                // End of code injection
                // Begin code injection
                
                uint len_out = static_cast<uint>(PyString_GET_SIZE(pyargs[1-1]));
                
                // End of code injection
                bool cpp_result = cppSelf->QPixmap::loadFromData(buf_out, len_out, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[2])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[2]);
                // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                // Begin code injection
                
                const uchar* buf_out = reinterpret_cast<const uchar*>(PyString_AS_STRING(pyargs[1-1]));
                
                // End of code injection
                // Begin code injection
                
                uint len_out = static_cast<uint>(PyString_GET_SIZE(pyargs[1-1]));
                
                // End of code injection
                bool cpp_result = cppSelf->QPixmap::loadFromData(buf_out, len_out, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_loadFromData_TypeError;
        } else goto SbkQPixmapFunc_loadFromData_TypeError;
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPixmap::loadFromData(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::loadFromData(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[2])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[2]);
                // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::loadFromData(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_loadFromData_TypeError;
        } else goto SbkQPixmapFunc_loadFromData_TypeError;
    } else goto SbkQPixmapFunc_loadFromData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_loadFromData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, str = None, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "uchar, unsigned int, str = None, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.loadFromData", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_mask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mask()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QBitmap cpp_result = cppSelf->QPixmap::mask();
    py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPixmap::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQPixmapFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.metric", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QPixmap::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QPixmap::rect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_save(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "save", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // save(QString,const char*,int)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPixmap::save(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // save(QString,const char*,int)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::save(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // save(QString,const char*,int)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::save(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_save_TypeError;
        } else goto SbkQPixmapFunc_save_TypeError;
    } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // save(QIODevice*,const char*,int)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPixmap::save(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // save(QIODevice*,const char*,int)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::save(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // save(QIODevice*,const char*,int)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QPixmap::save(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_save_TypeError;
        } else goto SbkQPixmapFunc_save_TypeError;
    } else goto SbkQPixmapFunc_save_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_save_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, str = None, int = -1", "PySide.QtCore.QString, str = None, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.save", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_scaled(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "scaled", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaled(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[2])) {
            Qt::AspectRatioMode cpp_arg2 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QPixmap::scaled(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[3])) {
                Qt::TransformationMode cpp_arg3 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[3]);
                // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QPixmap::scaled(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_scaled_TypeError;
        } else goto SbkQPixmapFunc_scaled_TypeError;
    } else if (Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaled(*cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[1])) {
            Qt::AspectRatioMode cpp_arg1 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QPixmap::scaled(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[2])) {
                Qt::TransformationMode cpp_arg2 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[2]);
                // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QPixmap::scaled(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else goto SbkQPixmapFunc_scaled_TypeError;
        } else goto SbkQPixmapFunc_scaled_TypeError;
    } else goto SbkQPixmapFunc_scaled_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_scaled_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtCore.Qt.AspectRatioMode = Qt.IgnoreAspectRatio, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", "int, int, PySide.QtCore.Qt.AspectRatioMode = Qt.IgnoreAspectRatio, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.scaled", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_scaledToHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scaledToHeight", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scaledToHeight(int,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaledToHeight(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[1])) {
            Qt::TransformationMode cpp_arg1 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[1]);
            // scaledToHeight(int,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaledToHeight(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_scaledToHeight_TypeError;
    } else goto SbkQPixmapFunc_scaledToHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_scaledToHeight_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.scaledToHeight", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_scaledToWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scaledToWidth", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scaledToWidth(int,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaledToWidth(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[1])) {
            Qt::TransformationMode cpp_arg1 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[1]);
            // scaledToWidth(int,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::scaledToWidth(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_scaledToWidth_TypeError;
    } else goto SbkQPixmapFunc_scaledToWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_scaledToWidth_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.scaledToWidth", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_scroll(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 5)
        goto SbkQPixmapFunc_scroll_TypeError;

    if (!PyArg_UnpackTuple(args, "scroll", 3, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
            if (numArgs == 6) {
                // scroll(int,int,int,int,int,int,QRegion*)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                cppSelf->QPixmap::scroll(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            } else if (Shiboken::Converter<QRegion* >::isConvertible(pyargs[6])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                    return 0;
                std::auto_ptr<QRegion > cpp_arg6_auto_ptr;
                QRegion* cpp_arg6 = Shiboken::Converter<QRegion* >::toCpp(pyargs[6]);
                if (!Shiboken::Converter<QRegion* >::isConvertible(pyargs[6]))
                    cpp_arg6_auto_ptr = std::auto_ptr<QRegion >(cpp_arg6);
                // scroll(int,int,int,int,int,int,QRegion*)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                cppSelf->QPixmap::scroll(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
            } else goto SbkQPixmapFunc_scroll_TypeError;
        } else if (Shiboken::Converter<QRect& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // scroll(int,int,QRect,QRegion*)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                cppSelf->QPixmap::scroll(cpp_arg0, cpp_arg1, *cpp_arg2);
            } else if (Shiboken::Converter<QRegion* >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QRegion > cpp_arg3_auto_ptr;
                QRegion* cpp_arg3 = Shiboken::Converter<QRegion* >::toCpp(pyargs[3]);
                if (!Shiboken::Converter<QRegion* >::isConvertible(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QRegion >(cpp_arg3);
                // scroll(int,int,QRect,QRegion*)
                QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
                cppSelf->QPixmap::scroll(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            } else goto SbkQPixmapFunc_scroll_TypeError;
        } else goto SbkQPixmapFunc_scroll_TypeError;
    } else goto SbkQPixmapFunc_scroll_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPixmapFunc_scroll_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QRect, PySide.QtGui.QRegion = None", "int, int, int, int, int, int, PySide.QtGui.QRegion = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.scroll", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_setAlphaChannel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPixmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(arg);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // setAlphaChannel(QPixmap)
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        cppSelf->QPixmap::setAlphaChannel(*cpp_arg0);
    } else goto SbkQPixmapFunc_setAlphaChannel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPixmapFunc_setAlphaChannel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.setAlphaChannel", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_setMask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBitmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBitmap > cpp_arg0_auto_ptr;
        QBitmap* cpp_arg0 = Shiboken::Converter<QBitmap* >::toCpp(arg);
        if (!Shiboken::Converter<QBitmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBitmap >(cpp_arg0);
        // setMask(QBitmap)
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        cppSelf->QPixmap::setMask(*cpp_arg0);
    } else goto SbkQPixmapFunc_setMask_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPixmapFunc_setMask_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBitmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.setMask", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QPixmap::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_toImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toImage()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QPixmap::toImage();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_transformed(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "transformed", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // transformed(QTransform,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::transformed(*cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[1])) {
            Qt::TransformationMode cpp_arg1 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[1]);
            // transformed(QTransform,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::transformed(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_transformed_TypeError;
    } else if (Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // transformed(QMatrix,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::transformed(*cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::TransformationMode >::isConvertible(pyargs[1])) {
            Qt::TransformationMode cpp_arg1 = Shiboken::Converter<Qt::TransformationMode >::toCpp(pyargs[1]);
            // transformed(QMatrix,Qt::TransformationMode)const
            QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QPixmap::transformed(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else goto SbkQPixmapFunc_transformed_TypeError;
    } else goto SbkQPixmapFunc_transformed_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_transformed_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", "PySide.QtGui.QTransform, PySide.QtCore.Qt.TransformationMode = Qt.FastTransformation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.transformed", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_trueMatrix(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "trueMatrix", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // trueMatrix(QTransform,int,int)
        QTransform cpp_result = QPixmap::trueMatrix(*cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else if (numArgs == 3 && Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // trueMatrix(QMatrix,int,int)
        QMatrix cpp_result = QPixmap::trueMatrix(*cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);
    } else goto SbkQPixmapFunc_trueMatrix_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_trueMatrix_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix, int, int", "PySide.QtGui.QTransform, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPixmap.trueMatrix", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPixmap::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_x11Info(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x11Info()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    const QX11Info & cpp_result = cppSelf->QPixmap::x11Info();
    py_result = Shiboken::Converter<QX11Info& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_x11PictureHandle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x11PictureHandle()const
    QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QPixmap::x11PictureHandle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPixmapFunc_x11SetDefaultScreen(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // x11SetDefaultScreen(int)
        int cpp_result = QPixmap::x11SetDefaultScreen(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQPixmapFunc_x11SetDefaultScreen_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc_x11SetDefaultScreen_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.x11SetDefaultScreen", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc_x11SetScreen(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // x11SetScreen(int)
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        cppSelf->QPixmap::x11SetScreen(cpp_arg0);
    } else goto SbkQPixmapFunc_x11SetScreen_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPixmapFunc_x11SetScreen_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.x11SetScreen", overloads);
        return 0;
}

static PyMethodDef SbkQPixmap_methods[] = {
    {"alphaChannel", (PyCFunction)SbkQPixmapFunc_alphaChannel, METH_NOARGS},
    {"cacheKey", (PyCFunction)SbkQPixmapFunc_cacheKey, METH_NOARGS},
    {"copy", (PyCFunction)SbkQPixmapFunc_copy, METH_VARARGS},
    {"createHeuristicMask", (PyCFunction)SbkQPixmapFunc_createHeuristicMask, METH_NOARGS|METH_O},
    {"createMaskFromColor", (PyCFunction)SbkQPixmapFunc_createMaskFromColor, METH_VARARGS},
    {"defaultDepth", (PyCFunction)SbkQPixmapFunc_defaultDepth, METH_NOARGS|METH_STATIC},
    {"depth", (PyCFunction)SbkQPixmapFunc_depth, METH_NOARGS},
    {"devType", (PyCFunction)SbkQPixmapFunc_devType, METH_NOARGS},
    {"fill", (PyCFunction)SbkQPixmapFunc_fill, METH_VARARGS},
    {"fromImage", (PyCFunction)SbkQPixmapFunc_fromImage, METH_VARARGS|METH_STATIC},
    {"fromX11Pixmap", (PyCFunction)SbkQPixmapFunc_fromX11Pixmap, METH_VARARGS|METH_STATIC},
    {"grabWidget", (PyCFunction)SbkQPixmapFunc_grabWidget, METH_VARARGS|METH_STATIC},
    {"grabWindow", (PyCFunction)SbkQPixmapFunc_grabWindow, METH_VARARGS|METH_STATIC},
    {"handle", (PyCFunction)SbkQPixmapFunc_handle, METH_NOARGS},
    {"hasAlpha", (PyCFunction)SbkQPixmapFunc_hasAlpha, METH_NOARGS},
    {"hasAlphaChannel", (PyCFunction)SbkQPixmapFunc_hasAlphaChannel, METH_NOARGS},
    {"height", (PyCFunction)SbkQPixmapFunc_height, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQPixmapFunc_isNull, METH_NOARGS},
    {"isQBitmap", (PyCFunction)SbkQPixmapFunc_isQBitmap, METH_NOARGS},
    {"load", (PyCFunction)SbkQPixmapFunc_load, METH_VARARGS},
    {"loadFromData", (PyCFunction)SbkQPixmapFunc_loadFromData, METH_VARARGS},
    {"mask", (PyCFunction)SbkQPixmapFunc_mask, METH_NOARGS},
    {"metric", (PyCFunction)SbkQPixmapFunc_metric, METH_O},
    {"paintEngine", (PyCFunction)SbkQPixmapFunc_paintEngine, METH_NOARGS},
    {"rect", (PyCFunction)SbkQPixmapFunc_rect, METH_NOARGS},
    {"save", (PyCFunction)SbkQPixmapFunc_save, METH_VARARGS},
    {"scaled", (PyCFunction)SbkQPixmapFunc_scaled, METH_VARARGS},
    {"scaledToHeight", (PyCFunction)SbkQPixmapFunc_scaledToHeight, METH_VARARGS},
    {"scaledToWidth", (PyCFunction)SbkQPixmapFunc_scaledToWidth, METH_VARARGS},
    {"scroll", (PyCFunction)SbkQPixmapFunc_scroll, METH_VARARGS},
    {"setAlphaChannel", (PyCFunction)SbkQPixmapFunc_setAlphaChannel, METH_O},
    {"setMask", (PyCFunction)SbkQPixmapFunc_setMask, METH_O},
    {"size", (PyCFunction)SbkQPixmapFunc_size, METH_NOARGS},
    {"toImage", (PyCFunction)SbkQPixmapFunc_toImage, METH_NOARGS},
    {"transformed", (PyCFunction)SbkQPixmapFunc_transformed, METH_VARARGS},
    {"trueMatrix", (PyCFunction)SbkQPixmapFunc_trueMatrix, METH_VARARGS|METH_STATIC},
    {"width", (PyCFunction)SbkQPixmapFunc_width, METH_NOARGS},
    {"x11Info", (PyCFunction)SbkQPixmapFunc_x11Info, METH_NOARGS},
    {"x11PictureHandle", (PyCFunction)SbkQPixmapFunc_x11PictureHandle, METH_NOARGS},
    {"x11SetDefaultScreen", (PyCFunction)SbkQPixmapFunc_x11SetDefaultScreen, METH_O|METH_STATIC},
    {"x11SetScreen", (PyCFunction)SbkQPixmapFunc_x11SetScreen, METH_O},
    {0} // Sentinel
};

static PyObject*
SbkQPixmapFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPixmap_Check(arg) && !SbkQPixmap_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPixmap) [reverse operator]
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPixmapFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQPixmapFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPixmap_Check(arg) && !SbkQPixmap_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPixmap&) [reverse operator]
        QPixmap* cppSelf = Shiboken::Converter<QPixmap* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPixmapFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPixmapFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPixmap.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPixmap_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPixmapFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPixmapFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

static void* SbkQPixmap_ObjCopierFunc(const void* ptr){
    return new QPixmapWrapper(*reinterpret_cast<const QPixmap*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPixmap_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPixmap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPixmapWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPixmap_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPixmap_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPixmap_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQPixmap_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QPixmap_ShareMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPixmap_ShareMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPixmap_ShareMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ShareMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPixmap_ShareMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPixmap_ShareMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPixmap_ShareMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QPixmap(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPIXMAP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPixmap_Type);

    SbkQPixmap_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQPixmap_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPixmap_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPixmap_Type));
    PyModule_AddObject(module, "QPixmap",
        ((PyObject*)&SbkQPixmap_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ShareMode
    SbkPySide_QtGuiTypes[SBK_QPIXMAP_SHAREMODE_IDX] = &SbkPySide_QtGui_QPixmap_ShareMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPixmap_ShareMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPixmap_ShareMode_Type);
    PyDict_SetItemString(SbkQPixmap_Type.super.ht_type.tp_dict,
            "ShareMode",((PyObject*)&SbkPySide_QtGui_QPixmap_ShareMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPixmap_ShareMode_Type,
        (long) QPixmap::ImplicitlyShared, "ImplicitlyShared");
    PyDict_SetItemString(SbkQPixmap_Type.super.ht_type.tp_dict,
        "ImplicitlyShared", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPixmap_ShareMode_Type.tp_dict,
        "ImplicitlyShared", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPixmap_ShareMode_Type,
        (long) QPixmap::ExplicitlyShared, "ExplicitlyShared");
    PyDict_SetItemString(SbkQPixmap_Type.super.ht_type.tp_dict,
        "ExplicitlyShared", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPixmap_ShareMode_Type.tp_dict,
        "ExplicitlyShared", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPixmap::ShareMode");

    Shiboken::TypeResolver::createValueTypeResolver<QPixmap >("QPixmap");
    Shiboken::TypeResolver::createValueTypeResolver<QPixmap >(typeid(QPixmap).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

