/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpainterpath_wrapper.h"
#include "qpainterpath_element_wrapper.h"

// Extra includes
#include <QList>
#include <QPainterPath>
#include <qdatastream.h>
#include <qfont.h>
#include <qmatrix.h>
#include <qpainterpath.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qstring.h>
#include <qtransform.h>

using namespace Shiboken;

static int
SbkQPainterPath_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPainterPath* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPainterPath", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPainterPath()
        cptr = new QPainterPath();
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // QPainterPath(QPointF)
        cptr = new QPainterPath(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        // QPainterPath(QPainterPath)
        cptr = new QPainterPath(*cpp_arg0);
    } else goto SbkQPainterPath_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPainterPath_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPainterPath_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPainterPath", "PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath", overloads);
        return -1;
}

static PyObject*
SbkQPainterPathFunc_addEllipse(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQPainterPathFunc_addEllipse_TypeError;

    if (!PyArg_UnpackTuple(args, "addEllipse", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // addEllipse(qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addEllipse(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // addEllipse(QRectF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addEllipse(*cpp_arg0);
    } else if (numArgs == 3 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // addEllipse(QPointF,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addEllipse(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQPainterPathFunc_addEllipse_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addEllipse_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, float, float", "PySide.QtCore.QRectF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.addEllipse", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // addPath(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addPath(*cpp_arg0);
    } else goto SbkQPainterPathFunc_addPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.addPath", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addPolygon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPolygonF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // addPolygon(QPolygonF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addPolygon(*cpp_arg0);
    } else goto SbkQPainterPathFunc_addPolygon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addPolygon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.addPolygon", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPainterPathFunc_addRect_TypeError;

    if (!PyArg_UnpackTuple(args, "addRect", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // addRect(qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // addRect(QRectF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addRect(*cpp_arg0);
    } else goto SbkQPainterPathFunc_addRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.addRect", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addRegion(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // addRegion(QRegion)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addRegion(*cpp_arg0);
    } else goto SbkQPainterPathFunc_addRegion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addRegion_TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.addRegion", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addRoundRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4)
        goto SbkQPainterPathFunc_addRoundRect_TypeError;

    if (!PyArg_UnpackTuple(args, "addRoundRect", 2, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        if (numArgs == 5) {
            // addRoundRect(qreal,qreal,qreal,qreal,int)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else if (numArgs == 6 && PyNumber_Check(pyargs[5])) {
            int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
            // addRoundRect(qreal,qreal,qreal,qreal,int,int)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        } else goto SbkQPainterPathFunc_addRoundRect_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // addRoundRect(QRectF,int)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundRect(*cpp_arg0, cpp_arg1);
        } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // addRoundRect(QRectF,int,int)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundRect(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQPainterPathFunc_addRoundRect_TypeError;
    } else goto SbkQPainterPathFunc_addRoundRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addRoundRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, int", "PySide.QtCore.QRectF, int, int", "float, float, float, float, int", "float, float, float, float, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.addRoundRect", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addRoundedRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 5)
        goto SbkQPainterPathFunc_addRoundedRect_TypeError;

    if (!PyArg_UnpackTuple(args, "addRoundedRect", 3, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        if (numArgs == 6) {
            // addRoundedRect(qreal,qreal,qreal,qreal,qreal,qreal,Qt::SizeMode)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundedRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        } else if (Shiboken::Converter<Qt::SizeMode >::isConvertible(pyargs[6])) {
            Qt::SizeMode cpp_arg6 = Shiboken::Converter<Qt::SizeMode >::toCpp(pyargs[6]);
            // addRoundedRect(qreal,qreal,qreal,qreal,qreal,qreal,Qt::SizeMode)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundedRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
        } else goto SbkQPainterPathFunc_addRoundedRect_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // addRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (Shiboken::Converter<Qt::SizeMode >::isConvertible(pyargs[3])) {
            Qt::SizeMode cpp_arg3 = Shiboken::Converter<Qt::SizeMode >::toCpp(pyargs[3]);
            // addRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
            QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
            cppSelf->QPainterPath::addRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQPainterPathFunc_addRoundedRect_TypeError;
    } else goto SbkQPainterPathFunc_addRoundedRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addRoundedRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, float, float, PySide.QtCore.Qt.SizeMode = Qt.AbsoluteSize", "float, float, float, float, float, float, PySide.QtCore.Qt.SizeMode = Qt.AbsoluteSize", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.addRoundedRect", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_addText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addText", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QFont& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QFont > cpp_arg2_auto_ptr;
        QFont* cpp_arg2 = Shiboken::Converter<QFont* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QFont& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QFont >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // addText(qreal,qreal,QFont,QString)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addText(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
    } else if (numArgs == 3 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QFont& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QFont > cpp_arg1_auto_ptr;
        QFont* cpp_arg1 = Shiboken::Converter<QFont* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QFont& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QFont >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // addText(QPointF,QFont,QString)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::addText(*cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQPainterPathFunc_addText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_addText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtGui.QFont, PySide.QtCore.QString", "float, float, PySide.QtGui.QFont, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.addText", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_angleAtPercent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // angleAtPercent(qreal)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QPainterPath::angleAtPercent(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_angleAtPercent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_angleAtPercent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.angleAtPercent", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_arcMoveTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3 || numArgs == 4)
        goto SbkQPainterPathFunc_arcMoveTo_TypeError;

    if (!PyArg_UnpackTuple(args, "arcMoveTo", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        // arcMoveTo(qreal,qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::arcMoveTo(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
    } else if (numArgs == 2 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // arcMoveTo(QRectF,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::arcMoveTo(*cpp_arg0, cpp_arg1);
    } else goto SbkQPainterPathFunc_arcMoveTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_arcMoveTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, float", "float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.arcMoveTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_arcTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterPathFunc_arcTo_TypeError;

    if (!PyArg_UnpackTuple(args, "arcTo", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        // arcTo(qreal,qreal,qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::arcTo(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
    } else if (numArgs == 3 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // arcTo(QRectF,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::arcTo(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQPainterPathFunc_arcTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_arcTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, float, float", "float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.arcTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QPainterPath::boundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_closeSubpath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // closeSubpath()
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    cppSelf->QPainterPath::closeSubpath();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPainterPathFunc_connectPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // connectPath(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::connectPath(*cpp_arg0);
    } else goto SbkQPainterPathFunc_connectPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_connectPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.connectPath", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // contains(QRectF)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainterPath::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // contains(QPointF)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainterPath::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // contains(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainterPath::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", "PySide.QtCore.QPointF", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.contains", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_controlPointRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // controlPointRect()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QPainterPath::controlPointRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_cubicTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterPathFunc_cubicTo_TypeError;

    if (!PyArg_UnpackTuple(args, "cubicTo", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        // cubicTo(qreal,qreal,qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::cubicTo(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
    } else if (numArgs == 3 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg2_auto_ptr;
        QPointF* cpp_arg2 = Shiboken::Converter<QPointF* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPointF >(cpp_arg2);
        // cubicTo(QPointF,QPointF,QPointF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::cubicTo(*cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQPainterPathFunc_cubicTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_cubicTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.QPointF, PySide.QtCore.QPointF", "float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.cubicTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_currentPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentPosition()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPainterPath::currentPosition();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_elementAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // elementAt(int)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        const QPainterPath::Element & cpp_result = cppSelf->QPainterPath::elementAt(cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath::Element& >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_elementAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_elementAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.elementAt", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_elementCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elementCount()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPainterPath::elementCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_fillRule(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fillRule()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    Qt::FillRule cpp_result = cppSelf->QPainterPath::fillRule();
    py_result = Shiboken::Converter<Qt::FillRule >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // intersected(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.intersected", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_intersects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // intersects(QRectF)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainterPath::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // intersects(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainterPath::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_intersects_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_intersects_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.intersects", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainterPath::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainterPath::length();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_lineTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lineTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // lineTo(qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::lineTo(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // lineTo(QPointF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::lineTo(*cpp_arg0);
    } else goto SbkQPainterPathFunc_lineTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_lineTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.lineTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_moveTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // moveTo(qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::moveTo(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveTo(QPointF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::moveTo(*cpp_arg0);
    } else goto SbkQPainterPathFunc_moveTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_moveTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.moveTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_percentAtLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // percentAtLength(qreal)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QPainterPath::percentAtLength(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_percentAtLength_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_percentAtLength_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.percentAtLength", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_pointAtPercent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // pointAtPercent(qreal)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QPainterPath::pointAtPercent(cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_pointAtPercent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_pointAtPercent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.pointAtPercent", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_quadTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQPainterPathFunc_quadTo_TypeError;

    if (!PyArg_UnpackTuple(args, "quadTo", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // quadTo(qreal,qreal,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::quadTo(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 2 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // quadTo(QPointF,QPointF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::quadTo(*cpp_arg0, *cpp_arg1);
    } else goto SbkQPainterPathFunc_quadTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_quadTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.QPointF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.quadTo", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_setElementPositionAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setElementPositionAt", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // setElementPositionAt(int,qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::setElementPositionAt(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQPainterPathFunc_setElementPositionAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_setElementPositionAt_TypeError:
        const char* overloads[] = {"int, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.setElementPositionAt", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_setFillRule(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::FillRule >::isConvertible(arg)) {
        Qt::FillRule cpp_arg0 = Shiboken::Converter<Qt::FillRule >::toCpp(arg);
        // setFillRule(Qt::FillRule)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::setFillRule(cpp_arg0);
    } else goto SbkQPainterPathFunc_setFillRule_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_setFillRule_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.FillRule", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.setFillRule", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_simplified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // simplified()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QPainterPath::simplified();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_slopeAtPercent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // slopeAtPercent(qreal)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QPainterPath::slopeAtPercent(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_slopeAtPercent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_slopeAtPercent_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.slopeAtPercent", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_subtracted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // subtracted(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::subtracted(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_subtracted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_subtracted_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.subtracted", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_subtractedInverted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // subtractedInverted(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::subtractedInverted(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_subtractedInverted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_subtractedInverted_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.subtractedInverted", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_toFillPolygon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toFillPolygon(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPainterPath::toFillPolygon();
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else if (Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // toFillPolygon(QTransform)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPainterPath::toFillPolygon(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else if (Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // toFillPolygon(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPainterPath::toFillPolygon(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_toFillPolygon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_toFillPolygon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix = QMatrix()", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.toFillPolygon", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_toFillPolygons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toFillPolygons(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toFillPolygons();
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // toFillPolygons(QTransform)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toFillPolygons(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // toFillPolygons(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toFillPolygons(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_toFillPolygons_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_toFillPolygons_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix = QMatrix()", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.toFillPolygons", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_toReversed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toReversed()const
    QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QPainterPath::toReversed();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathFunc_toSubpathPolygons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toSubpathPolygons(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toSubpathPolygons();
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // toSubpathPolygons(QTransform)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toSubpathPolygons(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // toSubpathPolygons(QMatrix)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QList<QPolygonF > cpp_result = cppSelf->QPainterPath::toSubpathPolygons(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QPolygonF > >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_toSubpathPolygons_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_toSubpathPolygons_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix = QMatrix()", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.toSubpathPolygons", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::translate(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translate(QPointF)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        cppSelf->QPainterPath::translate(*cpp_arg0);
    } else goto SbkQPainterPathFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.translate", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translated(qreal,qreal)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translated(QPointF)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainterPath.translated", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // united(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPath::united(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.united", overloads);
        return 0;
}

static PyMethodDef SbkQPainterPath_methods[] = {
    {"addEllipse", (PyCFunction)SbkQPainterPathFunc_addEllipse, METH_VARARGS},
    {"addPath", (PyCFunction)SbkQPainterPathFunc_addPath, METH_O},
    {"addPolygon", (PyCFunction)SbkQPainterPathFunc_addPolygon, METH_O},
    {"addRect", (PyCFunction)SbkQPainterPathFunc_addRect, METH_VARARGS},
    {"addRegion", (PyCFunction)SbkQPainterPathFunc_addRegion, METH_O},
    {"addRoundRect", (PyCFunction)SbkQPainterPathFunc_addRoundRect, METH_VARARGS},
    {"addRoundedRect", (PyCFunction)SbkQPainterPathFunc_addRoundedRect, METH_VARARGS},
    {"addText", (PyCFunction)SbkQPainterPathFunc_addText, METH_VARARGS},
    {"angleAtPercent", (PyCFunction)SbkQPainterPathFunc_angleAtPercent, METH_O},
    {"arcMoveTo", (PyCFunction)SbkQPainterPathFunc_arcMoveTo, METH_VARARGS},
    {"arcTo", (PyCFunction)SbkQPainterPathFunc_arcTo, METH_VARARGS},
    {"boundingRect", (PyCFunction)SbkQPainterPathFunc_boundingRect, METH_NOARGS},
    {"closeSubpath", (PyCFunction)SbkQPainterPathFunc_closeSubpath, METH_NOARGS},
    {"connectPath", (PyCFunction)SbkQPainterPathFunc_connectPath, METH_O},
    {"contains", (PyCFunction)SbkQPainterPathFunc_contains, METH_O},
    {"controlPointRect", (PyCFunction)SbkQPainterPathFunc_controlPointRect, METH_NOARGS},
    {"cubicTo", (PyCFunction)SbkQPainterPathFunc_cubicTo, METH_VARARGS},
    {"currentPosition", (PyCFunction)SbkQPainterPathFunc_currentPosition, METH_NOARGS},
    {"elementAt", (PyCFunction)SbkQPainterPathFunc_elementAt, METH_O},
    {"elementCount", (PyCFunction)SbkQPainterPathFunc_elementCount, METH_NOARGS},
    {"fillRule", (PyCFunction)SbkQPainterPathFunc_fillRule, METH_NOARGS},
    {"intersected", (PyCFunction)SbkQPainterPathFunc_intersected, METH_O},
    {"intersects", (PyCFunction)SbkQPainterPathFunc_intersects, METH_O},
    {"isEmpty", (PyCFunction)SbkQPainterPathFunc_isEmpty, METH_NOARGS},
    {"length", (PyCFunction)SbkQPainterPathFunc_length, METH_NOARGS},
    {"lineTo", (PyCFunction)SbkQPainterPathFunc_lineTo, METH_VARARGS},
    {"moveTo", (PyCFunction)SbkQPainterPathFunc_moveTo, METH_VARARGS},
    {"percentAtLength", (PyCFunction)SbkQPainterPathFunc_percentAtLength, METH_O},
    {"pointAtPercent", (PyCFunction)SbkQPainterPathFunc_pointAtPercent, METH_O},
    {"quadTo", (PyCFunction)SbkQPainterPathFunc_quadTo, METH_VARARGS},
    {"setElementPositionAt", (PyCFunction)SbkQPainterPathFunc_setElementPositionAt, METH_VARARGS},
    {"setFillRule", (PyCFunction)SbkQPainterPathFunc_setFillRule, METH_O},
    {"simplified", (PyCFunction)SbkQPainterPathFunc_simplified, METH_NOARGS},
    {"slopeAtPercent", (PyCFunction)SbkQPainterPathFunc_slopeAtPercent, METH_O},
    {"subtracted", (PyCFunction)SbkQPainterPathFunc_subtracted, METH_O},
    {"subtractedInverted", (PyCFunction)SbkQPainterPathFunc_subtractedInverted, METH_O},
    {"toFillPolygon", (PyCFunction)SbkQPainterPathFunc_toFillPolygon, METH_NOARGS|METH_O},
    {"toFillPolygons", (PyCFunction)SbkQPainterPathFunc_toFillPolygons, METH_NOARGS|METH_O},
    {"toReversed", (PyCFunction)SbkQPainterPathFunc_toReversed, METH_NOARGS},
    {"toSubpathPolygons", (PyCFunction)SbkQPainterPathFunc_toSubpathPolygons, METH_NOARGS|METH_O},
    {"translate", (PyCFunction)SbkQPainterPathFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQPainterPathFunc_translated, METH_VARARGS},
    {"united", (PyCFunction)SbkQPainterPathFunc_united, METH_O},
    {0} // Sentinel
};

static PyObject*
SbkQPainterPathFunc___and__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator&(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc___and___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___and___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__and__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___iand__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator&=(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        (*cppSelf) &= (*cpp_arg0);
    } else goto SbkQPainterPathFunc___iand___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPainterPathFunc___iand___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__iand__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*(QPainterPath,QTransform)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // operator*(QPainterPath,QMatrix)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator+(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__add__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator+=(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQPainterPathFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPainterPathFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator-(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator-=(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQPainterPathFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPainterPathFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPainterPath) [reverse operator]
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPainterPathFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPainterPath&) [reverse operator]
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPainterPathFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__rshift__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___or__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator|(QPainterPath)const
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = (*cppSelf) | (*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathFunc___or___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathFunc___or___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__or__", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathFunc___ior__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPainterPath_Check(arg) && !SbkQPainterPath_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // operator|=(QPainterPath)
        QPainterPath* cppSelf = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);
        (*cppSelf) |= (*cpp_arg0);
    } else goto SbkQPainterPathFunc___ior___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPainterPathFunc___ior___TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPath.__ior__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPainterPath_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQPainterPathFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQPainterPathFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQPainterPathFunc___mul__,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPainterPathFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPainterPathFunc___rshift__,
    /*nb_and*/                  (binaryfunc)SbkQPainterPathFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQPainterPathFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQPainterPathFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQPainterPathFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQPainterPathFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQPainterPathFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQPainterPath_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QPainterPath& cpp_self = *Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPainterPath& >::isConvertible(other)) {
                QPainterPath* cpp_other = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPainterPath_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPainterPath& >::isConvertible(other)) {
                QPainterPath* cpp_other = Shiboken::Converter<QPainterPath* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPainterPath_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQPainterPath_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPainterPath_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPainterPath",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPainterPath >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPainterPath_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPainterPath_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPainterPath_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPainterPath_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QPainterPath_ElementType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPainterPath_ElementType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPainterPath_ElementType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ElementType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPainterPath_ElementType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPainterPath_ElementType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPainterPath_ElementType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QPainterPath_Element(PyObject*);
PyAPI_FUNC(void)
init_QPainterPath(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPainterPath_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPainterPath_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPainterPath_Type));
    PyModule_AddObject(module, "QPainterPath",
        ((PyObject*)&SbkQPainterPath_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ElementType
    SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENTTYPE_IDX] = &SbkPySide_QtGui_QPainterPath_ElementType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPainterPath_ElementType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPainterPath_ElementType_Type);
    PyDict_SetItemString(SbkQPainterPath_Type.super.ht_type.tp_dict,
            "ElementType",((PyObject*)&SbkPySide_QtGui_QPainterPath_ElementType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainterPath_ElementType_Type,
        (long) QPainterPath::MoveToElement, "MoveToElement");
    PyDict_SetItemString(SbkQPainterPath_Type.super.ht_type.tp_dict,
        "MoveToElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainterPath_ElementType_Type.tp_dict,
        "MoveToElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainterPath_ElementType_Type,
        (long) QPainterPath::LineToElement, "LineToElement");
    PyDict_SetItemString(SbkQPainterPath_Type.super.ht_type.tp_dict,
        "LineToElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainterPath_ElementType_Type.tp_dict,
        "LineToElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainterPath_ElementType_Type,
        (long) QPainterPath::CurveToElement, "CurveToElement");
    PyDict_SetItemString(SbkQPainterPath_Type.super.ht_type.tp_dict,
        "CurveToElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainterPath_ElementType_Type.tp_dict,
        "CurveToElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainterPath_ElementType_Type,
        (long) QPainterPath::CurveToDataElement, "CurveToDataElement");
    PyDict_SetItemString(SbkQPainterPath_Type.super.ht_type.tp_dict,
        "CurveToDataElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainterPath_ElementType_Type.tp_dict,
        "CurveToDataElement", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPainterPath::ElementType");

    Shiboken::TypeResolver::createValueTypeResolver<QPainterPath >("QPainterPath");
    Shiboken::TypeResolver::createValueTypeResolver<QPainterPath >(typeid(QPainterPath).name());
    init_QPainterPath_Element(SbkQPainterPath_Type.super.ht_type.tp_dict);
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

