/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpaintenginestate_wrapper.h"

// Extra includes
#include <QPainterPath>
#include <qbrush.h>
#include <qfont.h>
#include <qmatrix.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpen.h>
#include <qpoint.h>
#include <qregion.h>
#include <qtransform.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPaintEngineStateWrapper::QPaintEngineStateWrapper() : QPaintEngineState() {
    // ... middle
}

QPaintEngineStateWrapper::~QPaintEngineStateWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPaintEngineState_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPaintEngineStateWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QPaintEngineState()
    cptr = new QPaintEngineStateWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQPaintEngineStateFunc_backgroundBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundBrush()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QPaintEngineState::backgroundBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_backgroundMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundMode()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    Qt::BGMode cpp_result = cppSelf->QPaintEngineState::backgroundMode();
    py_result = Shiboken::Converter<Qt::BGMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_brush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brush()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QPaintEngineState::brush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_brushNeedsResolving(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brushNeedsResolving()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPaintEngineState::brushNeedsResolving();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_brushOrigin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brushOrigin()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPaintEngineState::brushOrigin();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_clipOperation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipOperation()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    Qt::ClipOperation cpp_result = cppSelf->QPaintEngineState::clipOperation();
    py_result = Shiboken::Converter<Qt::ClipOperation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_clipPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipPath()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QPaintEngineState::clipPath();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_clipRegion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipRegion()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QRegion cpp_result = cppSelf->QPaintEngineState::clipRegion();
    py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_compositionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // compositionMode()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QPainter::CompositionMode cpp_result = cppSelf->QPaintEngineState::compositionMode();
    py_result = Shiboken::Converter<QPainter::CompositionMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QPaintEngineState::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_isClipEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isClipEnabled()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPaintEngineState::isClipEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_matrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // matrix()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QMatrix cpp_result = cppSelf->QPaintEngineState::matrix();
    py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_opacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // opacity()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPaintEngineState::opacity();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_painter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // painter()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QPainter * cpp_result = cppSelf->QPaintEngineState::painter();
    py_result = Shiboken::Converter<QPainter* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_pen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pen()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QPen cpp_result = cppSelf->QPaintEngineState::pen();
    py_result = Shiboken::Converter<QPen >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_penNeedsResolving(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // penNeedsResolving()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPaintEngineState::penNeedsResolving();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_renderHints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // renderHints()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QFlags<QPainter::RenderHint> cpp_result = cppSelf->QPaintEngineState::renderHints();
    py_result = Shiboken::Converter<QFlags<QPainter::RenderHint> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QFlags<QPaintEngine::DirtyFlag> cpp_result = cppSelf->QPaintEngineState::state();
    py_result = Shiboken::Converter<QFlags<QPaintEngine::DirtyFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaintEngineStateFunc_transform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transform()const
    QPaintEngineState* cppSelf = Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QPaintEngineState::transform();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPaintEngineState_methods[] = {
    {"backgroundBrush", (PyCFunction)SbkQPaintEngineStateFunc_backgroundBrush, METH_NOARGS},
    {"backgroundMode", (PyCFunction)SbkQPaintEngineStateFunc_backgroundMode, METH_NOARGS},
    {"brush", (PyCFunction)SbkQPaintEngineStateFunc_brush, METH_NOARGS},
    {"brushNeedsResolving", (PyCFunction)SbkQPaintEngineStateFunc_brushNeedsResolving, METH_NOARGS},
    {"brushOrigin", (PyCFunction)SbkQPaintEngineStateFunc_brushOrigin, METH_NOARGS},
    {"clipOperation", (PyCFunction)SbkQPaintEngineStateFunc_clipOperation, METH_NOARGS},
    {"clipPath", (PyCFunction)SbkQPaintEngineStateFunc_clipPath, METH_NOARGS},
    {"clipRegion", (PyCFunction)SbkQPaintEngineStateFunc_clipRegion, METH_NOARGS},
    {"compositionMode", (PyCFunction)SbkQPaintEngineStateFunc_compositionMode, METH_NOARGS},
    {"font", (PyCFunction)SbkQPaintEngineStateFunc_font, METH_NOARGS},
    {"isClipEnabled", (PyCFunction)SbkQPaintEngineStateFunc_isClipEnabled, METH_NOARGS},
    {"matrix", (PyCFunction)SbkQPaintEngineStateFunc_matrix, METH_NOARGS},
    {"opacity", (PyCFunction)SbkQPaintEngineStateFunc_opacity, METH_NOARGS},
    {"painter", (PyCFunction)SbkQPaintEngineStateFunc_painter, METH_NOARGS},
    {"pen", (PyCFunction)SbkQPaintEngineStateFunc_pen, METH_NOARGS},
    {"penNeedsResolving", (PyCFunction)SbkQPaintEngineStateFunc_penNeedsResolving, METH_NOARGS},
    {"renderHints", (PyCFunction)SbkQPaintEngineStateFunc_renderHints, METH_NOARGS},
    {"state", (PyCFunction)SbkQPaintEngineStateFunc_state, METH_NOARGS},
    {"transform", (PyCFunction)SbkQPaintEngineStateFunc_transform, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQPaintEngineState_get_dirtyFlags(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QPaintEngine::DirtyFlag> >::toPython(Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self)->dirtyFlags);
}
static int SbkQPaintEngineState_set_dirtyFlags(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'dirtyFlags' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QPaintEngine_DirtyFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'dirtyFlags', 'DirtyFlags' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPaintEngineState* >::toCpp((PyObject*)self)->dirtyFlags = Shiboken::Converter<QFlags<QPaintEngine::DirtyFlag> >::toCpp(value);

    return 0;
}

// Getters and Setters for QPaintEngineState
static PyGetSetDef SbkQPaintEngineState_getsetlist[] = {
    {const_cast<char*>("dirtyFlags"), (getter)SbkQPaintEngineState_get_dirtyFlags, (setter)SbkQPaintEngineState_set_dirtyFlags},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPaintEngineState_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPaintEngineState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPaintEngineStateWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPaintEngineState_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQPaintEngineState_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPaintEngineState_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQPaintEngineState_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQPaintEngineState_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QPaintEngineState*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QPaintEngineState(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPaintEngineState_Type);

    // Fill type discovery information
    SbkQPaintEngineState_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQPaintEngineState_Type.type_discovery->addTypeDiscoveryFunction(&SbkQPaintEngineState_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQPaintEngineState_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPaintEngineState_Type));
    PyModule_AddObject(module, "QPaintEngineState",
        ((PyObject*)&SbkQPaintEngineState_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPaintEngineState >("QPaintEngineState*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPaintEngineState >(typeid(QPaintEngineState).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

