/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qmessagebox_wrapper.h"

// Extra includes
#include <QList>
#include <QPixmap>
#include <qabstractbutton.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmessagebox.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qpushbutton.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMessageBoxWrapper::QMessageBoxWrapper(QMessageBox::Icon icon, const QString & title, const QString & text, QFlags<QMessageBox::StandardButton> buttons, QWidget * parent, QFlags<Qt::WindowType> flags) : QMessageBox(icon, title, text, buttons, parent, flags), m_metaObject(0) {
    // ... middle
}

QMessageBoxWrapper::QMessageBoxWrapper(QWidget * parent) : QMessageBox(parent), m_metaObject(0) {
    // ... middle
}

void QMessageBoxWrapper::accept()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "accept"));
    if (py_override.isNull()) {
        return this->QDialog::accept();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QMessageBox::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QMessageBox::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMessageBoxWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::done(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "done"));
    if (py_override.isNull()) {
        return this->QDialog::done(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMessageBoxWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QMessageBox::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMessageBoxWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMessageBoxWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMessageBoxWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QMessageBoxWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QMessageBox::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMessageBoxWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QMessageBoxWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QMessageBoxWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QMessageBoxWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::reject()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reject"));
    if (py_override.isNull()) {
        return this->QDialog::reject();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QMessageBox::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QDialog::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QMessageBox::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QMessageBoxWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QMessageBox::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMessageBox.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMessageBoxWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageBoxWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageBoxWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMessageBoxWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMessageBox::staticMetaObject);
}
    return m_metaObject;
}

int QMessageBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMessageBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMessageBoxWrapper::~QMessageBoxWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMessageBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMessageBoxWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQMessageBox_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMessageBox", 0, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (numArgs == 0) {
        // QMessageBox(QWidget*)
        cptr = new QMessageBoxWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QMessageBox(QWidget*)
        cptr = new QMessageBoxWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QMessageBox::Icon >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        QMessageBox::Icon cpp_arg0 = Shiboken::Converter<QMessageBox::Icon >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // QMessageBox(QMessageBox::Icon,QString,QString,QFlags<QMessageBox::StandardButton>,QWidget*,QFlags<Qt::WindowType>)
            cptr = new QMessageBoxWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2);
            Shiboken::setParent(pyargs[4], self);
        } else if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(pyargs[3])) {
            QFlags<QMessageBox::StandardButton> cpp_arg3 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // QMessageBox(QMessageBox::Icon,QString,QString,QFlags<QMessageBox::StandardButton>,QWidget*,QFlags<Qt::WindowType>)
                cptr = new QMessageBoxWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                Shiboken::setParent(pyargs[4], self);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return -1;
                QWidget* cpp_arg4 = Shiboken::Converter<QWidget* >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // QMessageBox(QMessageBox::Icon,QString,QString,QFlags<QMessageBox::StandardButton>,QWidget*,QFlags<Qt::WindowType>)
                    cptr = new QMessageBoxWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                    Shiboken::setParent(pyargs[4], self);
                } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[5])) {
                    QFlags<Qt::WindowType> cpp_arg5 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[5]);
                    // QMessageBox(QMessageBox::Icon,QString,QString,QFlags<QMessageBox::StandardButton>,QWidget*,QFlags<Qt::WindowType>)
                    cptr = new QMessageBoxWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                    Shiboken::setParent(pyargs[4], self);
                } else goto SbkQMessageBox_Init_TypeError;
            } else goto SbkQMessageBox_Init_TypeError;
        } else goto SbkQMessageBox_Init_TypeError;
    } else goto SbkQMessageBox_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMessageBox_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQMessageBox_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMessageBox.Icon, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButtons = QMessageBox.NoButton, PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = Qt.Dialog | Qt.MSWindowsFixedSizeDialogHint", "PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox", overloads);
        return -1;
}

static PyObject*
SbkQMessageBoxFunc_about(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "about", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // about(QWidget*,QString,QString)
        QMessageBox::about(cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQMessageBoxFunc_about_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_about_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.about", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_aboutQt(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "aboutQt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // aboutQt(QWidget*,QString)
            QMessageBox::aboutQt(cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // aboutQt(QWidget*,QString)
            QMessageBox::aboutQt(cpp_arg0, *cpp_arg1);
        } else goto SbkQMessageBoxFunc_aboutQt_TypeError;
    } else goto SbkQMessageBoxFunc_aboutQt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_aboutQt_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.aboutQt", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_addButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addButton", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QMessageBox::ButtonRole >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QMessageBox::ButtonRole cpp_arg1 = Shiboken::Converter<QMessageBox::ButtonRole >::toCpp(pyargs[1]);
        // addButton(QString,QMessageBox::ButtonRole)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        QPushButton * cpp_result = cppSelf->QMessageBox::addButton(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPushButton* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[0])) {
        QMessageBox::StandardButton cpp_arg0 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[0]);
        // addButton(QMessageBox::StandardButton)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        QPushButton * cpp_result = cppSelf->QMessageBox::addButton(cpp_arg0);
        py_result = Shiboken::Converter<QPushButton* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 2 && Shiboken::Converter<QAbstractButton* >::isConvertible(pyargs[0]) && Shiboken::Converter<QMessageBox::ButtonRole >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(pyargs[0]);
        QMessageBox::ButtonRole cpp_arg1 = Shiboken::Converter<QMessageBox::ButtonRole >::toCpp(pyargs[1]);
        // addButton(QAbstractButton*,QMessageBox::ButtonRole)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::addButton(cpp_arg0, cpp_arg1);
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQMessageBoxFunc_addButton_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_addButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton, PySide.QtGui.QMessageBox.ButtonRole", "PySide.QtGui.QMessageBox.StandardButton", "PySide.QtCore.QString, PySide.QtGui.QMessageBox.ButtonRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.addButton", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_button(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(arg)) {
        QMessageBox::StandardButton cpp_arg0 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(arg);
        // button(QMessageBox::StandardButton)const
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        QAbstractButton * cpp_result = cppSelf->QMessageBox::button(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractButton* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQMessageBoxFunc_button_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_button_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMessageBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.button", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_buttonRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // buttonRole(QAbstractButton*)const
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        QMessageBox::ButtonRole cpp_result = cppSelf->QMessageBox::buttonRole(cpp_arg0);
        py_result = Shiboken::Converter<QMessageBox::ButtonRole >::toPython(cpp_result);
    } else goto SbkQMessageBoxFunc_buttonRole_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_buttonRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.buttonRole", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QList<QAbstractButton * > cpp_result = cppSelf->QMessageBox::buttons();
    py_result = Shiboken::Converter<QList<QAbstractButton * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::changeEvent(cpp_arg0);
    } else goto SbkQMessageBoxFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_clickedButton(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clickedButton()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QAbstractButton * cpp_result = cppSelf->QMessageBox::clickedButton();
    py_result = Shiboken::Converter<QAbstractButton* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_closeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCloseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCloseEvent* cpp_arg0 = Shiboken::Converter<QCloseEvent* >::toCpp(arg);
        // closeEvent(QCloseEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::closeEvent(cpp_arg0);
    } else goto SbkQMessageBoxFunc_closeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_closeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCloseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.closeEvent", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_critical(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "critical", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // critical(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
            thread_state_saver.save();
            QMessageBox::StandardButton cpp_result = QMessageBox::critical(cpp_arg0, *cpp_arg1, *cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
        } else if (numArgs == 5 && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[3]) && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
            QMessageBox::StandardButton cpp_arg3 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[3]);
            QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
            // critical(QWidget*,QString,QString,QMessageBox::StandardButton,QMessageBox::StandardButton)
            int cpp_result = QMessageBox::critical(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(pyargs[3])) {
            QFlags<QMessageBox::StandardButton> cpp_arg3 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // critical(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::critical(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
                QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
                // critical(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::critical(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else goto SbkQMessageBoxFunc_critical_TypeError;
        } else goto SbkQMessageBoxFunc_critical_TypeError;
    } else goto SbkQMessageBoxFunc_critical_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_critical_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButtons = QMessageBox.Ok, PySide.QtGui.QMessageBox.StandardButton = NoButton", "PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButton, PySide.QtGui.QMessageBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.critical", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_defaultButton(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultButton()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QPushButton * cpp_result = cppSelf->QMessageBox::defaultButton();
    py_result = Shiboken::Converter<QPushButton* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_detailedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // detailedText()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMessageBox::detailedText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_escapeButton(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // escapeButton()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QAbstractButton * cpp_result = cppSelf->QMessageBox::escapeButton();
    py_result = Shiboken::Converter<QAbstractButton* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMessageBox::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMessageBoxFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.event", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_exec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exec()
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMessageBox::exec();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QMessageBox::Icon cpp_result = cppSelf->QMessageBox::icon();
    py_result = Shiboken::Converter<QMessageBox::Icon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_iconPixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconPixmap()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QMessageBox::iconPixmap();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_information(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "information", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // information(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
            thread_state_saver.save();
            QMessageBox::StandardButton cpp_result = QMessageBox::information(cpp_arg0, *cpp_arg1, *cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
        } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[3])) {
            QMessageBox::StandardButton cpp_arg3 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // information(QWidget*,QString,QString,QMessageBox::StandardButton,QMessageBox::StandardButton)
                QMessageBox::StandardButton cpp_result = QMessageBox::information(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
                QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
                // information(QWidget*,QString,QString,QMessageBox::StandardButton,QMessageBox::StandardButton)
                QMessageBox::StandardButton cpp_result = QMessageBox::information(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else goto SbkQMessageBoxFunc_information_TypeError;
        } else if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(pyargs[3])) {
            QFlags<QMessageBox::StandardButton> cpp_arg3 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // information(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::information(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
                QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
                // information(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::information(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else goto SbkQMessageBoxFunc_information_TypeError;
        } else goto SbkQMessageBoxFunc_information_TypeError;
    } else goto SbkQMessageBoxFunc_information_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_information_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButtons = QMessageBox.Ok, PySide.QtGui.QMessageBox.StandardButton = NoButton", "PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButton, PySide.QtGui.QMessageBox.StandardButton = NoButton", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.information", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_informativeText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // informativeText()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMessageBox::informativeText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::keyPressEvent(cpp_arg0);
    } else goto SbkQMessageBoxFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQMessageBoxFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // open()
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::open();
    } else if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // open(QObject*,const char*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::open(cpp_arg0, cpp_arg1);
    } else goto SbkQMessageBoxFunc_open_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_open_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.open", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_question(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "question", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // question(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
            thread_state_saver.save();
            QMessageBox::StandardButton cpp_result = QMessageBox::question(cpp_arg0, *cpp_arg1, *cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
        } else if (numArgs == 5 && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[3]) && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
            QMessageBox::StandardButton cpp_arg3 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[3]);
            QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
            // question(QWidget*,QString,QString,QMessageBox::StandardButton,QMessageBox::StandardButton)
            int cpp_result = QMessageBox::question(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(pyargs[3])) {
            QFlags<QMessageBox::StandardButton> cpp_arg3 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // question(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::question(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
                QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
                // question(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::question(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else goto SbkQMessageBoxFunc_question_TypeError;
        } else goto SbkQMessageBoxFunc_question_TypeError;
    } else goto SbkQMessageBoxFunc_question_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_question_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButtons = QMessageBox.Ok, PySide.QtGui.QMessageBox.StandardButton = NoButton", "PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButton, PySide.QtGui.QMessageBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.question", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_removeButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // removeButton(QAbstractButton*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::removeButton(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQMessageBoxFunc_removeButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_removeButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.removeButton", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::resizeEvent(cpp_arg0);
    } else goto SbkQMessageBoxFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setDefaultButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPushButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPushButton* cpp_arg0 = Shiboken::Converter<QPushButton* >::toCpp(arg);
        // setDefaultButton(QPushButton*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setDefaultButton(cpp_arg0);
    } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(arg)) {
        QMessageBox::StandardButton cpp_arg0 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(arg);
        // setDefaultButton(QMessageBox::StandardButton)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setDefaultButton(cpp_arg0);
    } else goto SbkQMessageBoxFunc_setDefaultButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setDefaultButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMessageBox.StandardButton", "PySide.QtGui.QPushButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setDefaultButton", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setDetailedText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDetailedText(QString)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setDetailedText(*cpp_arg0);
    } else goto SbkQMessageBoxFunc_setDetailedText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setDetailedText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setDetailedText", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setEscapeButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(arg)) {
        QMessageBox::StandardButton cpp_arg0 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(arg);
        // setEscapeButton(QMessageBox::StandardButton)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setEscapeButton(cpp_arg0);
    } else if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // setEscapeButton(QAbstractButton*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setEscapeButton(cpp_arg0);
    } else goto SbkQMessageBoxFunc_setEscapeButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setEscapeButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", "PySide.QtGui.QMessageBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setEscapeButton", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMessageBox::Icon >::isConvertible(arg)) {
        QMessageBox::Icon cpp_arg0 = Shiboken::Converter<QMessageBox::Icon >::toCpp(arg);
        // setIcon(QMessageBox::Icon)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setIcon(cpp_arg0);
    } else goto SbkQMessageBoxFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMessageBox.Icon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setIcon", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setIconPixmap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPixmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(arg);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // setIconPixmap(QPixmap)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setIconPixmap(*cpp_arg0);
    } else goto SbkQMessageBoxFunc_setIconPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setIconPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setIconPixmap", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setInformativeText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setInformativeText(QString)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setInformativeText(*cpp_arg0);
    } else goto SbkQMessageBoxFunc_setInformativeText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setInformativeText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setInformativeText", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setStandardButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(arg)) {
        QFlags<QMessageBox::StandardButton> cpp_arg0 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(arg);
        // setStandardButtons(QFlags<QMessageBox::StandardButton>)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setStandardButtons(cpp_arg0);
    } else goto SbkQMessageBoxFunc_setStandardButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setStandardButtons_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMessageBox.StandardButtons", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setStandardButtons", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setText(*cpp_arg0);
    } else goto SbkQMessageBoxFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setText", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_setTextFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextFormat >::isConvertible(arg)) {
        Qt::TextFormat cpp_arg0 = Shiboken::Converter<Qt::TextFormat >::toCpp(arg);
        // setTextFormat(Qt::TextFormat)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::setTextFormat(cpp_arg0);
    } else goto SbkQMessageBoxFunc_setTextFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_setTextFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.setTextFormat", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        cppSelf->QMessageBox::showEvent(cpp_arg0);
    } else goto SbkQMessageBoxFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMessageBoxFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMessageBox::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_standardButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // standardButton(QAbstractButton*)const
        QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
        QMessageBox::StandardButton cpp_result = cppSelf->QMessageBox::standardButton(cpp_arg0);
        py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
    } else goto SbkQMessageBoxFunc_standardButton_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_standardButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMessageBox.standardButton", overloads);
        return 0;
}

static PyObject*
SbkQMessageBoxFunc_standardButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // standardButtons()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QFlags<QMessageBox::StandardButton> cpp_result = cppSelf->QMessageBox::standardButtons();
    py_result = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMessageBox::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_textFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textFormat()const
    QMessageBox* cppSelf = Shiboken::Converter<QMessageBox* >::toCpp((PyObject*)self);
    Qt::TextFormat cpp_result = cppSelf->QMessageBox::textFormat();
    py_result = Shiboken::Converter<Qt::TextFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMessageBoxFunc_warning(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "warning", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // warning(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
            thread_state_saver.save();
            QMessageBox::StandardButton cpp_result = QMessageBox::warning(cpp_arg0, *cpp_arg1, *cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
        } else if (numArgs == 5 && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[3]) && Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
            QMessageBox::StandardButton cpp_arg3 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[3]);
            QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
            // warning(QWidget*,QString,QString,QMessageBox::StandardButton,QMessageBox::StandardButton)
            int cpp_result = QMessageBox::warning(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (SbkPySide_QtGui_QMessageBox_StandardButton_Check(pyargs[3])) {
            QFlags<QMessageBox::StandardButton> cpp_arg3 = Shiboken::Converter<QFlags<QMessageBox::StandardButton> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // warning(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::warning(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else if (Shiboken::Converter<QMessageBox::StandardButton >::isConvertible(pyargs[4])) {
                QMessageBox::StandardButton cpp_arg4 = Shiboken::Converter<QMessageBox::StandardButton >::toCpp(pyargs[4]);
                // warning(QWidget*,QString,QString,QFlags<QMessageBox::StandardButton>,QMessageBox::StandardButton)
                thread_state_saver.save();
                QMessageBox::StandardButton cpp_result = QMessageBox::warning(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QMessageBox::StandardButton >::toPython(cpp_result);
            } else goto SbkQMessageBoxFunc_warning_TypeError;
        } else goto SbkQMessageBoxFunc_warning_TypeError;
    } else goto SbkQMessageBoxFunc_warning_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMessageBoxFunc_warning_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButtons = QMessageBox.Ok, PySide.QtGui.QMessageBox.StandardButton = NoButton", "PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QMessageBox.StandardButton, PySide.QtGui.QMessageBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMessageBox.warning", overloads);
        return 0;
}

static PyMethodDef SbkQMessageBox_methods[] = {
    {"about", (PyCFunction)SbkQMessageBoxFunc_about, METH_VARARGS|METH_STATIC},
    {"aboutQt", (PyCFunction)SbkQMessageBoxFunc_aboutQt, METH_VARARGS|METH_STATIC},
    {"addButton", (PyCFunction)SbkQMessageBoxFunc_addButton, METH_VARARGS},
    {"button", (PyCFunction)SbkQMessageBoxFunc_button, METH_O},
    {"buttonRole", (PyCFunction)SbkQMessageBoxFunc_buttonRole, METH_O},
    {"buttons", (PyCFunction)SbkQMessageBoxFunc_buttons, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQMessageBoxFunc_changeEvent, METH_O},
    {"clickedButton", (PyCFunction)SbkQMessageBoxFunc_clickedButton, METH_NOARGS},
    {"closeEvent", (PyCFunction)SbkQMessageBoxFunc_closeEvent, METH_O},
    {"critical", (PyCFunction)SbkQMessageBoxFunc_critical, METH_VARARGS|METH_STATIC},
    {"defaultButton", (PyCFunction)SbkQMessageBoxFunc_defaultButton, METH_NOARGS},
    {"detailedText", (PyCFunction)SbkQMessageBoxFunc_detailedText, METH_NOARGS},
    {"escapeButton", (PyCFunction)SbkQMessageBoxFunc_escapeButton, METH_NOARGS},
    {"event", (PyCFunction)SbkQMessageBoxFunc_event, METH_O},
    {"exec", (PyCFunction)SbkQMessageBoxFunc_exec, METH_NOARGS},
    {"icon", (PyCFunction)SbkQMessageBoxFunc_icon, METH_NOARGS},
    {"iconPixmap", (PyCFunction)SbkQMessageBoxFunc_iconPixmap, METH_NOARGS},
    {"information", (PyCFunction)SbkQMessageBoxFunc_information, METH_VARARGS|METH_STATIC},
    {"informativeText", (PyCFunction)SbkQMessageBoxFunc_informativeText, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQMessageBoxFunc_keyPressEvent, METH_O},
    {"open", (PyCFunction)SbkQMessageBoxFunc_open, METH_VARARGS},
    {"question", (PyCFunction)SbkQMessageBoxFunc_question, METH_VARARGS|METH_STATIC},
    {"removeButton", (PyCFunction)SbkQMessageBoxFunc_removeButton, METH_O},
    {"resizeEvent", (PyCFunction)SbkQMessageBoxFunc_resizeEvent, METH_O},
    {"setDefaultButton", (PyCFunction)SbkQMessageBoxFunc_setDefaultButton, METH_O},
    {"setDetailedText", (PyCFunction)SbkQMessageBoxFunc_setDetailedText, METH_O},
    {"setEscapeButton", (PyCFunction)SbkQMessageBoxFunc_setEscapeButton, METH_O},
    {"setIcon", (PyCFunction)SbkQMessageBoxFunc_setIcon, METH_O},
    {"setIconPixmap", (PyCFunction)SbkQMessageBoxFunc_setIconPixmap, METH_O},
    {"setInformativeText", (PyCFunction)SbkQMessageBoxFunc_setInformativeText, METH_O},
    {"setStandardButtons", (PyCFunction)SbkQMessageBoxFunc_setStandardButtons, METH_O},
    {"setText", (PyCFunction)SbkQMessageBoxFunc_setText, METH_O},
    {"setTextFormat", (PyCFunction)SbkQMessageBoxFunc_setTextFormat, METH_O},
    {"showEvent", (PyCFunction)SbkQMessageBoxFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQMessageBoxFunc_sizeHint, METH_NOARGS},
    {"standardButton", (PyCFunction)SbkQMessageBoxFunc_standardButton, METH_O},
    {"standardButtons", (PyCFunction)SbkQMessageBoxFunc_standardButtons, METH_NOARGS},
    {"text", (PyCFunction)SbkQMessageBoxFunc_text, METH_NOARGS},
    {"textFormat", (PyCFunction)SbkQMessageBoxFunc_textFormat, METH_NOARGS},
    {"warning", (PyCFunction)SbkQMessageBoxFunc_warning, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMessageBoxSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QMessageBox* me = reinterpret_cast<QMessageBox*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX]))
        return static_cast<QDialog*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMessageBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMessageBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMessageBoxWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMessageBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMessageBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQMessageBoxSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QMessageBox_ButtonRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMessageBox_ButtonRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMessageBox_ButtonRole_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ButtonRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMessageBox_ButtonRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMessageBox_ButtonRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMessageBox_ButtonRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QMessageBox_StandardButton___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMessageBox::StandardButtons >::toPython(
        ((QMessageBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QMessageBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMessageBox_StandardButton___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMessageBox::StandardButtons >::toPython(
        ((QMessageBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QMessageBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMessageBox_StandardButton___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMessageBox::StandardButtons >::toPython(
        ((QMessageBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QMessageBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMessageBox_StandardButton___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMessageBox::StandardButtons >::toPython(
        ~ Shiboken::Converter< QMessageBox::StandardButtons >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QMessageBox_StandardButton_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QMessageBox_StandardButton___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QMessageBox_StandardButton___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QMessageBox_StandardButton___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QMessageBox_StandardButton___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QMessageBox_StandardButton_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMessageBox_StandardButton_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMessageBox_StandardButton_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardButton",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QMessageBox_StandardButton_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMessageBox_StandardButton_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMessageBox_StandardButton_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMessageBox_StandardButton_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMessageBox_StandardButtons_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMessageBox_StandardButtons_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardButtons",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QMessageBox_StandardButton_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMessageBox_StandardButtons_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMessageBox_StandardButtons_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QMessageBox_StandardButtons_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QMessageBox_Icon_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMessageBox_Icon_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMessageBox_Icon_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Icon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMessageBox_Icon_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMessageBox_Icon_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMessageBox_Icon_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QMessageBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMessageBox_Type);

    SbkQMessageBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX];
    SbkQMessageBox_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQMessageBox_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMessageBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMessageBox_Type));
    PyModule_AddObject(module, "QMessageBox",
        ((PyObject*)&SbkQMessageBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ButtonRole
    SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_BUTTONROLE_IDX] = &SbkPySide_QtGui_QMessageBox_ButtonRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMessageBox_ButtonRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type);
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
            "ButtonRole",((PyObject*)&SbkPySide_QtGui_QMessageBox_ButtonRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::InvalidRole, "InvalidRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "InvalidRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "InvalidRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::AcceptRole, "AcceptRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "AcceptRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "AcceptRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::RejectRole, "RejectRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "RejectRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "RejectRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::DestructiveRole, "DestructiveRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "DestructiveRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "DestructiveRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::ActionRole, "ActionRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "ActionRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "ActionRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::HelpRole, "HelpRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "HelpRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "HelpRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::YesRole, "YesRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "YesRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "YesRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::NoRole, "NoRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NoRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "NoRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::ResetRole, "ResetRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "ResetRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "ResetRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::ApplyRole, "ApplyRole");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "ApplyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "ApplyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_ButtonRole_Type,
        (long) QMessageBox::NRoles, "NRoles");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NRoles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_ButtonRole_Type.tp_dict,
        "NRoles", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMessageBox::ButtonRole");

    // init enum class: StandardButton
    SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_STANDARDBUTTON_IDX] = &SbkPySide_QtGui_QMessageBox_StandardButton_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMessageBox_StandardButton_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMessageBox_StandardButton_Type);
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
            "StandardButton",((PyObject*)&SbkPySide_QtGui_QMessageBox_StandardButton_Type));

    // init flags class: QFlags<QMessageBox::StandardButton>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QMESSAGEBOX_STANDARDBUTTON__IDX] = &SbkPySide_QtGui_QMessageBox_StandardButtons_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMessageBox_StandardButtons_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMessageBox_StandardButtons_Type);
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
            "StandardButtons",((PyObject*)&SbkPySide_QtGui_QMessageBox_StandardButtons_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::NoButton, "NoButton");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NoButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "NoButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Ok, "Ok");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Ok", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Ok", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Save, "Save");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Save", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Save", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::SaveAll, "SaveAll");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "SaveAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "SaveAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Open, "Open");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Yes, "Yes");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Yes", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Yes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::YesToAll, "YesToAll");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "YesToAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "YesToAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::No, "No");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "No", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "No", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::NoToAll, "NoToAll");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NoToAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "NoToAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Abort, "Abort");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Abort", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Abort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Retry, "Retry");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Retry", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Retry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Ignore, "Ignore");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Ignore", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Ignore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Close, "Close");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Cancel, "Cancel");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Cancel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Cancel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Discard, "Discard");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Discard", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Discard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Help, "Help");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Help", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Help", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Apply, "Apply");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Apply", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Apply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Reset, "Reset");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Reset", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Reset", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::RestoreDefaults, "RestoreDefaults");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "RestoreDefaults", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "RestoreDefaults", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::FirstButton, "FirstButton");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "FirstButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "FirstButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::LastButton, "LastButton");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "LastButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "LastButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::YesAll, "YesAll");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "YesAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "YesAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::NoAll, "NoAll");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NoAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "NoAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Default, "Default");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Default", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Default", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::Escape, "Escape");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Escape", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "Escape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::FlagMask, "FlagMask");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "FlagMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "FlagMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_StandardButton_Type,
        (long) QMessageBox::ButtonMask, "ButtonMask");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "ButtonMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_StandardButton_Type.tp_dict,
        "ButtonMask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMessageBox::StandardButton");

    // init enum class: Icon
    SbkPySide_QtGuiTypes[SBK_QMESSAGEBOX_ICON_IDX] = &SbkPySide_QtGui_QMessageBox_Icon_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMessageBox_Icon_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMessageBox_Icon_Type);
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
            "Icon",((PyObject*)&SbkPySide_QtGui_QMessageBox_Icon_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_Icon_Type,
        (long) QMessageBox::NoIcon, "NoIcon");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "NoIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_Icon_Type.tp_dict,
        "NoIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_Icon_Type,
        (long) QMessageBox::Information, "Information");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Information", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_Icon_Type.tp_dict,
        "Information", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_Icon_Type,
        (long) QMessageBox::Warning, "Warning");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Warning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_Icon_Type.tp_dict,
        "Warning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_Icon_Type,
        (long) QMessageBox::Critical, "Critical");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Critical", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_Icon_Type.tp_dict,
        "Critical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMessageBox_Icon_Type,
        (long) QMessageBox::Question, "Question");
    PyDict_SetItemString(SbkQMessageBox_Type.super.ht_type.tp_dict,
        "Question", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMessageBox_Icon_Type.tp_dict,
        "Question", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMessageBox::Icon");

    Shiboken::TypeResolver::createObjectTypeResolver<QMessageBox >("QMessageBox*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMessageBox >(typeid(QMessageBox).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

