/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmatrix3x3_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QMatrix3x3Wrapper::QMatrix3x3Wrapper() : QMatrix3x3() {
    // ... middle
}

QMatrix3x3Wrapper::~QMatrix3x3Wrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQMatrix3x3_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMatrix3x3Wrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QMatrix3x3()
    cptr = new QMatrix3x3Wrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyMethodDef SbkQMatrix3x3_methods[] = {
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMatrix3x3_ObjCopierFunc(const void* ptr){
    return new QMatrix3x3Wrapper(*reinterpret_cast<const QMatrix3x3*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMatrix3x3_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMatrix3x3",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMatrix3x3Wrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMatrix3x3_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMatrix3x3_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQMatrix3x3_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQMatrix3x3_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQMatrix3x3_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QMatrix3x3*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QMatrix3x3(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMATRIX3X3_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMatrix3x3_Type);

    // Fill type discovery information
    SbkQMatrix3x3_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQMatrix3x3_Type.type_discovery->addTypeDiscoveryFunction(&SbkQMatrix3x3_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQMatrix3x3_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMatrix3x3_Type));
    PyModule_AddObject(module, "QMatrix3x3",
        ((PyObject*)&SbkQMatrix3x3_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMatrix3x3 >("QMatrix3x3");
    Shiboken::TypeResolver::createValueTypeResolver<QMatrix3x3 >(typeid(QMatrix3x3).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

