/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qlistwidgetitem_wrapper.h"

// Extra includes
#include <qbrush.h>
#include <qdatastream.h>
#include <qfont.h>
#include <qicon.h>
#include <qlistwidget.h>
#include <qsize.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QListWidgetItemWrapper::QListWidgetItemWrapper(QListWidget * view, int type) : QListWidgetItem(view, type) {
    // ... middle
}

QListWidgetItemWrapper::QListWidgetItemWrapper(const QIcon & icon, const QString & text, QListWidget * view, int type) : QListWidgetItem(icon, text, view, type) {
    // ... middle
}

QListWidgetItemWrapper::QListWidgetItemWrapper(const QString & text, QListWidget * view, int type) : QListWidgetItem(text, view, type) {
    // ... middle
}

QListWidgetItem * QListWidgetItemWrapper::clone() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clone"));
    if (py_override.isNull()) {
        return this->QListWidgetItem::clone();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QListWidgetItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidgetItem.clone");
        return 0        ;
    }
    QListWidgetItem* cpp_result(Shiboken::Converter<QListWidgetItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QVariant QListWidgetItemWrapper::data(int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QListWidgetItem::data(role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidgetItem.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetItemWrapper::setData(int role, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QListWidgetItem::setData(role, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        role,
        Shiboken::Converter<QVariant& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QListWidgetItemWrapper::~QListWidgetItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQListWidgetItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QListWidgetItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QListWidgetItem", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QListWidgetItem(QListWidget*,int)
        cptr = new QListWidgetItemWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QListWidgetItem(QString,QListWidget*,int)
            cptr = new QListWidgetItemWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QListWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QListWidget* cpp_arg1 = Shiboken::Converter<QListWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QListWidgetItem(QString,QListWidget*,int)
                cptr = new QListWidgetItemWrapper(*cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[1], self);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QListWidgetItem(QString,QListWidget*,int)
                cptr = new QListWidgetItemWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[1], self);
            } else goto SbkQListWidgetItem_Init_TypeError;
        } else goto SbkQListWidgetItem_Init_TypeError;
    } else if (Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // QListWidgetItem(QIcon,QString,QListWidget*,int)
            cptr = new QListWidgetItemWrapper(*cpp_arg0, *cpp_arg1);
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QListWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QListWidget* cpp_arg2 = Shiboken::Converter<QListWidget* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QListWidgetItem(QIcon,QString,QListWidget*,int)
                cptr = new QListWidgetItemWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // QListWidgetItem(QIcon,QString,QListWidget*,int)
                cptr = new QListWidgetItemWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQListWidgetItem_Init_TypeError;
        } else goto SbkQListWidgetItem_Init_TypeError;
    } else if (Shiboken::Converter<QListWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QListWidget* cpp_arg0 = Shiboken::Converter<QListWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QListWidgetItem(QListWidget*,int)
            cptr = new QListWidgetItemWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[0], self);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QListWidgetItem(QListWidget*,int)
            cptr = new QListWidgetItemWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQListWidgetItem_Init_TypeError;
    } else goto SbkQListWidgetItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQListWidgetItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQListWidgetItem_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidget = None, int = Type", "PySide.QtGui.QIcon, PySide.QtCore.QString, PySide.QtGui.QListWidget = None, int = Type", "PySide.QtCore.QString, PySide.QtGui.QListWidget = None, int = Type", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidgetItem", overloads);
        return -1;
}

static PyObject*
SbkQListWidgetItemFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QListWidgetItem::background();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_checkState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // checkState()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    Qt::CheckState cpp_result = cppSelf->QListWidgetItem::checkState();
    py_result = Shiboken::Converter<Qt::CheckState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QListWidgetItem * cpp_result = cppSelf->QListWidgetItem::clone();
    py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // data(int)const
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QListWidgetItem::data(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQListWidgetItemFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetItemFunc_data_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.data", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QFlags<Qt::ItemFlag> cpp_result = cppSelf->QListWidgetItem::flags();
    py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QListWidgetItem::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_foreground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foreground()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QListWidgetItem::foreground();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QListWidgetItem::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_isHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHidden()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListWidgetItem::isHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_isSelected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelected()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListWidgetItem::isSelected();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_listWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // listWidget()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QListWidget * cpp_result = cppSelf->QListWidgetItem::listWidget();
    py_result = Shiboken::Converter<QListWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setBackground(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setBackground", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setCheckState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CheckState >::isConvertible(arg)) {
        Qt::CheckState cpp_arg0 = Shiboken::Converter<Qt::CheckState >::toCpp(arg);
        // setCheckState(Qt::CheckState)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setCheckState(cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setCheckState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setCheckState_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CheckState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setCheckState", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setData(int,QVariant)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setData(cpp_arg0, *cpp_arg1);
    } else goto SbkQListWidgetItemFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidgetItem.setData", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_ItemFlag_Check(arg)) {
        QFlags<Qt::ItemFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(arg);
        // setFlags(QFlags<Qt::ItemFlag>)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setFlags(cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ItemFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setFlags", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setFont(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setFont", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setForeground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForeground(QBrush)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setForeground(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setForeground", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHidden(bool)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setHidden(cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setHidden_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setHidden", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setIcon(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setIcon", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setSelected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelected(bool)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setSelected(cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setSelected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setSelected_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setSelected", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setSizeHint(QSize)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setSizeHint(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setSizeHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setSizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setSizeHint", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setStatusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStatusTip(QString)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setStatusTip(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setStatusTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setStatusTip", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setText(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setText", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setTextAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTextAlignment(int)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setTextAlignment(cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setTextAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setTextAlignment_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setTextAlignment", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setToolTip(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setToolTip", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QListWidgetItem::setWhatsThis(*cpp_arg0);
    } else goto SbkQListWidgetItemFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetItemFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.setWhatsThis", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QListWidgetItem::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_statusTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusTip()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QListWidgetItem::statusTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QListWidgetItem::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_textAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textAlignment()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListWidgetItem::textAlignment();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QListWidgetItem::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListWidgetItem::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetItemFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QListWidgetItem::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQListWidgetItem_methods[] = {
    {"background", (PyCFunction)SbkQListWidgetItemFunc_background, METH_NOARGS},
    {"checkState", (PyCFunction)SbkQListWidgetItemFunc_checkState, METH_NOARGS},
    {"clone", (PyCFunction)SbkQListWidgetItemFunc_clone, METH_NOARGS},
    {"data", (PyCFunction)SbkQListWidgetItemFunc_data, METH_O},
    {"flags", (PyCFunction)SbkQListWidgetItemFunc_flags, METH_NOARGS},
    {"font", (PyCFunction)SbkQListWidgetItemFunc_font, METH_NOARGS},
    {"foreground", (PyCFunction)SbkQListWidgetItemFunc_foreground, METH_NOARGS},
    {"icon", (PyCFunction)SbkQListWidgetItemFunc_icon, METH_NOARGS},
    {"isHidden", (PyCFunction)SbkQListWidgetItemFunc_isHidden, METH_NOARGS},
    {"isSelected", (PyCFunction)SbkQListWidgetItemFunc_isSelected, METH_NOARGS},
    {"listWidget", (PyCFunction)SbkQListWidgetItemFunc_listWidget, METH_NOARGS},
    {"setBackground", (PyCFunction)SbkQListWidgetItemFunc_setBackground, METH_O},
    {"setCheckState", (PyCFunction)SbkQListWidgetItemFunc_setCheckState, METH_O},
    {"setData", (PyCFunction)SbkQListWidgetItemFunc_setData, METH_VARARGS},
    {"setFlags", (PyCFunction)SbkQListWidgetItemFunc_setFlags, METH_O},
    {"setFont", (PyCFunction)SbkQListWidgetItemFunc_setFont, METH_O},
    {"setForeground", (PyCFunction)SbkQListWidgetItemFunc_setForeground, METH_O},
    {"setHidden", (PyCFunction)SbkQListWidgetItemFunc_setHidden, METH_O},
    {"setIcon", (PyCFunction)SbkQListWidgetItemFunc_setIcon, METH_O},
    {"setSelected", (PyCFunction)SbkQListWidgetItemFunc_setSelected, METH_O},
    {"setSizeHint", (PyCFunction)SbkQListWidgetItemFunc_setSizeHint, METH_O},
    {"setStatusTip", (PyCFunction)SbkQListWidgetItemFunc_setStatusTip, METH_O},
    {"setText", (PyCFunction)SbkQListWidgetItemFunc_setText, METH_O},
    {"setTextAlignment", (PyCFunction)SbkQListWidgetItemFunc_setTextAlignment, METH_O},
    {"setToolTip", (PyCFunction)SbkQListWidgetItemFunc_setToolTip, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQListWidgetItemFunc_setWhatsThis, METH_O},
    {"sizeHint", (PyCFunction)SbkQListWidgetItemFunc_sizeHint, METH_NOARGS},
    {"statusTip", (PyCFunction)SbkQListWidgetItemFunc_statusTip, METH_NOARGS},
    {"text", (PyCFunction)SbkQListWidgetItemFunc_text, METH_NOARGS},
    {"textAlignment", (PyCFunction)SbkQListWidgetItemFunc_textAlignment, METH_NOARGS},
    {"toolTip", (PyCFunction)SbkQListWidgetItemFunc_toolTip, METH_NOARGS},
    {"type", (PyCFunction)SbkQListWidgetItemFunc_type, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQListWidgetItemFunc_whatsThis, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQListWidgetItemFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQListWidgetItem_Check(arg) && !SbkQListWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QListWidgetItem) [reverse operator]
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetItemFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetItemFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetItemFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQListWidgetItem_Check(arg) && !SbkQListWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QListWidgetItem&) [reverse operator]
        QListWidgetItem* cppSelf = Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetItemFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetItemFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidgetItem.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQListWidgetItem_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQListWidgetItemFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQListWidgetItemFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQListWidgetItem_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QListWidgetItem& cpp_self = *Shiboken::Converter<QListWidgetItem* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQListWidgetItem_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQListWidgetItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QListWidgetItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QListWidgetItemWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQListWidgetItem_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQListWidgetItem_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQListWidgetItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQListWidgetItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQListWidgetItem_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQListWidgetItem_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QListWidgetItem*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QListWidgetItem_ItemType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListWidgetItem_ItemType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListWidgetItem_ItemType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListWidgetItem_ItemType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListWidgetItem_ItemType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListWidgetItem_ItemType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QListWidgetItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQListWidgetItem_Type);

    // Fill type discovery information
    SbkQListWidgetItem_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQListWidgetItem_Type.type_discovery->addTypeDiscoveryFunction(&SbkQListWidgetItem_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQListWidgetItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQListWidgetItem_Type));
    PyModule_AddObject(module, "QListWidgetItem",
        ((PyObject*)&SbkQListWidgetItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ItemType
    SbkPySide_QtGuiTypes[SBK_QLISTWIDGETITEM_ITEMTYPE_IDX] = &SbkPySide_QtGui_QListWidgetItem_ItemType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListWidgetItem_ItemType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListWidgetItem_ItemType_Type);
    PyDict_SetItemString(SbkQListWidgetItem_Type.super.ht_type.tp_dict,
            "ItemType",((PyObject*)&SbkPySide_QtGui_QListWidgetItem_ItemType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListWidgetItem_ItemType_Type,
        (long) QListWidgetItem::Type, "Type");
    PyDict_SetItemString(SbkQListWidgetItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListWidgetItem_ItemType_Type.tp_dict,
        "Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListWidgetItem_ItemType_Type,
        (long) QListWidgetItem::UserType, "UserType");
    PyDict_SetItemString(SbkQListWidgetItem_Type.super.ht_type.tp_dict,
        "UserType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListWidgetItem_ItemType_Type.tp_dict,
        "UserType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListWidgetItem::ItemType");

    Shiboken::TypeResolver::createObjectTypeResolver<QListWidgetItem >("QListWidgetItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QListWidgetItem >(typeid(QListWidgetItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

