/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qlistwidget_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlistwidget.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QListWidgetWrapper::QListWidgetWrapper(QWidget * parent) : QListWidget(parent), m_metaObject(0) {
    // ... middle
}

void QListWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListWidgetWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QListView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(current),
        Shiboken::Converter<QModelIndex& >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QListView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(topLeft),
        Shiboken::Converter<QModelIndex& >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QListView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QListView::dragLeaveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::dragMoveEvent(QDragMoveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QListView::dragMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QListWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QListWidgetWrapper::dropMimeData(int index, const QMimeData * data, Qt::DropAction action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QListWidget::dropMimeData(index, data, action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOO)",
        index,
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QListWidgetWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.edit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QListWidgetWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QListWidgetWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QListWidget::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QListWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QListWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QListWidgetWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QListView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.horizontalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QListWidgetWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QListView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPoint& >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.indexAt");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QListWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QListWidgetWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QListView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.isIndexHidden");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListWidgetWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QListWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QStringList QListWidgetWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QListWidget::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QSize QListWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::mouseMoveEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QListView::mouseMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QListView::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QListWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QListWidgetWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QListView::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QListView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QListView::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QListView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QListView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QListView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QListView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QListWidgetWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QListView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.selectedIndexes");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QListView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selected),
        Shiboken::Converter<QItemSelection& >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QListWidgetWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.selectionCommand");
        return QFlags<QItemSelectionModel::SelectionFlag>()        ;
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QListWidgetWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QListView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QListView::setSelection(rect, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelectionModel* >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QListWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QListWidgetWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.sizeHintForColumn");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QListWidgetWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.sizeHintForRow");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QListView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::DropAction> QListWidgetWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QListWidget::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListWidgetWrapper::timerEvent(QTimerEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QListView::timerEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QListView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListWidgetWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QListView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.verticalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListWidgetWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QListWidgetWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QListView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.viewOptions");
        return QStyleOptionViewItem()        ;
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QListWidgetWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QListWidgetWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QListView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.visualRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QListWidgetWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QListView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListWidget.visualRegionForSelection");
        return QRegion()        ;
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QListWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QListWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QListWidget::staticMetaObject);
}
    return m_metaObject;
}

int QListWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QListWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QListWidgetWrapper::~QListWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQListWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QListWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QListWidget", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QListWidget(QWidget*)
        cptr = new QListWidgetWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QListWidget(QWidget*)
        cptr = new QListWidgetWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQListWidget_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQListWidget_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQListWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget", overloads);
        return -1;
}

static PyObject*
SbkQListWidgetFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addItem(QString)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::addItem(*cpp_arg0);
    } else if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // addItem(QListWidgetItem*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::addItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQListWidgetFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.addItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_addItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // addItems(QStringList)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::addItems(*cpp_arg0);
    } else goto SbkQListWidgetFunc_addItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_addItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.addItems", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    cppSelf->QListWidget::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQListWidgetFunc_closePersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // closePersistentEditor(QListWidgetItem*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::closePersistentEditor(cpp_arg0);
    } else goto SbkQListWidgetFunc_closePersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_closePersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.closePersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListWidget::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_currentItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentItem()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    QListWidgetItem * cpp_result = cppSelf->QListWidget::currentItem();
    py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_currentRow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentRow()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListWidget::currentRow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::dropEvent(cpp_arg0);
    } else goto SbkQListWidgetFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QMimeData* >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QMimeData* cpp_arg1 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[1]);
        Qt::DropAction cpp_arg2 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[2]);
        // dropMimeData(int,const QMimeData*,Qt::DropAction)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QListWidget::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_dropMimeData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.dropMimeData", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_editItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // editItem(QListWidgetItem*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::editItem(cpp_arg0);
    } else goto SbkQListWidgetFunc_editItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_editItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.editItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QListWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.event", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_findItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "findItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QFlags<Qt::MatchFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[1]);
        // findItems(QString,QFlags<Qt::MatchFlag>)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QList<QListWidgetItem * > cpp_result = cppSelf->QListWidget::findItems(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QList<QListWidgetItem * > >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_findItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_findItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.findItems", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_indexFromItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // indexFromItem(QListWidgetItem*)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QListWidget::indexFromItem(cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_indexFromItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_indexFromItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.indexFromItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_insertItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // insertItem(int,QString)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::insertItem(cpp_arg0, *cpp_arg1);
        } else if (numArgs == 2 && Shiboken::Converter<QListWidgetItem* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QListWidgetItem* cpp_arg1 = Shiboken::Converter<QListWidgetItem* >::toCpp(pyargs[1]);
            // insertItem(int,QListWidgetItem*)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::insertItem(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQListWidgetFunc_insertItem_TypeError;
    } else goto SbkQListWidgetFunc_insertItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_insertItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QListWidgetItem", "int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.insertItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_insertItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QStringList& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // insertItems(int,QStringList)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::insertItems(cpp_arg0, *cpp_arg1);
    } else goto SbkQListWidgetFunc_insertItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_insertItems_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.insertItems", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_isSortingEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSortingEnabled()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListWidget::isSortingEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_item(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // item(int)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QListWidgetItem * cpp_result = cppSelf->QListWidget::item(cpp_arg0);
        py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetFunc_item_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_item_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.item", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemAt(int,int)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QListWidgetItem * cpp_result = cppSelf->QListWidget::itemAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // itemAt(QPoint)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QListWidgetItem * cpp_result = cppSelf->QListWidget::itemAt(*cpp_arg0);
        py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_itemAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_itemFromIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemFromIndex(QModelIndex)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QListWidgetItem * cpp_result = cppSelf->QListWidget::itemFromIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetFunc_itemFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_itemFromIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.itemFromIndex", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_itemWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // itemWidget(QListWidgetItem*)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QListWidget::itemWidget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQListWidgetFunc_itemWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_itemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.itemWidget", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_items(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMimeData* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // items(const QMimeData*)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QList<QListWidgetItem * > cpp_result = cppSelf->QListWidget::items(cpp_arg0);
        py_result = Shiboken::Converter<QList<QListWidgetItem * > >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_items_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_items_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.items", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QListWidget::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_openPersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // openPersistentEditor(QListWidgetItem*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::openPersistentEditor(cpp_arg0);
    } else goto SbkQListWidgetFunc_openPersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_openPersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.openPersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_removeItemWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // removeItemWidget(QListWidgetItem*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::removeItemWidget(cpp_arg0);
        Shiboken::setParent(self, 0);
    } else goto SbkQListWidgetFunc_removeItemWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_removeItemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.removeItemWidget", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_row(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // row(const QListWidgetItem*)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QListWidget::row(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_row_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_row_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.row", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_scrollToItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollToItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollToItem(const QListWidgetItem*,QAbstractItemView::ScrollHint)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::scrollToItem(cpp_arg0);
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollToItem(const QListWidgetItem*,QAbstractItemView::ScrollHint)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::scrollToItem(cpp_arg0, cpp_arg1);
        } else goto SbkQListWidgetFunc_scrollToItem_TypeError;
    } else goto SbkQListWidgetFunc_scrollToItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_scrollToItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.scrollToItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_selectedItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedItems()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    QList<QListWidgetItem * > cpp_result = cppSelf->QListWidget::selectedItems();
    py_result = Shiboken::Converter<QList<QListWidgetItem * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_setCurrentItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setCurrentItem(QListWidgetItem*)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::setCurrentItem(cpp_arg0);
        } else if (numArgs == 2 && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
            QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
            // setCurrentItem(QListWidgetItem*,QFlags<QItemSelectionModel::SelectionFlag>)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::setCurrentItem(cpp_arg0, cpp_arg1);
        } else goto SbkQListWidgetFunc_setCurrentItem_TypeError;
    } else goto SbkQListWidgetFunc_setCurrentItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_setCurrentItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", "PySide.QtGui.QListWidgetItem, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.setCurrentItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_setCurrentRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentRow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setCurrentRow(int)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::setCurrentRow(cpp_arg0);
        } else if (numArgs == 2 && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
            QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
            // setCurrentRow(int,QFlags<QItemSelectionModel::SelectionFlag>)
            QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
            cppSelf->QListWidget::setCurrentRow(cpp_arg0, cpp_arg1);
        } else goto SbkQListWidgetFunc_setCurrentRow_TypeError;
    } else goto SbkQListWidgetFunc_setCurrentRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_setCurrentRow_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.setCurrentRow", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_setItemWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QListWidgetItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // setItemWidget(QListWidgetItem*,QWidget*)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::setItemWidget(cpp_arg0, cpp_arg1);
        Shiboken::setParent(pyargs[0], pyargs[1]);
    } else goto SbkQListWidgetFunc_setItemWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_setItemWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListWidget.setItemWidget", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_setSortingEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSortingEnabled(bool)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::setSortingEnabled(cpp_arg0);
    } else goto SbkQListWidgetFunc_setSortingEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_setSortingEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.setSortingEnabled", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_sortItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // sortItems(Qt::SortOrder)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::sortItems();
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        Qt::SortOrder cpp_arg0 = Shiboken::Converter<Qt::SortOrder >::toCpp(arg);
        // sortItems(Qt::SortOrder)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        cppSelf->QListWidget::sortItems(cpp_arg0);
    } else goto SbkQListWidgetFunc_sortItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListWidgetFunc_sortItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.sortItems", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QListWidget::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListWidgetFunc_takeItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeItem(int)
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QListWidgetItem * cpp_result = cppSelf->QListWidget::takeItem(cpp_arg0);
        py_result = Shiboken::Converter<QListWidgetItem* >::toPython(cpp_result);

        // Ownership transferences.
    } else goto SbkQListWidgetFunc_takeItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_takeItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.takeItem", overloads);
        return 0;
}

static PyObject*
SbkQListWidgetFunc_visualItemRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QListWidgetItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QListWidgetItem* cpp_arg0 = Shiboken::Converter<QListWidgetItem* >::toCpp(arg);
        // visualItemRect(const QListWidgetItem*)const
        QListWidget* cppSelf = Shiboken::Converter<QListWidget* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QListWidget::visualItemRect(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQListWidgetFunc_visualItemRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListWidgetFunc_visualItemRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListWidget.visualItemRect", overloads);
        return 0;
}

static PyMethodDef SbkQListWidget_methods[] = {
    {"addItem", (PyCFunction)SbkQListWidgetFunc_addItem, METH_O},
    {"addItems", (PyCFunction)SbkQListWidgetFunc_addItems, METH_O},
    {"clear", (PyCFunction)SbkQListWidgetFunc_clear, METH_NOARGS},
    {"closePersistentEditor", (PyCFunction)SbkQListWidgetFunc_closePersistentEditor, METH_O},
    {"count", (PyCFunction)SbkQListWidgetFunc_count, METH_NOARGS},
    {"currentItem", (PyCFunction)SbkQListWidgetFunc_currentItem, METH_NOARGS},
    {"currentRow", (PyCFunction)SbkQListWidgetFunc_currentRow, METH_NOARGS},
    {"dropEvent", (PyCFunction)SbkQListWidgetFunc_dropEvent, METH_O},
    {"dropMimeData", (PyCFunction)SbkQListWidgetFunc_dropMimeData, METH_VARARGS},
    {"editItem", (PyCFunction)SbkQListWidgetFunc_editItem, METH_O},
    {"event", (PyCFunction)SbkQListWidgetFunc_event, METH_O},
    {"findItems", (PyCFunction)SbkQListWidgetFunc_findItems, METH_VARARGS},
    {"indexFromItem", (PyCFunction)SbkQListWidgetFunc_indexFromItem, METH_O},
    {"insertItem", (PyCFunction)SbkQListWidgetFunc_insertItem, METH_VARARGS},
    {"insertItems", (PyCFunction)SbkQListWidgetFunc_insertItems, METH_VARARGS},
    {"isSortingEnabled", (PyCFunction)SbkQListWidgetFunc_isSortingEnabled, METH_NOARGS},
    {"item", (PyCFunction)SbkQListWidgetFunc_item, METH_O},
    {"itemAt", (PyCFunction)SbkQListWidgetFunc_itemAt, METH_VARARGS},
    {"itemFromIndex", (PyCFunction)SbkQListWidgetFunc_itemFromIndex, METH_O},
    {"itemWidget", (PyCFunction)SbkQListWidgetFunc_itemWidget, METH_O},
    {"items", (PyCFunction)SbkQListWidgetFunc_items, METH_O},
    {"mimeTypes", (PyCFunction)SbkQListWidgetFunc_mimeTypes, METH_NOARGS},
    {"openPersistentEditor", (PyCFunction)SbkQListWidgetFunc_openPersistentEditor, METH_O},
    {"removeItemWidget", (PyCFunction)SbkQListWidgetFunc_removeItemWidget, METH_O},
    {"row", (PyCFunction)SbkQListWidgetFunc_row, METH_O},
    {"scrollToItem", (PyCFunction)SbkQListWidgetFunc_scrollToItem, METH_VARARGS},
    {"selectedItems", (PyCFunction)SbkQListWidgetFunc_selectedItems, METH_NOARGS},
    {"setCurrentItem", (PyCFunction)SbkQListWidgetFunc_setCurrentItem, METH_VARARGS},
    {"setCurrentRow", (PyCFunction)SbkQListWidgetFunc_setCurrentRow, METH_VARARGS},
    {"setItemWidget", (PyCFunction)SbkQListWidgetFunc_setItemWidget, METH_VARARGS},
    {"setSortingEnabled", (PyCFunction)SbkQListWidgetFunc_setSortingEnabled, METH_O},
    {"sortItems", (PyCFunction)SbkQListWidgetFunc_sortItems, METH_NOARGS|METH_O},
    {"supportedDropActions", (PyCFunction)SbkQListWidgetFunc_supportedDropActions, METH_NOARGS},
    {"takeItem", (PyCFunction)SbkQListWidgetFunc_takeItem, METH_O},
    {"visualItemRect", (PyCFunction)SbkQListWidgetFunc_visualItemRect, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQListWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QListWidget* me = reinterpret_cast<QListWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLISTVIEW_IDX]))
        return static_cast<QListView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQListWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QListWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QListWidgetWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQListWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQListWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQListWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QListWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLISTWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQListWidget_Type);

    SbkQListWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLISTVIEW_IDX];
    SbkQListWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQListWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQListWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQListWidget_Type));
    PyModule_AddObject(module, "QListWidget",
        ((PyObject*)&SbkQListWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QListWidget >("QListWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QListWidget >(typeid(QListWidget).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

