/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qinputmethodevent_attribute_wrapper.h"

// Extra includes
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQInputMethodEvent_Attribute_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QInputMethodEvent::Attribute* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "Attribute", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 4 && Shiboken::Converter<QInputMethodEvent::AttributeType >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[3])) {
        QInputMethodEvent::AttributeType cpp_arg0 = Shiboken::Converter<QInputMethodEvent::AttributeType >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg3_auto_ptr;
        QVariant* cpp_arg3 = Shiboken::Converter<QVariant* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QVariant >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QVariant >(cpp_arg3);
        // Attribute(QInputMethodEvent::AttributeType,int,int,QVariant)
        cptr = new QInputMethodEvent::Attribute(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
    } else goto SbkQInputMethodEvent_Attribute_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQInputMethodEvent_Attribute_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQInputMethodEvent_Attribute_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent.AttributeType, int, int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.Attribute", overloads);
        return -1;
}

static PyMethodDef SbkQInputMethodEvent_Attribute_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQInputMethodEvent_Attribute_get_length(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->length);
}
static int SbkQInputMethodEvent_Attribute_set_length(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'length' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'length', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->length = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQInputMethodEvent_Attribute_get_type(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QInputMethodEvent::AttributeType >::toPython(Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->type);
}
static int SbkQInputMethodEvent_Attribute_set_type(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QInputMethodEvent::AttributeType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'AttributeType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->type = Shiboken::Converter<QInputMethodEvent::AttributeType >::toCpp(value);

    return 0;
}

static PyObject* SbkQInputMethodEvent_Attribute_get_value(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QVariant >::toPython(Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->value);
}
static int SbkQInputMethodEvent_Attribute_set_value(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'value' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QVariant >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'value', 'QVariant' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->value = Shiboken::Converter<QVariant >::toCpp(value);

    return 0;
}

static PyObject* SbkQInputMethodEvent_Attribute_get_start(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->start);
}
static int SbkQInputMethodEvent_Attribute_set_start(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'start' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'start', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QInputMethodEvent::Attribute* >::toCpp((PyObject*)self)->start = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

// Getters and Setters for Attribute
static PyGetSetDef SbkQInputMethodEvent_Attribute_getsetlist[] = {
    {const_cast<char*>("length"), (getter)SbkQInputMethodEvent_Attribute_get_length, (setter)SbkQInputMethodEvent_Attribute_set_length},
    {const_cast<char*>("type"), (getter)SbkQInputMethodEvent_Attribute_get_type, (setter)SbkQInputMethodEvent_Attribute_set_type},
    {const_cast<char*>("value"), (getter)SbkQInputMethodEvent_Attribute_get_value, (setter)SbkQInputMethodEvent_Attribute_set_value},
    {const_cast<char*>("start"), (getter)SbkQInputMethodEvent_Attribute_get_start, (setter)SbkQInputMethodEvent_Attribute_set_start},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQInputMethodEvent_Attribute_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.Attribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QInputMethodEvent::Attribute >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQInputMethodEvent_Attribute_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQInputMethodEvent_Attribute_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQInputMethodEvent_Attribute_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QInputMethodEvent_Attribute(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQInputMethodEvent_Attribute_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQInputMethodEvent_Attribute_Type) < 0)
        return;

    PyDict_SetItemString(module,"Attribute", (PyObject*)&SbkQInputMethodEvent_Attribute_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QInputMethodEvent::Attribute >("QInputMethodEvent::Attribute");
    Shiboken::TypeResolver::createValueTypeResolver<QInputMethodEvent::Attribute >(typeid(QInputMethodEvent::Attribute).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

