/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsscenecontextmenuevent_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQGraphicsSceneContextMenuEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneContextMenuEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsSceneContextMenuEvent", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsSceneContextMenuEvent(QEvent::Type)
        cptr = new QGraphicsSceneContextMenuEvent();
    } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QGraphicsSceneContextMenuEvent(QEvent::Type)
        cptr = new QGraphicsSceneContextMenuEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsSceneContextMenuEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsSceneContextMenuEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneContextMenuEvent", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QGraphicsSceneContextMenuEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneContextMenuEvent::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_reason(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // reason()const
    QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
    QGraphicsSceneContextMenuEvent::Reason cpp_result = cppSelf->QGraphicsSceneContextMenuEvent::reason();
    py_result = Shiboken::Converter<QGraphicsSceneContextMenuEvent::Reason >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneContextMenuEvent::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneContextMenuEvent::screenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_setModifiers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifiers(QFlags<Qt::KeyboardModifier>)
        QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneContextMenuEvent::setModifiers(cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEventFunc_setModifiers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneContextMenuEventFunc_setModifiers_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneContextMenuEvent.setModifiers", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneContextMenuEvent::setPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEventFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneContextMenuEventFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneContextMenuEvent.setPos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_setReason(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneContextMenuEvent::Reason >::isConvertible(arg)) {
        QGraphicsSceneContextMenuEvent::Reason cpp_arg0 = Shiboken::Converter<QGraphicsSceneContextMenuEvent::Reason >::toCpp(arg);
        // setReason(QGraphicsSceneContextMenuEvent::Reason)
        QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneContextMenuEvent::setReason(cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEventFunc_setReason_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneContextMenuEventFunc_setReason_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneContextMenuEvent.Reason", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneContextMenuEvent.setReason", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneContextMenuEvent::setScenePos(*cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEventFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneContextMenuEventFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneContextMenuEvent.setScenePos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneContextMenuEventFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // setScreenPos(QPoint)
        QGraphicsSceneContextMenuEvent* cppSelf = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneContextMenuEvent::setScreenPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneContextMenuEventFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneContextMenuEventFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneContextMenuEvent.setScreenPos", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsSceneContextMenuEvent_methods[] = {
    {"modifiers", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_modifiers, METH_NOARGS},
    {"pos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_pos, METH_NOARGS},
    {"reason", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_reason, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_scenePos, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_screenPos, METH_NOARGS},
    {"setModifiers", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_setModifiers, METH_O},
    {"setPos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_setPos, METH_O},
    {"setReason", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_setReason, METH_O},
    {"setScenePos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_setScenePos, METH_O},
    {"setScreenPos", (PyCFunction)SbkQGraphicsSceneContextMenuEventFunc_setScreenPos, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneContextMenuEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneContextMenuEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsSceneContextMenuEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneContextMenuEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneContextMenuEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Reason",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QGraphicsSceneContextMenuEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneContextMenuEvent_Type);

    SbkQGraphicsSceneContextMenuEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneContextMenuEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneContextMenuEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneContextMenuEvent",
        ((PyObject*)&SbkQGraphicsSceneContextMenuEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Reason
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_REASON_IDX] = &SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type);
    PyDict_SetItemString(SbkQGraphicsSceneContextMenuEvent_Type.super.ht_type.tp_dict,
            "Reason",((PyObject*)&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type,
        (long) QGraphicsSceneContextMenuEvent::Mouse, "Mouse");
    PyDict_SetItemString(SbkQGraphicsSceneContextMenuEvent_Type.super.ht_type.tp_dict,
        "Mouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type.tp_dict,
        "Mouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type,
        (long) QGraphicsSceneContextMenuEvent::Keyboard, "Keyboard");
    PyDict_SetItemString(SbkQGraphicsSceneContextMenuEvent_Type.super.ht_type.tp_dict,
        "Keyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type.tp_dict,
        "Keyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type,
        (long) QGraphicsSceneContextMenuEvent::Other, "Other");
    PyDict_SetItemString(SbkQGraphicsSceneContextMenuEvent_Type.super.ht_type.tp_dict,
        "Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsSceneContextMenuEvent_Reason_Type.tp_dict,
        "Other", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsSceneContextMenuEvent::Reason");

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneContextMenuEvent >("QGraphicsSceneContextMenuEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneContextMenuEvent >(typeid(QGraphicsSceneContextMenuEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

