/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgraphicsitemanimation_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgraphicsitem.h>
#include <qgraphicsitemanimation.h>
#include <qmatrix.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qstring.h>
#include <qthread.h>
#include <qtimeline.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsItemAnimationWrapper::QGraphicsItemAnimationWrapper(QObject * parent) : QGraphicsItemAnimation(parent), m_metaObject(0) {
    // ... middle
}

void QGraphicsItemAnimationWrapper::afterAnimationStep(qreal step)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "afterAnimationStep"));
    if (py_override.isNull()) {
        return this->QGraphicsItemAnimation::afterAnimationStep(step);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(step)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsItemAnimationWrapper::beforeAnimationStep(qreal step)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "beforeAnimationStep"));
    if (py_override.isNull()) {
        return this->QGraphicsItemAnimation::beforeAnimationStep(step);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(step)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsItemAnimationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsItemAnimationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsItemAnimationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsItemAnimationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsItemAnimationWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsItemAnimation.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGraphicsItemAnimationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsItemAnimation.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QGraphicsItemAnimationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGraphicsItemAnimationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsItemAnimation::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsItemAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsItemAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsItemAnimationWrapper::~QGraphicsItemAnimationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsItemAnimation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsItemAnimationWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsItemAnimation", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsItemAnimation(QObject*)
        cptr = new QGraphicsItemAnimationWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGraphicsItemAnimation(QObject*)
        cptr = new QGraphicsItemAnimationWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsItemAnimation_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsItemAnimation_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsItemAnimation_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_afterAnimationStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // afterAnimationStep(qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::afterAnimationStep(cpp_arg0);
    } else goto SbkQGraphicsItemAnimationFunc_afterAnimationStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_afterAnimationStep_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.afterAnimationStep", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_beforeAnimationStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // beforeAnimationStep(qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::beforeAnimationStep(cpp_arg0);
    } else goto SbkQGraphicsItemAnimationFunc_beforeAnimationStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_beforeAnimationStep_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.beforeAnimationStep", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsItemAnimation::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_horizontalScaleAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // horizontalScaleAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::horizontalScaleAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_horizontalScaleAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_horizontalScaleAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.horizontalScaleAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_horizontalShearAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // horizontalShearAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::horizontalShearAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_horizontalShearAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_horizontalShearAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.horizontalShearAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_item(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // item()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QGraphicsItem * cpp_result = cppSelf->QGraphicsItemAnimation::item();
    py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_matrixAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // matrixAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        QMatrix cpp_result = cppSelf->QGraphicsItemAnimation::matrixAt(cpp_arg0);
        py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_matrixAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_matrixAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.matrixAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_posAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // posAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QGraphicsItemAnimation::posAt(cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_posAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_posAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.posAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_posList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // posList()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QList<QPair<qreal, QPointF > > cpp_result = cppSelf->QGraphicsItemAnimation::posList();
    py_result = Shiboken::Converter<QList<QPair<qreal, QPointF > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsItemAnimation::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_rotationAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // rotationAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::rotationAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_rotationAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_rotationAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.rotationAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_rotationList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rotationList()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QList<QPair<qreal, qreal > > cpp_result = cppSelf->QGraphicsItemAnimation::rotationList();
    py_result = Shiboken::Converter<QList<QPair<qreal, qreal > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_scaleList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaleList()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QList<QPair<qreal, QPointF > > cpp_result = cppSelf->QGraphicsItemAnimation::scaleList();
    py_result = Shiboken::Converter<QList<QPair<qreal, QPointF > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(arg);
        // setItem(QGraphicsItem*)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsItemAnimationFunc_setItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.setItem", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setPosAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPosAt", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // setPosAt(qreal,QPointF)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setPosAt(cpp_arg0, *cpp_arg1);
    } else goto SbkQGraphicsItemAnimationFunc_setPosAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setPosAt_TypeError:
        const char* overloads[] = {"float, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation.setPosAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setRotationAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRotationAt", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRotationAt(qreal,qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setRotationAt(cpp_arg0, cpp_arg1);
    } else goto SbkQGraphicsItemAnimationFunc_setRotationAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setRotationAt_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation.setRotationAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setScaleAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setScaleAt", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // setScaleAt(qreal,qreal,qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setScaleAt(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQGraphicsItemAnimationFunc_setScaleAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setScaleAt_TypeError:
        const char* overloads[] = {"float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation.setScaleAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setShearAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setShearAt", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // setShearAt(qreal,qreal,qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setShearAt(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQGraphicsItemAnimationFunc_setShearAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setShearAt_TypeError:
        const char* overloads[] = {"float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation.setShearAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setStep(qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setStep(cpp_arg0);
    } else goto SbkQGraphicsItemAnimationFunc_setStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setStep_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.setStep", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setTimeLine(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimeLine* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimeLine* cpp_arg0 = Shiboken::Converter<QTimeLine* >::toCpp(arg);
        // setTimeLine(QTimeLine*)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setTimeLine(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsItemAnimationFunc_setTimeLine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setTimeLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimeLine", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.setTimeLine", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_setTranslationAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setTranslationAt", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // setTranslationAt(qreal,qreal,qreal)
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsItemAnimation::setTranslationAt(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQGraphicsItemAnimationFunc_setTranslationAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsItemAnimationFunc_setTranslationAt_TypeError:
        const char* overloads[] = {"float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsItemAnimation.setTranslationAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_shearList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shearList()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QList<QPair<qreal, QPointF > > cpp_result = cppSelf->QGraphicsItemAnimation::shearList();
    py_result = Shiboken::Converter<QList<QPair<qreal, QPointF > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_timeLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // timeLine()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QTimeLine * cpp_result = cppSelf->QGraphicsItemAnimation::timeLine();
    py_result = Shiboken::Converter<QTimeLine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_translationList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // translationList()const
    QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
    QList<QPair<qreal, QPointF > > cpp_result = cppSelf->QGraphicsItemAnimation::translationList();
    py_result = Shiboken::Converter<QList<QPair<qreal, QPointF > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_verticalScaleAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // verticalScaleAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::verticalScaleAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_verticalScaleAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_verticalScaleAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.verticalScaleAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_verticalShearAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // verticalShearAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::verticalShearAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_verticalShearAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_verticalShearAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.verticalShearAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_xTranslationAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // xTranslationAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::xTranslationAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_xTranslationAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_xTranslationAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.xTranslationAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsItemAnimationFunc_yTranslationAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // yTranslationAt(qreal)const
        QGraphicsItemAnimation* cppSelf = Shiboken::Converter<QGraphicsItemAnimation* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsItemAnimation::yTranslationAt(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQGraphicsItemAnimationFunc_yTranslationAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsItemAnimationFunc_yTranslationAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsItemAnimation.yTranslationAt", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsItemAnimation_methods[] = {
    {"afterAnimationStep", (PyCFunction)SbkQGraphicsItemAnimationFunc_afterAnimationStep, METH_O},
    {"beforeAnimationStep", (PyCFunction)SbkQGraphicsItemAnimationFunc_beforeAnimationStep, METH_O},
    {"clear", (PyCFunction)SbkQGraphicsItemAnimationFunc_clear, METH_NOARGS},
    {"horizontalScaleAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_horizontalScaleAt, METH_O},
    {"horizontalShearAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_horizontalShearAt, METH_O},
    {"item", (PyCFunction)SbkQGraphicsItemAnimationFunc_item, METH_NOARGS},
    {"matrixAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_matrixAt, METH_O},
    {"posAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_posAt, METH_O},
    {"posList", (PyCFunction)SbkQGraphicsItemAnimationFunc_posList, METH_NOARGS},
    {"reset", (PyCFunction)SbkQGraphicsItemAnimationFunc_reset, METH_NOARGS},
    {"rotationAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_rotationAt, METH_O},
    {"rotationList", (PyCFunction)SbkQGraphicsItemAnimationFunc_rotationList, METH_NOARGS},
    {"scaleList", (PyCFunction)SbkQGraphicsItemAnimationFunc_scaleList, METH_NOARGS},
    {"setItem", (PyCFunction)SbkQGraphicsItemAnimationFunc_setItem, METH_O},
    {"setPosAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_setPosAt, METH_VARARGS},
    {"setRotationAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_setRotationAt, METH_VARARGS},
    {"setScaleAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_setScaleAt, METH_VARARGS},
    {"setShearAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_setShearAt, METH_VARARGS},
    {"setStep", (PyCFunction)SbkQGraphicsItemAnimationFunc_setStep, METH_O},
    {"setTimeLine", (PyCFunction)SbkQGraphicsItemAnimationFunc_setTimeLine, METH_O},
    {"setTranslationAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_setTranslationAt, METH_VARARGS},
    {"shearList", (PyCFunction)SbkQGraphicsItemAnimationFunc_shearList, METH_NOARGS},
    {"timeLine", (PyCFunction)SbkQGraphicsItemAnimationFunc_timeLine, METH_NOARGS},
    {"translationList", (PyCFunction)SbkQGraphicsItemAnimationFunc_translationList, METH_NOARGS},
    {"verticalScaleAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_verticalScaleAt, METH_O},
    {"verticalShearAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_verticalShearAt, METH_O},
    {"xTranslationAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_xTranslationAt, METH_O},
    {"yTranslationAt", (PyCFunction)SbkQGraphicsItemAnimationFunc_yTranslationAt, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsItemAnimation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsItemAnimation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsItemAnimationWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsItemAnimation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsItemAnimation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGraphicsItemAnimation(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEMANIMATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsItemAnimation_Type);

    SbkQGraphicsItemAnimation_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQGraphicsItemAnimation_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsItemAnimation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsItemAnimation_Type));
    PyModule_AddObject(module, "QGraphicsItemAnimation",
        ((PyObject*)&SbkQGraphicsItemAnimation_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsItemAnimation >("QGraphicsItemAnimation*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsItemAnimation >(typeid(QGraphicsItemAnimation).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

