/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgraphicsdropshadoweffect_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qgraphicseffect.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsDropShadowEffectWrapper::QGraphicsDropShadowEffectWrapper(QObject * parent) : QGraphicsDropShadowEffect(parent), m_metaObject(0) {
    // ... middle
}

QRectF QGraphicsDropShadowEffectWrapper::boundingRectFor(const QRectF & rect) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRectFor"));
    if (py_override.isNull()) {
        return this->QGraphicsDropShadowEffect::boundingRectFor(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsDropShadowEffect.boundingRectFor");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsDropShadowEffectWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsDropShadowEffectWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsDropShadowEffectWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsDropShadowEffectWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsDropShadowEffectWrapper::draw(QPainter * painter)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "draw"));
    if (py_override.isNull()) {
        return this->QGraphicsDropShadowEffect::draw(painter);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPainter* >::toPython(painter)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsDropShadowEffectWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsDropShadowEffect.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGraphicsDropShadowEffectWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsDropShadowEffect.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QGraphicsDropShadowEffectWrapper::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sourceChanged"));
    if (py_override.isNull()) {
        return this->QGraphicsEffect::sourceChanged(flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsDropShadowEffectWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGraphicsDropShadowEffectWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsDropShadowEffect::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsDropShadowEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsDropShadowEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsDropShadowEffectWrapper::~QGraphicsDropShadowEffectWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsDropShadowEffect_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsDropShadowEffectWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsDropShadowEffect", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsDropShadowEffect(QObject*)
        cptr = new QGraphicsDropShadowEffectWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGraphicsDropShadowEffect(QObject*)
        cptr = new QGraphicsDropShadowEffectWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsDropShadowEffect_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsDropShadowEffect_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsDropShadowEffect_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsDropShadowEffect", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_blurRadius(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blurRadius()const
    QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsDropShadowEffect::blurRadius();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_boundingRectFor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // boundingRectFor(QRectF)const
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsDropShadowEffect::boundingRectFor(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQGraphicsDropShadowEffectFunc_boundingRectFor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsDropShadowEffectFunc_boundingRectFor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.boundingRectFor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_color(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // color()const
    QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QGraphicsDropShadowEffect::color();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_draw(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // draw(QPainter*)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::draw(cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.draw", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_offset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // offset()const
    QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsDropShadowEffect::offset();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_setBlurRadius(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBlurRadius(qreal)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::setBlurRadius(cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_setBlurRadius_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_setBlurRadius_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.setBlurRadius", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_setColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!Shiboken::Converter<QColor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setColor(QColor)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::setColor(*cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_setColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_setColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.setColor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_setOffset(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOffset", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOffset(qreal)
            QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsDropShadowEffect::setOffset(cpp_arg0);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            // setOffset(qreal,qreal)
            QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsDropShadowEffect::setOffset(cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsDropShadowEffectFunc_setOffset_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setOffset(QPointF)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::setOffset(*cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_setOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_setOffset_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsDropShadowEffect.setOffset", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_setXOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setXOffset(qreal)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::setXOffset(cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_setXOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_setXOffset_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.setXOffset", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_setYOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setYOffset(qreal)
        QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsDropShadowEffect::setYOffset(cpp_arg0);
    } else goto SbkQGraphicsDropShadowEffectFunc_setYOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsDropShadowEffectFunc_setYOffset_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsDropShadowEffect.setYOffset", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_xOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // xOffset()const
    QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsDropShadowEffect::xOffset();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsDropShadowEffectFunc_yOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yOffset()const
    QGraphicsDropShadowEffect* cppSelf = Shiboken::Converter<QGraphicsDropShadowEffect* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsDropShadowEffect::yOffset();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGraphicsDropShadowEffect_methods[] = {
    {"blurRadius", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_blurRadius, METH_NOARGS},
    {"boundingRectFor", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_boundingRectFor, METH_O},
    {"color", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_color, METH_NOARGS},
    {"draw", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_draw, METH_O},
    {"offset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_offset, METH_NOARGS},
    {"setBlurRadius", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_setBlurRadius, METH_O},
    {"setColor", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_setColor, METH_O},
    {"setOffset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_setOffset, METH_VARARGS},
    {"setXOffset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_setXOffset, METH_O},
    {"setYOffset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_setYOffset, METH_O},
    {"xOffset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_xOffset, METH_NOARGS},
    {"yOffset", (PyCFunction)SbkQGraphicsDropShadowEffectFunc_yOffset, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsDropShadowEffect_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsDropShadowEffect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsDropShadowEffectWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsDropShadowEffect_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsDropShadowEffect_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGraphicsDropShadowEffect(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSDROPSHADOWEFFECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsDropShadowEffect_Type);

    SbkQGraphicsDropShadowEffect_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX];
    // Fill type discovery information
    SbkQGraphicsDropShadowEffect_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsDropShadowEffect_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsDropShadowEffect_Type));
    PyModule_AddObject(module, "QGraphicsDropShadowEffect",
        ((PyObject*)&SbkQGraphicsDropShadowEffect_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsDropShadowEffect >("QGraphicsDropShadowEffect*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsDropShadowEffect >(typeid(QGraphicsDropShadowEffect).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

