/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsanchorlayout_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qgraphicsanchorlayout.h>
#include <qgraphicsitem.h>
#include <qgraphicslayoutitem.h>
#include <qrect.h>
#include <qsize.h>
#include <qsizepolicy.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsAnchorLayoutWrapper::QGraphicsAnchorLayoutWrapper(QGraphicsLayoutItem * parent) : QGraphicsAnchorLayout(parent) {
    // ... middle
}

int QGraphicsAnchorLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsAnchorLayout.count");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsAnchorLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QGraphicsLayoutItem * QGraphicsAnchorLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::itemAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsAnchorLayout.itemAt");
        return 0        ;
    }
    QGraphicsLayoutItem* cpp_result(Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QGraphicsAnchorLayoutWrapper::removeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeAt"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::removeAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsAnchorLayoutWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QGraphicsAnchorLayoutWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsAnchorLayout::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF& >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsAnchorLayout.sizeHint");
        return QSizeF()        ;
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsAnchorLayoutWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsAnchorLayoutWrapper::widgetEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widgetEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::widgetEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QGraphicsAnchorLayoutWrapper::~QGraphicsAnchorLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsAnchorLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsAnchorLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsAnchorLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsAnchorLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsAnchorLayoutWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        // QGraphicsAnchorLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsAnchorLayoutWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsAnchorLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsAnchorLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsAnchorLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_addAnchor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addAnchor", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::AnchorPoint >::isConvertible(pyargs[1]) && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::AnchorPoint >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        Qt::AnchorPoint cpp_arg1 = Shiboken::Converter<Qt::AnchorPoint >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QGraphicsLayoutItem* cpp_arg2 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[2]);
        Qt::AnchorPoint cpp_arg3 = Shiboken::Converter<Qt::AnchorPoint >::toCpp(pyargs[3]);
        // addAnchor(QGraphicsLayoutItem*,Qt::AnchorPoint,QGraphicsLayoutItem*,Qt::AnchorPoint)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        QGraphicsAnchor * cpp_result = cppSelf->QGraphicsAnchorLayout::addAnchor(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QGraphicsAnchor* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsAnchorLayoutFunc_addAnchor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsAnchorLayoutFunc_addAnchor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.AnchorPoint, PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.AnchorPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout.addAnchor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_addAnchors(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addAnchors", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QGraphicsLayoutItem* cpp_arg1 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // addAnchors(QGraphicsLayoutItem*,QGraphicsLayoutItem*,QFlags<Qt::Orientation>)
            QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsAnchorLayout::addAnchors(cpp_arg0, cpp_arg1);
        } else if (SbkPySide_QtCore_Qt_Orientation_Check(pyargs[2])) {
            QFlags<Qt::Orientation> cpp_arg2 = Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(pyargs[2]);
            // addAnchors(QGraphicsLayoutItem*,QGraphicsLayoutItem*,QFlags<Qt::Orientation>)
            QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsAnchorLayout::addAnchors(cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGraphicsAnchorLayoutFunc_addAnchors_TypeError;
    } else goto SbkQGraphicsAnchorLayoutFunc_addAnchors_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_addAnchors_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.Orientations = Qt.Horizontal | Qt.Vertical", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout.addAnchors", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_addCornerAnchors(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addCornerAnchors", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::Corner >::isConvertible(pyargs[1]) && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::Corner >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        Qt::Corner cpp_arg1 = Shiboken::Converter<Qt::Corner >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QGraphicsLayoutItem* cpp_arg2 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[2]);
        Qt::Corner cpp_arg3 = Shiboken::Converter<Qt::Corner >::toCpp(pyargs[3]);
        // addCornerAnchors(QGraphicsLayoutItem*,Qt::Corner,QGraphicsLayoutItem*,Qt::Corner)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::addCornerAnchors(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQGraphicsAnchorLayoutFunc_addCornerAnchors_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_addCornerAnchors_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.Corner, PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.Corner", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout.addCornerAnchors", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_anchor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "anchor", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::AnchorPoint >::isConvertible(pyargs[1]) && Shiboken::Converter<QGraphicsLayoutItem* >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::AnchorPoint >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        Qt::AnchorPoint cpp_arg1 = Shiboken::Converter<Qt::AnchorPoint >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QGraphicsLayoutItem* cpp_arg2 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[2]);
        Qt::AnchorPoint cpp_arg3 = Shiboken::Converter<Qt::AnchorPoint >::toCpp(pyargs[3]);
        // anchor(QGraphicsLayoutItem*,Qt::AnchorPoint,QGraphicsLayoutItem*,Qt::AnchorPoint)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        QGraphicsAnchor * cpp_result = cppSelf->QGraphicsAnchorLayout::anchor(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QGraphicsAnchor* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsAnchorLayoutFunc_anchor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsAnchorLayoutFunc_anchor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.AnchorPoint, PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.AnchorPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout.anchor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsAnchorLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_horizontalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalSpacing()const
    QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsAnchorLayout::horizontalSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsAnchorLayout::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        QGraphicsLayoutItem * cpp_result = cppSelf->QGraphicsAnchorLayout::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsAnchorLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsAnchorLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_removeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeAt(int)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::removeAt(cpp_arg0);
    } else goto SbkQGraphicsAnchorLayoutFunc_removeAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_removeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.removeAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::setGeometry(*cpp_arg0);
    } else goto SbkQGraphicsAnchorLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_setHorizontalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHorizontalSpacing(qreal)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::setHorizontalSpacing(cpp_arg0);
    } else goto SbkQGraphicsAnchorLayoutFunc_setHorizontalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_setHorizontalSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.setHorizontalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setSpacing(qreal)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::setSpacing(cpp_arg0);
    } else goto SbkQGraphicsAnchorLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.setSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_setVerticalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setVerticalSpacing(qreal)
        QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsAnchorLayout::setVerticalSpacing(cpp_arg0);
    } else goto SbkQGraphicsAnchorLayoutFunc_setVerticalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsAnchorLayoutFunc_setVerticalSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsAnchorLayout.setVerticalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsAnchorLayout::sizeHint(cpp_arg0);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
        } else if (Shiboken::Converter<QSizeF& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QSizeF& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsAnchorLayout::sizeHint(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
        } else goto SbkQGraphicsAnchorLayoutFunc_sizeHint_TypeError;
    } else goto SbkQGraphicsAnchorLayoutFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsAnchorLayoutFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF = QSizeF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsAnchorLayout.sizeHint", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsAnchorLayoutFunc_verticalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalSpacing()const
    QGraphicsAnchorLayout* cppSelf = Shiboken::Converter<QGraphicsAnchorLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsAnchorLayout::verticalSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGraphicsAnchorLayout_methods[] = {
    {"addAnchor", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_addAnchor, METH_VARARGS},
    {"addAnchors", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_addAnchors, METH_VARARGS},
    {"addCornerAnchors", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_addCornerAnchors, METH_VARARGS},
    {"anchor", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_anchor, METH_VARARGS},
    {"count", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_count, METH_NOARGS},
    {"horizontalSpacing", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_horizontalSpacing, METH_NOARGS},
    {"invalidate", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_itemAt, METH_O},
    {"removeAt", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_removeAt, METH_O},
    {"setGeometry", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_setGeometry, METH_O},
    {"setHorizontalSpacing", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_setHorizontalSpacing, METH_O},
    {"setSpacing", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_setSpacing, METH_O},
    {"setVerticalSpacing", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_setVerticalSpacing, METH_O},
    {"sizeHint", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_sizeHint, METH_VARARGS},
    {"verticalSpacing", (PyCFunction)SbkQGraphicsAnchorLayoutFunc_verticalSpacing, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsAnchorLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsAnchorLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsAnchorLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsAnchorLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsAnchorLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGraphicsAnchorLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSANCHORLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsAnchorLayout_Type);

    SbkQGraphicsAnchorLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUT_IDX];
    // Fill type discovery information
    SbkQGraphicsAnchorLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsAnchorLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsAnchorLayout_Type));
    PyModule_AddObject(module, "QGraphicsAnchorLayout",
        ((PyObject*)&SbkQGraphicsAnchorLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsAnchorLayout >("QGraphicsAnchorLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsAnchorLayout >(typeid(QGraphicsAnchorLayout).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

