/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <set>
#include "pyside_qtgui_python.h"

#include "qdropevent_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qmimedata.h>
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQDropEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDropEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX]);
    if (type != myType) {
        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDropEvent", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_DropAction_Check(pyargs[1]) && Shiboken::Converter<QMimeData* >::isConvertible(pyargs[2]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        QFlags<Qt::DropAction> cpp_arg1 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        QMimeData* cpp_arg2 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[2]);
        QFlags<Qt::MouseButton> cpp_arg3 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[3]);
        QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
        if (numArgs == 5) {
            // QDropEvent(QPoint,QFlags<Qt::DropAction>,const QMimeData*,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,QEvent::Type)
            cptr = new QDropEvent(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[5])) {
            QEvent::Type cpp_arg5 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[5]);
            // QDropEvent(QPoint,QFlags<Qt::DropAction>,const QMimeData*,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,QEvent::Type)
            cptr = new QDropEvent(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        } else goto SbkQDropEvent_Init_TypeError;
    } else goto SbkQDropEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDropEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDropEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.Qt.DropActions, PySide.QtCore.QMimeData, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.QEvent.Type = Drop", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDropEvent", overloads);
        return -1;
}

static PyObject*
SbkQDropEventFunc_acceptProposedAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // acceptProposedAction()
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    cppSelf->QDropEvent::acceptProposedAction();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQDropEventFunc_dropAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dropAction()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    Qt::DropAction cpp_result = cppSelf->QDropEvent::dropAction();
    py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_encodedData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // encodedData(const char*)const
        QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QDropEvent::encodedData(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQDropEventFunc_encodedData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDropEventFunc_encodedData_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDropEvent.encodedData", overloads);
        return 0;
}

static PyObject*
SbkQDropEventFunc_format(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // format(int)const
        QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
        const char * cpp_result = cppSelf->QDropEvent::format();
        py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // format(int)const
        QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
        const char * cpp_result = cppSelf->QDropEvent::format(cpp_arg0);
        py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    } else goto SbkQDropEventFunc_format_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDropEventFunc_format_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDropEvent.format", overloads);
        return 0;
}

static PyObject*
SbkQDropEventFunc_keyboardModifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyboardModifiers()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QDropEvent::keyboardModifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_mimeData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeData()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    const QMimeData * cpp_result = cppSelf->QDropEvent::mimeData();
    py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_mouseButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mouseButtons()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QDropEvent::mouseButtons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QDropEvent::pos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_possibleActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // possibleActions()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QDropEvent::possibleActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_proposedAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proposedAction()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    Qt::DropAction cpp_result = cppSelf->QDropEvent::proposedAction();
    py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDropEventFunc_provides(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // provides(const char*)const
        QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDropEvent::provides(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDropEventFunc_provides_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDropEventFunc_provides_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDropEvent.provides", overloads);
        return 0;
}

static PyObject*
SbkQDropEventFunc_setDropAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::DropAction >::isConvertible(arg)) {
        Qt::DropAction cpp_arg0 = Shiboken::Converter<Qt::DropAction >::toCpp(arg);
        // setDropAction(Qt::DropAction)
        QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
        cppSelf->QDropEvent::setDropAction(cpp_arg0);
    } else goto SbkQDropEventFunc_setDropAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDropEventFunc_setDropAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDropEvent.setDropAction", overloads);
        return 0;
}

static PyObject*
SbkQDropEventFunc_source(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // source()const
    QDropEvent* cppSelf = Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QDropEvent::source();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQDropEvent_methods[] = {
    {"acceptProposedAction", (PyCFunction)SbkQDropEventFunc_acceptProposedAction, METH_NOARGS},
    {"dropAction", (PyCFunction)SbkQDropEventFunc_dropAction, METH_NOARGS},
    {"encodedData", (PyCFunction)SbkQDropEventFunc_encodedData, METH_O},
    {"format", (PyCFunction)SbkQDropEventFunc_format, METH_NOARGS|METH_O},
    {"keyboardModifiers", (PyCFunction)SbkQDropEventFunc_keyboardModifiers, METH_NOARGS},
    {"mimeData", (PyCFunction)SbkQDropEventFunc_mimeData, METH_NOARGS},
    {"mouseButtons", (PyCFunction)SbkQDropEventFunc_mouseButtons, METH_NOARGS},
    {"pos", (PyCFunction)SbkQDropEventFunc_pos, METH_NOARGS},
    {"possibleActions", (PyCFunction)SbkQDropEventFunc_possibleActions, METH_NOARGS},
    {"proposedAction", (PyCFunction)SbkQDropEventFunc_proposedAction, METH_NOARGS},
    {"provides", (PyCFunction)SbkQDropEventFunc_provides, METH_O},
    {"setDropAction", (PyCFunction)SbkQDropEventFunc_setDropAction, METH_O},
    {"source", (PyCFunction)SbkQDropEventFunc_source, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQDropEvent_get_mdata(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QMimeData* >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->mdata);
}
static int SbkQDropEvent_set_mdata(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mdata' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QMimeData* >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mdata', 'QMimeData' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->mdata = Shiboken::Converter<QMimeData* >::toCpp(value);

    Shiboken::SbkBaseWrapper_keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "mdata", value);

    return 0;
}

static PyObject* SbkQDropEvent_get_default_action(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::DropAction >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->default_action);
}
static int SbkQDropEvent_set_default_action(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'default_action' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::DropAction >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'default_action', 'DropAction' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->default_action = Shiboken::Converter<Qt::DropAction >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_modState(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->modState);
}
static int SbkQDropEvent_set_modState(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'modState' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_KeyboardModifier_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'modState', 'KeyboardModifiers' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->modState = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_fmts(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QList<QByteArray > >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->fmts);
}
static int SbkQDropEvent_set_fmts(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'fmts' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QList<QByteArray > >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'fmts', 'QList' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->fmts = Shiboken::Converter<QList<QByteArray > >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_mouseState(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->mouseState);
}
static int SbkQDropEvent_set_mouseState(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mouseState' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_MouseButton_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mouseState', 'MouseButtons' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->mouseState = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_drop_action(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::DropAction >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->drop_action);
}
static int SbkQDropEvent_set_drop_action(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'drop_action' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::DropAction >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'drop_action', 'DropAction' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->drop_action = Shiboken::Converter<Qt::DropAction >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_p(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->p);
}
static int SbkQDropEvent_set_p(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'p' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'p', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->p = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQDropEvent_get_act(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->act);
}
static int SbkQDropEvent_set_act(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'act' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_DropAction_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'act', 'DropActions' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDropEvent* >::toCpp((PyObject*)self)->act = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(value);

    return 0;
}

// Getters and Setters for QDropEvent
static PyGetSetDef SbkQDropEvent_getsetlist[] = {
    {const_cast<char*>("mdata"), (getter)SbkQDropEvent_get_mdata, (setter)SbkQDropEvent_set_mdata},
    {const_cast<char*>("default_action"), (getter)SbkQDropEvent_get_default_action, (setter)SbkQDropEvent_set_default_action},
    {const_cast<char*>("modState"), (getter)SbkQDropEvent_get_modState, (setter)SbkQDropEvent_set_modState},
    {const_cast<char*>("fmts"), (getter)SbkQDropEvent_get_fmts, (setter)SbkQDropEvent_set_fmts},
    {const_cast<char*>("mouseState"), (getter)SbkQDropEvent_get_mouseState, (setter)SbkQDropEvent_set_mouseState},
    {const_cast<char*>("drop_action"), (getter)SbkQDropEvent_get_drop_action, (setter)SbkQDropEvent_set_drop_action},
    {const_cast<char*>("p"), (getter)SbkQDropEvent_get_p, (setter)SbkQDropEvent_set_p},
    {const_cast<char*>("act"), (getter)SbkQDropEvent_get_act, (setter)SbkQDropEvent_set_act},
    {0}  // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int*
SbkQDropEvent_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QDropEvent* class_ptr = reinterpret_cast<const QDropEvent*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QEvent*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QEvent*>((QDropEvent*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QMimeSource*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QMimeSource*>((QDropEvent*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQDropEventSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QDropEvent* me = reinterpret_cast<QDropEvent*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX]))
        return static_cast<QEvent*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDropEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDropEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDropEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDropEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQDropEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDropEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQDropEvent_mi_init,
    /*mi_specialcast*/      &SbkQDropEventSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QDropEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDropEvent_Type);

    SbkQDropEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    SbkQDropEvent_Type.super.ht_type.tp_bases = PyTuple_Pack(1,
        (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENT_IDX]);

    if (PyType_Ready((PyTypeObject*)&SbkQDropEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDropEvent_Type));
    PyModule_AddObject(module, "QDropEvent",
        ((PyObject*)&SbkQDropEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QDropEvent >("QDropEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDropEvent >(typeid(QDropEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

