/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <set>
#include "pyside_qtgui_python.h"

#include "qdragenterevent_wrapper.h"

// Extra includes
#include <qmimedata.h>
#include <qpoint.h>
#include <qrect.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQDragEnterEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDragEnterEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDragEnterEvent", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 5 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_DropAction_Check(pyargs[1]) && Shiboken::Converter<QMimeData* >::isConvertible(pyargs[2]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        QFlags<Qt::DropAction> cpp_arg1 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        QMimeData* cpp_arg2 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[2]);
        QFlags<Qt::MouseButton> cpp_arg3 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[3]);
        QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
        // QDragEnterEvent(QPoint,QFlags<Qt::DropAction>,const QMimeData*,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
        cptr = new QDragEnterEvent(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
    } else goto SbkQDragEnterEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDragEnterEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDragEnterEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.Qt.DropActions, PySide.QtCore.QMimeData, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDragEnterEvent", overloads);
        return -1;
}

static PyMethodDef SbkQDragEnterEvent_methods[] = {
    {0} // Sentinel
};

extern "C"
{

static void* SbkQDragEnterEventSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QDragEnterEvent* me = reinterpret_cast<QDragEnterEvent*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]))
        return static_cast<QDragMoveEvent*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX]))
        return static_cast<QDropEvent*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX]))
        return static_cast<QEvent*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDragEnterEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDragEnterEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDragEnterEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDragEnterEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDragEnterEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQDragEnterEventSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QDragEnterEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDragEnterEvent_Type);

    SbkQDragEnterEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX];
    SbkQDragEnterEvent_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX])->mi_init;

    if (PyType_Ready((PyTypeObject*)&SbkQDragEnterEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDragEnterEvent_Type));
    PyModule_AddObject(module, "QDragEnterEvent",
        ((PyObject*)&SbkQDragEnterEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QDragEnterEvent >("QDragEnterEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDragEnterEvent >(typeid(QDragEnterEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

