/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qcommonstyle_wrapper.h"

// Extra includes
#include <QList>
#include <qapplication.h>
#include <qbytearray.h>
#include <qcommonstyle.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QCommonStyleWrapper::QCommonStyleWrapper() : QCommonStyle(), m_metaObject(0) {
    // ... middle
}

void QCommonStyleWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCommonStyleWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCommonStyleWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, QPainter * p, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawComplexControl"));
    if (py_override.isNull()) {
        return this->QCommonStyle::drawComplexControl(cc, opt, p, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QPainter* >::toPython(p),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::drawControl(QStyle::ControlElement element, const QStyleOption * opt, QPainter * p, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawControl"));
    if (py_override.isNull()) {
        return this->QCommonStyle::drawControl(element, opt, p, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ControlElement >::toPython(element),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QPainter* >::toPython(p),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::drawItemPixmap(QPainter * painter, const QRect & rect, int alignment, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemPixmap"));
    if (py_override.isNull()) {
        return this->QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        alignment,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCommonStyleWrapper::drawItemText(QPainter * painter, const QRect & rect, int flags, const QPalette & pal, bool enabled, const QString & text, QPalette::ColorRole textRole) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemText"));
    if (py_override.isNull()) {
        return this->QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiOOOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        flags,
        Shiboken::Converter<QPalette& >::toPython(pal),
        Shiboken::Converter<bool >::toPython(enabled),
        Shiboken::Converter<QString& >::toPython(text),
        Shiboken::Converter<QPalette::ColorRole >::toPython(textRole)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCommonStyleWrapper::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption * opt, QPainter * p, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawPrimitive"));
    if (py_override.isNull()) {
        return this->QCommonStyle::drawPrimitive(pe, opt, p, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::PrimitiveElement >::toPython(pe),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QPainter* >::toPython(p),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QCommonStyleWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QCommonStyleWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QPixmap QCommonStyleWrapper::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap & pixmap, const QStyleOption * opt) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "generatedIconPixmap"));
    if (py_override.isNull()) {
        return this->QCommonStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QIcon::Mode >::toPython(iconMode),
        Shiboken::Converter<QPixmap& >::toPython(pixmap),
        Shiboken::Converter<QStyleOption* >::toPython(opt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.generatedIconPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

QStyle::SubControl QCommonStyleWrapper::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, const QPoint & pt, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTestComplexControl"));
    if (py_override.isNull()) {
        return this->QCommonStyle::hitTestComplexControl(cc, opt, pt, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QPoint& >::toPython(pt),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyle::SubControl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyle::SubControl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.hitTestComplexControl");
        return QStyle::SubControl()        ;
    }
    QStyle::SubControl cpp_result(Shiboken::Converter<QStyle::SubControl >::toCpp(py_result));
    return cpp_result;
}

QRect QCommonStyleWrapper::itemPixmapRect(const QRect & r, int flags, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemPixmapRect"));
    if (py_override.isNull()) {
        return this->QStyle::itemPixmapRect(r, flags, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QRect& >::toPython(r),
        flags,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.itemPixmapRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

int QCommonStyleWrapper::pixelMetric(QStyle::PixelMetric m, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixelMetric"));
    if (py_override.isNull()) {
        return this->QCommonStyle::pixelMetric(m, opt, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::PixelMetric >::toPython(m),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.pixelMetric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QCommonStyleWrapper::polish(QApplication * app)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCommonStyle::polish(app);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(app)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::polish(QPalette & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCommonStyle::polish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPalette& >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::polish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCommonStyle::polish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QCommonStyleWrapper::sizeFromContents(QStyle::ContentsType ct, const QStyleOption * opt, const QSize & contentsSize, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeFromContents"));
    if (py_override.isNull()) {
        return this->QCommonStyle::sizeFromContents(ct, opt, contentsSize, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ContentsType >::toPython(ct),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QSize& >::toPython(contentsSize),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.sizeFromContents");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QPalette QCommonStyleWrapper::standardPalette() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPalette"));
    if (py_override.isNull()) {
        return this->QStyle::standardPalette();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPalette();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPalette >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.standardPalette");
        return QPalette()        ;
    }
    QPalette cpp_result(Shiboken::Converter<QPalette >::toCpp(py_result));
    return cpp_result;
}

QPixmap QCommonStyleWrapper::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPixmap"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCommonStyle.standardPixmap()' not implemented.");
        return QPixmap();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::StandardPixmap >::toPython(standardPixmap),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.standardPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

int QCommonStyleWrapper::styleHint(QStyle::StyleHint sh, const QStyleOption * opt, const QWidget * w, QStyleHintReturn * shret) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "styleHint"));
    if (py_override.isNull()) {
        return this->QCommonStyle::styleHint(sh, opt, w, shret);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::StyleHint >::toPython(sh),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(w),
        Shiboken::Converter<QStyleHintReturn* >::toPython(shret)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.styleHint");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QRect QCommonStyleWrapper::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, QStyle::SubControl sc, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subControlRect"));
    if (py_override.isNull()) {
        return this->QCommonStyle::subControlRect(cc, opt, sc, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QStyle::SubControl >::toPython(sc),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.subControlRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRect QCommonStyleWrapper::subElementRect(QStyle::SubElement r, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subElementRect"));
    if (py_override.isNull()) {
        return this->QCommonStyle::subElementRect(r, opt, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::SubElement >::toPython(r),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCommonStyle.subElementRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

void QCommonStyleWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCommonStyleWrapper::unpolish(QApplication * application)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QCommonStyle::unpolish(application);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(application)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCommonStyleWrapper::unpolish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QCommonStyle::unpolish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QCommonStyleWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QCommonStyle::staticMetaObject);
}
    return m_metaObject;
}

int QCommonStyleWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QCommonStyle::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QCommonStyleWrapper::~QCommonStyleWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQCommonStyle_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCommonStyleWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QCOMMONSTYLE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QCommonStyle' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QCommonStyle()
    cptr = new QCommonStyleWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQCommonStyleFunc_drawComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawComplexControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQCommonStyleFunc_drawComplexControl_TypeError;
    } else goto SbkQCommonStyleFunc_drawComplexControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCommonStyleFunc_drawComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.drawComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_drawControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ControlElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2])) {
        QStyle::ControlElement cpp_arg0 = Shiboken::Converter<QStyle::ControlElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawControl(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQCommonStyleFunc_drawControl_TypeError;
    } else goto SbkQCommonStyleFunc_drawControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCommonStyleFunc_drawControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ControlElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.drawControl", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_drawPrimitive(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawPrimitive", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::PrimitiveElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2])) {
        QStyle::PrimitiveElement cpp_arg0 = Shiboken::Converter<QStyle::PrimitiveElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            cppSelf->QCommonStyle::drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQCommonStyleFunc_drawPrimitive_TypeError;
    } else goto SbkQCommonStyleFunc_drawPrimitive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCommonStyleFunc_drawPrimitive_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PrimitiveElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.drawPrimitive", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_generatedIconPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "generatedIconPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[2])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOption* cpp_arg2 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[2]);
        // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QCommonStyle::generatedIconPixmap(cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQCommonStyleFunc_generatedIconPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_generatedIconPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode, PySide.QtGui.QPixmap, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.generatedIconPixmap", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_hitTestComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "hitTestComplexControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        if (numArgs == 3) {
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->QCommonStyle::hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->QCommonStyle::hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
        } else goto SbkQCommonStyleFunc_hitTestComplexControl_TypeError;
    } else goto SbkQCommonStyleFunc_hitTestComplexControl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_hitTestComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtCore.QPoint, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.hitTestComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_pixelMetric(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixelMetric", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::PixelMetric >::isConvertible(pyargs[0])) {
        QStyle::PixelMetric cpp_arg0 = Shiboken::Converter<QStyle::PixelMetric >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QCommonStyle::pixelMetric(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCommonStyle::pixelMetric(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCommonStyle::pixelMetric(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQCommonStyleFunc_pixelMetric_TypeError;
        } else goto SbkQCommonStyleFunc_pixelMetric_TypeError;
    } else goto SbkQCommonStyleFunc_pixelMetric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_pixelMetric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PixelMetric, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.pixelMetric", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_polish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // polish(QWidget*)
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        cppSelf->QCommonStyle::polish(cpp_arg0);
    } else if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // polish(QPalette&)
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        cppSelf->QCommonStyle::polish(*cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // polish(QApplication*)
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        cppSelf->QCommonStyle::polish(cpp_arg0);
    } else goto SbkQCommonStyleFunc_polish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCommonStyleFunc_polish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QPalette", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCommonStyle.polish", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_sizeFromContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sizeFromContents", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ContentsType >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QSize& >::isConvertible(pyargs[2])) {
        QStyle::ContentsType cpp_arg0 = Shiboken::Converter<QStyle::ContentsType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSize* cpp_arg2 = Shiboken::Converter<QSize* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QSize cpp_result = cppSelf->QCommonStyle::sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QSize cpp_result = cppSelf->QCommonStyle::sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        } else goto SbkQCommonStyleFunc_sizeFromContents_TypeError;
    } else goto SbkQCommonStyleFunc_sizeFromContents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_sizeFromContents_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ContentsType, PySide.QtGui.QStyleOption, PySide.QtCore.QSize, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.sizeFromContents", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_standardIconImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardIconImplementation", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QCommonStyle::standardIconImplementation(cpp_arg0);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QCommonStyle::standardIconImplementation(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QCommonStyle::standardIconImplementation(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            } else goto SbkQCommonStyleFunc_standardIconImplementation_TypeError;
        } else goto SbkQCommonStyleFunc_standardIconImplementation_TypeError;
    } else goto SbkQCommonStyleFunc_standardIconImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_standardIconImplementation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.standardIconImplementation", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_styleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "styleHint", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::StyleHint >::isConvertible(pyargs[0])) {
        QStyle::StyleHint cpp_arg0 = Shiboken::Converter<QStyle::StyleHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QCommonStyle::styleHint(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCommonStyle::styleHint(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->QCommonStyle::styleHint(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                } else if (Shiboken::Converter<QStyleHintReturn* >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QStyleHintReturn* cpp_arg3 = Shiboken::Converter<QStyleHintReturn* >::toCpp(pyargs[3]);
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->QCommonStyle::styleHint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                } else goto SbkQCommonStyleFunc_styleHint_TypeError;
            } else goto SbkQCommonStyleFunc_styleHint_TypeError;
        } else goto SbkQCommonStyleFunc_styleHint_TypeError;
    } else goto SbkQCommonStyleFunc_styleHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_styleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StyleHint, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None, PySide.QtGui.QStyleHintReturn = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.styleHint", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_subControlRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subControlRect", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyle::SubControl >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        QStyle::SubControl cpp_arg2 = Shiboken::Converter<QStyle::SubControl >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCommonStyle::subControlRect(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCommonStyle::subControlRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else goto SbkQCommonStyleFunc_subControlRect_TypeError;
    } else goto SbkQCommonStyleFunc_subControlRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_subControlRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QStyle.SubControl, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.subControlRect", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_subElementRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subElementRect", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::SubElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
        QStyle::SubElement cpp_arg0 = Shiboken::Converter<QStyle::SubElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCommonStyle::subElementRect(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCommonStyle::subElementRect(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else goto SbkQCommonStyleFunc_subElementRect_TypeError;
    } else goto SbkQCommonStyleFunc_subElementRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCommonStyleFunc_subElementRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.SubElement, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCommonStyle.subElementRect", overloads);
        return 0;
}

static PyObject*
SbkQCommonStyleFunc_unpolish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // unpolish(QWidget*)
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        cppSelf->QCommonStyle::unpolish(cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // unpolish(QApplication*)
        QCommonStyle* cppSelf = Shiboken::Converter<QCommonStyle* >::toCpp((PyObject*)self);
        cppSelf->QCommonStyle::unpolish(cpp_arg0);
    } else goto SbkQCommonStyleFunc_unpolish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCommonStyleFunc_unpolish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCommonStyle.unpolish", overloads);
        return 0;
}

static PyMethodDef SbkQCommonStyle_methods[] = {
    {"drawComplexControl", (PyCFunction)SbkQCommonStyleFunc_drawComplexControl, METH_VARARGS},
    {"drawControl", (PyCFunction)SbkQCommonStyleFunc_drawControl, METH_VARARGS},
    {"drawPrimitive", (PyCFunction)SbkQCommonStyleFunc_drawPrimitive, METH_VARARGS},
    {"generatedIconPixmap", (PyCFunction)SbkQCommonStyleFunc_generatedIconPixmap, METH_VARARGS},
    {"hitTestComplexControl", (PyCFunction)SbkQCommonStyleFunc_hitTestComplexControl, METH_VARARGS},
    {"pixelMetric", (PyCFunction)SbkQCommonStyleFunc_pixelMetric, METH_VARARGS},
    {"polish", (PyCFunction)SbkQCommonStyleFunc_polish, METH_O},
    {"sizeFromContents", (PyCFunction)SbkQCommonStyleFunc_sizeFromContents, METH_VARARGS},
    {"standardIconImplementation", (PyCFunction)SbkQCommonStyleFunc_standardIconImplementation, METH_VARARGS},
    {"styleHint", (PyCFunction)SbkQCommonStyleFunc_styleHint, METH_VARARGS},
    {"subControlRect", (PyCFunction)SbkQCommonStyleFunc_subControlRect, METH_VARARGS},
    {"subElementRect", (PyCFunction)SbkQCommonStyleFunc_subElementRect, METH_VARARGS},
    {"unpolish", (PyCFunction)SbkQCommonStyleFunc_unpolish, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCommonStyle_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QCommonStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QCommonStyleWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCommonStyle_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCommonStyle_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QCommonStyle(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCOMMONSTYLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCommonStyle_Type);

    SbkQCommonStyle_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLE_IDX];
    // Fill type discovery information
    SbkQCommonStyle_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQCommonStyle_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCommonStyle_Type));
    PyModule_AddObject(module, "QCommonStyle",
        ((PyObject*)&SbkQCommonStyle_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QCommonStyle >("QCommonStyle*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCommonStyle >(typeid(QCommonStyle).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

