/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qbuttongroup_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractbutton.h>
#include <qbuttongroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QButtonGroupWrapper::QButtonGroupWrapper(QObject * parent) : QButtonGroup(parent), m_metaObject(0) {
    // ... middle
}

void QButtonGroupWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QButtonGroupWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QButtonGroupWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QButtonGroupWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QButtonGroupWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QButtonGroup.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QButtonGroupWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QButtonGroup.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QButtonGroupWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QButtonGroupWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QButtonGroup::staticMetaObject);
}
    return m_metaObject;
}

int QButtonGroupWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QButtonGroup::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QButtonGroupWrapper::~QButtonGroupWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQButtonGroup_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QButtonGroupWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QButtonGroup", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QButtonGroup(QObject*)
        cptr = new QButtonGroupWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QButtonGroup(QObject*)
        cptr = new QButtonGroupWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQButtonGroup_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQButtonGroup_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQButtonGroup_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QButtonGroup", overloads);
        return -1;
}

static PyObject*
SbkQButtonGroupFunc_addButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addButton", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QAbstractButton* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addButton(QAbstractButton*)
            QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
            cppSelf->QButtonGroup::addButton(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // addButton(QAbstractButton*,int)
            QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
            cppSelf->QButtonGroup::addButton(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQButtonGroupFunc_addButton_TypeError;
    } else goto SbkQButtonGroupFunc_addButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQButtonGroupFunc_addButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", "PySide.QtGui.QAbstractButton, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QButtonGroup.addButton", overloads);
        return 0;
}

static PyObject*
SbkQButtonGroupFunc_button(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // button(int)const
        QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
        QAbstractButton * cpp_result = cppSelf->QButtonGroup::button(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractButton* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQButtonGroupFunc_button_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQButtonGroupFunc_button_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QButtonGroup.button", overloads);
        return 0;
}

static PyObject*
SbkQButtonGroupFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
    QList<QAbstractButton * > cpp_result = cppSelf->QButtonGroup::buttons();
    py_result = Shiboken::Converter<QList<QAbstractButton * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQButtonGroupFunc_checkedButton(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // checkedButton()const
    QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
    QAbstractButton * cpp_result = cppSelf->QButtonGroup::checkedButton();
    py_result = Shiboken::Converter<QAbstractButton* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQButtonGroupFunc_checkedId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // checkedId()const
    QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QButtonGroup::checkedId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQButtonGroupFunc_exclusive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exclusive()const
    QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QButtonGroup::exclusive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQButtonGroupFunc_id(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // id(QAbstractButton*)const
        QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QButtonGroup::id(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQButtonGroupFunc_id_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQButtonGroupFunc_id_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QButtonGroup.id", overloads);
        return 0;
}

static PyObject*
SbkQButtonGroupFunc_removeButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractButton* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // removeButton(QAbstractButton*)
        QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
        cppSelf->QButtonGroup::removeButton(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQButtonGroupFunc_removeButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQButtonGroupFunc_removeButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QButtonGroup.removeButton", overloads);
        return 0;
}

static PyObject*
SbkQButtonGroupFunc_setExclusive(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setExclusive(bool)
        QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
        cppSelf->QButtonGroup::setExclusive(cpp_arg0);
    } else goto SbkQButtonGroupFunc_setExclusive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQButtonGroupFunc_setExclusive_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QButtonGroup.setExclusive", overloads);
        return 0;
}

static PyObject*
SbkQButtonGroupFunc_setId(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setId", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractButton* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setId(QAbstractButton*,int)
        QButtonGroup* cppSelf = Shiboken::Converter<QButtonGroup* >::toCpp((PyObject*)self);
        cppSelf->QButtonGroup::setId(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQButtonGroupFunc_setId_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQButtonGroupFunc_setId_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QButtonGroup.setId", overloads);
        return 0;
}

static PyMethodDef SbkQButtonGroup_methods[] = {
    {"addButton", (PyCFunction)SbkQButtonGroupFunc_addButton, METH_VARARGS},
    {"button", (PyCFunction)SbkQButtonGroupFunc_button, METH_O},
    {"buttons", (PyCFunction)SbkQButtonGroupFunc_buttons, METH_NOARGS},
    {"checkedButton", (PyCFunction)SbkQButtonGroupFunc_checkedButton, METH_NOARGS},
    {"checkedId", (PyCFunction)SbkQButtonGroupFunc_checkedId, METH_NOARGS},
    {"exclusive", (PyCFunction)SbkQButtonGroupFunc_exclusive, METH_NOARGS},
    {"id", (PyCFunction)SbkQButtonGroupFunc_id, METH_O},
    {"removeButton", (PyCFunction)SbkQButtonGroupFunc_removeButton, METH_O},
    {"setExclusive", (PyCFunction)SbkQButtonGroupFunc_setExclusive, METH_O},
    {"setId", (PyCFunction)SbkQButtonGroupFunc_setId, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQButtonGroup_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QButtonGroup",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QButtonGroupWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQButtonGroup_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQButtonGroup_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QButtonGroup(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QBUTTONGROUP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQButtonGroup_Type);

    SbkQButtonGroup_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQButtonGroup_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQButtonGroup_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQButtonGroup_Type));
    PyModule_AddObject(module, "QButtonGroup",
        ((PyObject*)&SbkQButtonGroup_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QButtonGroup >("QButtonGroup*");
    Shiboken::TypeResolver::createObjectTypeResolver<QButtonGroup >(typeid(QButtonGroup).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

