/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qboxlayout_wrapper.h"

// Extra includes
#include <qboxlayout.h>
#include <qcoreevent.h>
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qsize.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QBoxLayoutWrapper::QBoxLayoutWrapper(QBoxLayout::Direction arg__1, QWidget * parent) : QBoxLayout(arg__1, parent), m_metaObject(0) {
    // ... middle
}

void QBoxLayoutWrapper::addItem(QLayoutItem * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addItem"));
    if (py_override.isNull()) {
        return this->QBoxLayout::addItem(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QLayoutItem* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QBoxLayoutWrapper::childEvent(QChildEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QBoxLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QBoxLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QBoxLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.count");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QBoxLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QBoxLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QBoxLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QBoxLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::Orientation> QBoxLayoutWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QBoxLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.expandingDirections");
        return QFlags<Qt::Orientation>()        ;
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QBoxLayoutWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QLayout::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.geometry");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QBoxLayoutWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QBoxLayout::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.hasHeightForWidth");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QBoxLayoutWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QBoxLayout::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QBoxLayoutWrapper::indexOf(QWidget * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexOf"));
    if (py_override.isNull()) {
        return this->QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.indexOf");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QBoxLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QBoxLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QBoxLayoutWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.isEmpty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QBoxLayoutWrapper::itemAt(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QBoxLayout::itemAt(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.itemAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayout * QBoxLayoutWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayout::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.layout");
        return 0        ;
    }
    QLayout* cpp_result(Shiboken::Converter<QLayout* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QSize QBoxLayoutWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QBoxLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.maximumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QBoxLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QBoxLayout::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.minimumHeightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QBoxLayoutWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QBoxLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.minimumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QBoxLayoutWrapper::setGeometry(const QRect & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QBoxLayout::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRect& >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QBoxLayoutWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QBoxLayout::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QBoxLayoutWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.spacerItem");
        return 0        ;
    }
    QSpacerItem* cpp_result(Shiboken::Converter<QSpacerItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayoutItem * QBoxLayoutWrapper::takeAt(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "takeAt"));
    if (py_override.isNull()) {
        return this->QBoxLayout::takeAt(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.takeAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QBoxLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QBoxLayoutWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QBoxLayout.widget");
        return 0        ;
    }
    QWidget* cpp_result(Shiboken::Converter<QWidget* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

const QMetaObject* QBoxLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QBoxLayout::staticMetaObject);
}
    return m_metaObject;
}

int QBoxLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QBoxLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QBoxLayoutWrapper::~QBoxLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQBoxLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QBoxLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QBoxLayout", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QBoxLayout::Direction >::isConvertible(pyargs[0])) {
        QBoxLayout::Direction cpp_arg0 = Shiboken::Converter<QBoxLayout::Direction >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QBoxLayout(QBoxLayout::Direction,QWidget*)
            cptr = new QBoxLayoutWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QBoxLayout(QBoxLayout::Direction,QWidget*)
            cptr = new QBoxLayoutWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQBoxLayout_Init_TypeError;
    } else goto SbkQBoxLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQBoxLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQBoxLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBoxLayout.Direction, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout", overloads);
        return -1;
}

static PyObject*
SbkQBoxLayoutFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayoutItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(arg);
        // addItem(QLayoutItem*)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addItem(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
    } else goto SbkQBoxLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.addItem", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addLayout(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addLayout", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QLayout* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addLayout(QLayout*,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::addLayout(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // addLayout(QLayout*,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::addLayout(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQBoxLayoutFunc_addLayout_TypeError;
    } else goto SbkQBoxLayoutFunc_addLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.addLayout", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addSpacerItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSpacerItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSpacerItem* cpp_arg0 = Shiboken::Converter<QSpacerItem* >::toCpp(arg);
        // addSpacerItem(QSpacerItem*)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addSpacerItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQBoxLayoutFunc_addSpacerItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addSpacerItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSpacerItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.addSpacerItem", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addSpacing(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addSpacing(cpp_arg0);
    } else goto SbkQBoxLayoutFunc_addSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.addSpacing", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // addStretch(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addStretch();
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addStretch(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addStretch(cpp_arg0);
    } else goto SbkQBoxLayoutFunc_addStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addStretch_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.addStretch", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addStrut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addStrut(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::addStrut(cpp_arg0);
    } else goto SbkQBoxLayoutFunc_addStrut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addStrut_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.addStrut", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_addWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addWidget", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::addWidget(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
                QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
                cppSelf->QBoxLayout::addWidget(cpp_arg0, cpp_arg1);
                Shiboken::setParent(self, pyargs[0]);
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[2])) {
                QFlags<Qt::AlignmentFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[2]);
                // addWidget(QWidget*,int,QFlags<Qt::AlignmentFlag>)
                QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
                cppSelf->QBoxLayout::addWidget(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[0]);
            } else goto SbkQBoxLayoutFunc_addWidget_TypeError;
        } else goto SbkQBoxLayoutFunc_addWidget_TypeError;
    } else goto SbkQBoxLayoutFunc_addWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_addWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, int = 0, PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.addWidget", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QBoxLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_direction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // direction()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    QBoxLayout::Direction cpp_result = cppSelf->QBoxLayout::direction();
    py_result = Shiboken::Converter<QBoxLayout::Direction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QBoxLayout::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_hasHeightForWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHeightForWidth()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QBoxLayout::hasHeightForWidth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_heightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // heightForWidth(int)const
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QBoxLayout::heightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQBoxLayoutFunc_heightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_heightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.heightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QLayoutItem* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QLayoutItem* cpp_arg1 = Shiboken::Converter<QLayoutItem* >::toCpp(pyargs[1]);
        // insertItem(int,QLayoutItem*)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::insertItem(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQBoxLayoutFunc_insertItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertItem", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertLayout(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertLayout", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QLayout* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QLayout* cpp_arg1 = Shiboken::Converter<QLayout* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertLayout(int,QLayout*,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::insertLayout(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // insertLayout(int,QLayout*,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::insertLayout(cpp_arg0, cpp_arg1, cpp_arg2);
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQBoxLayoutFunc_insertLayout_TypeError;
    } else goto SbkQBoxLayoutFunc_insertLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertLayout_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QLayout, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertLayout", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertSpacerItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertSpacerItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QSpacerItem* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSpacerItem* cpp_arg1 = Shiboken::Converter<QSpacerItem* >::toCpp(pyargs[1]);
        // insertSpacerItem(int,QSpacerItem*)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::insertSpacerItem(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQBoxLayoutFunc_insertSpacerItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertSpacerItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QSpacerItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertSpacerItem", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertSpacing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // insertSpacing(int,int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::insertSpacing(cpp_arg0, cpp_arg1);
    } else goto SbkQBoxLayoutFunc_insertSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertSpacing_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertSpacing", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertStretch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertStretch", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertStretch(int,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::insertStretch(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // insertStretch(int,int)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::insertStretch(cpp_arg0, cpp_arg1);
        } else goto SbkQBoxLayoutFunc_insertStretch_TypeError;
    } else goto SbkQBoxLayoutFunc_insertStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertStretch_TypeError:
        const char* overloads[] = {"int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertStretch", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_insertWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertWidget", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
            QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
            cppSelf->QBoxLayout::insertWidget(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
                QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
                cppSelf->QBoxLayout::insertWidget(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[1]);
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[3])) {
                QFlags<Qt::AlignmentFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[3]);
                // insertWidget(int,QWidget*,int,QFlags<Qt::AlignmentFlag>)
                QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
                cppSelf->QBoxLayout::insertWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                Shiboken::setParent(self, pyargs[1]);
            } else goto SbkQBoxLayoutFunc_insertWidget_TypeError;
        } else goto SbkQBoxLayoutFunc_insertWidget_TypeError;
    } else goto SbkQBoxLayoutFunc_insertWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_insertWidget_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QWidget, int = 0, PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.insertWidget", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    cppSelf->QBoxLayout::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQBoxLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QBoxLayout::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQBoxLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QBoxLayout::maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_minimumHeightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // minimumHeightForWidth(int)const
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QBoxLayout::minimumHeightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQBoxLayoutFunc_minimumHeightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_minimumHeightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.minimumHeightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QBoxLayout::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_setDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBoxLayout::Direction >::isConvertible(arg)) {
        QBoxLayout::Direction cpp_arg0 = Shiboken::Converter<QBoxLayout::Direction >::toCpp(arg);
        // setDirection(QBoxLayout::Direction)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::setDirection(cpp_arg0);
    } else goto SbkQBoxLayoutFunc_setDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_setDirection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBoxLayout.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.setDirection", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::setGeometry(*cpp_arg0);
    } else goto SbkQBoxLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpacing(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::setSpacing(cpp_arg0);
    } else goto SbkQBoxLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.setSpacing", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_setStretch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStretch", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setStretch(int,int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        cppSelf->QBoxLayout::setStretch(cpp_arg0, cpp_arg1);
    } else goto SbkQBoxLayoutFunc_setStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBoxLayoutFunc_setStretch_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.setStretch", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_setStretchFactor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStretchFactor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setStretchFactor(QWidget*,int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QBoxLayout::setStretchFactor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setStretchFactor(QLayout*,int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QBoxLayout::setStretchFactor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQBoxLayoutFunc_setStretchFactor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_setStretchFactor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout, int", "PySide.QtGui.QWidget, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBoxLayout.setStretchFactor", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QBoxLayout::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QBoxLayout::spacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBoxLayoutFunc_stretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // stretch(int)const
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QBoxLayout::stretch(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQBoxLayoutFunc_stretch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_stretch_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.stretch", overloads);
        return 0;
}

static PyObject*
SbkQBoxLayoutFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QBoxLayout* cppSelf = Shiboken::Converter<QBoxLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QBoxLayout::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, 0);
        Shiboken::setParent(self, py_result);
    } else goto SbkQBoxLayoutFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBoxLayoutFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBoxLayout.takeAt", overloads);
        return 0;
}

static PyMethodDef SbkQBoxLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQBoxLayoutFunc_addItem, METH_O},
    {"addLayout", (PyCFunction)SbkQBoxLayoutFunc_addLayout, METH_VARARGS},
    {"addSpacerItem", (PyCFunction)SbkQBoxLayoutFunc_addSpacerItem, METH_O},
    {"addSpacing", (PyCFunction)SbkQBoxLayoutFunc_addSpacing, METH_O},
    {"addStretch", (PyCFunction)SbkQBoxLayoutFunc_addStretch, METH_NOARGS|METH_O},
    {"addStrut", (PyCFunction)SbkQBoxLayoutFunc_addStrut, METH_O},
    {"addWidget", (PyCFunction)SbkQBoxLayoutFunc_addWidget, METH_VARARGS},
    {"count", (PyCFunction)SbkQBoxLayoutFunc_count, METH_NOARGS},
    {"direction", (PyCFunction)SbkQBoxLayoutFunc_direction, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQBoxLayoutFunc_expandingDirections, METH_NOARGS},
    {"hasHeightForWidth", (PyCFunction)SbkQBoxLayoutFunc_hasHeightForWidth, METH_NOARGS},
    {"heightForWidth", (PyCFunction)SbkQBoxLayoutFunc_heightForWidth, METH_O},
    {"insertItem", (PyCFunction)SbkQBoxLayoutFunc_insertItem, METH_VARARGS},
    {"insertLayout", (PyCFunction)SbkQBoxLayoutFunc_insertLayout, METH_VARARGS},
    {"insertSpacerItem", (PyCFunction)SbkQBoxLayoutFunc_insertSpacerItem, METH_VARARGS},
    {"insertSpacing", (PyCFunction)SbkQBoxLayoutFunc_insertSpacing, METH_VARARGS},
    {"insertStretch", (PyCFunction)SbkQBoxLayoutFunc_insertStretch, METH_VARARGS},
    {"insertWidget", (PyCFunction)SbkQBoxLayoutFunc_insertWidget, METH_VARARGS},
    {"invalidate", (PyCFunction)SbkQBoxLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQBoxLayoutFunc_itemAt, METH_O},
    {"maximumSize", (PyCFunction)SbkQBoxLayoutFunc_maximumSize, METH_NOARGS},
    {"minimumHeightForWidth", (PyCFunction)SbkQBoxLayoutFunc_minimumHeightForWidth, METH_O},
    {"minimumSize", (PyCFunction)SbkQBoxLayoutFunc_minimumSize, METH_NOARGS},
    {"setDirection", (PyCFunction)SbkQBoxLayoutFunc_setDirection, METH_O},
    {"setGeometry", (PyCFunction)SbkQBoxLayoutFunc_setGeometry, METH_O},
    {"setSpacing", (PyCFunction)SbkQBoxLayoutFunc_setSpacing, METH_O},
    {"setStretch", (PyCFunction)SbkQBoxLayoutFunc_setStretch, METH_VARARGS},
    {"setStretchFactor", (PyCFunction)SbkQBoxLayoutFunc_setStretchFactor, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQBoxLayoutFunc_sizeHint, METH_NOARGS},
    {"spacing", (PyCFunction)SbkQBoxLayoutFunc_spacing, METH_NOARGS},
    {"stretch", (PyCFunction)SbkQBoxLayoutFunc_stretch, METH_O},
    {"takeAt", (PyCFunction)SbkQBoxLayoutFunc_takeAt, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQBoxLayoutSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QBoxLayout* me = reinterpret_cast<QBoxLayout*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]))
        return static_cast<QLayout*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast<QLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQBoxLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QBoxLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QBoxLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQBoxLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQBoxLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQBoxLayoutSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QBoxLayout_Direction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QBoxLayout_Direction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QBoxLayout_Direction_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Direction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QBoxLayout_Direction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QBoxLayout_Direction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QBoxLayout_Direction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QBoxLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQBoxLayout_Type);

    SbkQBoxLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX];
    SbkQBoxLayout_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX])->mi_init;

    // Fill type discovery information
    SbkQBoxLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQBoxLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQBoxLayout_Type));
    PyModule_AddObject(module, "QBoxLayout",
        ((PyObject*)&SbkQBoxLayout_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Direction
    SbkPySide_QtGuiTypes[SBK_QBOXLAYOUT_DIRECTION_IDX] = &SbkPySide_QtGui_QBoxLayout_Direction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QBoxLayout_Direction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QBoxLayout_Direction_Type);
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
            "Direction",((PyObject*)&SbkPySide_QtGui_QBoxLayout_Direction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::LeftToRight, "LeftToRight");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "LeftToRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "LeftToRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::RightToLeft, "RightToLeft");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "RightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "RightToLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::TopToBottom, "TopToBottom");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "TopToBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "TopToBottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::BottomToTop, "BottomToTop");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "BottomToTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "BottomToTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::Down, "Down");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "Down", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "Down", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QBoxLayout_Direction_Type,
        (long) QBoxLayout::Up, "Up");
    PyDict_SetItemString(SbkQBoxLayout_Type.super.ht_type.tp_dict,
        "Up", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QBoxLayout_Direction_Type.tp_dict,
        "Up", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QBoxLayout::Direction");

    Shiboken::TypeResolver::createObjectTypeResolver<QBoxLayout >("QBoxLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QBoxLayout >(typeid(QBoxLayout).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

