/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qapplication_wrapper.h"

// Extra includes
#include <QBasicTimer>
#include <QFont>
#include <QFontMetrics>
#include <QIcon>
#include <QList>
#include <QLocale>
#include <QPalette>
#include <QStyle>
#include <qapplication.h>
#include <qbytearray.h>
#include <qclipboard.h>
#include <qcoreapplication.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdesktopwidget.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qsessionmanager.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qthread.h>
#include <qtranslator.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Begin code injection
// ========================================================================
// START of custom code block [file: glue/qapplication_init.cpp]
// Borrowed reference to QtGui module
extern PyObject* moduleQtGui;

static int QApplicationArgCount;
static char** QApplicationArgValues;

void DeleteQApplicationAtExit() {
    if (QApplication::instance()) {
        delete QApplication::instance();
        for (int i = 0; i < QApplicationArgCount; ++i)
            delete[] QApplicationArgValues[i];
    }
}

int SbkQApplication_Init(PyObject* self, PyObject* args, PyObject*)
{
    if (QApplication::instance()) {
        PyErr_SetString(PyExc_RuntimeError, "A QApplication instance already exists.");
        return -1;
    }

    int numArgs = PyTuple_GET_SIZE(args);
    if (numArgs != 1) {
        PyErr_BadArgument();
        return -1;
    }

    if (!PySequenceToArgcArgv(PyTuple_GET_ITEM(args, 0), &QApplicationArgCount, &QApplicationArgValues, "PySideApp")) {
        PyErr_BadArgument();
        return -1;
    }

    SbkBaseWrapper_setCptr(self, new QApplication(QApplicationArgCount, QApplicationArgValues));
    SbkBaseWrapper_setValidCppObject(self, 1);
    Shiboken::BindingManager::instance().registerWrapper(reinterpret_cast<SbkBaseWrapper*>(self));

    // Verify if qApp is in main module
    const char QAPP_MACRO[] = "qApp";
    PyObject* localsDict = PyEval_GetLocals();
    if (localsDict) {
        PyObject* qAppObj = PyDict_GetItemString(localsDict, QAPP_MACRO);
        if (qAppObj)
            PyDict_SetItemString(localsDict, QAPP_MACRO, self);
    }
    PyObject_SetAttrString(moduleQtGui, QAPP_MACRO, self);

    Py_INCREF(self);
    Py_AtExit(DeleteQApplicationAtExit);

    return 1;
}

// END of custom code block [file: glue/qapplication_init.cpp]
// ========================================================================

// End of code injection

// Native ---------------------------------------------------------

void QApplicationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QApplicationWrapper::commitData(QSessionManager & sm)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QApplication::commitData(sm);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSessionManager& >::toPython(sm)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QApplicationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QApplicationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QApplicationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QApplicationWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QApplication.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QApplicationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QApplication.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QApplicationWrapper::notify(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "notify"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QApplication.notify");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QApplicationWrapper::saveState(QSessionManager & sm)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveState"));
    if (py_override.isNull()) {
        return this->QApplication::saveState(sm);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSessionManager& >::toPython(sm)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QApplicationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QApplicationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QApplication::staticMetaObject);
}
    return m_metaObject;
}

int QApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QApplicationWrapper::~QApplicationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static PyObject*
SbkQApplicationFunc_aboutQt(PyObject* self)
{

    // aboutQt()
    QApplication::aboutQt();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQApplicationFunc_activeModalWidget(PyObject* self)
{
    PyObject* py_result = 0;

    // activeModalWidget()
    QWidget * cpp_result = QApplication::activeModalWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_activePopupWidget(PyObject* self)
{
    PyObject* py_result = 0;

    // activePopupWidget()
    QWidget * cpp_result = QApplication::activePopupWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_activeWindow(PyObject* self)
{
    PyObject* py_result = 0;

    // activeWindow()
    QWidget * cpp_result = QApplication::activeWindow();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_alert(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "alert", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // alert(QWidget*,int)
            QApplication::alert(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // alert(QWidget*,int)
            QApplication::alert(cpp_arg0, cpp_arg1);
        } else goto SbkQApplicationFunc_alert_TypeError;
    } else goto SbkQApplicationFunc_alert_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_alert_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.alert", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_allWidgets(PyObject* self)
{
    PyObject* py_result = 0;

    // allWidgets()
    QList<QWidget * > cpp_result = QApplication::allWidgets();
    py_result = Shiboken::Converter<QList<QWidget * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_autoSipEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoSipEnabled()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QApplication::autoSipEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_beep(PyObject* self)
{

    // beep()
    QApplication::beep();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQApplicationFunc_changeOverrideCursor(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QCursor > cpp_arg0_auto_ptr;
        QCursor* cpp_arg0 = Shiboken::Converter<QCursor* >::toCpp(arg);
        if (!Shiboken::Converter<QCursor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QCursor >(cpp_arg0);
        // changeOverrideCursor(QCursor)
        QApplication::changeOverrideCursor(*cpp_arg0);
    } else goto SbkQApplicationFunc_changeOverrideCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_changeOverrideCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.changeOverrideCursor", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_clipboard(PyObject* self)
{
    PyObject* py_result = 0;

    // clipboard()
    QClipboard * cpp_result = QApplication::clipboard();
    py_result = Shiboken::Converter<QClipboard* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_closeAllWindows(PyObject* self)
{

    // closeAllWindows()
    QApplication::closeAllWindows();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQApplicationFunc_colorSpec(PyObject* self)
{
    PyObject* py_result = 0;

    // colorSpec()
    int cpp_result = QApplication::colorSpec();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_commitData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSessionManager& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSessionManager* cpp_arg0 = Shiboken::Converter<QSessionManager* >::toCpp(arg);
        // commitData(QSessionManager&)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        cppSelf->QApplication::commitData(*cpp_arg0);
    } else goto SbkQApplicationFunc_commitData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_commitData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSessionManager", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.commitData", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_cursorFlashTime(PyObject* self)
{
    PyObject* py_result = 0;

    // cursorFlashTime()
    int cpp_result = QApplication::cursorFlashTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_desktop(PyObject* self)
{
    PyObject* py_result = 0;

    // desktop()
    QDesktopWidget * cpp_result = QApplication::desktop();
    py_result = Shiboken::Converter<QDesktopWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_desktopSettingsAware(PyObject* self)
{
    PyObject* py_result = 0;

    // desktopSettingsAware()
    bool cpp_result = QApplication::desktopSettingsAware();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_doubleClickInterval(PyObject* self)
{
    PyObject* py_result = 0;

    // doubleClickInterval()
    int cpp_result = QApplication::doubleClickInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QApplication::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.event", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_exec_(PyObject* self)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // exec()
    thread_state_saver.save();
    int cpp_result = QApplication::exec();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_focusWidget(PyObject* self)
{
    PyObject* py_result = 0;

    // focusWidget()
    QWidget * cpp_result = QApplication::focusWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_font(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // font()
        QFont cpp_result = QApplication::font();
        py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // font(const QWidget*)
        QFont cpp_result = QApplication::font(cpp_arg0);
        py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_font_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_font_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.font", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_fontMetrics(PyObject* self)
{
    PyObject* py_result = 0;

    // fontMetrics()
    QFontMetrics cpp_result = QApplication::fontMetrics();
    py_result = Shiboken::Converter<QFontMetrics >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_globalStrut(PyObject* self)
{
    PyObject* py_result = 0;

    // globalStrut()
    QSize cpp_result = QApplication::globalStrut();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_inputContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputContext()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    QInputContext * cpp_result = cppSelf->QApplication::inputContext();
    py_result = Shiboken::Converter<QInputContext* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_isEffectEnabled(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::UIEffect >::isConvertible(arg)) {
        Qt::UIEffect cpp_arg0 = Shiboken::Converter<Qt::UIEffect >::toCpp(arg);
        // isEffectEnabled(Qt::UIEffect)
        bool cpp_result = QApplication::isEffectEnabled(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_isEffectEnabled_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_isEffectEnabled_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.UIEffect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.isEffectEnabled", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_isLeftToRight(PyObject* self)
{
    PyObject* py_result = 0;

    // isLeftToRight()
    bool cpp_result = QApplication::isLeftToRight();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_isRightToLeft(PyObject* self)
{
    PyObject* py_result = 0;

    // isRightToLeft()
    bool cpp_result = QApplication::isRightToLeft();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_isSessionRestored(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSessionRestored()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QApplication::isSessionRestored();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_keyboardInputDirection(PyObject* self)
{
    PyObject* py_result = 0;

    // keyboardInputDirection()
    Qt::LayoutDirection cpp_result = QApplication::keyboardInputDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_keyboardInputInterval(PyObject* self)
{
    PyObject* py_result = 0;

    // keyboardInputInterval()
    int cpp_result = QApplication::keyboardInputInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_keyboardInputLocale(PyObject* self)
{
    PyObject* py_result = 0;

    // keyboardInputLocale()
    QLocale cpp_result = QApplication::keyboardInputLocale();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_keyboardModifiers(PyObject* self)
{
    PyObject* py_result = 0;

    // keyboardModifiers()
    QFlags<Qt::KeyboardModifier> cpp_result = QApplication::keyboardModifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_layoutDirection(PyObject* self)
{
    PyObject* py_result = 0;

    // layoutDirection()
    Qt::LayoutDirection cpp_result = QApplication::layoutDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_mouseButtons(PyObject* self)
{
    PyObject* py_result = 0;

    // mouseButtons()
    QFlags<Qt::MouseButton> cpp_result = QApplication::mouseButtons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_notify(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "notify", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // notify(QObject*,QEvent*)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QApplication::notify(cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_notify_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_notify_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.notify", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_overrideCursor(PyObject* self)
{
    PyObject* py_result = 0;

    // overrideCursor()
    QCursor * cpp_result = QApplication::overrideCursor();
    py_result = Shiboken::Converter<QCursor* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_palette(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // palette()
        QPalette cpp_result = QApplication::palette();
        py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // palette(const QWidget*)
        QPalette cpp_result = QApplication::palette(cpp_arg0);
        py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_palette_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_palette_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.palette", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_quitOnLastWindowClosed(PyObject* self)
{
    PyObject* py_result = 0;

    // quitOnLastWindowClosed()
    bool cpp_result = QApplication::quitOnLastWindowClosed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_restoreOverrideCursor(PyObject* self)
{

    // restoreOverrideCursor()
    QApplication::restoreOverrideCursor();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQApplicationFunc_saveState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSessionManager& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSessionManager* cpp_arg0 = Shiboken::Converter<QSessionManager* >::toCpp(arg);
        // saveState(QSessionManager&)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        cppSelf->QApplication::saveState(*cpp_arg0);
    } else goto SbkQApplicationFunc_saveState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_saveState_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSessionManager", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.saveState", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_sessionId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionId()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QApplication::sessionId();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_sessionKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionKey()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QApplication::sessionKey();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_setActiveWindow(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setActiveWindow(QWidget*)
        QApplication::setActiveWindow(cpp_arg0);
    } else goto SbkQApplicationFunc_setActiveWindow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setActiveWindow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setActiveWindow", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setAutoSipEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoSipEnabled(bool)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        cppSelf->QApplication::setAutoSipEnabled(cpp_arg0);
    } else goto SbkQApplicationFunc_setAutoSipEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setAutoSipEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setAutoSipEnabled", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setColorSpec(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColorSpec(int)
        QApplication::setColorSpec(cpp_arg0);
    } else goto SbkQApplicationFunc_setColorSpec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setColorSpec_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setColorSpec", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setCursorFlashTime(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCursorFlashTime(int)
        QApplication::setCursorFlashTime(cpp_arg0);
    } else goto SbkQApplicationFunc_setCursorFlashTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setCursorFlashTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setCursorFlashTime", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setDesktopSettingsAware(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDesktopSettingsAware(bool)
        QApplication::setDesktopSettingsAware(cpp_arg0);
    } else goto SbkQApplicationFunc_setDesktopSettingsAware_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setDesktopSettingsAware_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setDesktopSettingsAware", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setDoubleClickInterval(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDoubleClickInterval(int)
        QApplication::setDoubleClickInterval(cpp_arg0);
    } else goto SbkQApplicationFunc_setDoubleClickInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setDoubleClickInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setDoubleClickInterval", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setEffectEnabled(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEffectEnabled", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::UIEffect >::isConvertible(pyargs[0])) {
        Qt::UIEffect cpp_arg0 = Shiboken::Converter<Qt::UIEffect >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setEffectEnabled(Qt::UIEffect,bool)
            QApplication::setEffectEnabled(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setEffectEnabled(Qt::UIEffect,bool)
            QApplication::setEffectEnabled(cpp_arg0, cpp_arg1);
        } else goto SbkQApplicationFunc_setEffectEnabled_TypeError;
    } else goto SbkQApplicationFunc_setEffectEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setEffectEnabled_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.UIEffect, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.setEffectEnabled", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setGlobalStrut(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setGlobalStrut(QSize)
        QApplication::setGlobalStrut(*cpp_arg0);
    } else goto SbkQApplicationFunc_setGlobalStrut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setGlobalStrut_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setGlobalStrut", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setGraphicsSystem(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setGraphicsSystem(QString)
        QApplication::setGraphicsSystem(*cpp_arg0);
    } else goto SbkQApplicationFunc_setGraphicsSystem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setGraphicsSystem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setGraphicsSystem", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setInputContext(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputContext* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputContext* cpp_arg0 = Shiboken::Converter<QInputContext* >::toCpp(arg);
        // setInputContext(QInputContext*)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        cppSelf->QApplication::setInputContext(cpp_arg0);
    } else goto SbkQApplicationFunc_setInputContext_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setInputContext_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputContext", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setInputContext", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setKeyboardInputInterval(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setKeyboardInputInterval(int)
        QApplication::setKeyboardInputInterval(cpp_arg0);
    } else goto SbkQApplicationFunc_setKeyboardInputInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setKeyboardInputInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setKeyboardInputInterval", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setLayoutDirection(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setLayoutDirection(Qt::LayoutDirection)
        QApplication::setLayoutDirection(cpp_arg0);
    } else goto SbkQApplicationFunc_setLayoutDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setLayoutDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setLayoutDirection", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setOverrideCursor(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QCursor > cpp_arg0_auto_ptr;
        QCursor* cpp_arg0 = Shiboken::Converter<QCursor* >::toCpp(arg);
        if (!Shiboken::Converter<QCursor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QCursor >(cpp_arg0);
        // setOverrideCursor(QCursor)
        QApplication::setOverrideCursor(*cpp_arg0);
    } else goto SbkQApplicationFunc_setOverrideCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setOverrideCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setOverrideCursor", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setPalette(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPalette", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPalette& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPalette& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        if (numArgs == 1) {
            // setPalette(QPalette,const char*)
            QApplication::setPalette(*cpp_arg0);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // setPalette(QPalette,const char*)
            QApplication::setPalette(*cpp_arg0, cpp_arg1);
        } else goto SbkQApplicationFunc_setPalette_TypeError;
    } else goto SbkQApplicationFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette, str = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.setPalette", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setQuitOnLastWindowClosed(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setQuitOnLastWindowClosed(bool)
        QApplication::setQuitOnLastWindowClosed(cpp_arg0);
    } else goto SbkQApplicationFunc_setQuitOnLastWindowClosed_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setQuitOnLastWindowClosed_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setQuitOnLastWindowClosed", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setStartDragDistance(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStartDragDistance(int)
        QApplication::setStartDragDistance(cpp_arg0);
    } else goto SbkQApplicationFunc_setStartDragDistance_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setStartDragDistance_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setStartDragDistance", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setStartDragTime(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStartDragTime(int)
        QApplication::setStartDragTime(cpp_arg0);
    } else goto SbkQApplicationFunc_setStartDragTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setStartDragTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setStartDragTime", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setStyle(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStyle(QString)
        QStyle * cpp_result = QApplication::setStyle(*cpp_arg0);
        py_result = Shiboken::Converter<QStyle* >::toPython(cpp_result);
    } else if (Shiboken::Converter<QStyle* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStyle* cpp_arg0 = Shiboken::Converter<QStyle* >::toCpp(arg);
        // setStyle(QStyle*)

        QApplication::setStyle(cpp_arg0);

        // Begin code injection
        
        Shiboken::setParent(Shiboken::Converter<QApplication* >::toPython(qApp), arg);
        
        // End of code injection
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQApplicationFunc_setStyle_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setStyle", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setStyleSheet(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStyleSheet(QString)
        QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
        cppSelf->QApplication::setStyleSheet(*cpp_arg0);
    } else goto SbkQApplicationFunc_setStyleSheet_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setStyleSheet_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setStyleSheet", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setWheelScrollLines(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setWheelScrollLines(int)
        QApplication::setWheelScrollLines(cpp_arg0);
    } else goto SbkQApplicationFunc_setWheelScrollLines_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setWheelScrollLines_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setWheelScrollLines", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_setWindowIcon(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setWindowIcon(QIcon)
        QApplication::setWindowIcon(*cpp_arg0);
    } else goto SbkQApplicationFunc_setWindowIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQApplicationFunc_setWindowIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QApplication.setWindowIcon", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_startDragDistance(PyObject* self)
{
    PyObject* py_result = 0;

    // startDragDistance()
    int cpp_result = QApplication::startDragDistance();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_startDragTime(PyObject* self)
{
    PyObject* py_result = 0;

    // startDragTime()
    int cpp_result = QApplication::startDragTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_style(PyObject* self)
{
    PyObject* py_result = 0;

    // style()

    QStyle * cpp_result = QApplication::style();
    py_result = Shiboken::Converter<QStyle* >::toPython(cpp_result);

    // Begin code injection
    
    Shiboken::setParent(Shiboken::Converter<QApplication* >::toPython(qApp), py_result);
    
    // End of code injection

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_styleSheet(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // styleSheet()const
    QApplication* cppSelf = Shiboken::Converter<QApplication* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QApplication::styleSheet();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_syncX(PyObject* self)
{

    // syncX()
    QApplication::syncX();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQApplicationFunc_topLevelAt(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "topLevelAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // topLevelAt(int,int)
        QWidget * cpp_result = QApplication::topLevelAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // topLevelAt(QPoint)
        QWidget * cpp_result = QApplication::topLevelAt(*cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_topLevelAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_topLevelAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.topLevelAt", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_topLevelWidgets(PyObject* self)
{
    PyObject* py_result = 0;

    // topLevelWidgets()
    QList<QWidget * > cpp_result = QApplication::topLevelWidgets();
    py_result = Shiboken::Converter<QList<QWidget * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_type(PyObject* self)
{
    PyObject* py_result = 0;

    // type()
    QApplication::Type cpp_result = QApplication::type();
    py_result = Shiboken::Converter<QApplication::Type >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_wheelScrollLines(PyObject* self)
{
    PyObject* py_result = 0;

    // wheelScrollLines()
    int cpp_result = QApplication::wheelScrollLines();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQApplicationFunc_widgetAt(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "widgetAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // widgetAt(int,int)
        QWidget * cpp_result = QApplication::widgetAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // widgetAt(QPoint)
        QWidget * cpp_result = QApplication::widgetAt(*cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    } else goto SbkQApplicationFunc_widgetAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQApplicationFunc_widgetAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QApplication.widgetAt", overloads);
        return 0;
}

static PyObject*
SbkQApplicationFunc_windowIcon(PyObject* self)
{
    PyObject* py_result = 0;

    // windowIcon()
    QIcon cpp_result = QApplication::windowIcon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQApplication_methods[] = {
    {"aboutQt", (PyCFunction)SbkQApplicationFunc_aboutQt, METH_NOARGS|METH_STATIC},
    {"activeModalWidget", (PyCFunction)SbkQApplicationFunc_activeModalWidget, METH_NOARGS|METH_STATIC},
    {"activePopupWidget", (PyCFunction)SbkQApplicationFunc_activePopupWidget, METH_NOARGS|METH_STATIC},
    {"activeWindow", (PyCFunction)SbkQApplicationFunc_activeWindow, METH_NOARGS|METH_STATIC},
    {"alert", (PyCFunction)SbkQApplicationFunc_alert, METH_VARARGS|METH_STATIC},
    {"allWidgets", (PyCFunction)SbkQApplicationFunc_allWidgets, METH_NOARGS|METH_STATIC},
    {"autoSipEnabled", (PyCFunction)SbkQApplicationFunc_autoSipEnabled, METH_NOARGS},
    {"beep", (PyCFunction)SbkQApplicationFunc_beep, METH_NOARGS|METH_STATIC},
    {"changeOverrideCursor", (PyCFunction)SbkQApplicationFunc_changeOverrideCursor, METH_O|METH_STATIC},
    {"clipboard", (PyCFunction)SbkQApplicationFunc_clipboard, METH_NOARGS|METH_STATIC},
    {"closeAllWindows", (PyCFunction)SbkQApplicationFunc_closeAllWindows, METH_NOARGS|METH_STATIC},
    {"colorSpec", (PyCFunction)SbkQApplicationFunc_colorSpec, METH_NOARGS|METH_STATIC},
    {"commitData", (PyCFunction)SbkQApplicationFunc_commitData, METH_O},
    {"cursorFlashTime", (PyCFunction)SbkQApplicationFunc_cursorFlashTime, METH_NOARGS|METH_STATIC},
    {"desktop", (PyCFunction)SbkQApplicationFunc_desktop, METH_NOARGS|METH_STATIC},
    {"desktopSettingsAware", (PyCFunction)SbkQApplicationFunc_desktopSettingsAware, METH_NOARGS|METH_STATIC},
    {"doubleClickInterval", (PyCFunction)SbkQApplicationFunc_doubleClickInterval, METH_NOARGS|METH_STATIC},
    {"event", (PyCFunction)SbkQApplicationFunc_event, METH_O},
    {"exec_", (PyCFunction)SbkQApplicationFunc_exec_, METH_NOARGS|METH_STATIC},
    {"focusWidget", (PyCFunction)SbkQApplicationFunc_focusWidget, METH_NOARGS|METH_STATIC},
    {"font", (PyCFunction)SbkQApplicationFunc_font, METH_NOARGS|METH_O|METH_STATIC},
    {"fontMetrics", (PyCFunction)SbkQApplicationFunc_fontMetrics, METH_NOARGS|METH_STATIC},
    {"globalStrut", (PyCFunction)SbkQApplicationFunc_globalStrut, METH_NOARGS|METH_STATIC},
    {"inputContext", (PyCFunction)SbkQApplicationFunc_inputContext, METH_NOARGS},
    {"isEffectEnabled", (PyCFunction)SbkQApplicationFunc_isEffectEnabled, METH_O|METH_STATIC},
    {"isLeftToRight", (PyCFunction)SbkQApplicationFunc_isLeftToRight, METH_NOARGS|METH_STATIC},
    {"isRightToLeft", (PyCFunction)SbkQApplicationFunc_isRightToLeft, METH_NOARGS|METH_STATIC},
    {"isSessionRestored", (PyCFunction)SbkQApplicationFunc_isSessionRestored, METH_NOARGS},
    {"keyboardInputDirection", (PyCFunction)SbkQApplicationFunc_keyboardInputDirection, METH_NOARGS|METH_STATIC},
    {"keyboardInputInterval", (PyCFunction)SbkQApplicationFunc_keyboardInputInterval, METH_NOARGS|METH_STATIC},
    {"keyboardInputLocale", (PyCFunction)SbkQApplicationFunc_keyboardInputLocale, METH_NOARGS|METH_STATIC},
    {"keyboardModifiers", (PyCFunction)SbkQApplicationFunc_keyboardModifiers, METH_NOARGS|METH_STATIC},
    {"layoutDirection", (PyCFunction)SbkQApplicationFunc_layoutDirection, METH_NOARGS|METH_STATIC},
    {"mouseButtons", (PyCFunction)SbkQApplicationFunc_mouseButtons, METH_NOARGS|METH_STATIC},
    {"notify", (PyCFunction)SbkQApplicationFunc_notify, METH_VARARGS},
    {"overrideCursor", (PyCFunction)SbkQApplicationFunc_overrideCursor, METH_NOARGS|METH_STATIC},
    {"palette", (PyCFunction)SbkQApplicationFunc_palette, METH_NOARGS|METH_O|METH_STATIC},
    {"quitOnLastWindowClosed", (PyCFunction)SbkQApplicationFunc_quitOnLastWindowClosed, METH_NOARGS|METH_STATIC},
    {"restoreOverrideCursor", (PyCFunction)SbkQApplicationFunc_restoreOverrideCursor, METH_NOARGS|METH_STATIC},
    {"saveState", (PyCFunction)SbkQApplicationFunc_saveState, METH_O},
    {"sessionId", (PyCFunction)SbkQApplicationFunc_sessionId, METH_NOARGS},
    {"sessionKey", (PyCFunction)SbkQApplicationFunc_sessionKey, METH_NOARGS},
    {"setActiveWindow", (PyCFunction)SbkQApplicationFunc_setActiveWindow, METH_O|METH_STATIC},
    {"setAutoSipEnabled", (PyCFunction)SbkQApplicationFunc_setAutoSipEnabled, METH_O},
    {"setColorSpec", (PyCFunction)SbkQApplicationFunc_setColorSpec, METH_O|METH_STATIC},
    {"setCursorFlashTime", (PyCFunction)SbkQApplicationFunc_setCursorFlashTime, METH_O|METH_STATIC},
    {"setDesktopSettingsAware", (PyCFunction)SbkQApplicationFunc_setDesktopSettingsAware, METH_O|METH_STATIC},
    {"setDoubleClickInterval", (PyCFunction)SbkQApplicationFunc_setDoubleClickInterval, METH_O|METH_STATIC},
    {"setEffectEnabled", (PyCFunction)SbkQApplicationFunc_setEffectEnabled, METH_VARARGS|METH_STATIC},
    {"setGlobalStrut", (PyCFunction)SbkQApplicationFunc_setGlobalStrut, METH_O|METH_STATIC},
    {"setGraphicsSystem", (PyCFunction)SbkQApplicationFunc_setGraphicsSystem, METH_O|METH_STATIC},
    {"setInputContext", (PyCFunction)SbkQApplicationFunc_setInputContext, METH_O},
    {"setKeyboardInputInterval", (PyCFunction)SbkQApplicationFunc_setKeyboardInputInterval, METH_O|METH_STATIC},
    {"setLayoutDirection", (PyCFunction)SbkQApplicationFunc_setLayoutDirection, METH_O|METH_STATIC},
    {"setOverrideCursor", (PyCFunction)SbkQApplicationFunc_setOverrideCursor, METH_O|METH_STATIC},
    {"setPalette", (PyCFunction)SbkQApplicationFunc_setPalette, METH_VARARGS|METH_STATIC},
    {"setQuitOnLastWindowClosed", (PyCFunction)SbkQApplicationFunc_setQuitOnLastWindowClosed, METH_O|METH_STATIC},
    {"setStartDragDistance", (PyCFunction)SbkQApplicationFunc_setStartDragDistance, METH_O|METH_STATIC},
    {"setStartDragTime", (PyCFunction)SbkQApplicationFunc_setStartDragTime, METH_O|METH_STATIC},
    {"setStyle", (PyCFunction)SbkQApplicationFunc_setStyle, METH_O|METH_STATIC},
    {"setStyleSheet", (PyCFunction)SbkQApplicationFunc_setStyleSheet, METH_O},
    {"setWheelScrollLines", (PyCFunction)SbkQApplicationFunc_setWheelScrollLines, METH_O|METH_STATIC},
    {"setWindowIcon", (PyCFunction)SbkQApplicationFunc_setWindowIcon, METH_O|METH_STATIC},
    {"startDragDistance", (PyCFunction)SbkQApplicationFunc_startDragDistance, METH_NOARGS|METH_STATIC},
    {"startDragTime", (PyCFunction)SbkQApplicationFunc_startDragTime, METH_NOARGS|METH_STATIC},
    {"style", (PyCFunction)SbkQApplicationFunc_style, METH_NOARGS|METH_STATIC},
    {"styleSheet", (PyCFunction)SbkQApplicationFunc_styleSheet, METH_NOARGS},
    {"syncX", (PyCFunction)SbkQApplicationFunc_syncX, METH_NOARGS|METH_STATIC},
    {"topLevelAt", (PyCFunction)SbkQApplicationFunc_topLevelAt, METH_VARARGS|METH_STATIC},
    {"topLevelWidgets", (PyCFunction)SbkQApplicationFunc_topLevelWidgets, METH_NOARGS|METH_STATIC},
    {"type", (PyCFunction)SbkQApplicationFunc_type, METH_NOARGS|METH_STATIC},
    {"wheelScrollLines", (PyCFunction)SbkQApplicationFunc_wheelScrollLines, METH_NOARGS|METH_STATIC},
    {"widgetAt", (PyCFunction)SbkQApplicationFunc_widgetAt, METH_VARARGS|METH_STATIC},
    {"windowIcon", (PyCFunction)SbkQApplicationFunc_windowIcon, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQApplication_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QApplication",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QApplicationWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQApplication_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQApplication_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QApplication_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QApplication_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QApplication_Type_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QApplication_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QApplication_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QApplication_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QApplication_ColorSpec_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QApplication_ColorSpec_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QApplication_ColorSpec_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ColorSpec",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QApplication_ColorSpec_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QApplication_ColorSpec_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QApplication_ColorSpec_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QApplication(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QAPPLICATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQApplication_Type);


    SbkQApplication_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_IDX];
    // Fill type discovery information
    SbkQApplication_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQApplication_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQApplication_Type));
    PyModule_AddObject(module, "QApplication",
        ((PyObject*)&SbkQApplication_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Type
    SbkPySide_QtGuiTypes[SBK_QAPPLICATION_TYPE_IDX] = &SbkPySide_QtGui_QApplication_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QApplication_Type_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QApplication_Type_Type);
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkPySide_QtGui_QApplication_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_Type_Type,
        (long) QApplication::Tty, "Tty");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "Tty", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_Type_Type.tp_dict,
        "Tty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_Type_Type,
        (long) QApplication::GuiClient, "GuiClient");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "GuiClient", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_Type_Type.tp_dict,
        "GuiClient", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_Type_Type,
        (long) QApplication::GuiServer, "GuiServer");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "GuiServer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_Type_Type.tp_dict,
        "GuiServer", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QApplication::Type");

    // init enum class: ColorSpec
    SbkPySide_QtGuiTypes[SBK_QAPPLICATION_COLORSPEC_IDX] = &SbkPySide_QtGui_QApplication_ColorSpec_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QApplication_ColorSpec_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QApplication_ColorSpec_Type);
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
            "ColorSpec",((PyObject*)&SbkPySide_QtGui_QApplication_ColorSpec_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_ColorSpec_Type,
        (long) QApplication::NormalColor, "NormalColor");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "NormalColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_ColorSpec_Type.tp_dict,
        "NormalColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_ColorSpec_Type,
        (long) QApplication::CustomColor, "CustomColor");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "CustomColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_ColorSpec_Type.tp_dict,
        "CustomColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QApplication_ColorSpec_Type,
        (long) QApplication::ManyColor, "ManyColor");
    PyDict_SetItemString(SbkQApplication_Type.super.ht_type.tp_dict,
        "ManyColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QApplication_ColorSpec_Type.tp_dict,
        "ManyColor", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QApplication::ColorSpec");


    Shiboken::TypeResolver::createObjectTypeResolver<QApplication >("QApplication*");
    Shiboken::TypeResolver::createObjectTypeResolver<QApplication >(typeid(QApplication).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken


