/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qactionevent_wrapper.h"

// Extra includes
#include <qaction.h>

using namespace Shiboken;

static int
SbkQActionEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QActionEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QActionEvent", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QAction* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QAction* cpp_arg1 = Shiboken::Converter<QAction* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QActionEvent(int,QAction*,QAction*)
            cptr = new QActionEvent(cpp_arg0, cpp_arg1);
        } else if (Shiboken::Converter<QAction* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QAction* cpp_arg2 = Shiboken::Converter<QAction* >::toCpp(pyargs[2]);
            // QActionEvent(int,QAction*,QAction*)
            cptr = new QActionEvent(cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQActionEvent_Init_TypeError;
    } else goto SbkQActionEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQActionEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQActionEvent_Init_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QAction, PySide.QtGui.QAction = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QActionEvent", overloads);
        return -1;
}

static PyObject*
SbkQActionEventFunc_action(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // action()const
    QActionEvent* cppSelf = Shiboken::Converter<QActionEvent* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QActionEvent::action();
    py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQActionEventFunc_before(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // before()const
    QActionEvent* cppSelf = Shiboken::Converter<QActionEvent* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QActionEvent::before();
    py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQActionEvent_methods[] = {
    {"action", (PyCFunction)SbkQActionEventFunc_action, METH_NOARGS},
    {"before", (PyCFunction)SbkQActionEventFunc_before, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQActionEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QActionEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QActionEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQActionEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQActionEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QActionEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QACTIONEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQActionEvent_Type);

    SbkQActionEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQActionEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQActionEvent_Type));
    PyModule_AddObject(module, "QActionEvent",
        ((PyObject*)&SbkQActionEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QActionEvent >("QActionEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QActionEvent >(typeid(QActionEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

