/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qxmlstreamreader_wrapper.h"

// Extra includes
#include <QVector>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qxmlstream.h>

using namespace Shiboken;

static int
SbkQXmlStreamReader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlStreamReader* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlStreamReader", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlStreamReader()
        cptr = new QXmlStreamReader();
    } else if (numArgs == 1 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // QXmlStreamReader(QByteArray)
        cptr = new QXmlStreamReader(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QXmlStreamReader(QString)
        cptr = new QXmlStreamReader(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // QXmlStreamReader(QIODevice*)
        cptr = new QXmlStreamReader(cpp_arg0);
    } else goto SbkQXmlStreamReader_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlStreamReader_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQXmlStreamReader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", "PySide.QtCore.QByteArray", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamReader", overloads);
        return -1;
}

static PyObject*
SbkQXmlStreamReaderFunc_addData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // addData(QByteArray)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::addData(*cpp_arg0);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addData(QString)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::addData(*cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_addData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_addData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.addData", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_addExtraNamespaceDeclaration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlStreamNamespaceDeclaration& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamNamespaceDeclaration* cpp_arg0 = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp(arg);
        // addExtraNamespaceDeclaration(QXmlStreamNamespaceDeclaration)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::addExtraNamespaceDeclaration(*cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_addExtraNamespaceDeclaration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_addExtraNamespaceDeclaration_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamNamespaceDeclaration", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.addExtraNamespaceDeclaration", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_addExtraNamespaceDeclarations(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QXmlStreamNamespaceDeclaration >  >::isConvertible(arg)) {
        QVector<QXmlStreamNamespaceDeclaration >  cpp_arg0 = Shiboken::Converter<QVector<QXmlStreamNamespaceDeclaration >  >::toCpp(arg);
        // addExtraNamespaceDeclarations(QVector<QXmlStreamNamespaceDeclaration>)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::addExtraNamespaceDeclarations(cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_addExtraNamespaceDeclarations_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_addExtraNamespaceDeclarations_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.addExtraNamespaceDeclarations", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_attributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attributes()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QXmlStreamAttributes cpp_result = cppSelf->QXmlStreamReader::attributes();
    py_result = Shiboken::Converter<QXmlStreamAttributes >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_characterOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // characterOffset()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QXmlStreamReader::characterOffset();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamReader::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlStreamReaderFunc_columnNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnNumber()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QXmlStreamReader::columnNumber();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QXmlStreamReader::device();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_documentEncoding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentEncoding()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::documentEncoding();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_documentVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentVersion()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::documentVersion();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_dtdName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dtdName()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::dtdName();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_dtdPublicId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dtdPublicId()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::dtdPublicId();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_dtdSystemId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dtdSystemId()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::dtdSystemId();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_entityDeclarations(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // entityDeclarations()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QVector<QXmlStreamEntityDeclaration > cpp_result = cppSelf->QXmlStreamReader::entityDeclarations();
    py_result = Shiboken::Converter<QVector<QXmlStreamEntityDeclaration > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_entityResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // entityResolver()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QXmlStreamEntityResolver * cpp_result = cppSelf->QXmlStreamReader::entityResolver();
    py_result = Shiboken::Converter<QXmlStreamEntityResolver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QXmlStreamReader::Error cpp_result = cppSelf->QXmlStreamReader::error();
    py_result = Shiboken::Converter<QXmlStreamReader::Error >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QXmlStreamReader::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_hasError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasError()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::hasError();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isCDATA(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCDATA()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isCDATA();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isCharacters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCharacters()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isCharacters();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isComment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isComment()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isComment();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isDTD(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDTD()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isDTD();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isEndDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEndDocument()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isEndDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isEndElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEndElement()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isEndElement();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isEntityReference(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEntityReference()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isEntityReference();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isProcessingInstruction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isProcessingInstruction()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isProcessingInstruction();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isStandaloneDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isStandaloneDocument()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isStandaloneDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isStartDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isStartDocument()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isStartDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isStartElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isStartElement()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isStartElement();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_isWhitespace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWhitespace()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::isWhitespace();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_lineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineNumber()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QXmlStreamReader::lineNumber();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::name();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_namespaceDeclarations(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceDeclarations()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QVector<QXmlStreamNamespaceDeclaration > cpp_result = cppSelf->QXmlStreamReader::namespaceDeclarations();
    py_result = Shiboken::Converter<QVector<QXmlStreamNamespaceDeclaration > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_namespaceProcessing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceProcessing()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::namespaceProcessing();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_namespaceUri(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceUri()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::namespaceUri();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_notationDeclarations(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notationDeclarations()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QVector<QXmlStreamNotationDeclaration > cpp_result = cppSelf->QXmlStreamReader::notationDeclarations();
    py_result = Shiboken::Converter<QVector<QXmlStreamNotationDeclaration > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_prefix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefix()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::prefix();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_processingInstructionData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processingInstructionData()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::processingInstructionData();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_processingInstructionTarget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processingInstructionTarget()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::processingInstructionTarget();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_qualifiedName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // qualifiedName()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::qualifiedName();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_raiseError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // raiseError(QString)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::raiseError();
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // raiseError(QString)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::raiseError(*cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_raiseError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_raiseError_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.raiseError", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_readElementText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // readElementText()
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlStreamReader::readElementText();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QXmlStreamReader::ReadElementTextBehaviour >::isConvertible(arg)) {
        QXmlStreamReader::ReadElementTextBehaviour cpp_arg0 = Shiboken::Converter<QXmlStreamReader::ReadElementTextBehaviour >::toCpp(arg);
        // readElementText(QXmlStreamReader::ReadElementTextBehaviour)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlStreamReader::readElementText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQXmlStreamReaderFunc_readElementText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlStreamReaderFunc_readElementText_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QXmlStreamReader.ReadElementTextBehaviour", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.readElementText", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_readNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readNext()
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QXmlStreamReader::TokenType cpp_result = cppSelf->QXmlStreamReader::readNext();
    py_result = Shiboken::Converter<QXmlStreamReader::TokenType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_readNextStartElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readNextStartElement()
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamReader::readNextStartElement();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::setDevice(cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.setDevice", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_setEntityResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlStreamEntityResolver* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamEntityResolver* cpp_arg0 = Shiboken::Converter<QXmlStreamEntityResolver* >::toCpp(arg);
        // setEntityResolver(QXmlStreamEntityResolver*)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::setEntityResolver(cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_setEntityResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_setEntityResolver_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamEntityResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.setEntityResolver", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_setNamespaceProcessing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setNamespaceProcessing(bool)
        QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamReader::setNamespaceProcessing(cpp_arg0);
    } else goto SbkQXmlStreamReaderFunc_setNamespaceProcessing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamReaderFunc_setNamespaceProcessing_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamReader.setNamespaceProcessing", overloads);
        return 0;
}

static PyObject*
SbkQXmlStreamReaderFunc_skipCurrentElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // skipCurrentElement()
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamReader::skipCurrentElement();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlStreamReaderFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamReader::text();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_tokenString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tokenString()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QXmlStreamReader::tokenString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamReaderFunc_tokenType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tokenType()const
    QXmlStreamReader* cppSelf = Shiboken::Converter<QXmlStreamReader* >::toCpp((PyObject*)self);
    QXmlStreamReader::TokenType cpp_result = cppSelf->QXmlStreamReader::tokenType();
    py_result = Shiboken::Converter<QXmlStreamReader::TokenType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQXmlStreamReader_methods[] = {
    {"addData", (PyCFunction)SbkQXmlStreamReaderFunc_addData, METH_O},
    {"addExtraNamespaceDeclaration", (PyCFunction)SbkQXmlStreamReaderFunc_addExtraNamespaceDeclaration, METH_O},
    {"addExtraNamespaceDeclarations", (PyCFunction)SbkQXmlStreamReaderFunc_addExtraNamespaceDeclarations, METH_O},
    {"atEnd", (PyCFunction)SbkQXmlStreamReaderFunc_atEnd, METH_NOARGS},
    {"attributes", (PyCFunction)SbkQXmlStreamReaderFunc_attributes, METH_NOARGS},
    {"characterOffset", (PyCFunction)SbkQXmlStreamReaderFunc_characterOffset, METH_NOARGS},
    {"clear", (PyCFunction)SbkQXmlStreamReaderFunc_clear, METH_NOARGS},
    {"columnNumber", (PyCFunction)SbkQXmlStreamReaderFunc_columnNumber, METH_NOARGS},
    {"device", (PyCFunction)SbkQXmlStreamReaderFunc_device, METH_NOARGS},
    {"documentEncoding", (PyCFunction)SbkQXmlStreamReaderFunc_documentEncoding, METH_NOARGS},
    {"documentVersion", (PyCFunction)SbkQXmlStreamReaderFunc_documentVersion, METH_NOARGS},
    {"dtdName", (PyCFunction)SbkQXmlStreamReaderFunc_dtdName, METH_NOARGS},
    {"dtdPublicId", (PyCFunction)SbkQXmlStreamReaderFunc_dtdPublicId, METH_NOARGS},
    {"dtdSystemId", (PyCFunction)SbkQXmlStreamReaderFunc_dtdSystemId, METH_NOARGS},
    {"entityDeclarations", (PyCFunction)SbkQXmlStreamReaderFunc_entityDeclarations, METH_NOARGS},
    {"entityResolver", (PyCFunction)SbkQXmlStreamReaderFunc_entityResolver, METH_NOARGS},
    {"error", (PyCFunction)SbkQXmlStreamReaderFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQXmlStreamReaderFunc_errorString, METH_NOARGS},
    {"hasError", (PyCFunction)SbkQXmlStreamReaderFunc_hasError, METH_NOARGS},
    {"isCDATA", (PyCFunction)SbkQXmlStreamReaderFunc_isCDATA, METH_NOARGS},
    {"isCharacters", (PyCFunction)SbkQXmlStreamReaderFunc_isCharacters, METH_NOARGS},
    {"isComment", (PyCFunction)SbkQXmlStreamReaderFunc_isComment, METH_NOARGS},
    {"isDTD", (PyCFunction)SbkQXmlStreamReaderFunc_isDTD, METH_NOARGS},
    {"isEndDocument", (PyCFunction)SbkQXmlStreamReaderFunc_isEndDocument, METH_NOARGS},
    {"isEndElement", (PyCFunction)SbkQXmlStreamReaderFunc_isEndElement, METH_NOARGS},
    {"isEntityReference", (PyCFunction)SbkQXmlStreamReaderFunc_isEntityReference, METH_NOARGS},
    {"isProcessingInstruction", (PyCFunction)SbkQXmlStreamReaderFunc_isProcessingInstruction, METH_NOARGS},
    {"isStandaloneDocument", (PyCFunction)SbkQXmlStreamReaderFunc_isStandaloneDocument, METH_NOARGS},
    {"isStartDocument", (PyCFunction)SbkQXmlStreamReaderFunc_isStartDocument, METH_NOARGS},
    {"isStartElement", (PyCFunction)SbkQXmlStreamReaderFunc_isStartElement, METH_NOARGS},
    {"isWhitespace", (PyCFunction)SbkQXmlStreamReaderFunc_isWhitespace, METH_NOARGS},
    {"lineNumber", (PyCFunction)SbkQXmlStreamReaderFunc_lineNumber, METH_NOARGS},
    {"name", (PyCFunction)SbkQXmlStreamReaderFunc_name, METH_NOARGS},
    {"namespaceDeclarations", (PyCFunction)SbkQXmlStreamReaderFunc_namespaceDeclarations, METH_NOARGS},
    {"namespaceProcessing", (PyCFunction)SbkQXmlStreamReaderFunc_namespaceProcessing, METH_NOARGS},
    {"namespaceUri", (PyCFunction)SbkQXmlStreamReaderFunc_namespaceUri, METH_NOARGS},
    {"notationDeclarations", (PyCFunction)SbkQXmlStreamReaderFunc_notationDeclarations, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQXmlStreamReaderFunc_prefix, METH_NOARGS},
    {"processingInstructionData", (PyCFunction)SbkQXmlStreamReaderFunc_processingInstructionData, METH_NOARGS},
    {"processingInstructionTarget", (PyCFunction)SbkQXmlStreamReaderFunc_processingInstructionTarget, METH_NOARGS},
    {"qualifiedName", (PyCFunction)SbkQXmlStreamReaderFunc_qualifiedName, METH_NOARGS},
    {"raiseError", (PyCFunction)SbkQXmlStreamReaderFunc_raiseError, METH_NOARGS|METH_O},
    {"readElementText", (PyCFunction)SbkQXmlStreamReaderFunc_readElementText, METH_NOARGS|METH_O},
    {"readNext", (PyCFunction)SbkQXmlStreamReaderFunc_readNext, METH_NOARGS},
    {"readNextStartElement", (PyCFunction)SbkQXmlStreamReaderFunc_readNextStartElement, METH_NOARGS},
    {"setDevice", (PyCFunction)SbkQXmlStreamReaderFunc_setDevice, METH_O},
    {"setEntityResolver", (PyCFunction)SbkQXmlStreamReaderFunc_setEntityResolver, METH_O},
    {"setNamespaceProcessing", (PyCFunction)SbkQXmlStreamReaderFunc_setNamespaceProcessing, METH_O},
    {"skipCurrentElement", (PyCFunction)SbkQXmlStreamReaderFunc_skipCurrentElement, METH_NOARGS},
    {"text", (PyCFunction)SbkQXmlStreamReaderFunc_text, METH_NOARGS},
    {"tokenString", (PyCFunction)SbkQXmlStreamReaderFunc_tokenString, METH_NOARGS},
    {"tokenType", (PyCFunction)SbkQXmlStreamReaderFunc_tokenType, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlStreamReader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QXmlStreamReader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlStreamReader >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlStreamReader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlStreamReader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QXmlStreamReader_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QXmlStreamReader_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QXmlStreamReader_Error_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QXmlStreamReader_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QXmlStreamReader_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QXmlStreamReader_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QXmlStreamReader_TokenType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QXmlStreamReader_TokenType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QXmlStreamReader_TokenType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TokenType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QXmlStreamReader_TokenType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QXmlStreamReader_TokenType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QXmlStreamReader_TokenType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ReadElementTextBehaviour",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QXmlStreamReader(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlStreamReader_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlStreamReader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlStreamReader_Type));
    PyModule_AddObject(module, "QXmlStreamReader",
        ((PyObject*)&SbkQXmlStreamReader_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX] = &SbkPySide_QtCore_QXmlStreamReader_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QXmlStreamReader_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QXmlStreamReader_Error_Type);
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtCore_QXmlStreamReader_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_Error_Type,
        (long) QXmlStreamReader::NoError, "NoError");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_Error_Type,
        (long) QXmlStreamReader::UnexpectedElementError, "UnexpectedElementError");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "UnexpectedElementError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_Error_Type.tp_dict,
        "UnexpectedElementError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_Error_Type,
        (long) QXmlStreamReader::CustomError, "CustomError");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "CustomError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_Error_Type.tp_dict,
        "CustomError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_Error_Type,
        (long) QXmlStreamReader::NotWellFormedError, "NotWellFormedError");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "NotWellFormedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_Error_Type.tp_dict,
        "NotWellFormedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_Error_Type,
        (long) QXmlStreamReader::PrematureEndOfDocumentError, "PrematureEndOfDocumentError");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "PrematureEndOfDocumentError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_Error_Type.tp_dict,
        "PrematureEndOfDocumentError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlStreamReader::Error");

    // init enum class: TokenType
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX] = &SbkPySide_QtCore_QXmlStreamReader_TokenType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type);
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
            "TokenType",((PyObject*)&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::NoToken, "NoToken");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "NoToken", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "NoToken", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::Invalid, "Invalid");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::StartDocument, "StartDocument");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "StartDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "StartDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::EndDocument, "EndDocument");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "EndDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "EndDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::StartElement, "StartElement");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "StartElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "StartElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::EndElement, "EndElement");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "EndElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "EndElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::Characters, "Characters");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "Characters", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "Characters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::Comment, "Comment");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "Comment", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "Comment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::DTD, "DTD");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "DTD", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "DTD", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::EntityReference, "EntityReference");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "EntityReference", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "EntityReference", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_TokenType_Type,
        (long) QXmlStreamReader::ProcessingInstruction, "ProcessingInstruction");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "ProcessingInstruction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_TokenType_Type.tp_dict,
        "ProcessingInstruction", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlStreamReader::TokenType");

    // init enum class: ReadElementTextBehaviour
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX] = &SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type);
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
            "ReadElementTextBehaviour",((PyObject*)&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type,
        (long) QXmlStreamReader::ErrorOnUnexpectedElement, "ErrorOnUnexpectedElement");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "ErrorOnUnexpectedElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type.tp_dict,
        "ErrorOnUnexpectedElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type,
        (long) QXmlStreamReader::IncludeChildElements, "IncludeChildElements");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "IncludeChildElements", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type.tp_dict,
        "IncludeChildElements", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type,
        (long) QXmlStreamReader::SkipChildElements, "SkipChildElements");
    PyDict_SetItemString(SbkQXmlStreamReader_Type.super.ht_type.tp_dict,
        "SkipChildElements", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Type.tp_dict,
        "SkipChildElements", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlStreamReader::ReadElementTextBehaviour");

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlStreamReader >("QXmlStreamReader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlStreamReader >(typeid(QXmlStreamReader).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

