/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qxmlstreamnamespacedeclaration_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxmlstream.h>

using namespace Shiboken;

static int
SbkQXmlStreamNamespaceDeclaration_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlStreamNamespaceDeclaration* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QXmlStreamNamespaceDeclaration", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QXmlStreamNamespaceDeclaration()
        cptr = new QXmlStreamNamespaceDeclaration();
    } else if (numArgs == 1 && Shiboken::Converter<QXmlStreamNamespaceDeclaration& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlStreamNamespaceDeclaration* cpp_arg0 = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp(pyargs[0]);
        // QXmlStreamNamespaceDeclaration(QXmlStreamNamespaceDeclaration)
        cptr = new QXmlStreamNamespaceDeclaration(*cpp_arg0);
    } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // QXmlStreamNamespaceDeclaration(QString,QString)
        cptr = new QXmlStreamNamespaceDeclaration(*cpp_arg0, *cpp_arg1);
    } else goto SbkQXmlStreamNamespaceDeclaration_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlStreamNamespaceDeclaration_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQXmlStreamNamespaceDeclaration_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QXmlStreamNamespaceDeclaration", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamNamespaceDeclaration", overloads);
        return -1;
}

static PyObject*
SbkQXmlStreamNamespaceDeclarationFunc_namespaceUri(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceUri()const
    QXmlStreamNamespaceDeclaration* cppSelf = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamNamespaceDeclaration::namespaceUri();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlStreamNamespaceDeclarationFunc_prefix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefix()const
    QXmlStreamNamespaceDeclaration* cppSelf = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamNamespaceDeclaration::prefix();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQXmlStreamNamespaceDeclaration_methods[] = {
    {"namespaceUri", (PyCFunction)SbkQXmlStreamNamespaceDeclarationFunc_namespaceUri, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQXmlStreamNamespaceDeclarationFunc_prefix, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQXmlStreamNamespaceDeclaration_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QXmlStreamNamespaceDeclaration& cpp_self = *Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QXmlStreamNamespaceDeclaration& >::isConvertible(other)) {
                QXmlStreamNamespaceDeclaration* cpp_other = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQXmlStreamNamespaceDeclaration_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QXmlStreamNamespaceDeclaration& >::isConvertible(other)) {
                QXmlStreamNamespaceDeclaration* cpp_other = Shiboken::Converter<QXmlStreamNamespaceDeclaration* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQXmlStreamNamespaceDeclaration_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQXmlStreamNamespaceDeclaration_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlStreamNamespaceDeclaration_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QXmlStreamNamespaceDeclaration",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlStreamNamespaceDeclaration >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQXmlStreamNamespaceDeclaration_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlStreamNamespaceDeclaration_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlStreamNamespaceDeclaration_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QXmlStreamNamespaceDeclaration(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlStreamNamespaceDeclaration_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlStreamNamespaceDeclaration_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlStreamNamespaceDeclaration_Type));
    PyModule_AddObject(module, "QXmlStreamNamespaceDeclaration",
        ((PyObject*)&SbkQXmlStreamNamespaceDeclaration_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamNamespaceDeclaration >("QXmlStreamNamespaceDeclaration");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamNamespaceDeclaration >(typeid(QXmlStreamNamespaceDeclaration).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

