/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtextcodec_converterstate_wrapper.h"

// Extra includes
#include <QTextCodec>

using namespace Shiboken;

static int
SbkQTextCodec_ConverterState_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextCodec::ConverterState* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "ConverterState", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // ConverterState(QFlags<QTextCodec::ConversionFlag>)
        cptr = new QTextCodec::ConverterState();
    } else if (SbkPySide_QtCore_QTextCodec_ConversionFlag_Check(pyargs[0])) {
        QFlags<QTextCodec::ConversionFlag> cpp_arg0 = Shiboken::Converter<QFlags<QTextCodec::ConversionFlag> >::toCpp(pyargs[0]);
        // ConverterState(QFlags<QTextCodec::ConversionFlag>)
        cptr = new QTextCodec::ConverterState(cpp_arg0);
    } else goto SbkQTextCodec_ConverterState_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextCodec_ConverterState_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextCodec_ConverterState_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec.ConversionFlags = QTextCodec.DefaultConversion", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.ConverterState", overloads);
        return -1;
}

static PyMethodDef SbkQTextCodec_ConverterState_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQTextCodec_ConverterState_get_flags(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QTextCodec::ConversionFlag> >::toPython(Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->flags);
}
static int SbkQTextCodec_ConverterState_set_flags(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'flags' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_QTextCodec_ConversionFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'flags', 'ConversionFlags' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->flags = Shiboken::Converter<QFlags<QTextCodec::ConversionFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextCodec_ConverterState_get_remainingChars(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->remainingChars);
}
static int SbkQTextCodec_ConverterState_set_remainingChars(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'remainingChars' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'remainingChars', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->remainingChars = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextCodec_ConverterState_get_invalidChars(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->invalidChars);
}
static int SbkQTextCodec_ConverterState_set_invalidChars(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'invalidChars' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'invalidChars', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextCodec::ConverterState* >::toCpp((PyObject*)self)->invalidChars = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

// Getters and Setters for ConverterState
static PyGetSetDef SbkQTextCodec_ConverterState_getsetlist[] = {
    {const_cast<char*>("flags"), (getter)SbkQTextCodec_ConverterState_get_flags, (setter)SbkQTextCodec_ConverterState_set_flags},
    {const_cast<char*>("remainingChars"), (getter)SbkQTextCodec_ConverterState_get_remainingChars, (setter)SbkQTextCodec_ConverterState_set_remainingChars},
    {const_cast<char*>("invalidChars"), (getter)SbkQTextCodec_ConverterState_get_invalidChars, (setter)SbkQTextCodec_ConverterState_set_invalidChars},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextCodec_ConverterState_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.ConverterState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextCodec::ConverterState >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextCodec_ConverterState_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTextCodec_ConverterState_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextCodec_ConverterState_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextCodec_ConverterState(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextCodec_ConverterState_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextCodec_ConverterState_Type) < 0)
        return;

    PyDict_SetItemString(module,"ConverterState", (PyObject*)&SbkQTextCodec_ConverterState_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<QTextCodec::ConverterState >("QTextCodec::ConverterState*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextCodec::ConverterState >(typeid(QTextCodec::ConverterState).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

